/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.viewer;

import com.activetree.common.attr.reader.CommonAttributeReader;
import com.activetree.common.attr.reader.DefaultCommonAttributeReader;
import com.activetree.common.doc.DocEvent;
import com.activetree.common.doc.DocUtil;
import com.activetree.common.doc.PrintDialog;
import com.activetree.common.object.KeyValueObject;
import com.activetree.common.object.PasswordProvider;
import com.activetree.common.page.AbstractPage;
import com.activetree.common.print.AbstractPrinter;
import com.activetree.common.resource.AtCommonResource;
import com.activetree.common.swing.AtWidget;
import com.activetree.common.utils.AtComponentUtil;
import com.activetree.common.utils.AtDebug;
import com.activetree.common.utils.CursorUtil;
import com.activetree.common.utils.DataUtil;
import com.activetree.common.utils.MediaUtil;
import com.activetree.common.utils.PrintUtil;
import com.activetree.common.utils.StringUtil;
import com.activetree.common.viewer.AbstractDocumentViewer;
import com.activetree.common.viewer.DocPasswordProviderDialog;
import com.activetree.common.web.CallBackReply;
import com.activetree.common.web.WebContext;
import com.activetree.common.web.WebDoc;
import com.activetree.common.web.WebDocAttributeParser;
import com.activetree.common.web.WebInterface;
import com.activetree.common.web.WebViewContext;
import com.activetree.common.web.WebViewContextImpl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.print.DocPrintJob;
import javax.print.PrintService;
import javax.print.attribute.standard.PrintQuality;
import javax.print.attribute.standard.Sides;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public abstract class AbstractViewerForBrowser
extends WebDocAttributeParser {
    protected List viewerControls;
    protected Object document;
    protected String password;
    protected String urlAuthId;
    protected String urlAuthPassword;
    protected String proxyHost;
    protected String proxyPort;
    protected String proxySet;
    protected String licenseKey;
    protected AbstractDocumentViewer viewPane;
    protected DocPasswordProviderDialog pswdProvider;

    public AbstractViewerForBrowser(WebInterface docParamContext) {
        super(docParamContext);
    }

    protected DefaultCommonAttributeReader createWebDoc() {
        WebDoc webDoc = new WebDoc();
        return webDoc;
    }

    protected WebContext createWebContext(DefaultCommonAttributeReader webDoc) {
        WebViewContext webCtx = this.createWebViewContext(webDoc);
        return webCtx;
    }

    public void start() {
        Object doc;
        this.webContext.debug("BEGIN-----viewer start() -----");
        this.webContext.debug("PdfViewer4Browser.self.start() inited=" + this.inited);
        List docListObj = (List)this.webDoc.getAttribute("DOC_LIST_OBJ");
        if (docListObj != null && docListObj.size() > 0) {
            this.webDoc.setAttribute("DOCUMENT", docListObj.get(0));
        }
        this.webContext.debug("---TEST: - if doc can be opened---");
        this.document = doc = this.webDoc.getAttribute("DOCUMENT");
        this.webContext.debug("docObj=" + doc);
        Container c = (Container)this.getComponent();
        c.removeAll();
        c.setLayout(new BorderLayout(0, 0));
        this.webContext.debug("removed views");
        String controls = this.getDocParameter("VIEWER_CONTROLS");
        this.webContext.debug("controls=" + controls + ", controls.length=" + (controls != null ? controls.length() : 0));
        this.webContext.debug("VIEWER_CONTROLS=" + controls);
        this.viewerControls = DocUtil.getSimpleList(controls);
        this.webContext.debug("viewerControlList=" + this.viewerControls);
        this.password = this.webDoc.getStringAttribute("PASSWORD");
        this.licenseKey = this.webDoc.getStringAttribute("LICENSE_KEY");
        this.urlAuthId = this.webDoc.getStringAttribute("URL_AUTH_ID");
        this.urlAuthPassword = this.webDoc.getStringAttribute("URL_AUTH_PASSWORD");
        this.proxyHost = this.webDoc.getStringAttribute("PROXY_HOST");
        this.proxyPort = this.webDoc.getStringAttribute("PROXY_PORT");
        this.proxySet = this.webDoc.getStringAttribute("PROXY_SET");
        this.webContext.debug("got all params");
        this.setLicenseKey(this.licenseKey);
        String errMsg = null;
        if (doc instanceof String) {
            this.webContext.debug("B4 getWhiteSpaceEnabledURL() document=" + this.document);
            this.document = StringUtil.getWhiteSpaceEnabledURL((String)this.document);
            this.webContext.debug("after getWhiteSpaceEnabledURL() document=" + this.document);
        }
        this.webContext.debug("doc=" + doc);
        if (doc == null) {
            errMsg = "No document";
            this.showNoDocError(this.webContext, errMsg);
            return;
        }
        this.viewPane = this.createViewPane();
        this.pswdProvider.setOwner(this.viewPane);
        this.viewPane.setAttribute("LICENSE_KEY", this.webDoc.getAttribute("LICENSE_KEY"));
        this.viewPane.setAttribute("LICENSE_KEY", this.licenseKey);
        c.add((Component)this.viewPane, "Center");
        c.validate();
        c.invalidate();
        Window window = AtComponentUtil.getWindowForComponent(this.viewPane);
        this.webContext.debug("after viewPane added - window for viewer: " + window);
        window = SwingUtilities.getWindowAncestor(this.viewPane);
        this.webContext.debug("after viewPane added - window for viewer: " + window);
        this.customizeViewPane(this.viewPane);
        this.webContext.debug("customizeViewPane() done");
        final Object docSource = doc;
        Runnable r = new Runnable(){

            public void run() {
                AbstractViewerForBrowser.this.viewPane.addOnLoadProperty(AbstractDocumentViewer.PROPERTY_ON_LOAD_FIT_TO_WIDTH);
                AbstractViewerForBrowser.this.webContext.debug("docSource=" + docSource);
                AbstractViewerForBrowser.this.viewPane.showDocument(docSource);
                AbstractViewerForBrowser.this.webContext.debug("showPdf(" + docSource + ") done");
                AbstractViewerForBrowser.this.webContext.debug("END --- viewer start() ----");
            }
        };
        SwingUtilities.invokeLater(r);
    }

    protected String getDocParameter(String attr) {
        String s = this.getStringParameter(attr, null);
        this.webContext.debug("getDocParameter(" + attr + ") => \"" + s + "\", s.length=" + (s != null ? s.length() : 0));
        if (s == null) {
            s = this.webDoc.getStringAttribute(attr);
        }
        this.webContext.debug("return " + attr + "=\"" + s + "\" s.len=" + (s != null ? s.length() : 0));
        return s;
    }

    protected void showNoDocError(WebContext webContext, String extraMsg) {
        String noDocMsg = AtCommonResource.MESSAGE_RESOURCE.getText("NO_DOCUMENTS_TO_PRINT");
        webContext.debug("noDocMsg=" + noDocMsg);
        String msg = "<html><body>" + noDocMsg;
        if (extraMsg != null) {
            msg = msg + "<p>";
            msg = msg + extraMsg;
            msg = msg + "</p>";
        }
        msg = msg + "</body></html>";
        webContext.debug("msg={" + msg + "}");
        JEditorPane editorPane = new JEditorPane("text/html", msg);
        editorPane.setEditable(false);
        editorPane.setBackground(SystemColor.white);
        Container c = (Container)this.getComponent();
        webContext.debug("c=" + c);
        c.removeAll();
        c.invalidate();
        webContext.debug("invalidate()");
        c.setBackground(SystemColor.white);
        c.setLayout(new BorderLayout());
        c.add((Component)editorPane, "North");
        webContext.debug("add(editorPane)");
        c.validate();
        c.invalidate();
        webContext.debug("invalidate()");
        webContext.debug("showNoDoc() - comp=" + c);
        if (c instanceof JComponent) {
            JComponent jcomp = (JComponent)c;
            jcomp.revalidate();
            jcomp.validate();
            jcomp.updateUI();
            CursorUtil.setCursorToAllPanes(editorPane, AbstractDocumentViewer.DEFAULT_CURSOR);
            webContext.debug("applet comp UI updated.");
        }
    }

    protected boolean hasDocList() {
        return true;
    }

    protected abstract void setLicenseKey(String var1);

    protected PrintDialog createPrintDialog() {
        return null;
    }

    protected void downloadPrintDialogCustomParams() {
    }

    protected WebViewContext createWebViewContext(CommonAttributeReader webDoc) {
        Object appletContext = this.getContext();
        Component owner = this.getComponent();
        WebViewContextImpl context = new WebViewContextImpl(appletContext, webDoc, owner);
        return context;
    }

    protected WebContext getViewContext() {
        return this.webContext;
    }

    void debugSp() {
        String webDocAttrs = this.webDoc.getDebugString();
        this.webContext.debug("webDoc attrs\n" + webDocAttrs);
        String paper = (String)this.webDoc.getAttribute("PAPER");
        boolean autoMatchPaper = this.webDoc.getPrimitiveBooleanAttribute("AUTO_MATCH_PAPER");
        int pageScaling = this.webDoc.getPrimitiveIntegerAttribute("PAGE_SCALING");
        boolean isAutoRotateAndCenter = this.webDoc.getPrimitiveBooleanAttribute("AUTO_ROTATE_AND_CENTER");
        int copies = this.webDoc.getPrimitiveIntegerAttribute("COPIES");
        boolean isCollate = this.webDoc.getPrimitiveBooleanAttribute("COLLATE_COPIES");
        boolean isUsePrinterMargins = this.webDoc.getPrimitiveBooleanAttribute("IS_USE_PRINTER_MARGINS");
        PrintQuality printQuality = PrintUtil.getPrintQuality((String)this.webDoc.getAttribute("PRINT_QUALITY"));
        Sides sideToPrint = MediaUtil.getMediaSide((String)this.webDoc.getAttribute("SIDE_TO_PRINT"));
        String jobName = this.webDoc.getStringAttribute("JOB_NAME");
        this.webContext.debug("PAPER=" + paper);
        this.webContext.debug("AUTO_MATCH_PAPER=" + autoMatchPaper);
        this.webContext.debug("PAGE_SCALING=" + pageScaling);
        this.webContext.debug("AUTO_ROTATE_AND_CENTER=" + isAutoRotateAndCenter);
        this.webContext.debug("COPIES=" + copies);
        this.webContext.debug("COLLATE_COPIES=" + isCollate);
        this.webContext.debug("IS_USE_PRINTER_MARGINS=" + isUsePrinterMargins);
        this.webContext.debug("PRINT_QUALITY=" + printQuality);
        this.webContext.debug("SIDE_TO_PRINT=" + sideToPrint);
        this.webContext.debug("JOB_NAME=" + jobName);
    }

    protected abstract AbstractDocumentViewer createViewPane();

    protected abstract AbstractPrinter createPrinter();

    protected void silentPrint() {
        this.webContext.debug("silentPrintActionPerformed()");
        (AbstractViewerForBrowser)this.new sp().x.sprint();
        try {
            this.showNoDocError(this.webContext, null);
        }
        catch (Throwable t) {
            this.webContext.debug("showNoDocError() had NPE (Ok) [" + t.getMessage() + "]");
        }
        Object closeStatus = this.webContext.callJavaScript("window.close()");
        this.webContext.debug("Window Close Status: [" + closeStatus + "]");
    }

    protected PasswordProvider createCustomPasswordProvider() {
        this.pswdProvider = new DocPasswordProviderDialog(this.viewPane, this.document, this.password);
        this.pswdProvider.setUrlAuthUser(this.urlAuthId);
        this.pswdProvider.setUrlAuthPassword(this.urlAuthPassword);
        this.pswdProvider.setProxyHost(this.proxyHost);
        this.pswdProvider.setProxyPort(this.proxyPort);
        this.pswdProvider.setProxySet(this.proxySet);
        this.webContext.debug("createCustomPasswordProvider...viewPane=" + this.viewPane);
        return this.pswdProvider;
    }

    protected KeyValueObject[] createCustomZoomComboValueList() {
        int i;
        String zoomComboValues = this.webDoc.getStringAttribute("ZOOM_COMBO_VALUES");
        if (zoomComboValues == null) {
            return null;
        }
        int dim = DataUtil.getArrayDimension(zoomComboValues);
        AtDebug.debug("Custom zoom combo array dimension: " + dim);
        Object[] arry = (Object[])DataUtil.parseArray(zoomComboValues);
        AtDebug.debug("Zoom combo value array actual: " + (arry != null ? arry.length : -1));
        Object[] texts = null;
        Object[] values = null;
        if (dim == 2) {
            texts = (Object[])arry[0];
            values = (Object[])arry[1];
        }
        AtDebug.debug("Zoom combo texts size: " + (texts != null ? texts.length : -1));
        AtDebug.debug("Zoom combo value size: " + (values != null ? values.length : -1));
        KeyValueObject[] valueList = null;
        if (texts != null && values != null && texts.length == values.length) {
            valueList = new KeyValueObject[texts.length];
            for (i = 0; i < texts.length; ++i) {
                Object keyObj = texts[i];
                String key = keyObj instanceof String ? (String)keyObj : keyObj.toString();
                key = key.trim();
                key = StringUtil.trimDoubleQuotes(key);
                Object valueObj = values[i];
                String valueStr = valueObj instanceof String ? (String)valueObj : valueObj.toString();
                String tempStr = valueStr.trim();
                double value = Double.parseDouble(tempStr);
                valueList[i] = new KeyValueObject(key, value);
            }
        } else {
            AtDebug.debug("WARNING", "Illegal ZoomComboValues=" + zoomComboValues);
        }
        AtDebug.debug(4, "=ZOOM_COMBO_VALUES=");
        for (i = 0; valueList != null && i < valueList.length; ++i) {
            AtDebug.debug(4, valueList[i].getKey() + "=" + valueList[i].getValue());
        }
        return valueList;
    }

    protected void customizeViewPane(AbstractDocumentViewer viewPane) {
        this.webContext.debug("customizeViewPane()");
        this.webContext.debug("viewControls=" + this.viewerControls);
        if (this.viewerControls == null || this.viewerControls.size() == 0) {
            this.webContext.debug("No customization on viewer controls.");
            return;
        }
        viewPane.setAllControlsVisible(false);
        this.webContext.debug("Begin - VIEWER_CONTROLS make visible");
        Iterator controlCommands = this.viewerControls.iterator();
        viewPane.makeVisible(controlCommands, true);
        viewPane.validate();
        viewPane.invalidate();
        this.webContext.debug("End - VIEWER_CONTROLS made visible");
        boolean isSilentPrint = this.viewerControls.contains("SILENT_PRINT_BUTTON");
        this.webContext.debug("SILENT_PRINT_BUTTON=" + isSilentPrint);
        if (isSilentPrint) {
            JComponent c = viewPane.getViewerControl("SILENT_PRINT_BUTTON");
            if (c instanceof AtWidget) {
                ((AtWidget)c).setActionCommand("SILENT_PRINT_CMD");
            } else if (c instanceof AbstractButton) {
                ((AbstractButton)c).setActionCommand("SILENT_PRINT_CMD");
            }
        }
        viewPane.revalidate();
        viewPane.validate();
    }

    public void destroy() {
        try {
            this.webContext.debug("destroy()");
            this.viewPane.saveUserPreferences();
            this.viewPane.stopCurrentLoading();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void stop() {
        try {
            this.webContext.debug("stop()");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private class sp {
        px x = new px();

        private sp() {
        }

        class px {
            px() {
            }

            void sprint() {
                AbstractViewerForBrowser.this.webContext.debug("silentPrint()");
                WebDoc webDoc = (WebDoc)AbstractViewerForBrowser.this.getViewContext().getWebDoc();
                Object dataSource = ((sp)sp.this).AbstractViewerForBrowser.this.viewPane.getDocumentSource();
                PrinterJob pj = PrinterJob.getPrinterJob();
                PrintService defaultPrintService = pj.getPrintService();
                String paper = (String)webDoc.getAttribute("PAPER");
                AbstractPage[] pages = ((sp)sp.this).AbstractViewerForBrowser.this.viewPane.getPages();
                if (pages == null || pages.length == 0) {
                    AbstractViewerForBrowser.this.webContext.debug("No pages to print (return).");
                    return;
                }
                AbstractPage page1 = pages[0];
                Rectangle2D printableArea = page1.getPrintableArea();
                PageFormat pageFormat = MediaUtil.getSelectedPageFormat(printableArea);
                if (paper != null) {
                    pageFormat = WebDocAttributeParser.getPageFormatForSelectedMediaName(paper, AbstractViewerForBrowser.this.webContext);
                }
                boolean autoMatchPaper = webDoc.getPrimitiveBooleanAttribute("AUTO_MATCH_PAPER");
                int pageScaling = webDoc.getPrimitiveIntegerAttribute("PAGE_SCALING");
                boolean isAutoRotateAndCenter = webDoc.getPrimitiveBooleanAttribute("AUTO_ROTATE_AND_CENTER");
                int copies = webDoc.getPrimitiveIntegerAttribute("COPIES");
                boolean isCollate = webDoc.getPrimitiveBooleanAttribute("COLLATE_COPIES");
                boolean isUsePrinterMargins = webDoc.getPrimitiveBooleanAttribute("IS_USE_PRINTER_MARGINS");
                PrintQuality printQuality = PrintUtil.getPrintQuality((String)webDoc.getAttribute("PRINT_QUALITY"));
                Sides sideToPrint = MediaUtil.getMediaSide((String)webDoc.getAttribute("SIDE_TO_PRINT"));
                String jobName = webDoc.getStringAttribute("JOB_NAME");
                AbstractViewerForBrowser.this.webContext.debug("--begin b4 printing sp param--");
                AbstractViewerForBrowser.this.debugSp();
                AbstractViewerForBrowser.this.webContext.debug("----end sp params---");
                try {
                    this.sp(dataSource, defaultPrintService, pageFormat, autoMatchPaper, pageScaling, isAutoRotateAndCenter, copies, isCollate, isUsePrinterMargins, printQuality, sideToPrint, jobName, ((sp)sp.this).AbstractViewerForBrowser.this.viewPane.getPasswordProvider());
                    DocEvent printEndedEvent = new DocEvent(dataSource, 22, pages.length, defaultPrintService.getName());
                    ((sp)sp.this).AbstractViewerForBrowser.this.viewPane.getDocPrinter().notifyEvent(printEndedEvent);
                    webDoc.setAttribute("PAGE_COUNT", new Integer(pages == null ? 0 : pages.length));
                    webDoc.setAttribute("JOB_NAME", pj.getJobName());
                    webDoc.setAttribute("PRINTER_NAME", pj.getPrintService().getName());
                    webDoc.setAttribute("JOB_STATUS", "SUCCESS");
                    webDoc.setAttribute("JOB_ERROR_MESSAGE", null);
                    webDoc.setAttribute("JOB_ERROR_STACK", null);
                    webDoc.setAttribute("DATE_TIME", new Date().toString());
                }
                catch (Throwable t) {
                    String errMsg = t.getMessage();
                    webDoc.setAttribute("JOB_ERROR_MESSAGE", errMsg);
                    String stack = StringUtil.getStackTrace(t);
                    webDoc.setAttribute("JOB_ERROR_STACK", stack);
                    webDoc.setAttribute("JOB_STATUS", "FAILED");
                    AbstractViewerForBrowser.this.webContext.debug(9, t);
                    boolean showPrintErrdialog = AbstractViewerForBrowser.this.webContext.getWebDoc().getPrimitiveBooleanAttribute("SHOW_PRINT_ERROR_DIALOG");
                    AbstractViewerForBrowser.this.webContext.debug("startPrint() - showPrintErrDialog=" + showPrintErrdialog);
                    if (showPrintErrdialog) {
                        Component owner = AbstractViewerForBrowser.this.webContext.getContextOwner();
                        String title = AtCommonResource.MESSAGE_RESOURCE.getText("PRINT_ERROR");
                        JOptionPane.showMessageDialog(owner, errMsg, title, 0);
                    }
                    return;
                }
                CallBackReply replyAfter = AbstractViewerForBrowser.this.webContext.callServer("POST", "FINISHED");
                AbstractViewerForBrowser.this.webContext.processCallBackReplyAfter(replyAfter);
                AbstractViewerForBrowser.this.webContext.onSuccessShowPage();
                AbstractViewerForBrowser.this.webContext.onFailureShowPage();
            }

            void sp(Object dataSource, Object printerToPrint, PageFormat pageFormat, boolean choosePaperSourceByPageSize, int pageScaling, boolean isAutoRotateAndCenter, int copies, boolean isCollate, boolean isUsePrinterMargins, PrintQuality printQuality, Sides sideToPrint, String jobName, PasswordProvider passwordProvider) throws Exception {
                AbstractPrinter docPrinter = AbstractViewerForBrowser.this.createPrinter();
                if (printerToPrint instanceof PrintService) {
                    docPrinter.setPrintService((PrintService)printerToPrint);
                } else if (printerToPrint instanceof DocPrintJob) {
                    docPrinter.setDocPrintJob((DocPrintJob)printerToPrint);
                }
                docPrinter.setDefaultPageFormat(pageFormat);
                docPrinter.setChoosePaperSourceByPageSize(choosePaperSourceByPageSize);
                docPrinter.setPageScaling(pageScaling);
                docPrinter.setAutoRotateAndCenter(isAutoRotateAndCenter);
                docPrinter.setCollate(isCollate);
                docPrinter.setCopies(copies);
                docPrinter.setUsePrinterMargins(isUsePrinterMargins);
                docPrinter.setPrintQuality(printQuality);
                docPrinter.setSideToPrint(sideToPrint);
                docPrinter.setJobName(jobName);
                docPrinter.setPasswordProvider(passwordProvider);
                docPrinter.print(dataSource);
                docPrinter.close();
            }
        }
    }
}

