/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.viewer;

import com.activetree.common.utils.StringUtil;
import com.activetree.common.viewer.AtStatusCellData;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.SystemColor;
import java.awt.image.MemoryImageSource;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class AtStatusCell
extends JPanel
implements Runnable {
    private static final int REFRESH_TIME_MILLIS = 30;
    private int FORWARD = 1;
    private int BACKWARD = 2;
    private int animationDirection = this.FORWARD;
    private int lastAnimationX = -1;
    private static final Color ANIM_COLOR = new Color(153, 153, 255);
    private static final int w = 20;
    private static final int h = 16;
    private static final int[] imgData = new int[320];
    private static final MemoryImageSource ANIMATOR_MEM_ICON;
    private ImageIcon ANIMATOR_ICON = null;
    public static final int OK = 1;
    public static final int WARNING = 2;
    public static final int ERROR = 3;
    protected boolean progressing = false;
    protected String tooltip;
    protected String displayLabel;
    protected String progressLabel;
    protected int status = 1;
    protected Color progressColor = new Color(102, 102, 255, 100);
    protected Color progressLabelColor = new Color(0, 0, 0, 100);
    protected Color normalLabelColor = SystemColor.black;
    private ImageIcon icon;
    private int progressPercent = 1;
    private boolean showAnimation = true;
    private int pWidth = 100;
    private int pHeight = 20;
    private Dimension prefSize = new Dimension();
    private Thread animationThread = null;
    private int GAP = 3;
    int paintCount = 0;

    public AtStatusCell(AtStatusCellData cellData) {
        this.displayLabel = cellData.getDisplayLabel();
        this.progressLabel = cellData.getProgressLabel();
        this.tooltip = cellData.tooltip;
        this.icon = null;
        super.setToolTipText(this.tooltip);
        this.ANIMATOR_ICON = new ImageIcon(super.createImage(ANIMATOR_MEM_ICON));
    }

    public AtStatusCell(String displayLabel, String progressLabel, String tooltip, ImageIcon icon, boolean showAnimation) {
        this.displayLabel = displayLabel;
        this.progressLabel = progressLabel;
        this.tooltip = tooltip;
        this.icon = icon;
        this.showAnimation = showAnimation;
        super.setToolTipText(tooltip);
        this.ANIMATOR_ICON = new ImageIcon(super.createImage(ANIMATOR_MEM_ICON));
    }

    public Color getProgressLabelColor() {
        return this.progressLabelColor;
    }

    public void setProgressLabelColor(Color progressLabelColor) {
        this.progressLabelColor = progressLabelColor;
    }

    public Color getProgressColor() {
        return this.progressColor;
    }

    public void setProgressColor(Color progressColor) {
        this.progressColor = progressColor;
    }

    public String getProgressLabel() {
        return this.progressLabel;
    }

    public void setProgressLabel(String progressLabel) {
        this.progressLabel = progressLabel;
    }

    public Color getNormalLabelColor() {
        return this.normalLabelColor;
    }

    public void setNormalLabelColor(Color normalLabelColor) {
        this.normalLabelColor = normalLabelColor;
    }

    public void setIcon(ImageIcon icon) {
        this.icon = icon;
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    public void setAnimationLabel(final String label) {
        Runnable r = new Runnable(){

            public void run() {
                AtStatusCell.this.progressLabel = label;
            }
        };
        SwingUtilities.invokeLater(r);
    }

    public String getAnimationLabel() {
        return this.progressLabel;
    }

    public boolean isShowAnimation() {
        return this.showAnimation;
    }

    public void setShowAnimation(boolean showAnimation) {
        this.showAnimation = showAnimation;
    }

    public int getPreferredWidth() {
        return this.pWidth;
    }

    public int getPreferredHeight() {
        return this.pHeight;
    }

    public void setPreferredWidth(int pWidth) {
        this.pWidth = pWidth;
    }

    public void setPreferredHeight(int pHeight) {
        this.pHeight = pHeight;
    }

    public Dimension getPreferredSize() {
        if (this.pWidth == -1) {
            return super.getPreferredSize();
        }
        this.prefSize.width = this.pWidth;
        this.prefSize.height = this.pHeight;
        return this.prefSize;
    }

    public String getDisplayLabel() {
        return this.displayLabel;
    }

    public String getTooltipText() {
        return this.tooltip;
    }

    public int getPostProgressStatus() {
        return this.status;
    }

    public boolean isProgressing() {
        return this.progressing;
    }

    public void setDisplayLabel(final String newDisplayLabel) {
        Runnable r = new Runnable(){

            public void run() {
                AtStatusCell.this.displayLabel = newDisplayLabel;
                AtStatusCell.this.repaint();
            }
        };
        SwingUtilities.invokeLater(r);
    }

    public void setTooltip(final String newTooltip) {
        Runnable r = new Runnable(){

            public void run() {
                AtStatusCell.this.tooltip = newTooltip;
                AtStatusCell.this.setToolTipText(AtStatusCell.this.tooltip);
            }
        };
        SwingUtilities.invokeLater(r);
    }

    public void setStatus(final int postProgressStatus) {
        Runnable r = new Runnable(){

            public void run() {
                AtStatusCell.this.status = postProgressStatus;
                AtStatusCell.this.repaint();
            }
        };
        SwingUtilities.invokeLater(r);
    }

    public void startAnimation() {
        this.animationThread = new Thread(this);
        this.progressing = true;
        this.animationThread.start();
    }

    public void stopAnimation() {
        Runnable r = new Runnable(){

            public void run() {
                AtStatusCell.this.progressing = false;
                AtStatusCell.this.lastAnimationX = -1;
                AtStatusCell.this.animationDirection = AtStatusCell.this.FORWARD;
                AtStatusCell.this.repaint();
            }
        };
        Thread t = new Thread(r);
        t.start();
    }

    public void run() {
        while (this.progressing) {
            if (!this.isVisible()) continue;
            this.repaint();
            ++this.progressPercent;
            if (this.progressPercent > 100) {
                this.progressPercent = 75;
            }
            try {
                Thread.sleep(30L);
            }
            catch (Throwable throwable) {}
        }
    }

    public void paint(Graphics g) {
        this.draw(g);
    }

    private void draw(Graphics g) {
        Color orgColor = g.getColor();
        Font orgFont = g.getFont();
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int w = this.getSize().width;
        int h = this.getSize().height;
        g.setColor(this.getBackground());
        g.fillRect(0, 0, w, h);
        g.setColor(this.getBackground().darker());
        g.drawLine(1, 1, w - 3, 1);
        g.drawLine(1, h - 3, 1, 1);
        g.setColor(this.getBackground().brighter());
        g.drawLine(w - 3, 1, w - 3, h - 3);
        g.drawLine(w - 3, h - 3, 1, h - 3);
        int iconx = this.GAP;
        int iconw = 0;
        int iconh = 0;
        if (this.icon != null) {
            int icony;
            iconw = this.icon.getIconWidth();
            if (iconw > 14) {
                iconw = 14;
            }
            if ((iconh = this.icon.getIconHeight()) > 14) {
                iconh = 14;
            }
            if ((icony = (h - iconh) / 2) < this.GAP) {
                icony = this.GAP;
            }
            g.drawImage(this.icon.getImage(), iconx, icony, iconw, iconh, this);
        }
        int fontHeight = fontMetrics.getHeight();
        if (this.progressing && this.isShowAnimation()) {
            int animatorIconW = this.ANIMATOR_ICON.getIconWidth();
            int animatorIconH = this.ANIMATOR_ICON.getIconHeight();
            int animationX = -1;
            animationX = this.lastAnimationX == -1 ? iconx + iconw + this.GAP : this.lastAnimationX;
            if (this.animationDirection == this.FORWARD) {
                int availableWidth;
                if ((availableWidth = w - (++animationX + this.GAP)) < animatorIconW) {
                    this.animationDirection = this.BACKWARD;
                    --animationX;
                }
            } else {
                int minx = this.GAP + iconw + this.GAP;
                if (--animationX < minx) {
                    --animationX;
                    this.animationDirection = this.FORWARD;
                }
            }
            g.setColor(this.progressColor);
            g.drawImage(this.ANIMATOR_ICON.getImage(), animationX, 2, animatorIconW, h - 5, this);
            this.lastAnimationX = animationX;
        }
        String label = this.displayLabel;
        if (this.progressing) {
            label = this.progressLabel;
        }
        if (label != null) {
            label = StringUtil.truncateString(label, w - (iconx + iconw + this.GAP), fontMetrics);
        }
        if (label != null) {
            g.setFont(this.getFont());
            if (this.progressing) {
                g.setColor(this.normalLabelColor.darker());
            } else {
                g.setColor(this.normalLabelColor);
            }
            int x = iconx;
            if (this.icon != null) {
                x += iconw;
                x += this.GAP;
            }
            int y = this.getSize().height / 2 + fontHeight / 4;
            g.drawString(label, x, y);
        }
        g.setColor(orgColor);
        g.setFont(orgFont);
    }

    static {
        for (int i = 0; i < imgData.length; ++i) {
            AtStatusCell.imgData[i] = ANIM_COLOR.getRGB();
        }
        ANIMATOR_MEM_ICON = new MemoryImageSource(20, 16, imgData, 0, 20);
    }
}

