/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.viewer;

import com.activetree.common.resource.AtImageList;
import com.activetree.common.viewer.AtMultiCellStatusBar;
import com.activetree.common.viewer.AtStatusCell;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;

public class StatusBarControl
implements Serializable {
    public AtMultiCellStatusBar statusPane;
    final AtStatusCell statusCell = new AtStatusCell("", "", null, null, true);
    final AtStatusCell messageCell = new AtStatusCell("", "", null, null, false);
    final AtStatusCell pageSizeInfoCell = new AtStatusCell("", "", null, null, false);
    final AtStatusCell pageInfoCell = new AtStatusCell("", "", null, null, false);
    final AtStatusCell gcCell;

    public StatusBarControl() {
        this.gcCell = new AtStatusCell("", "", null, AtImageList.IMAGE_LIST.GC, false);
        this.setupContentPane();
    }

    protected void setupContentPane() {
        this.statusCell.setPreferredWidth(100);
        this.gcCell.setPreferredWidth(100);
        this.pageInfoCell.setPreferredWidth(100);
        this.pageSizeInfoCell.setPreferredWidth(100);
        this.messageCell.setPreferredWidth(-1);
        ArrayList<AtStatusCell> cells = new ArrayList<AtStatusCell>();
        cells.add(this.messageCell);
        cells.add(this.gcCell);
        cells.add(this.pageSizeInfoCell);
        cells.add(this.pageInfoCell);
        cells.add(this.statusCell);
        this.statusPane = new AtMultiCellStatusBar(cells);
    }

    public AtStatusCell getStatusCell() {
        return this.statusCell;
    }

    public AtStatusCell getMessageCell() {
        return this.messageCell;
    }

    public AtStatusCell getPageSizeInfoCell() {
        return this.pageSizeInfoCell;
    }

    public AtStatusCell getPageInfoCell() {
        return this.pageInfoCell;
    }

    public AtStatusCell getMemoryInfoCell() {
        return this.gcCell;
    }

    public void setPageSizeInfo(final String pageSizeInfo, final String tooltip) {
        Runnable r = new Runnable(){

            public void run() {
                StatusBarControl.this.pageSizeInfoCell.setDisplayLabel(pageSizeInfo);
                StatusBarControl.this.pageSizeInfoCell.setTooltip(tooltip);
            }
        };
        SwingUtilities.invokeLater(r);
    }

    public void setMemoryInfo(final String memoryInfo) {
        Runnable r = new Runnable(){

            public void run() {
                StatusBarControl.this.gcCell.setDisplayLabel(memoryInfo);
                StatusBarControl.this.gcCell.setTooltip(memoryInfo);
                StatusBarControl.this.gcCell.repaint();
            }
        };
        SwingUtilities.invokeLater(r);
    }

    public void setPageInfo(final String pageInfo) {
        Runnable r = new Runnable(){

            public void run() {
                StatusBarControl.this.pageInfoCell.setDisplayLabel(pageInfo);
            }
        };
        SwingUtilities.invokeLater(r);
    }

    public void startAnimation(final ImageIcon icon, final String animationMessage) {
        Runnable r = new Runnable(){

            public void run() {
                StatusBarControl.this.setMessage(animationMessage);
                StatusBarControl.this.statusCell.setIcon(icon);
                StatusBarControl.this.statusCell.startAnimation();
            }
        };
        new Thread(r).start();
    }

    public void stopAnimation(final ImageIcon icon, final String displayLabel) {
        Runnable r = new Runnable(){

            public void run() {
                StatusBarControl.this.setMessage(displayLabel);
                StatusBarControl.this.statusCell.setIcon(icon);
                StatusBarControl.this.statusCell.stopAnimation();
            }
        };
        new Thread(r).start();
    }

    public void setStatusIcon(ImageIcon icon) {
        this.statusCell.setIcon(icon);
        this.statusCell.repaint();
    }

    public void setMessage(final String message) {
        Runnable r = new Runnable(){

            public void run() {
                StatusBarControl.this.messageCell.setDisplayLabel(message);
                StatusBarControl.this.messageCell.setTooltip(message);
                StatusBarControl.this.messageCell.repaint();
            }
        };
        SwingUtilities.invokeLater(r);
    }
}

