/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.viewer;

import com.activetree.common.doc.DefaultDocListener;
import com.activetree.common.doc.DocEvent;
import com.activetree.common.resource.AtCommonResource;
import com.activetree.common.utils.AtComponentUtil;
import com.activetree.common.viewer.ProgressStatusEvent;
import com.activetree.common.viewer.ProgressStatusListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class UIDocListener
extends DefaultDocListener
implements ProgressStatusListener {
    public static final String closeText = AtCommonResource.MESSAGE_RESOURCE.getText("Close");
    public static final String cancelText = AtCommonResource.MESSAGE_RESOURCE.getText("Cancel");
    protected AtProgressDialog progressWindow = null;
    protected int totalCount = -1;
    protected boolean cancelled = false;

    public void start(Component parent, String title, String message, boolean modal, boolean showDetails, boolean windowDisposeOnSuccess, int totalCount) {
        this.totalCount = totalCount;
        this.cancelled = false;
        Window window = AtComponentUtil.getWindowForComponent(parent);
        this.progressWindow = window instanceof Frame ? new AtProgressDialog(title, message, (Frame)window, modal, showDetails) : (window instanceof Dialog ? new AtProgressDialog(title, message, (Dialog)window, modal, showDetails) : new AtProgressDialog(title, message, (Frame)null, false, showDetails));
        this.progressWindow.addProgressStatusListener(this);
        this.progressWindow.setWindowDisposableOnSuccess(windowDisposeOnSuccess);
        this.progressWindow.start();
    }

    public Window getProgressWindow() {
        return this.progressWindow;
    }

    public void progressReported(ProgressStatusEvent evt) {
        if (evt.getStatus() == 2) {
            this.cancel();
        } else if (evt.getStatus() == 3) {
            this.close();
        } else if (evt.getStatus() == 1) {
            // empty if block
        }
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void cancel() {
        this.cancelled = true;
        this.close();
    }

    public void close() {
        this.progressWindow.clean();
        this.progressWindow.dispose();
        this.totalCount = -1;
    }

    protected void pageRenderedForViewer(DocEvent evt, int pageIndex) {
        this.checkIfCancelled();
    }

    protected void pageRenderedForThumbnailView(DocEvent evt, int thumbnailIndex) {
        this.checkIfCancelled();
    }

    protected void pageLoaded(DocEvent evt, int pageIndex) {
        this.checkIfCancelled();
    }

    protected void pageCount(DocEvent evt, int pageCount) {
        this.checkIfCancelled();
    }

    protected void pageConverted(DocEvent evt, int pageCount) {
        this.checkIfCancelled();
    }

    protected void printStarting(DocEvent evt, Object source, String printerName) {
        this.checkIfCancelled();
        String printing = AtCommonResource.MESSAGE_RESOURCE.getText("PRINTING");
        String to = AtCommonResource.MESSAGE_RESOURCE.getText("to");
        String msg = printing + " " + to + ": " + printerName;
        String docName = null;
        if (source instanceof String) {
            docName = (String)source;
        } else if (source != null) {
            docName = source.toString();
        }
        this.progressWindow.appendMessage(msg);
        if (docName != null) {
            String document = AtCommonResource.MESSAGE_RESOURCE.getText("Document");
            this.progressWindow.appendMessage(document + ": " + docName);
        }
    }

    protected void printableCalled(DocEvent evt, int pageIndex) {
        this.checkIfCancelled();
    }

    protected void pagePrinted(DocEvent evt, int pageCount) {
        this.checkIfCancelled();
        String printed = AtCommonResource.MESSAGE_RESOURCE.getText("PRINTED");
        String of = AtCommonResource.MESSAGE_RESOURCE.getText("PAGE_OF");
        String total = AtCommonResource.MESSAGE_RESOURCE.getText("Total");
        double progress = (double)pageCount / (double)this.totalCount;
        int progressPercent = (int)(progress * 100.0);
        String msg = printed + " " + pageCount + " " + of + " " + total + " " + this.totalCount + " (" + progressPercent + "%)";
        this.progressWindow.setProgress(progressPercent);
        this.progressWindow.setHeaderMessage(msg);
    }

    protected void printFinished(DocEvent evt, Object source, String printerName) {
        this.checkIfCancelled();
        String printed_to = AtCommonResource.MESSAGE_RESOURCE.getText("Printed_to");
        String total = AtCommonResource.MESSAGE_RESOURCE.getText("Total");
        String pages = AtCommonResource.MESSAGE_RESOURCE.getText("PAGES_MSG");
        String msg = printed_to + ": " + printerName + " (" + total + " " + this.totalCount + " " + pages + ")";
        this.progressWindow.appendMessage(msg);
        this.progressWindow.setProgress(100);
    }

    protected void docError(DocEvent evt, Object failedDoc, int value, Object details) {
        this.checkIfCancelled();
        String print_error = AtCommonResource.MESSAGE_RESOURCE.getText("PRINT_ERROR");
        String msg = print_error + ": " + failedDoc + "\n" + value + "\n" + details;
        this.progressWindow.appendMessage(msg);
    }

    protected void jobFinished(DocEvent evt) {
        this.checkIfCancelled();
    }

    protected void checkIfCancelled() {
        if (this.cancelled) {
            throw new RuntimeException(cancelText);
        }
    }

    class AtProgressDialog
    extends JDialog {
        private JProgressBar progressBar;
        private JCheckBox checkBox;
        private JCheckBox showDetails;
        private JScrollPane scroller;
        private JTextArea textArea;
        private Vector clients;
        private String message;
        private JButton cancel;
        private JLabel headerLabel;

        public AtProgressDialog(String title, String message, Dialog parent, boolean modal, boolean showDetailsBox) {
            super(parent, title, modal);
            this.clients = new Vector();
            this.message = message;
            this.setupContentPane(parent, showDetailsBox);
        }

        public AtProgressDialog(String title, String message, Frame parent, boolean modal, boolean showDetailsBox) {
            super(parent, title, modal);
            this.clients = new Vector();
            this.message = message;
            this.setupContentPane(parent, showDetailsBox);
        }

        public void clean() {
            if (this.clients != null) {
                this.clients.clear();
                this.clients = null;
            }
        }

        public void setCloseEnabled(boolean enable) {
            this.cancel.setEnabled(enable);
        }

        private void setupContentPane(Container parent, boolean showDetailsBox) {
            this.headerLabel = new JLabel(this.message);
            this.progressBar = new JProgressBar(0, 100);
            this.progressBar.setBorderPainted(true);
            this.progressBar.setValue(0);
            this.progressBar.setString("0" + AtCommonResource.MESSAGE_RESOURCE.getText("PERCENT"));
            this.progressBar.setStringPainted(true);
            this.textArea = new JTextArea(5, 30);
            this.textArea.setBackground(SystemColor.white);
            this.textArea.setEditable(false);
            this.scroller = new JScrollPane(this.textArea);
            this.checkBox = new JCheckBox(AtCommonResource.MESSAGE_RESOURCE.getText("CLOSE_WINDOW_WHEN_COMPLETED"), false);
            this.checkBox.setMnemonic(AtCommonResource.MESSAGE_RESOURCE.getMnemonic("CLOSE_WINDOW_WHEN_COMPLETED"));
            this.showDetails = new JCheckBox(AtCommonResource.MESSAGE_RESOURCE.getText("SHOW_DETAILS"), showDetailsBox);
            this.showDetails.setMnemonic(AtCommonResource.MESSAGE_RESOURCE.getMnemonic("SHOW_DETAILS"));
            this.showDetails.addActionListener(new ActionListener(this){
                private final /* synthetic */ AtProgressDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent evt) {
                    this.this$1.showDetailsActionPerformed(evt);
                }
            });
            this.cancel = new JButton(cancelText);
            this.cancel.setMnemonic(AtCommonResource.MESSAGE_RESOURCE.getMnemonic("Cancel"));
            this.cancel.addActionListener(new ActionListener(this){
                private final /* synthetic */ AtProgressDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent evt) {
                    this.this$1.cancelActionPerformed(evt);
                }
            });
            JPanel cbPane = new JPanel(new GridBagLayout());
            cbPane.add((Component)this.checkBox, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 5), 0, 0));
            cbPane.add((Component)this.showDetails, new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
            JPanel top = new JPanel(new GridBagLayout());
            top.add((Component)this.headerLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0));
            top.add((Component)this.progressBar, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0));
            top.add((Component)this.scroller, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 0, 5), 0, 0));
            top.add((Component)cbPane, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0));
            top.add((Component)this.cancel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 12, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.setSize(new Dimension(500, 280));
            this.setContentPane(top);
            this.setDefaultCloseOperation(0);
            this.pack();
            AtComponentUtil.centerOnContainer(parent, this);
        }

        public void setHeaderMessage(String msg) {
            Runnable r = new Runnable(this, msg){
                private final /* synthetic */ String val$msg;
                private final /* synthetic */ AtProgressDialog this$1;
                {
                    this.this$1 = this$1;
                    this.val$msg = val$msg;
                }

                public void run() {
                    AtProgressDialog.access$000(this.this$1).setText(this.val$msg);
                }
            };
            SwingUtilities.invokeLater(r);
        }

        public String setHeaderMessage() {
            return this.headerLabel.getText();
        }

        public void addProgressStatusListener(ProgressStatusListener l2) {
            if (this.clients != null && !this.clients.contains(l2)) {
                this.clients.add(l2);
            }
        }

        public void removeProgressStatusListener(ProgressStatusListener l2) {
            if (this.clients != null) {
                this.clients.remove(l2);
            }
        }

        public void setShowDetails(boolean show) {
            this.showDetails.setSelected(show);
        }

        void showDetailsActionPerformed(ActionEvent evt) {
            Runnable runner = new Runnable(this){
                private final /* synthetic */ AtProgressDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    if (!AtProgressDialog.access$100(this.this$1).isSelected()) {
                        AtProgressDialog.access$200(this.this$1).setVisible(false);
                    } else {
                        AtProgressDialog.access$200(this.this$1).setVisible(true);
                    }
                    this.this$1.pack();
                }
            };
            SwingUtilities.invokeLater(runner);
        }

        void cancelActionPerformed(ActionEvent evt) {
            String text = evt.getActionCommand();
            this.setVisible(false);
            if (text.equalsIgnoreCase(cancelText)) {
                this.notifyClients(new ProgressStatusEvent(this, 2));
            } else {
                this.notifyClients(new ProgressStatusEvent(this, 3));
            }
        }

        public void setWindowDisposableOnSuccess(boolean disposableOnSuccess) {
            Runnable runner = new Runnable(this, disposableOnSuccess){
                private final /* synthetic */ boolean val$disposableOnSuccess;
                private final /* synthetic */ AtProgressDialog this$1;
                {
                    this.this$1 = this$1;
                    this.val$disposableOnSuccess = val$disposableOnSuccess;
                }

                public void run() {
                    AtProgressDialog.access$300(this.this$1).setSelected(this.val$disposableOnSuccess);
                }
            };
            SwingUtilities.invokeLater(runner);
        }

        public boolean isWindowDisposableOnSuccess() {
            return this.checkBox.isSelected();
        }

        public void setTextForTaskCompletionCheckBox(String text, char mnemonic) {
            Runnable runner = new Runnable(this, text, mnemonic){
                private final /* synthetic */ String val$text;
                private final /* synthetic */ char val$mnemonic;
                private final /* synthetic */ AtProgressDialog this$1;
                {
                    this.this$1 = this$1;
                    this.val$text = val$text;
                    this.val$mnemonic = val$mnemonic;
                }

                public void run() {
                    AtProgressDialog.access$300(this.this$1).setText(this.val$text);
                    AtProgressDialog.access$300(this.this$1).setMnemonic(this.val$mnemonic);
                    AtProgressDialog.access$300(this.this$1).repaint();
                }
            };
            SwingUtilities.invokeLater(runner);
        }

        public void setTextForShowDetailsCheckBox(String text, char mnemonic) {
            Runnable runner = new Runnable(this, text, mnemonic){
                private final /* synthetic */ String val$text;
                private final /* synthetic */ char val$mnemonic;
                private final /* synthetic */ AtProgressDialog this$1;
                {
                    this.this$1 = this$1;
                    this.val$text = val$text;
                    this.val$mnemonic = val$mnemonic;
                }

                public void run() {
                    AtProgressDialog.access$100(this.this$1).setText(this.val$text);
                    AtProgressDialog.access$100(this.this$1).setMnemonic(this.val$mnemonic);
                    AtProgressDialog.access$100(this.this$1).repaint();
                }
            };
            SwingUtilities.invokeLater(runner);
        }

        private void notifyClients(ProgressStatusEvent e) {
            for (int i = 0; this.clients != null && i < this.clients.size(); ++i) {
                ((ProgressStatusListener)this.clients.get(i)).progressReported(e);
            }
        }

        public void setCancelText(String text) {
            this.cancel.setText(text);
        }

        public void setProgress(int progress) {
            Runnable runner = new Runnable(this, progress){
                private final /* synthetic */ int val$progress;
                private final /* synthetic */ AtProgressDialog this$1;
                {
                    this.this$1 = this$1;
                    this.val$progress = val$progress;
                }

                public void run() {
                    if (this.val$progress < 100 && this.val$progress > 0) {
                        AtProgressDialog.access$400(this.this$1).setValue(this.val$progress);
                        AtProgressDialog.access$400(this.this$1).setString(this.val$progress + "%");
                        AtProgressDialog.access$400(this.this$1).setStringPainted(true);
                    } else if (this.val$progress == 100) {
                        AtProgressDialog.access$400(this.this$1).setValue(this.val$progress);
                        AtProgressDialog.access$400(this.this$1).setString(this.val$progress + "%");
                        AtProgressDialog.access$400(this.this$1).setStringPainted(true);
                        AtProgressDialog.access$500(this.this$1).setText(closeText);
                        AtProgressDialog.access$500(this.this$1).setEnabled(true);
                        AtProgressDialog.access$600(this.this$1, new ProgressStatusEvent(this, 1));
                        if (AtProgressDialog.access$300(this.this$1).isSelected()) {
                            this.this$1.setVisible(false);
                            this.this$1.dispose();
                        }
                    }
                }
            };
            SwingUtilities.invokeLater(runner);
        }

        public void appendMessage(String msg) {
            Runnable r = new Runnable(this, msg){
                private final /* synthetic */ String val$msg;
                private final /* synthetic */ AtProgressDialog this$1;
                {
                    this.this$1 = this$1;
                    this.val$msg = val$msg;
                }

                public void run() {
                    AtProgressDialog.access$700(this.this$1).append(this.val$msg + "\n");
                    AtProgressDialog.access$700(this.this$1).setCaretPosition(AtProgressDialog.access$700(this.this$1).getDocument().getLength());
                }
            };
            SwingUtilities.invokeLater(r);
        }

        public void setMessage(String msg) {
            Runnable r = new Runnable(this, msg){
                private final /* synthetic */ String val$msg;
                private final /* synthetic */ AtProgressDialog this$1;
                {
                    this.this$1 = this$1;
                    this.val$msg = val$msg;
                }

                public void run() {
                    AtProgressDialog.access$700(this.this$1).setText(this.val$msg);
                    AtProgressDialog.access$700(this.this$1).setCaretPosition(AtProgressDialog.access$700(this.this$1).getDocument().getLength());
                }
            };
            SwingUtilities.invokeLater(r);
        }

        public void start() {
            Runnable runner = new Runnable(this){
                private final /* synthetic */ AtProgressDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    this.this$1.setVisible(true);
                }
            };
            Thread t = new Thread(runner);
            t.start();
        }

        static /* synthetic */ JLabel access$000(AtProgressDialog x0) {
            return x0.headerLabel;
        }

        static /* synthetic */ JCheckBox access$100(AtProgressDialog x0) {
            return x0.showDetails;
        }

        static /* synthetic */ JScrollPane access$200(AtProgressDialog x0) {
            return x0.scroller;
        }

        static /* synthetic */ JCheckBox access$300(AtProgressDialog x0) {
            return x0.checkBox;
        }

        static /* synthetic */ JProgressBar access$400(AtProgressDialog x0) {
            return x0.progressBar;
        }

        static /* synthetic */ JButton access$500(AtProgressDialog x0) {
            return x0.cancel;
        }

        static /* synthetic */ void access$600(AtProgressDialog x0, ProgressStatusEvent x1) {
            x0.notifyClients(x1);
        }

        static /* synthetic */ JTextArea access$700(AtProgressDialog x0) {
            return x0.textArea;
        }
    }
}

