/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.web;

import com.activetree.common.attr.reader.CommonAttributeReader;
import com.activetree.common.utils.AtDebug;
import com.activetree.common.utils.StringUtil;
import com.activetree.common.web.CallBackReply;
import com.activetree.common.web.CallBackRequest;
import com.activetree.common.web.WebComm;
import com.activetree.common.web.WebContext;
import java.applet.Applet;
import java.applet.AppletContext;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Map;

public class BasicWebContextImpl
implements WebContext {
    protected final WebComm webComm = new WebComm();
    protected Object webContext;
    protected CommonAttributeReader webDoc;
    protected Component owner;
    static final String jsObject = "netscape.javascript.JSObject";

    public BasicWebContextImpl(Object webContext, CommonAttributeReader webDoc, Component owner) {
        this.webContext = webContext;
        this.webDoc = webDoc;
        this.owner = owner;
    }

    public CallBackReply callServer(String urlString, String method, CallBackRequest request) {
        URL url = null;
        try {
            url = new URL(urlString);
        }
        catch (Throwable t) {
            AtDebug.debug(9, t);
            return null;
        }
        Map reqParams = request.getParamMap();
        Map replyParams = this.webComm.getWebReply(url, method, reqParams);
        if (this.webComm.getErrorStack() != null) {
            throw new RuntimeException(this.webComm.getErrorMessage() + "\r\n" + this.webComm.getErrorStack());
        }
        CallBackReply reply = new CallBackReply(replyParams);
        return reply;
    }

    public CommonAttributeReader getWebDoc() {
        return this.webDoc;
    }

    public void setWebDoc(CommonAttributeReader webDoc) {
        this.webDoc = webDoc;
    }

    public Component getContextOwner() {
        return this.owner;
    }

    public void setContextOwner(Component owner) {
        this.owner = owner;
    }

    public void showPage(String urlStr, String target) {
        if (target == null) {
            target = "_blank";
        }
        try {
            URL url = new URL(urlStr);
            Object webContext = this.getWebContext();
            if (webContext == null || !(webContext instanceof Applet)) {
                throw new RuntimeException("Wrong web context: " + webContext);
            }
            Applet applet = (Applet)webContext;
            AppletContext appletContext = applet.getAppletContext();
            appletContext.showDocument(url, target);
            this.debug(1, "showPage(" + urlStr + ") called.");
        }
        catch (Throwable t) {
            this.debug(9, "ERROR: " + t.getMessage());
        }
    }

    public void showMessage(String msg) {
        boolean statusUpdateEnabled = this.getWebDoc().getPrimitiveBooleanAttribute("STATUS_UPDATE_ENABLED");
        try {
            if (statusUpdateEnabled) {
                String jsTarget = this.getWebDoc().getStringAttribute("ON_MESSAGE_JS_TARGET");
                this.showMessage(msg, jsTarget);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void showMessage(String message, String target) {
        message = this.unquoteMessage(message);
        try {
            String messageJavaScript = this.webDoc.getStringAttribute("ON_MESSAGE_JS_NAME");
            String jobId = "[" + this.getJobId() + "] ";
            message = jobId + message;
            String urlStr = "javascript:" + messageJavaScript + "('" + message + "')";
            URL url = new URL(urlStr);
            Object webContext = this.getWebContext();
            if (webContext != null && webContext instanceof Applet) {
                Applet applet = (Applet)webContext;
                AppletContext appletContext = applet.getAppletContext();
                this.debug(messageJavaScript + "(" + urlStr + ")");
                appletContext.showDocument(url);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected String getJobId() {
        String jobId = this.getWebDoc().getStringAttribute("JOB_ID");
        if (jobId == null) {
            jobId = "UNKNOWN";
        }
        return jobId;
    }

    protected String unquoteMessage(String msg) {
        if (msg == null || msg.length() == 0) {
            return msg;
        }
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < msg.length(); ++i) {
            char c = msg.charAt(i);
            if (c == '\'' || c == '\r' || c == '\n') continue;
            b.append(c);
        }
        return b.toString();
    }

    public Object callJavaScript(String jScript) {
        Object retVal;
        block4: {
            retVal = null;
            try {
                Class<?> c = Class.forName(jsObject);
                this.debug("netscape.javascript.JSObject->" + c);
                Method window = null;
                Method eval = null;
                Method[] jsMethods = c.getMethods();
                for (int i = 0; jsMethods != null && i < jsMethods.length; ++i) {
                    if (jsMethods[i].getName().compareTo("getWindow") == 0) {
                        window = jsMethods[i];
                        continue;
                    }
                    if (jsMethods[i].getName().compareTo("eval") != 0) continue;
                    eval = jsMethods[i];
                }
                this.debug("browserWindow=" + window);
                this.debug("eval=" + eval);
                Method jsWindowMethod = c.getDeclaredMethod("getWindow", Applet.class);
                this.debug("jsWindowMethod=" + jsWindowMethod);
                Object webCtx = this.getWebContext();
                this.debug("webCtx=" + webCtx + ": instance of Applet? " + (webCtx instanceof Applet));
                Object jsWindow = jsWindowMethod.invoke(c, webCtx);
                this.debug("jsWindow=" + jsWindow);
                Method evalMethod = c.getDeclaredMethod("eval", String.class);
                this.debug("evalMethod=" + evalMethod);
                retVal = evalMethod.invoke(jsWindow, jScript);
                this.debug("eval() called -- retVal=" + retVal);
            }
            catch (Throwable t) {
                if (this.webContext == null || !(this.webContext instanceof Applet)) break block4;
                this.debug(9, "js invoke (error): [" + t + "]");
            }
        }
        this.debug("js retVal=" + (retVal != null ? retVal.getClass().getName() : null));
        return retVal;
    }

    public void callJavaScript(String scriptName, String message) {
        block3: {
            String urlStr = "javascript:" + scriptName + "('" + message + "')";
            try {
                URL url = new URL(urlStr);
                Object webContext = this.getWebContext();
                if (webContext != null && webContext instanceof Applet) {
                    Applet applet = (Applet)webContext;
                    AppletContext appletContext = applet.getAppletContext();
                    appletContext.showDocument(url);
                }
            }
            catch (Throwable t) {
                if (this.webContext == null || !(this.webContext instanceof Applet)) break block3;
                this.debug(9, "callJavaScript: ERROR [" + t.getMessage() + "]");
            }
        }
    }

    public boolean isJobSuccessful() {
        CommonAttributeReader webDoc = this.getWebDoc();
        String jobStatus = webDoc.getStringAttribute("JOB_STATUS");
        boolean ret = false;
        if (jobStatus != null && jobStatus.equalsIgnoreCase("SUCCESS")) {
            ret = true;
        }
        this.debug("isJobSuccessful() " + ret);
        return ret;
    }

    public boolean isJobCancelled() {
        CommonAttributeReader webDoc = this.getWebDoc();
        String jobStatus = webDoc.getStringAttribute("JOB_STATUS");
        boolean ret = false;
        if (jobStatus != null && jobStatus.equalsIgnoreCase("CANCELED")) {
            ret = true;
        }
        this.debug("isJobCancelled() " + ret);
        return ret;
    }

    public boolean isJobFailed() {
        CommonAttributeReader webDoc = this.getWebDoc();
        String jobStatus = webDoc.getStringAttribute("JOB_STATUS");
        boolean ret = false;
        if (jobStatus != null && jobStatus.equalsIgnoreCase("FAILED")) {
            ret = true;
        }
        return ret;
    }

    protected boolean hasShowSuccessPage() {
        CommonAttributeReader webDoc = this.getWebDoc();
        String successPage = webDoc.getStringAttribute("ON_SUCCESS_SHOW_PAGE");
        boolean ret = false;
        if (successPage != null && !successPage.equalsIgnoreCase("")) {
            ret = true;
        }
        this.debug("hasShowSuccessPage() " + ret + "[successPage=" + successPage + "]");
        return ret;
    }

    protected boolean hasShowFailurePage() {
        CommonAttributeReader webDoc = this.getWebDoc();
        String failurePage = webDoc.getStringAttribute("ON_FAILURE_SHOW_PAGE");
        boolean ret = false;
        if (failurePage != null && !failurePage.equalsIgnoreCase("")) {
            ret = true;
        }
        this.debug("hasShowFailurePage() " + ret + "[failurePage=" + failurePage + "]");
        return ret;
    }

    public Object getWebContext() {
        if (this.webContext != null) {
            return this.webContext;
        }
        Applet applet = (Applet)BasicWebContextImpl.getParentForComponent(this.owner, Applet.class, true);
        if (applet == null) {
            return null;
        }
        this.webContext = applet;
        return this.webContext;
    }

    protected boolean isCallServerBefore() {
        CommonAttributeReader webDoc = this.getWebDoc();
        boolean callBefore = webDoc.getPrimitiveBooleanAttribute("IS_CALL_SERVER_BEFORE");
        this.debug("isCallServerBefore() " + callBefore);
        return callBefore;
    }

    protected boolean isCallServerAfter() {
        CommonAttributeReader webDoc = this.getWebDoc();
        boolean callAfter = webDoc.getPrimitiveBooleanAttribute("IS_CALL_SERVER_AFTER");
        this.debug("isCallServerAfter() " + callAfter);
        return callAfter;
    }

    protected boolean hasServerCallBackUrl() {
        CommonAttributeReader webDoc = this.getWebDoc();
        String serverCallBackUrl = webDoc.getStringAttribute("SERVER_CALL_BACK_URL");
        boolean ret = false;
        if (serverCallBackUrl != null && !serverCallBackUrl.equalsIgnoreCase("")) {
            ret = true;
        }
        this.debug("hasServerCallBackUrl() " + ret + " [callBackUrl=" + serverCallBackUrl + "]");
        return ret;
    }

    public void processCallBackReplyBefore(CallBackReply reply) {
        this.uploadCallBackParams(reply);
    }

    public void processCallBackReplyAfter(CallBackReply reply) {
        this.uploadCallBackParams(reply);
    }

    public void uploadCallBackParams(CallBackReply reply) {
        CommonAttributeReader webDoc = this.getWebDoc();
        if (reply == null || reply.getParameterCount() == 0) {
            return;
        }
        String[] paramNames = reply.getParameterNames();
        for (int i = 0; paramNames != null && i < paramNames.length; ++i) {
            String paramName = paramNames[i];
            String paramValue = reply.getParameter(paramName);
            webDoc.setAttribute(paramName, paramValue);
        }
    }

    public CallBackReply callServer(String whenValue, String requestName) {
        return null;
    }

    public void onSuccessShowPage() {
    }

    public void onFailureShowPage() {
    }

    public String getDebugString() {
        StringBuffer buf = new StringBuffer();
        String docStr = this.getWebDoc().getDebugString();
        buf.append(docStr == null ? "" : docStr);
        buf.append(", owner: " + (this.getContextOwner() == null ? "null" : this.getContextOwner().getClass().getName()));
        return buf.toString();
    }

    public void debug(Object message) {
        this.debug(1, message);
    }

    public void debug(int debugLevel, Object message) {
        AtDebug.debug(debugLevel, message);
    }

    public void doOnMouseDown() {
    }

    public void doOnMouseUp() {
    }

    public void doOnMouseClick() {
    }

    public void doOnMouseDoubleClick() {
    }

    public void doOnMouseEnter() {
    }

    public void doOnMouseOver() {
    }

    public void doOnMouseOut() {
    }

    public static Window getWindowForComponent(Component comp) {
        if (comp == null) {
            return null;
        }
        if (comp instanceof Window) {
            return (Window)comp;
        }
        for (Container parent = comp.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof Window)) continue;
            return (Window)parent;
        }
        return null;
    }

    public static Component getParentForComponent(Component from, Class parentToFind, boolean matchType) {
        if (from == null) {
            return null;
        }
        for (Component parent = from; parent != null; parent = parent.getParent()) {
            boolean typeMatched = false;
            if (matchType) {
                typeMatched = parentToFind.isInstance(parent);
            }
            boolean exactMatch = parent.getClass().getName().equals(parentToFind.getName());
            if (!typeMatched && !exactMatch) continue;
            return parent;
        }
        return null;
    }

    public String getStackTrace(Throwable aThrowable) {
        String stack = StringUtil.getStackTrace(aThrowable);
        return stack;
    }
}

