/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.web;

import com.activetree.common.attr.AbstractDocAttributes;
import com.activetree.common.data.KeyValue;
import java.io.Serializable;
import java.util.Hashtable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class MeAttributeParser
implements Serializable {
    public void populateMouseHandlerAttributes(AbstractDocAttributes obj, NodeList childNodes) throws Throwable {
        this.populateMouseHandlerAttributes("onMouseClick", "web", "java", obj, childNodes);
        this.populateMouseHandlerAttributes("onMouseDoubleClick", "web", "java", obj, childNodes);
    }

    protected void populateMouseHandlerAttributes(String attr, String webParam, String javaParam, AbstractDocAttributes obj, NodeList childNodes) throws Throwable {
        KeyValue javaAction;
        if (obj == null || childNodes == null || childNodes.getLength() == 0) {
            return;
        }
        Node onMoseClick = this.getProperty(attr, childNodes);
        if (onMoseClick == null) {
            return;
        }
        NodeList cp = onMoseClick.getChildNodes();
        if (cp == null || cp.getLength() == 0) {
            return;
        }
        Node webNode = this.getProperty(webParam, cp);
        Node javaNode = this.getProperty(javaParam, cp);
        KeyValue webAction = this.getWebAction(webNode, "url", "target");
        Hashtable<String, KeyValue> meActions = null;
        if (webAction != null) {
            if (meActions == null) {
                meActions = new Hashtable<String, KeyValue>();
            }
            meActions.put("web", webAction);
        }
        if ((javaAction = this.getWebAction(javaNode, "beanName", "beanMethod")) != null) {
            if (meActions == null) {
                meActions = new Hashtable();
            }
            meActions.put(javaParam, javaAction);
        }
        if (meActions != null) {
            obj.setAttribute(attr, meActions);
        }
    }

    protected KeyValue getWebAction(Node node, String attr1, String attr2) {
        NodeList webNodeChilds;
        if (node != null && ((webNodeChilds = node.getChildNodes()) != null || webNodeChilds.getLength() > 0)) {
            String param1 = this.parseString(webNodeChilds, attr1);
            String param2 = this.parseString(webNodeChilds, attr2);
            KeyValue kv = new KeyValue(param1, param2);
            return kv;
        }
        return null;
    }

    protected Node getProperty(String propertyName, NodeList propertiesList) {
        for (int i = 0; propertiesList != null && i < propertiesList.getLength(); ++i) {
            String nodeName;
            Node aProperty = propertiesList.item(i);
            if (!(aProperty instanceof Element) || (nodeName = aProperty.getNodeName()) == null || !(nodeName = nodeName.trim()).equalsIgnoreCase(propertyName)) continue;
            return aProperty;
        }
        return null;
    }

    protected String parseString(NodeList childProperties, String propertyName) {
        if (childProperties == null) {
            return null;
        }
        Node prop = this.getProperty(propertyName, childProperties);
        String value = this.getPropertyValue(prop);
        return value;
    }

    protected String getPropertyValue(Node property) {
        if (property == null) {
            return null;
        }
        NodeList childs = property.getChildNodes();
        for (int i = 0; childs != null && i < childs.getLength(); ++i) {
            String value;
            Node aChildNode = childs.item(i);
            if (!(aChildNode instanceof Text) || (value = aChildNode.getNodeValue()) == null) continue;
            value = value.trim();
            return value;
        }
        return null;
    }
}

