/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.web;

import com.activetree.common.utils.AtDebug;
import com.activetree.common.utils.DataCommUtil;
import com.activetree.common.utils.StringUtil;
import com.activetree.common.utils.WebUtil;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;

public class WebComm
implements Serializable {
    private static final String SET_COOKIE = "Set-Cookie";
    private static final String COOKIE_VALUE_DELIMITER = ";";
    private static final String PATH = "path";
    private static final String EXPIRES = "expires";
    private static final String DATE_FORMAT = "EEE, dd-MMM-yyyy hh:mm:ss z";
    private static final String SET_COOKIE_SEPARATOR = ";";
    private static final String COOKIE = "Cookie";
    private static final String NAME_VALUE_SEPARATOR = "=";
    private static final char DOT = '.';
    private DateFormat dateFormat = new SimpleDateFormat("EEE, dd-MMM-yyyy hh:mm:ss z");
    private String errorMessage;
    private String errorStack;

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getErrorStack() {
        return this.errorStack;
    }

    public String autoLogin(String loginUrlStr, Map params, Map cookies) throws Throwable {
        URL loginUrl = new URL(loginUrlStr);
        HttpURLConnection con = (HttpURLConnection)loginUrl.openConnection();
        con.connect();
        Map cookies2 = this.getCookies(con);
        if (cookies == null) {
            throw new RuntimeException("Cookies map is null.");
        }
        cookies.putAll(cookies2);
        con.disconnect();
        String loginReply = this.getWebReply(loginUrl, "POST", params, cookies);
        return loginReply;
    }

    private Map getCookies(URLConnection conn) throws Throwable {
        String headerName = null;
        HashMap<String, String> cookies = new HashMap<String, String>();
        int i = 1;
        while ((headerName = conn.getHeaderFieldKey(i)) != null) {
            if (headerName.equalsIgnoreCase(SET_COOKIE)) {
                StringTokenizer st = new StringTokenizer(conn.getHeaderField(i), ";");
                while (st.hasMoreTokens()) {
                    String aCookie = st.nextToken();
                    StringTokenizer tk = new StringTokenizer(aCookie, NAME_VALUE_SEPARATOR);
                    while (tk != null && tk.hasMoreTokens()) {
                        String key = tk.nextToken();
                        String value = tk.nextToken();
                        key = key.trim();
                        value = value.trim();
                        if (key.equals("")) continue;
                        cookies.put(key, value);
                    }
                }
            }
            ++i;
        }
        return cookies;
    }

    public String getWebReply(URL url, String method, Map requestParams, Map cookies) throws Throwable {
        String reply = null;
        if (method == null) {
            method = "POST";
        }
        String postData = this.createURLEncodedQueryString(requestParams);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        this.setCookies(connection, cookies);
        connection.setRequestMethod(method);
        connection.setUseCaches(false);
        connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        connection.setDoInput(true);
        if (postData != null) {
            connection.setDoOutput(true);
            connection.setRequestProperty("Content-Length", "" + Integer.toString(postData.getBytes().length));
            DataOutputStream out = new DataOutputStream(connection.getOutputStream());
            out.writeBytes(postData);
            out.flush();
            out.close();
        }
        InputStream is = connection.getInputStream();
        byte[] data = this.readStream(is);
        connection.disconnect();
        String replyData = null;
        if (data != null) {
            replyData = new String(data);
        }
        reply = replyData;
        return reply;
    }

    private void setCookies(URLConnection conn, Map cookies) throws Throwable {
        if (cookies == null || cookies.size() == 0) {
            return;
        }
        URL url = conn.getURL();
        String path = url.getPath();
        StringBuffer cookieStringBuffer = new StringBuffer();
        Iterator cookieNames = cookies.keySet().iterator();
        while (cookieNames.hasNext()) {
            String cookieName = (String)cookieNames.next();
            String cookieValue = (String)cookies.get(cookieName);
            if (!this.comparePaths((String)cookies.get(PATH), path) || !this.isNotExpired((String)cookies.get(EXPIRES))) continue;
            cookieStringBuffer.append(cookieName);
            cookieStringBuffer.append(NAME_VALUE_SEPARATOR);
            cookieStringBuffer.append(cookieValue);
            cookieStringBuffer.append("; ");
        }
        char lastChar = cookieStringBuffer.charAt(cookieStringBuffer.length() - 2);
        if (lastChar == ";".charAt(0)) {
            cookieStringBuffer.deleteCharAt(cookieStringBuffer.length() - 2);
        }
        String cookieString = cookieStringBuffer.toString();
        cookieString = cookieString.trim();
        try {
            conn.setRequestProperty(COOKIE, cookieString);
        }
        catch (IllegalStateException ise) {
            IOException ioe = new IOException("Illegal State! Cookies cannot be set on a URLConnection that is already connected.\n" + ise.getMessage());
            throw ioe;
        }
    }

    private boolean isNotExpired(String cookieExpires) {
        if (cookieExpires == null) {
            return true;
        }
        Date now = new Date();
        try {
            return now.compareTo(this.dateFormat.parse(cookieExpires)) <= 0;
        }
        catch (ParseException pe) {
            AtDebug.debug(9, "Cookie Parsing exception for cookieExpires=\"" + cookieExpires + "\"");
            return false;
        }
    }

    private boolean comparePaths(String cookiePath, String targetPath) {
        if (cookiePath == null) {
            return true;
        }
        if (cookiePath.equals("/")) {
            return true;
        }
        return targetPath.regionMatches(0, cookiePath, 0, cookiePath.length());
    }

    public Map getWebReply(URL url, String method, Map requestParams) {
        AtDebug.debug("=== Start getWebReply() ===");
        AtDebug.debug("URL=" + url);
        AtDebug.debug("Method=" + method);
        AtDebug.debug("requestParams=" + requestParams);
        this.errorMessage = null;
        this.errorStack = null;
        HashMap<String, String> reply = null;
        if (method == null) {
            method = "POST";
        }
        try {
            String queryString = this.createURLEncodedQueryString(requestParams);
            String postData = null;
            if (method.equalsIgnoreCase("GET")) {
                url = this.createGetURL(url.toExternalForm(), queryString);
            } else {
                postData = queryString;
            }
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            DataCommUtil.setJSessionID(connection);
            connection.setUseCaches(false);
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            connection.setDoInput(true);
            if (postData != null) {
                connection.setDoOutput(true);
                connection.setRequestProperty("Content-Length", "" + Integer.toString(postData.getBytes().length));
                DataOutputStream out = new DataOutputStream(connection.getOutputStream());
                out.writeBytes(postData);
                out.flush();
                out.close();
            }
            InputStream is = connection.getInputStream();
            byte[] data = this.readStream(is);
            connection.disconnect();
            String replyData = "";
            if (data != null) {
                replyData = new String(data, "UTF-8");
            }
            AtDebug.debug("replyData: [" + replyData + "]");
            String s = null;
            if (replyData != null && replyData.length() > 0) {
                s = URLDecoder.decode(replyData, "UTF-8");
            }
            AtDebug.debug("Decoded reply data: [" + s + "]");
            String docList = WebUtil.parseDocListParam("DOC_LIST", s);
            AtDebug.debug("docList=[" + docList + "]");
            String paramString = s;
            if (docList != null && docList.length() > 0) {
                String fs;
                String docListParam = "DOC_LIST=" + docList;
                int idx1 = s.indexOf(docListParam);
                int idx2 = idx1 + docListParam.length();
                String s1 = s.substring(0, idx1);
                String s2 = s.substring(idx2);
                paramString = fs = s1 + s2;
            }
            if ((reply = this.getURLDecodedMap(paramString)) == null && docList != null && docList.length() > 0) {
                reply = new HashMap<String, String>();
            }
            if (docList != null && docList.length() > 0) {
                reply.put("DOC_LIST", docList);
            }
            AtDebug.debug("Reply Map: " + reply);
        }
        catch (Throwable t) {
            this.errorMessage = t.getMessage();
            this.errorStack = StringUtil.getStackTrace(t);
            AtDebug.debug(9, t);
            return null;
        }
        AtDebug.debug("**** End getWebReply() ***");
        return reply;
    }

    protected URL createGetURL(String baseUrl, String qString) throws IOException {
        String urlWithQString = null;
        urlWithQString = qString != null && qString.length() > 0 ? baseUrl + "?" + qString : baseUrl;
        URL url = new URL(urlWithQString);
        return url;
    }

    protected byte[] readStream(InputStream is) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        int bytesCount = 0;
        while ((bytesCount = is.read(buf)) != -1) {
            out.write(buf, 0, bytesCount);
        }
        is.close();
        out.close();
        byte[] data = out.toByteArray();
        return data;
    }

    protected Map getURLDecodedMap(String s) throws UnsupportedEncodingException {
        if (s == null || s.length() == 0) {
            return null;
        }
        s = URLDecoder.decode(s, "UTF-8");
        HashMap<String, String> map = new HashMap<String, String>();
        StringTokenizer tk = new StringTokenizer(s, "&");
        while (tk.hasMoreTokens()) {
            String aTk = tk.nextToken();
            aTk = aTk.trim();
            try {
                StringTokenizer tk2 = new StringTokenizer(aTk, NAME_VALUE_SEPARATOR);
                String key = tk2.nextToken();
                String value = tk2.nextToken();
                key = key.trim();
                value = value.trim();
                map.put(key, value);
            }
            catch (Throwable t) {}
        }
        return map;
    }

    protected String createURLEncodedQueryString(Map params) throws IOException {
        if (params == null || params.size() == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        Iterator keyIter = params.keySet().iterator();
        while (keyIter != null && keyIter.hasNext()) {
            String value;
            Object aKey = keyIter.next();
            Object aValue = params.get(aKey);
            if (aValue == null || (value = aValue instanceof String ? (String)aValue : aValue.toString()) == null || value.equalsIgnoreCase("null") || value.length() == 0) continue;
            buf.append(URLEncoder.encode((String)aKey, "UTF-8"));
            buf.append('=');
            buf.append(URLEncoder.encode(value, "UTF-8"));
            buf.append('&');
        }
        if (buf.charAt(buf.length() - 1) == '&') {
            buf.delete(buf.length() - 1, buf.length());
        }
        String s = buf.toString();
        return s;
    }

    public static final void main(String[] args) throws Throwable {
        String urlStr = args[0];
        URL url = new URL(urlStr);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("REQUEST_NAME", "DOC_ID");
        map.put("DOC_ID", "demoDocId");
        map.put("PAPER", "(612, 792)");
        map.put("TEST KEY", "Test value");
        map.put("NULL TEST", null);
        WebComm test = new WebComm();
        Map postReply = test.getWebReply(url, "POST", map);
        System.out.println("postReply=" + postReply);
        Map getReply = test.getWebReply(url, "GET", map);
        System.out.println("getReply=" + getReply);
    }
}

