/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.web;

import com.activetree.common.attr.reader.CommonAttributeReader;
import com.activetree.common.web.BasicWebContextImpl;
import com.activetree.common.web.CallBackReply;
import com.activetree.common.web.CallBackRequest;
import com.activetree.common.web.WebDoc;
import java.awt.Component;
import java.util.Map;

public class WebContextImpl
extends BasicWebContextImpl {
    public WebContextImpl(Object webCtx, CommonAttributeReader webDoc, Component owner) {
        super(webCtx, webDoc, owner);
    }

    public CallBackReply callServer(String method, String requestName) {
        if (!this.hasServerCallBackUrl()) {
            return null;
        }
        CallBackReply reply = null;
        WebDoc webDoc = (WebDoc)this.getWebDoc();
        String serverCallBackPage = webDoc.getStringAttribute("SERVER_CALL_BACK_URL");
        if (serverCallBackPage != null) {
            try {
                Map callBackParams = webDoc.getCallBackParams();
                webDoc.setAttribute("REQUEST_NAME", requestName, callBackParams);
                CallBackRequest req = new CallBackRequest(callBackParams);
                reply = this.callServer(serverCallBackPage, method, req);
            }
            catch (Throwable t) {
                this.debug(9, serverCallBackPage + " got error (" + t.getMessage() + ")");
                this.debug(9, t);
            }
            this.debug("Server callback reply: " + reply);
        }
        return reply;
    }

    public void onSuccessShowPage() {
        boolean isShowPrintPreview = this.webDoc.getPrimitiveBooleanAttribute("IS_SHOW_PRINT_PREVIEW");
        if (isShowPrintPreview) {
            this.debug("onSuccessShowPage() isShowPrintPreview " + isShowPrintPreview + " - returning.");
            return;
        }
        if (this.isJobFailed() || this.isJobCancelled()) {
            return;
        }
        if (!this.hasShowSuccessPage()) {
            return;
        }
        WebDoc webDoc = (WebDoc)this.getWebDoc();
        String onSuccessPage = webDoc.getStringAttribute("ON_SUCCESS_SHOW_PAGE");
        String onSuccessPageTarget = webDoc.getStringAttribute("ON_SUCCESS_PAGE_TARGET");
        if (onSuccessPage != null) {
            try {
                String queryString = webDoc.getOnSuccessQueryString(webDoc);
                String s = null;
                int idx = onSuccessPage.indexOf(63);
                s = idx >= 0 ? onSuccessPage + "&" + queryString : onSuccessPage + "?" + queryString;
                this.showPage(s, onSuccessPageTarget);
            }
            catch (Throwable t) {
                this.debug(9, "Error in parsing on success query string.");
                this.debug(9, t);
            }
        }
    }

    public void onFailureShowPage() {
        boolean isShowPrintPreview = this.webDoc.getPrimitiveBooleanAttribute("IS_SHOW_PRINT_PREVIEW");
        if (isShowPrintPreview) {
            this.debug("onFailureShowPage() isShowPrintPreview " + isShowPrintPreview + " - returning.");
            return;
        }
        if (this.isJobSuccessful()) {
            return;
        }
        if (!this.hasShowFailurePage()) {
            return;
        }
        WebDoc webDoc = (WebDoc)this.getWebDoc();
        String onFailurePage = webDoc.getStringAttribute("ON_FAILURE_SHOW_PAGE");
        String onFailurePageTarget = webDoc.getStringAttribute("ON_FAILURE_PAGE_TARGET");
        if (onFailurePage != null) {
            try {
                String queryString = webDoc.getOnFailureQueryString(webDoc);
                String s = null;
                int idx = onFailurePage.indexOf(63);
                s = idx >= 0 ? onFailurePage + "&" + queryString : onFailurePage + "?" + queryString;
                this.showPage(s, onFailurePageTarget);
            }
            catch (Throwable t) {
                this.debug(9, "Error parsing on failure page query string.");
                this.debug(9, t);
            }
        }
    }
}

