/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.date;

import com.icafe4j.date.DateTime;
import com.icafe4j.string.StringUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class DateUtils {
    private DateUtils() {
    }

    public static Date dateAfter(Date date, int n, int n2) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(1, n);
        calendar.add(2, n2);
        return calendar.getTime();
    }

    public static Date dateAfter(Date date, int n, int n2, int n3) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(1, n);
        calendar.add(2, n2);
        calendar.add(5, n3);
        return calendar.getTime();
    }

    public static Date dateAfter(Date date, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(1, n);
        calendar.add(2, n2);
        calendar.add(5, n3);
        calendar.add(10, n4);
        calendar.add(12, n5);
        calendar.add(13, n6);
        calendar.add(14, n7);
        return calendar.getTime();
    }

    public static Date daysAfter(Date date, int n) {
        return new Date(date.getTime() + 86400000L * (long)n);
    }

    public static String format(Date date, String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        return simpleDateFormat.format(date);
    }

    public static String formatISO8601(Date date) {
        return DateUtils.format(date, "yyyy-MM-dd'T'HH:mm:ss.SSS");
    }

    public static String formatISO8601(Date date, TimeZone timeZone) {
        SimpleDateFormat simpleDateFormat = null;
        if (timeZone != null) {
            simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'.'SSSZ");
            simpleDateFormat.setTimeZone(timeZone);
            String string = simpleDateFormat.format(date);
            if (string.endsWith("0000")) {
                return string.replaceAll("[+-]0000$", "Z");
            }
            return string.replaceAll("(\\d{2})(\\d{2})$", "$1:$2");
        }
        simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        return simpleDateFormat.format(date);
    }

    public static Date hoursAfter(Date date, int n) {
        return new Date(date.getTime() + 3600000L * (long)n);
    }

    public static boolean isValidDateStr(String string, String string2) {
        return DateUtils.isValidDateStr(string, string2, Locale.getDefault());
    }

    public static boolean isValidDateStr(String string, String string2, Locale locale) {
        if (StringUtils.isNullOrEmpty(string) || StringUtils.isNullOrEmpty(string2)) {
            throw new IllegalArgumentException("Null or empty date/format.");
        }
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2, locale);
            simpleDateFormat.setLenient(false);
            simpleDateFormat.parse(string);
        }
        catch (ParseException parseException) {
            return false;
        }
        return true;
    }

    public static Date monthsAfter(Date date, int n) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, n);
        return calendar.getTime();
    }

    public static DateTime parseISO8601(String string) throws ParseException {
        TimeZone timeZone = null;
        StringBuilder stringBuilder = new StringBuilder(30);
        String[] stringArray = new String[]{"yyyy", "yyyy-MM", "yyyy-MM-dd"};
        String[] stringArray2 = new String[]{"HH", "HH:mm", "HH:mm:ss"};
        String[] stringArray3 = string.split("-");
        stringBuilder.append(stringArray[Math.min(stringArray3.length - 1, 2)]);
        int n = string.indexOf("T");
        if (n > 0) {
            string = string.replace("Z", "+00:00");
            boolean bl = false;
            int n2 = 0;
            String string2 = string.substring(n);
            if (string2.indexOf("+") > 0 || string2.indexOf("-") > 0) {
                bl = true;
                n2 = 5;
                timeZone = TimeZone.getTimeZone("GMT" + string.substring(string.length() - 6));
                string = StringUtils.replaceLast(string, ":", "");
            }
            String[] stringArray4 = string.split(":");
            stringBuilder.append("'T'");
            stringBuilder.append(stringArray2[stringArray4.length - 1]);
            int n3 = string.indexOf(".");
            if (n3 > 0) {
                stringBuilder.append("'.'");
                int n4 = string.length() - n3 - 1 - n2;
                if (n4 > 3) {
                    String string3 = string.substring(n3, n3 + n4 + 1);
                    string = string.replace(string3, string.substring(n3, n3 + 4));
                }
                for (int i = n4; i > 0; --i) {
                    stringBuilder.append("S");
                }
            }
            if (bl) {
                stringBuilder.append("Z");
            }
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(stringBuilder.toString());
        return new DateTime(simpleDateFormat.parse(string), timeZone);
    }

    public static Date yearsAfter(Date date, int n) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(1, n);
        return calendar.getTime();
    }
}

