/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.compression.lzw;

import com.icafe4j.image.compression.ImageEncoder;
import com.icafe4j.image.compression.lzw.LZWCompressionTable;
import com.icafe4j.util.Updatable;
import java.io.OutputStream;
import java.util.Arrays;

public class LZWHashEncoder
implements ImageEncoder {
    private static short EMPTY = (short)-1;
    private int codeSize;
    private int codeLen;
    private int clearCode;
    private int endOfImage;
    private int limit;
    private short prefix = EMPTY;
    private int bufIndex = 0;
    private int empty_bits;
    private int buf_length;
    private byte[] bytes_buf;
    private OutputStream os;
    private boolean isTIFF = false;
    private Updatable<Integer> writer;
    private LZWCompressionTable stringTable = new LZWCompressionTable();
    private static final short[] mask = new short[]{0, 1, 3, 7, 15, 31, 63, 127, 255};
    int compressedDataLen = 0;

    public LZWHashEncoder(OutputStream outputStream, int n, int n2) {
        this.codeSize = n;
        this.bytes_buf = new byte[n2];
        this.buf_length = n2;
        this.os = outputStream;
    }

    public LZWHashEncoder(OutputStream outputStream, int n, int n2, Updatable<Integer> updatable) {
        this(outputStream, n, n2);
        this.isTIFF = true;
        this.writer = updatable;
    }

    @Override
    public void initialize() throws Exception {
        this.clearCode = 1 << this.codeSize;
        this.endOfImage = this.clearCode + 1;
        this.codeLen = this.codeSize + 1;
        this.limit = (1 << this.codeLen) - 1;
        this.empty_bits = 8;
        this.stringTable.clearTable(this.codeSize);
        this.compressedDataLen = 0;
        this.prefix = EMPTY;
        if (!this.isTIFF) {
            this.os.write(this.codeSize);
        }
        this.send_code_to_buffer(this.clearCode);
    }

    @Override
    public void encode(byte[] byArray, int n, int n2) throws Exception {
        if (n < 0 || n2 <= 0) {
            return;
        }
        byte by = 0;
        short s = 0;
        for (int i = n; i < n + n2; ++i) {
            by = byArray[i];
            s = this.stringTable.findCharString(this.prefix, by);
            if (s != EMPTY) {
                this.prefix = s;
                continue;
            }
            this.send_code_to_buffer(this.prefix);
            if (this.stringTable.addCharString(this.prefix, by) > (this.isTIFF ? this.limit - 1 : this.limit)) {
                if (++this.codeLen > 12) {
                    --this.codeLen;
                    this.send_code_to_buffer(this.clearCode);
                    this.stringTable.clearTable(this.codeSize);
                    this.codeLen = this.codeSize + 1;
                }
                this.limit = (1 << this.codeLen) - 1;
            }
            this.prefix = (short)(by & 0xFF);
        }
    }

    @Override
    public void finish() throws Exception {
        if (this.prefix != EMPTY) {
            this.send_code_to_buffer(this.prefix);
        }
        this.send_code_to_buffer(this.endOfImage);
        this.flush_buf(this.bufIndex + 1);
        if (this.isTIFF) {
            this.writer.update(this.compressedDataLen);
        }
    }

    @Override
    public int getCompressedDataLen() {
        return this.compressedDataLen;
    }

    private void send_code_to_buffer(int n) throws Exception {
        int n2 = this.codeLen;
        if (this.isTIFF) {
            int n3 = this.bufIndex;
            this.bytes_buf[n3] = (byte)(this.bytes_buf[n3] | n >>> n2 & mask[this.empty_bits]);
            for (n2 = this.codeLen - this.empty_bits; n2 > 8; n2 -= 8) {
                if (++this.bufIndex >= this.buf_length) {
                    this.flush_buf(this.buf_length);
                }
                int n4 = this.bufIndex;
                this.bytes_buf[n4] = (byte)(this.bytes_buf[n4] | n >>> n2 - 8 & mask[8]);
            }
            if (n2 > 0) {
                if (++this.bufIndex >= this.buf_length) {
                    this.flush_buf(this.buf_length);
                }
                int n5 = this.bufIndex;
                this.bytes_buf[n5] = (byte)(this.bytes_buf[n5] | (n & mask[n2]) << 8 - n2);
                n2 -= 8;
            }
        } else {
            int n6 = this.bufIndex;
            this.bytes_buf[n6] = (byte)(this.bytes_buf[n6] | (n & mask[this.empty_bits]) << 8 - this.empty_bits);
            n >>= this.empty_bits;
            n2 -= this.empty_bits;
            while (n2 > 0) {
                if (++this.bufIndex >= this.buf_length) {
                    this.flush_buf(this.buf_length);
                }
                int n7 = this.bufIndex;
                this.bytes_buf[n7] = (byte)(this.bytes_buf[n7] | n & 0xFF);
                n >>= 8;
                n2 -= 8;
            }
        }
        this.empty_bits = -n2;
    }

    private void flush_buf(int n) throws Exception {
        if (!this.isTIFF) {
            this.os.write(n);
        }
        this.os.write(this.bytes_buf, 0, n);
        this.bufIndex = 0;
        Arrays.fill(this.bytes_buf, 0, n, (byte)0);
        this.compressedDataLen += n;
    }
}

