/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.jpeg;

public class JPEGConsts {
    public static final int SUBSAMPLING_NONE = 0;
    public static final int SUBSAMPLING_422 = 1;
    public static final int SUBSAMPLING_420 = 2;
    private static final int[] ZIGZAG_TRAVERSE_ORDER = new int[]{0, 1, 8, 16, 9, 2, 3, 10, 17, 24, 32, 25, 18, 11, 4, 5, 12, 19, 26, 33, 40, 48, 41, 34, 27, 20, 13, 6, 7, 14, 21, 28, 35, 42, 49, 56, 57, 50, 43, 36, 29, 22, 15, 23, 30, 37, 44, 51, 58, 59, 52, 45, 38, 31, 39, 46, 53, 60, 61, 54, 47, 55, 62, 63};
    private static final int[] DE_ZIGZAG_TRAVERSE_ORDER = new int[]{0, 1, 5, 6, 14, 15, 27, 28, 2, 4, 7, 13, 16, 26, 29, 42, 3, 8, 12, 17, 25, 30, 41, 43, 9, 11, 18, 24, 31, 40, 44, 53, 10, 19, 23, 32, 39, 45, 52, 54, 20, 22, 33, 38, 46, 51, 55, 60, 21, 34, 37, 47, 50, 56, 59, 61, 35, 36, 48, 49, 57, 58, 62, 63};
    private static final int[] QUANT_LUMINANCE = new int[]{16, 11, 10, 16, 24, 40, 51, 61, 12, 12, 14, 19, 26, 58, 60, 55, 14, 13, 16, 24, 40, 57, 69, 56, 14, 17, 22, 29, 51, 87, 80, 62, 18, 22, 37, 56, 68, 109, 103, 77, 24, 35, 55, 64, 81, 104, 113, 92, 49, 64, 78, 87, 103, 121, 120, 101, 72, 92, 95, 98, 112, 100, 103, 99};
    private static final int[] QUANT_CHROMINANCE = new int[]{17, 18, 24, 47, 99, 99, 99, 99, 18, 21, 26, 66, 99, 99, 99, 99, 24, 26, 56, 99, 99, 99, 99, 99, 47, 66, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99};
    private static final byte[] DC_LUMINANCE_BITS = new byte[]{0, 1, 5, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0};
    private static final byte[] DC_LUMINANCE_VALUES = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11};
    private static final byte[] DC_CHROMINANCE_BITS = new byte[]{0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0};
    private static final byte[] DC_CHROMINANCE_VALUES = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11};
    private static final byte[] AC_LUMINANCE_BITS = new byte[]{0, 2, 1, 3, 3, 2, 4, 3, 5, 5, 4, 4, 0, 0, 1, 125};
    private static final byte[] AC_LUMINANCE_VALUES = new byte[]{1, 2, 3, 0, 4, 17, 5, 18, 33, 49, 65, 6, 19, 81, 97, 7, 34, 113, 20, 50, -127, -111, -95, 8, 35, 66, -79, -63, 21, 82, -47, -16, 36, 51, 98, 114, -126, 9, 10, 22, 23, 24, 25, 26, 37, 38, 39, 40, 41, 42, 52, 53, 54, 55, 56, 57, 58, 67, 68, 69, 70, 71, 72, 73, 74, 83, 84, 85, 86, 87, 88, 89, 90, 99, 100, 101, 102, 103, 104, 105, 106, 115, 116, 117, 118, 119, 120, 121, 122, -125, -124, -123, -122, -121, -120, -119, -118, -110, -109, -108, -107, -106, -105, -104, -103, -102, -94, -93, -92, -91, -90, -89, -88, -87, -86, -78, -77, -76, -75, -74, -73, -72, -71, -70, -62, -61, -60, -59, -58, -57, -56, -55, -54, -46, -45, -44, -43, -42, -41, -40, -39, -38, -31, -30, -29, -28, -27, -26, -25, -24, -23, -22, -15, -14, -13, -12, -11, -10, -9, -8, -7, -6};
    private static final byte[] AC_CHROMINANCE_BITS = new byte[]{0, 2, 1, 2, 4, 4, 3, 4, 7, 5, 4, 4, 0, 1, 2, 119};
    private static final byte[] AC_CHROMINANCE_VALUES = new byte[]{0, 1, 2, 3, 17, 4, 5, 33, 49, 6, 18, 65, 81, 7, 97, 113, 19, 34, 50, -127, 8, 20, 66, -111, -95, -79, -63, 9, 35, 51, 82, -16, 21, 98, 114, -47, 10, 22, 36, 52, -31, 37, -15, 23, 24, 25, 26, 38, 39, 40, 41, 42, 53, 54, 55, 56, 57, 58, 67, 68, 69, 70, 71, 72, 73, 74, 83, 84, 85, 86, 87, 88, 89, 90, 99, 100, 101, 102, 103, 104, 105, 106, 115, 116, 117, 118, 119, 120, 121, 122, -126, -125, -124, -123, -122, -121, -120, -119, -118, -110, -109, -108, -107, -106, -105, -104, -103, -102, -94, -93, -92, -91, -90, -89, -88, -87, -86, -78, -77, -76, -75, -74, -73, -72, -71, -70, -62, -61, -60, -59, -58, -57, -56, -55, -54, -46, -45, -44, -43, -42, -41, -40, -39, -38, -30, -29, -28, -27, -26, -25, -24, -23, -22, -14, -13, -12, -11, -10, -9, -8, -7, -6};

    public static final byte[] getACChrominanceBits() {
        return (byte[])AC_CHROMINANCE_BITS.clone();
    }

    public static final byte[] getACChrominanceValues() {
        return (byte[])AC_CHROMINANCE_VALUES.clone();
    }

    public static final byte[] getACLuminanceBits() {
        return (byte[])AC_LUMINANCE_BITS.clone();
    }

    public static final byte[] getACLuminanceValues() {
        return (byte[])AC_LUMINANCE_VALUES.clone();
    }

    public static final byte[] getDCChrominanceBits() {
        return (byte[])DC_CHROMINANCE_BITS.clone();
    }

    public static final byte[] getDCChrominanceValues() {
        return (byte[])DC_CHROMINANCE_VALUES.clone();
    }

    public static final byte[] getDCLuminanceBits() {
        return (byte[])DC_LUMINANCE_BITS.clone();
    }

    public static final byte[] getDCLuminanceValues() {
        return (byte[])DC_LUMINANCE_VALUES.clone();
    }

    public static final int[] getDefaultChrominanceMatrix(int n) {
        int[] nArray = (int[])QUANT_CHROMINANCE.clone();
        if (n <= 0) {
            n = 1;
        }
        if (n > 100) {
            n = 100;
        }
        n = n < 50 ? 5000 / n : 200 - n * 2;
        for (int i = 0; i < 64; ++i) {
            int n2 = (nArray[i] * n + 50) / 100;
            if (n2 <= 0) {
                n2 = 1;
            }
            if (n2 >= 255) {
                n2 = 255;
            }
            nArray[i] = n2;
        }
        return nArray;
    }

    public static final int[] getDefaultLuminanceMatrix(int n) {
        int[] nArray = (int[])QUANT_LUMINANCE.clone();
        if (n <= 0) {
            n = 1;
        }
        if (n > 100) {
            n = 100;
        }
        n = n < 50 ? 5000 / n : 200 - n * 2;
        for (int i = 0; i < 64; ++i) {
            int n2 = (nArray[i] * n + 50) / 100;
            if (n2 <= 0) {
                n2 = 1;
            }
            if (n2 >= 255) {
                n2 = 255;
            }
            nArray[i] = n2;
        }
        return nArray;
    }

    public static final int[] getDeZigzagMatrix() {
        return (int[])DE_ZIGZAG_TRAVERSE_ORDER.clone();
    }

    public static final int[] getZigzagMatrix() {
        return (int[])ZIGZAG_TRAVERSE_ORDER.clone();
    }

    private JPEGConsts() {
    }
}

