/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.jpeg;

import java.util.HashMap;
import java.util.Map;

public enum Marker {
    TEM("Temporary private use by arithmetic encoders", -255),
    SOF0("Baseline DCT", -64),
    SOF1("Extended sequential DCT, Huffman coding", -63),
    SOF2("Progressive DCT, Huffman coding", -62),
    SOF3("Lossless, Huffman coding", -61),
    DHT("Define Huffman table", -60),
    SOF5("Differential sequential DCT, Huffman coding", -59),
    SOF6("Differential progressive DCT, Huffman coding", -58),
    SOF7("Differential lossless, Huffman coding", -57),
    JPG("Reserved", -56),
    SOF9("Sequential DCT, arithmetic coding", -55),
    SOF10("Progressive DCT, arithmetic coding", -54),
    SOF11("Lossless, arithmetic coding", -53),
    DAC("Define Arithmetic Table ", -52),
    SOF13("Differential sequential DCT, arithmetic coding", -51),
    SOF14("Differential progressive DCT, arithmetic coding", -50),
    SOF15("Differential lossless, arithmetic coding", -49),
    RST0("Restart 0", -48),
    RST1("Restart 1", -47),
    RST2("Restart 2", -46),
    RST3("Restart 3", -45),
    RST4("Restart 4", -44),
    RST5("Restart 5", -43),
    RST6("Restart 6", -42),
    RST7("Restart 7", -41),
    SOI("Start of image", -40),
    EOI("End of image", -39),
    SOS("Start of scan", -38),
    DQT("Define quantization table", -37),
    DNL("Define number of lines", -36),
    DRI("Define restart interval", -35),
    DHP("Define hierarchical progression", -34),
    EXP("Expand reference components", -33),
    APP0("JFIF/JFXX/CIFF/AVI1", -32),
    APP1("EXIF/XMP/ExtendedXMP", -31),
    APP2("FPXR/ICC profile/MPF/PreviewImage", -30),
    APP3("Meta/Stim", -29),
    APP4("Scalado", -28),
    APP5("RMETA", -27),
    APP6("EPPIM/NITF", -26),
    APP7("", -25),
    APP8("SPIFF", -24),
    APP9("", -23),
    APP10("Comment", -22),
    APP11("", -21),
    APP12("Photoshop Ducky/PictureInfo", -20),
    APP13("Photoshop IRB/Adobe_CM", -19),
    APP14("Adobe DCT encoding information", -18),
    APP15("GraphicConverter", -17),
    JPG0("Reserved", -16),
    JPG13("Reserved", -3),
    COM("Comment", -2),
    PADDING("Padding", -1),
    UNKNOWN("Unknown", 0);

    private static final Map<Short, Marker> markerMap;
    private final String description;
    private final short value;

    private Marker(String string2, short s) {
        this.description = string2;
        this.value = s;
    }

    public String getDescription() {
        return this.description;
    }

    public short getValue() {
        return this.value;
    }

    public static Marker fromShort(short s) {
        Marker marker = markerMap.get(s);
        if (marker == null) {
            return UNKNOWN;
        }
        return marker;
    }

    public String toString() {
        return this.name() + ": " + this.description;
    }

    static {
        markerMap = new HashMap<Short, Marker>();
        for (Marker marker : Marker.values()) {
            markerMap.put(marker.getValue(), marker);
        }
    }

    public static enum Attribute {
        STAND_ALONE,
        MARKER_SEGMENT;

    }
}

