/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.meta;

import com.icafe4j.image.ImageType;
import com.icafe4j.image.bmp.BMPTweaker;
import com.icafe4j.image.gif.GIFTweaker;
import com.icafe4j.image.jpeg.JPEGTweaker;
import com.icafe4j.image.meta.MetadataReader;
import com.icafe4j.image.meta.MetadataType;
import com.icafe4j.image.meta.adobe._8BIM;
import com.icafe4j.image.meta.exif.Exif;
import com.icafe4j.image.meta.iptc.IPTCDataSet;
import com.icafe4j.image.meta.xmp.XMP;
import com.icafe4j.image.png.PNGTweaker;
import com.icafe4j.image.tiff.TIFFTweaker;
import com.icafe4j.image.util.IMGUtils;
import com.icafe4j.io.FileCacheRandomAccessInputStream;
import com.icafe4j.io.FileCacheRandomAccessOutputStream;
import com.icafe4j.io.PeekHeadInputStream;
import com.icafe4j.io.RandomAccessInputStream;
import com.icafe4j.io.RandomAccessOutputStream;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Metadata
implements MetadataReader {
    public static final int IMAGE_MAGIC_NUMBER_LEN = 4;
    private MetadataType type;
    protected byte[] data;
    protected boolean isDataRead;
    private static final Logger LOGGER = LoggerFactory.getLogger(Metadata.class);

    public static void extractThumbnails(File file, String string) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        Metadata.extractThumbnails(fileInputStream, string);
        fileInputStream.close();
    }

    public static void extractThumbnails(InputStream inputStream, String string) throws IOException {
        PeekHeadInputStream peekHeadInputStream = new PeekHeadInputStream(inputStream, 4);
        ImageType imageType = IMGUtils.guessImageType(peekHeadInputStream);
        switch (imageType) {
            case JPG: {
                JPEGTweaker.extractThumbnails(peekHeadInputStream, string);
                break;
            }
            case TIFF: {
                FileCacheRandomAccessInputStream fileCacheRandomAccessInputStream = new FileCacheRandomAccessInputStream(peekHeadInputStream);
                TIFFTweaker.extractThumbnail(fileCacheRandomAccessInputStream, string);
                ((RandomAccessInputStream)fileCacheRandomAccessInputStream).shallowClose();
                break;
            }
            case PNG: {
                LOGGER.info("PNG image format does not contain any thumbnail");
                break;
            }
            case GIF: 
            case PCX: 
            case TGA: 
            case BMP: {
                LOGGER.info("{} image format does not contain any thumbnails", (Object)imageType);
                break;
            }
            default: {
                peekHeadInputStream.close();
                throw new IllegalArgumentException("Thumbnail extracting is not supported for " + (Object)((Object)imageType) + " image");
            }
        }
        peekHeadInputStream.shallowClose();
    }

    public static void extractThumbnails(String string, String string2) throws IOException {
        Metadata.extractThumbnails(new File(string), string2);
    }

    public static void insertComment(InputStream inputStream, OutputStream outputStream, String string) throws IOException {
        Metadata.insertComments(inputStream, outputStream, Arrays.asList(string));
    }

    public static void insertComments(InputStream inputStream, OutputStream outputStream, List<String> list) throws IOException {
        PeekHeadInputStream peekHeadInputStream = new PeekHeadInputStream(inputStream, 4);
        ImageType imageType = IMGUtils.guessImageType(peekHeadInputStream);
        switch (imageType) {
            case JPG: {
                JPEGTweaker.insertComments(peekHeadInputStream, outputStream, list);
                break;
            }
            case TIFF: {
                FileCacheRandomAccessInputStream fileCacheRandomAccessInputStream = new FileCacheRandomAccessInputStream(peekHeadInputStream);
                FileCacheRandomAccessOutputStream fileCacheRandomAccessOutputStream = new FileCacheRandomAccessOutputStream(outputStream);
                TIFFTweaker.insertComments(list, fileCacheRandomAccessInputStream, fileCacheRandomAccessOutputStream);
                ((RandomAccessInputStream)fileCacheRandomAccessInputStream).shallowClose();
                ((RandomAccessOutputStream)fileCacheRandomAccessOutputStream).shallowClose();
                break;
            }
            case PNG: {
                PNGTweaker.insertComments(peekHeadInputStream, outputStream, list);
                break;
            }
            case GIF: {
                GIFTweaker.insertComments(peekHeadInputStream, outputStream, list);
                break;
            }
            case PCX: 
            case TGA: 
            case BMP: {
                LOGGER.info("{} image format does not support comment data", (Object)imageType);
                break;
            }
            default: {
                peekHeadInputStream.close();
                throw new IllegalArgumentException("comment data inserting is not supported for " + (Object)((Object)imageType) + " image");
            }
        }
        peekHeadInputStream.shallowClose();
    }

    public static void insertExif(InputStream inputStream, OutputStream outputStream, Exif exif) throws IOException {
        Metadata.insertExif(inputStream, outputStream, exif, false);
    }

    public static void insertExif(InputStream inputStream, OutputStream outputStream, Exif exif, boolean bl) throws IOException {
        PeekHeadInputStream peekHeadInputStream = new PeekHeadInputStream(inputStream, 4);
        ImageType imageType = IMGUtils.guessImageType(peekHeadInputStream);
        switch (imageType) {
            case JPG: {
                JPEGTweaker.insertExif(peekHeadInputStream, outputStream, exif, bl);
                break;
            }
            case TIFF: {
                FileCacheRandomAccessInputStream fileCacheRandomAccessInputStream = new FileCacheRandomAccessInputStream(peekHeadInputStream);
                FileCacheRandomAccessOutputStream fileCacheRandomAccessOutputStream = new FileCacheRandomAccessOutputStream(outputStream);
                TIFFTweaker.insertExif(fileCacheRandomAccessInputStream, fileCacheRandomAccessOutputStream, exif, bl);
                ((RandomAccessInputStream)fileCacheRandomAccessInputStream).shallowClose();
                ((RandomAccessOutputStream)fileCacheRandomAccessOutputStream).shallowClose();
                break;
            }
            case PNG: 
            case GIF: 
            case PCX: 
            case TGA: 
            case BMP: {
                LOGGER.info("{} image format does not support EXIF data", (Object)imageType);
                break;
            }
            default: {
                peekHeadInputStream.close();
                throw new IllegalArgumentException("EXIF data inserting is not supported for " + (Object)((Object)imageType) + " image");
            }
        }
        peekHeadInputStream.shallowClose();
    }

    public static void insertICCProfile(InputStream inputStream, OutputStream outputStream, ICC_Profile iCC_Profile) throws IOException {
        Metadata.insertICCProfile(inputStream, outputStream, iCC_Profile.getData());
    }

    public static void insertICCProfile(InputStream inputStream, OutputStream outputStream, byte[] byArray) throws IOException {
        PeekHeadInputStream peekHeadInputStream = new PeekHeadInputStream(inputStream, 4);
        ImageType imageType = IMGUtils.guessImageType(peekHeadInputStream);
        switch (imageType) {
            case JPG: {
                JPEGTweaker.insertICCProfile((InputStream)peekHeadInputStream, outputStream, byArray);
                break;
            }
            case TIFF: {
                FileCacheRandomAccessInputStream fileCacheRandomAccessInputStream = new FileCacheRandomAccessInputStream(peekHeadInputStream);
                FileCacheRandomAccessOutputStream fileCacheRandomAccessOutputStream = new FileCacheRandomAccessOutputStream(outputStream);
                TIFFTweaker.insertICCProfile(byArray, 0, (RandomAccessInputStream)fileCacheRandomAccessInputStream, (RandomAccessOutputStream)fileCacheRandomAccessOutputStream);
                ((RandomAccessInputStream)fileCacheRandomAccessInputStream).shallowClose();
                ((RandomAccessOutputStream)fileCacheRandomAccessOutputStream).shallowClose();
                break;
            }
            case GIF: 
            case PCX: 
            case TGA: 
            case BMP: {
                LOGGER.info("{} image format does not support ICCProfile data", (Object)imageType);
                break;
            }
            default: {
                peekHeadInputStream.close();
                throw new IllegalArgumentException("ICCProfile data inserting is not supported for " + (Object)((Object)imageType) + " image");
            }
        }
        peekHeadInputStream.shallowClose();
    }

    public static void insertIPTC(InputStream inputStream, OutputStream outputStream, Collection<IPTCDataSet> collection) throws IOException {
        Metadata.insertIPTC(inputStream, outputStream, collection, false);
    }

    public static void insertIPTC(InputStream inputStream, OutputStream outputStream, Collection<IPTCDataSet> collection, boolean bl) throws IOException {
        PeekHeadInputStream peekHeadInputStream = new PeekHeadInputStream(inputStream, 4);
        ImageType imageType = IMGUtils.guessImageType(peekHeadInputStream);
        switch (imageType) {
            case JPG: {
                JPEGTweaker.insertIPTC(peekHeadInputStream, outputStream, collection, bl);
                break;
            }
            case TIFF: {
                FileCacheRandomAccessInputStream fileCacheRandomAccessInputStream = new FileCacheRandomAccessInputStream(peekHeadInputStream);
                FileCacheRandomAccessOutputStream fileCacheRandomAccessOutputStream = new FileCacheRandomAccessOutputStream(outputStream);
                TIFFTweaker.insertIPTC(fileCacheRandomAccessInputStream, fileCacheRandomAccessOutputStream, collection, bl);
                ((RandomAccessInputStream)fileCacheRandomAccessInputStream).shallowClose();
                ((RandomAccessOutputStream)fileCacheRandomAccessOutputStream).shallowClose();
                break;
            }
            case PNG: 
            case GIF: 
            case PCX: 
            case TGA: 
            case BMP: {
                LOGGER.info("{} image format does not support IPTC data", (Object)imageType);
                break;
            }
            default: {
                peekHeadInputStream.close();
                throw new IllegalArgumentException("IPTC data inserting is not supported for " + (Object)((Object)imageType) + " image");
            }
        }
        peekHeadInputStream.shallowClose();
    }

    public static void insertIRB(InputStream inputStream, OutputStream outputStream, Collection<_8BIM> collection) throws IOException {
        Metadata.insertIRB(inputStream, outputStream, collection, false);
    }

    public static void insertIRB(InputStream inputStream, OutputStream outputStream, Collection<_8BIM> collection, boolean bl) throws IOException {
        PeekHeadInputStream peekHeadInputStream = new PeekHeadInputStream(inputStream, 4);
        ImageType imageType = IMGUtils.guessImageType(peekHeadInputStream);
        switch (imageType) {
            case JPG: {
                JPEGTweaker.insertIRB(peekHeadInputStream, outputStream, collection, bl);
                break;
            }
            case TIFF: {
                FileCacheRandomAccessInputStream fileCacheRandomAccessInputStream = new FileCacheRandomAccessInputStream(peekHeadInputStream);
                FileCacheRandomAccessOutputStream fileCacheRandomAccessOutputStream = new FileCacheRandomAccessOutputStream(outputStream);
                TIFFTweaker.insertIRB(fileCacheRandomAccessInputStream, fileCacheRandomAccessOutputStream, collection, bl);
                ((RandomAccessInputStream)fileCacheRandomAccessInputStream).shallowClose();
                ((RandomAccessOutputStream)fileCacheRandomAccessOutputStream).shallowClose();
                break;
            }
            case PNG: 
            case GIF: 
            case PCX: 
            case TGA: 
            case BMP: {
                LOGGER.info("{} image format does not support IRB data", (Object)imageType);
                break;
            }
            default: {
                peekHeadInputStream.close();
                throw new IllegalArgumentException("IRB data inserting is not supported for " + (Object)((Object)imageType) + " image");
            }
        }
        peekHeadInputStream.shallowClose();
    }

    public static void insertIRBThumbnail(InputStream inputStream, OutputStream outputStream, BufferedImage bufferedImage) throws IOException {
        PeekHeadInputStream peekHeadInputStream = new PeekHeadInputStream(inputStream, 4);
        ImageType imageType = IMGUtils.guessImageType(peekHeadInputStream);
        switch (imageType) {
            case JPG: {
                JPEGTweaker.insertIRBThumbnail(peekHeadInputStream, outputStream, bufferedImage);
                break;
            }
            case TIFF: {
                FileCacheRandomAccessInputStream fileCacheRandomAccessInputStream = new FileCacheRandomAccessInputStream(peekHeadInputStream);
                FileCacheRandomAccessOutputStream fileCacheRandomAccessOutputStream = new FileCacheRandomAccessOutputStream(outputStream);
                TIFFTweaker.insertThumbnail(fileCacheRandomAccessInputStream, fileCacheRandomAccessOutputStream, bufferedImage);
                ((RandomAccessInputStream)fileCacheRandomAccessInputStream).shallowClose();
                ((RandomAccessOutputStream)fileCacheRandomAccessOutputStream).shallowClose();
                break;
            }
            case PNG: 
            case GIF: 
            case PCX: 
            case TGA: 
            case BMP: {
                LOGGER.info("{} image format does not support IRB thumbnail", (Object)imageType);
                break;
            }
            default: {
                peekHeadInputStream.close();
                throw new IllegalArgumentException("IRB thumbnail inserting is not supported for " + (Object)((Object)imageType) + " image");
            }
        }
        peekHeadInputStream.shallowClose();
    }

    public static void insertXMP(InputStream inputStream, OutputStream outputStream, XMP xMP) throws IOException {
        PeekHeadInputStream peekHeadInputStream = new PeekHeadInputStream(inputStream, 4);
        ImageType imageType = IMGUtils.guessImageType(peekHeadInputStream);
        switch (imageType) {
            case JPG: {
                JPEGTweaker.insertXMP(peekHeadInputStream, outputStream, xMP);
                break;
            }
            case TIFF: {
                FileCacheRandomAccessInputStream fileCacheRandomAccessInputStream = new FileCacheRandomAccessInputStream(peekHeadInputStream);
                FileCacheRandomAccessOutputStream fileCacheRandomAccessOutputStream = new FileCacheRandomAccessOutputStream(outputStream);
                TIFFTweaker.insertXMP(xMP, (RandomAccessInputStream)fileCacheRandomAccessInputStream, (RandomAccessOutputStream)fileCacheRandomAccessOutputStream);
                ((RandomAccessInputStream)fileCacheRandomAccessInputStream).shallowClose();
                ((RandomAccessOutputStream)fileCacheRandomAccessOutputStream).shallowClose();
                break;
            }
            case PNG: {
                PNGTweaker.insertXMP((InputStream)peekHeadInputStream, outputStream, xMP);
                break;
            }
            case GIF: {
                GIFTweaker.insertXMPApplicationBlock((InputStream)peekHeadInputStream, outputStream, xMP);
                break;
            }
            case PCX: 
            case TGA: 
            case BMP: {
                LOGGER.info("{} image format does not support XMP data", (Object)imageType);
                break;
            }
            default: {
                peekHeadInputStream.close();
                throw new IllegalArgumentException("XMP inserting is not supported for " + (Object)((Object)imageType) + " image");
            }
        }
        peekHeadInputStream.shallowClose();
    }

    public static void insertMetadata(Collection<Metadata> collection, InputStream inputStream, OutputStream outputStream) throws IOException {
        PeekHeadInputStream peekHeadInputStream = new PeekHeadInputStream(inputStream, 4);
        ImageType imageType = IMGUtils.guessImageType(peekHeadInputStream);
        switch (imageType) {
            case JPG: {
                JPEGTweaker.insertMetadata(collection, peekHeadInputStream, outputStream);
                break;
            }
            case TIFF: {
                FileCacheRandomAccessInputStream fileCacheRandomAccessInputStream = new FileCacheRandomAccessInputStream(peekHeadInputStream);
                FileCacheRandomAccessOutputStream fileCacheRandomAccessOutputStream = new FileCacheRandomAccessOutputStream(outputStream);
                TIFFTweaker.insertMetadata(fileCacheRandomAccessInputStream, fileCacheRandomAccessOutputStream, collection);
                ((RandomAccessInputStream)fileCacheRandomAccessInputStream).shallowClose();
                ((RandomAccessOutputStream)fileCacheRandomAccessOutputStream).shallowClose();
                break;
            }
            default: {
                peekHeadInputStream.close();
                throw new IllegalArgumentException("inserting more than one metadata is not supported for " + (Object)((Object)imageType) + " image");
            }
        }
        peekHeadInputStream.shallowClose();
    }

    public static void insertXMP(InputStream inputStream, OutputStream outputStream, String string) throws IOException {
        PeekHeadInputStream peekHeadInputStream = new PeekHeadInputStream(inputStream, 4);
        ImageType imageType = IMGUtils.guessImageType(peekHeadInputStream);
        switch (imageType) {
            case JPG: {
                JPEGTweaker.insertXMP(peekHeadInputStream, outputStream, string, null);
                break;
            }
            case TIFF: {
                FileCacheRandomAccessInputStream fileCacheRandomAccessInputStream = new FileCacheRandomAccessInputStream(peekHeadInputStream);
                FileCacheRandomAccessOutputStream fileCacheRandomAccessOutputStream = new FileCacheRandomAccessOutputStream(outputStream);
                TIFFTweaker.insertXMP(string, (RandomAccessInputStream)fileCacheRandomAccessInputStream, (RandomAccessOutputStream)fileCacheRandomAccessOutputStream);
                ((RandomAccessInputStream)fileCacheRandomAccessInputStream).shallowClose();
                ((RandomAccessOutputStream)fileCacheRandomAccessOutputStream).shallowClose();
                break;
            }
            case PNG: {
                PNGTweaker.insertXMP((InputStream)peekHeadInputStream, outputStream, string);
                break;
            }
            case GIF: {
                GIFTweaker.insertXMPApplicationBlock((InputStream)peekHeadInputStream, outputStream, string);
                break;
            }
            case PCX: 
            case TGA: 
            case BMP: {
                LOGGER.info("{} image format does not support XMP data", (Object)imageType);
                break;
            }
            default: {
                peekHeadInputStream.close();
                throw new IllegalArgumentException("XMP inserting is not supported for " + (Object)((Object)imageType) + " image");
            }
        }
        peekHeadInputStream.shallowClose();
    }

    public static Map<MetadataType, Metadata> readMetadata(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        Map<MetadataType, Metadata> map = Metadata.readMetadata(fileInputStream);
        fileInputStream.close();
        return map;
    }

    public static Map<MetadataType, Metadata> readMetadata(InputStream inputStream) throws IOException {
        Map<Object, Object> map = new HashMap();
        PeekHeadInputStream peekHeadInputStream = new PeekHeadInputStream(inputStream, 4);
        ImageType imageType = IMGUtils.guessImageType(peekHeadInputStream);
        switch (imageType) {
            case JPG: {
                map = JPEGTweaker.readMetadata(peekHeadInputStream);
                break;
            }
            case TIFF: {
                FileCacheRandomAccessInputStream fileCacheRandomAccessInputStream = new FileCacheRandomAccessInputStream(peekHeadInputStream);
                map = TIFFTweaker.readMetadata(fileCacheRandomAccessInputStream);
                ((RandomAccessInputStream)fileCacheRandomAccessInputStream).shallowClose();
                break;
            }
            case PNG: {
                map = PNGTweaker.readMetadata(peekHeadInputStream);
                break;
            }
            case GIF: {
                map = GIFTweaker.readMetadata(peekHeadInputStream);
                break;
            }
            case BMP: {
                map = BMPTweaker.readMetadata(peekHeadInputStream);
                break;
            }
            default: {
                peekHeadInputStream.close();
                throw new IllegalArgumentException("Metadata reading is not supported for " + (Object)((Object)imageType) + " image");
            }
        }
        peekHeadInputStream.shallowClose();
        return map;
    }

    public static Map<MetadataType, Metadata> readMetadata(String string) throws IOException {
        return Metadata.readMetadata(new File(string));
    }

    public static void removeMetadata(InputStream inputStream, OutputStream outputStream, MetadataType ... metadataTypeArray) throws IOException {
        PeekHeadInputStream peekHeadInputStream = new PeekHeadInputStream(inputStream, 4);
        ImageType imageType = IMGUtils.guessImageType(peekHeadInputStream);
        switch (imageType) {
            case JPG: {
                JPEGTweaker.removeMetadata(peekHeadInputStream, outputStream, metadataTypeArray);
                break;
            }
            case TIFF: {
                FileCacheRandomAccessInputStream fileCacheRandomAccessInputStream = new FileCacheRandomAccessInputStream(peekHeadInputStream);
                FileCacheRandomAccessOutputStream fileCacheRandomAccessOutputStream = new FileCacheRandomAccessOutputStream(outputStream);
                TIFFTweaker.removeMetadata(fileCacheRandomAccessInputStream, fileCacheRandomAccessOutputStream, metadataTypeArray);
                ((RandomAccessInputStream)fileCacheRandomAccessInputStream).shallowClose();
                ((RandomAccessOutputStream)fileCacheRandomAccessOutputStream).shallowClose();
                break;
            }
            case PCX: 
            case TGA: 
            case BMP: {
                LOGGER.info("{} image format does not support meta data", (Object)imageType);
                break;
            }
            default: {
                peekHeadInputStream.close();
                throw new IllegalArgumentException("Metadata removing is not supported for " + (Object)((Object)imageType) + " image");
            }
        }
        peekHeadInputStream.shallowClose();
    }

    public Metadata(MetadataType metadataType) {
        this.type = metadataType;
    }

    public Metadata(MetadataType metadataType, byte[] byArray) {
        if (metadataType == null) {
            throw new IllegalArgumentException("Metadata type must be specified");
        }
        if (byArray == null) {
            throw new IllegalArgumentException("Input data array is null");
        }
        if (byArray.length == 0) {
            this.isDataRead = true;
        }
        this.type = metadataType;
        this.data = byArray;
    }

    protected void ensureDataRead() {
        if (!this.isDataRead) {
            try {
                this.read();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public byte[] getData() {
        if (this.data != null) {
            return (byte[])this.data.clone();
        }
        return null;
    }

    public MetadataType getType() {
        return this.type;
    }

    @Override
    public boolean isDataRead() {
        return this.isDataRead;
    }

    @Override
    public abstract void showMetadata();

    public void write(OutputStream outputStream) throws IOException {
        byte[] byArray = this.getData();
        if (byArray != null) {
            outputStream.write(byArray);
        }
    }
}

