/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.meta.adobe;

import com.icafe4j.image.meta.Metadata;
import com.icafe4j.image.meta.MetadataType;
import com.icafe4j.image.meta.adobe.IPTC_NAA;
import com.icafe4j.image.meta.adobe.IRBThumbnail;
import com.icafe4j.image.meta.adobe.ImageResourceID;
import com.icafe4j.image.meta.adobe.JPEGQuality;
import com.icafe4j.image.meta.adobe.ThumbnailResource;
import com.icafe4j.image.meta.adobe.VersionInfo;
import com.icafe4j.image.meta.adobe._8BIM;
import com.icafe4j.io.IOUtils;
import com.icafe4j.util.ArrayUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IRB
extends Metadata {
    private boolean containsThumbnail;
    private ThumbnailResource thumbnail;
    Map<Short, _8BIM> _8bims = new HashMap<Short, _8BIM>();
    private static final Logger LOGGER = LoggerFactory.getLogger(IRB.class);

    public static void showIRB(byte[] byArray) {
        if (byArray != null && byArray.length > 0) {
            IRB iRB = new IRB(byArray);
            try {
                iRB.read();
                iRB.showMetadata();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public static void showIRB(InputStream inputStream) {
        try {
            IRB.showIRB(IOUtils.inputStreamToByteArray(inputStream));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public IRB(byte[] byArray) {
        super(MetadataType.PHOTOSHOP_IRB, byArray);
    }

    public boolean containsThumbnail() {
        this.ensureDataRead();
        return this.containsThumbnail;
    }

    public _8BIM get8BIM(short s) {
        this.ensureDataRead();
        return this._8bims.get(s);
    }

    public Map<Short, _8BIM> get8BIM() {
        this.ensureDataRead();
        return Collections.unmodifiableMap(this._8bims);
    }

    public IRBThumbnail getThumbnail() {
        this.ensureDataRead();
        return this.thumbnail.getThumbnail();
    }

    public ThumbnailResource getThumbnailResource() {
        this.ensureDataRead();
        return this.thumbnail;
    }

    @Override
    public void read() throws IOException {
        if (!this.isDataRead) {
            int n = 0;
            while (n + 4 < this.data.length) {
                int n2;
                String string = new String(this.data, n, 4);
                n += 4;
                if (!string.equals("8BIM")) continue;
                short s = IOUtils.readShortMM(this.data, n);
                n += 2;
                if ((n2 = this.data[n++] & 0xFF) % 2 == 0) {
                    ++n2;
                }
                String string2 = new String(this.data, n, n2).trim();
                int n3 = IOUtils.readIntMM(this.data, n += n2);
                n += 4;
                if (n3 <= 0) continue;
                ImageResourceID imageResourceID = ImageResourceID.fromShort(s);
                switch (imageResourceID) {
                    case JPEG_QUALITY: {
                        this._8bims.put(s, new JPEGQuality(string2, ArrayUtils.subArray(this.data, n, n3)));
                        break;
                    }
                    case VERSION_INFO: {
                        this._8bims.put(s, new VersionInfo(string2, ArrayUtils.subArray(this.data, n, n3)));
                        break;
                    }
                    case IPTC_NAA: {
                        byte[] byArray = ArrayUtils.subArray(this.data, n, n3);
                        _8BIM _8BIM2 = this._8bims.get(s);
                        if (_8BIM2 != null) {
                            byte[] byArray2 = _8BIM2.getData();
                            this._8bims.put(s, new IPTC_NAA(string2, ArrayUtils.concat(byArray2, new byte[][]{byArray})));
                            break;
                        }
                        this._8bims.put(s, new IPTC_NAA(string2, byArray));
                        break;
                    }
                    case THUMBNAIL_RESOURCE_PS4: 
                    case THUMBNAIL_RESOURCE_PS5: {
                        this.containsThumbnail = true;
                        this.thumbnail = new ThumbnailResource(imageResourceID, ArrayUtils.subArray(this.data, n, n3));
                        this._8bims.put(s, this.thumbnail);
                        break;
                    }
                    default: {
                        this._8bims.put(s, new _8BIM(s, string2, n3, ArrayUtils.subArray(this.data, n, n3)));
                    }
                }
                n += n3;
                if (n3 % 2 == 0) continue;
                ++n;
            }
            this.isDataRead = true;
        }
    }

    @Override
    public void showMetadata() {
        this.ensureDataRead();
        LOGGER.info("<<Adobe IRB information starts>>");
        for (_8BIM _8BIM2 : this._8bims.values()) {
            _8BIM2.print();
        }
        if (this.containsThumbnail) {
            LOGGER.info("{}", (Object)this.thumbnail.getResouceID());
            int n = this.thumbnail.getDataType();
            switch (n) {
                case 1: {
                    LOGGER.info("Thumbnail format: KJpegRGB");
                    break;
                }
                case 0: {
                    LOGGER.info("Thumbnail format: KRawRGB");
                }
            }
            LOGGER.info("Thumbnail width: {}", (Object)this.thumbnail.getWidth());
            LOGGER.info("Thumbnail height: {}", (Object)this.thumbnail.getHeight());
            LOGGER.info("Padded row bytes: {}", (Object)this.thumbnail.getPaddedRowBytes());
            LOGGER.info("Total size: {}", (Object)this.thumbnail.getTotalSize());
            LOGGER.info("Size after compression: {}", (Object)this.thumbnail.getCompressedSize());
            LOGGER.info("Bits per pixel: {}", (Object)this.thumbnail.getBitsPerPixel());
            LOGGER.info("Number of planes: {}", (Object)this.thumbnail.getNumOfPlanes());
        }
        LOGGER.info("<<Adobe IRB information ends>>");
    }
}

