/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.meta.adobe;

import com.icafe4j.image.ImageIO;
import com.icafe4j.image.ImageParam;
import com.icafe4j.image.ImageType;
import com.icafe4j.image.meta.Thumbnail;
import com.icafe4j.image.options.JPEGOptions;
import com.icafe4j.image.writer.ImageWriter;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;

public class IRBThumbnail
extends Thumbnail {
    public IRBThumbnail() {
    }

    public IRBThumbnail(BufferedImage bufferedImage) {
        super(bufferedImage);
    }

    public IRBThumbnail(int n, int n2, int n3, byte[] byArray) {
        super(n, n2, n3, byArray);
    }

    public IRBThumbnail(IRBThumbnail iRBThumbnail) {
        this.dataType = iRBThumbnail.dataType;
        this.height = iRBThumbnail.height;
        this.width = iRBThumbnail.width;
        this.thumbnail = iRBThumbnail.thumbnail;
        this.compressedThumbnail = iRBThumbnail.compressedThumbnail;
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        if (this.getDataType() == 1) {
            outputStream.write(this.getCompressedImage());
        } else if (this.getDataType() == 0) {
            BufferedImage bufferedImage = this.getRawImage();
            if (bufferedImage == null) {
                throw new IllegalArgumentException("Expected raw data thumbnail does not exist!");
            }
            ImageWriter imageWriter = ImageIO.getWriter(ImageType.JPG);
            ImageParam.ImageParamBuilder imageParamBuilder = ImageParam.getBuilder();
            JPEGOptions jPEGOptions = new JPEGOptions();
            jPEGOptions.setQuality(this.writeQuality);
            imageParamBuilder.imageOptions(jPEGOptions);
            imageWriter.setImageParam(imageParamBuilder.build());
            try {
                imageWriter.write(bufferedImage, outputStream);
            }
            catch (Exception exception) {
                throw new RuntimeException("Unable to compress thumbnail as JPEG");
            }
        }
    }
}

