/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.meta.adobe;

import com.icafe4j.image.meta.adobe.ImageResourceID;
import com.icafe4j.image.meta.adobe._8BIM;
import com.icafe4j.io.IOUtils;
import com.icafe4j.string.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionInfo
extends _8BIM {
    private int version;
    private boolean hasRealMergedData;
    private String writerName;
    private String readerName;
    private int fileVersion;
    private static final Logger LOGGER = LoggerFactory.getLogger(VersionInfo.class);

    public VersionInfo() {
        this("VersionInfo");
    }

    public VersionInfo(String string) {
        super(ImageResourceID.VERSION_INFO, string, null);
    }

    public VersionInfo(String string, byte[] byArray) {
        super(ImageResourceID.VERSION_INFO, string, byArray);
        this.read();
    }

    public VersionInfo(int n, boolean bl, String string, String string2, int n2) {
        this("VersionInfo", n, bl, string, string2, n2);
    }

    public VersionInfo(String string, int n, boolean bl, String string2, String string3, int n2) {
        super(ImageResourceID.VERSION_INFO, string, null);
        this.version = n;
        this.hasRealMergedData = bl;
        this.writerName = string2;
        this.readerName = string3;
        this.fileVersion = n2;
    }

    public int getFileVersion() {
        return this.fileVersion;
    }

    public int getVersion() {
        return this.version;
    }

    public boolean hasRealMergedData() {
        return this.hasRealMergedData;
    }

    public String getReaderName() {
        return this.readerName;
    }

    public String getWriterName() {
        return this.writerName;
    }

    private void read() {
        int n = 0;
        this.version = IOUtils.readIntMM(this.data, n);
        n += 4;
        this.hasRealMergedData = this.data[n++] != 0;
        int n2 = IOUtils.readIntMM(this.data, n);
        this.writerName = StringUtils.toUTF16BE(this.data, n += 4, n2 * 2);
        int n3 = IOUtils.readIntMM(this.data, n += n2 * 2);
        this.readerName = StringUtils.toUTF16BE(this.data, n += 4, n3 * 2);
        this.fileVersion = IOUtils.readIntMM(this.data, n += n3 * 2);
    }

    @Override
    public void print() {
        super.print();
        LOGGER.info("Version: {}", (Object)this.getVersion());
        LOGGER.info("Has Real Merged Data: {}", (Object)this.hasRealMergedData);
        LOGGER.info("Writer name: {}", (Object)this.writerName);
        LOGGER.info("Reader name: {}", (Object)this.readerName);
        LOGGER.info("File Version: {}", (Object)this.getFileVersion());
    }

    public void setHasRealMergedData(boolean bl) {
        this.hasRealMergedData = bl;
    }

    public void setFileVersion(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("File version number is negative");
        }
        this.fileVersion = n;
    }

    public void setVersion(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Version number is negative");
        }
        this.version = n;
    }

    public void setWriterName(String string) {
        this.writerName = string;
    }

    public void setReaderName(String string) {
        this.readerName = string;
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        if (this.data == null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            IOUtils.writeIntMM(byteArrayOutputStream, this.version);
            byteArrayOutputStream.write(this.hasRealMergedData ? 1 : 0);
            byte[] byArray = null;
            byArray = this.writerName.getBytes("UTF-16BE");
            IOUtils.writeIntMM(byteArrayOutputStream, this.writerName.length());
            byteArrayOutputStream.write(byArray);
            byte[] byArray2 = null;
            byArray2 = this.readerName.getBytes("UTF-16BE");
            IOUtils.writeIntMM(byteArrayOutputStream, this.readerName.length());
            byteArrayOutputStream.write(byArray2);
            IOUtils.writeIntMM(byteArrayOutputStream, this.fileVersion);
            this.data = byteArrayOutputStream.toByteArray();
            this.size = this.data.length;
        }
        super.write(outputStream);
    }
}

