/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.meta.exif;

import com.icafe4j.image.meta.Metadata;
import com.icafe4j.image.meta.MetadataType;
import com.icafe4j.image.meta.exif.ExifTag;
import com.icafe4j.image.meta.exif.ExifThumbnail;
import com.icafe4j.image.meta.exif.GPSTag;
import com.icafe4j.image.tiff.FieldType;
import com.icafe4j.image.tiff.IFD;
import com.icafe4j.image.tiff.TIFFTweaker;
import com.icafe4j.image.tiff.TiffField;
import com.icafe4j.image.tiff.TiffTag;
import com.icafe4j.io.FileCacheRandomAccessInputStream;
import com.icafe4j.io.FileCacheRandomAccessOutputStream;
import com.icafe4j.io.IOUtils;
import com.icafe4j.io.RandomAccessInputStream;
import com.icafe4j.io.RandomAccessOutputStream;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Exif
extends Metadata {
    protected IFD imageIFD;
    protected IFD exifSubIFD;
    protected IFD gpsSubIFD;
    protected ExifThumbnail thumbnail;
    private boolean containsThumbnail;
    private boolean isThumbnailRequired;
    public static final int FIRST_IFD_OFFSET = 8;
    private static final Logger LOGGER = LoggerFactory.getLogger(Exif.class);

    public Exif() {
        super(MetadataType.EXIF);
        this.isDataRead = true;
    }

    public Exif(byte[] byArray) {
        super(MetadataType.EXIF, byArray);
        this.ensureDataRead();
    }

    public Exif(IFD iFD) {
        this();
        this.setImageIFD(iFD);
    }

    public Exif(InputStream inputStream) throws IOException {
        this(IOUtils.inputStreamToByteArray(inputStream));
    }

    public void addExifField(ExifTag exifTag, FieldType fieldType, Object object) {
        TiffField<?> tiffField;
        if (this.exifSubIFD == null) {
            this.exifSubIFD = new IFD();
        }
        if ((tiffField = FieldType.createField(exifTag, fieldType, object)) == null) {
            throw new IllegalArgumentException("Cannot create required EXIF TIFF field");
        }
        this.exifSubIFD.addField(tiffField);
    }

    public void addGPSField(GPSTag gPSTag, FieldType fieldType, Object object) {
        TiffField<?> tiffField;
        if (this.gpsSubIFD == null) {
            this.gpsSubIFD = new IFD();
        }
        if ((tiffField = FieldType.createField(gPSTag, fieldType, object)) == null) {
            throw new IllegalArgumentException("Cannot create required GPS TIFF field");
        }
        this.gpsSubIFD.addField(tiffField);
    }

    public void addImageField(TiffTag tiffTag, FieldType fieldType, Object object) {
        TiffField<?> tiffField;
        if (this.imageIFD == null) {
            this.imageIFD = new IFD();
        }
        if ((tiffField = FieldType.createField(tiffTag, fieldType, object)) == null) {
            throw new IllegalArgumentException("Cannot create required Image TIFF field");
        }
        this.imageIFD.addField(tiffField);
    }

    public boolean containsThumbnail() {
        if (this.containsThumbnail) {
            return true;
        }
        return this.thumbnail != null;
    }

    public IFD getExifIFD() {
        if (this.exifSubIFD != null) {
            return new IFD(this.exifSubIFD);
        }
        return null;
    }

    public IFD getGPSIFD() {
        if (this.gpsSubIFD != null) {
            return new IFD(this.gpsSubIFD);
        }
        return null;
    }

    public IFD getImageIFD() {
        if (this.imageIFD != null) {
            return new IFD(this.imageIFD);
        }
        return null;
    }

    public ExifThumbnail getThumbnail() {
        if (this.thumbnail != null) {
            return new ExifThumbnail(this.thumbnail);
        }
        return null;
    }

    public boolean isThumbnailRequired() {
        return this.isThumbnailRequired;
    }

    @Override
    public void read() throws IOException {
        if (!this.isDataRead) {
            FileCacheRandomAccessInputStream fileCacheRandomAccessInputStream = new FileCacheRandomAccessInputStream(new ByteArrayInputStream(this.data));
            ArrayList<IFD> arrayList = new ArrayList<IFD>(3);
            TIFFTweaker.readIFDs(arrayList, fileCacheRandomAccessInputStream);
            if (arrayList.size() > 0) {
                this.imageIFD = (IFD)arrayList.get(0);
                this.exifSubIFD = this.imageIFD.getChild(TiffTag.EXIF_SUB_IFD);
                this.gpsSubIFD = this.imageIFD.getChild(TiffTag.GPS_SUB_IFD);
            }
            if (arrayList.size() >= 2) {
                IFD iFD = (IFD)arrayList.get(1);
                int n = -1;
                int n2 = -1;
                TiffField<?> tiffField = iFD.getField(TiffTag.IMAGE_WIDTH);
                if (tiffField != null) {
                    n = tiffField.getDataAsLong()[0];
                }
                if ((tiffField = iFD.getField(TiffTag.IMAGE_LENGTH)) != null) {
                    n2 = tiffField.getDataAsLong()[0];
                }
                if ((tiffField = iFD.getField(TiffTag.JPEG_INTERCHANGE_FORMAT)) != null) {
                    int n3 = tiffField.getDataAsLong()[0];
                    tiffField = iFD.getField(TiffTag.JPEG_INTERCHANGE_FORMAT_LENGTH);
                    int n4 = tiffField.getDataAsLong()[0];
                    ((RandomAccessInputStream)fileCacheRandomAccessInputStream).seek(n3);
                    byte[] byArray = new byte[n4];
                    fileCacheRandomAccessInputStream.readFully(byArray);
                    this.thumbnail = new ExifThumbnail(n, n2, 1, byArray, iFD);
                    this.containsThumbnail = true;
                } else {
                    tiffField = iFD.getField(TiffTag.STRIP_OFFSETS);
                    if (tiffField == null) {
                        tiffField = iFD.getField(TiffTag.TILE_OFFSETS);
                    }
                    if (tiffField != null) {
                        ((RandomAccessInputStream)fileCacheRandomAccessInputStream).seek(0L);
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        FileCacheRandomAccessOutputStream fileCacheRandomAccessOutputStream = new FileCacheRandomAccessOutputStream(byteArrayOutputStream);
                        TIFFTweaker.retainPages(fileCacheRandomAccessInputStream, fileCacheRandomAccessOutputStream, 1);
                        ((RandomAccessOutputStream)fileCacheRandomAccessOutputStream).close();
                        this.thumbnail = new ExifThumbnail(n, n2, 2, byteArrayOutputStream.toByteArray(), iFD);
                        this.containsThumbnail = true;
                    }
                }
            }
            ((RandomAccessInputStream)fileCacheRandomAccessInputStream).shallowClose();
            this.isDataRead = true;
        }
    }

    public void setExifIFD(IFD iFD) {
        this.exifSubIFD = iFD;
    }

    public void setGPSIFD(IFD iFD) {
        this.gpsSubIFD = iFD;
    }

    public void setImageIFD(IFD iFD) {
        if (iFD == null) {
            throw new IllegalArgumentException("Input image IFD is null");
        }
        this.imageIFD = iFD;
        this.exifSubIFD = iFD.getChild(TiffTag.EXIF_SUB_IFD);
        this.gpsSubIFD = iFD.getChild(TiffTag.GPS_SUB_IFD);
    }

    public void setThumbnail(ExifThumbnail exifThumbnail) {
        this.thumbnail = exifThumbnail;
    }

    public void setThumbnailImage(BufferedImage bufferedImage) {
        if (this.thumbnail == null) {
            this.thumbnail = new ExifThumbnail();
        }
        this.thumbnail.setImage(bufferedImage);
    }

    public void setThumbnailRequired(boolean bl) {
        this.isThumbnailRequired = bl;
    }

    @Override
    public void showMetadata() {
        this.ensureDataRead();
        LOGGER.info("Exif output starts =>");
        if (this.imageIFD != null) {
            LOGGER.info("<<Image IFD starts>>");
            TIFFTweaker.printIFD(this.imageIFD, TiffTag.class, "");
            LOGGER.info("<<Image IFD ends>>");
        }
        if (this.containsThumbnail) {
            LOGGER.info("Exif thumbnail format: {}", (Object)(this.thumbnail.getDataType() == 1 ? "DATA_TYPE_JPG" : "DATA_TYPE_TIFF"));
            LOGGER.info("Exif thumbnail data length: {}", (Object)this.thumbnail.getCompressedImage().length);
        }
        LOGGER.info("<= Exif output ends");
    }

    @Override
    public abstract void write(OutputStream var1) throws IOException;
}

