/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.meta.exif;

import com.icafe4j.image.tiff.FieldType;
import com.icafe4j.image.tiff.Tag;
import com.icafe4j.image.tiff.TiffTag;
import com.icafe4j.string.StringUtils;
import java.util.HashMap;
import java.util.Map;

public enum InteropTag implements Tag
{
    INTEROPERABILITY_INDEX("InteroperabilityIndex", 1){

        @Override
        public FieldType getFieldType() {
            return FieldType.ASCII;
        }
    }
    ,
    INTEROPERABILITY_VERSION("InteroperabilityVersion", 2){

        @Override
        public FieldType getFieldType() {
            return FieldType.UNDEFINED;
        }
    }
    ,
    RELATED_IMAGE_FILE_FORMAT("RelatedImageFileFormat", 4096){

        @Override
        public FieldType getFieldType() {
            return FieldType.ASCII;
        }
    }
    ,
    RELATED_IMAGE_WIDTH("RelatedImageWidth", 4097){

        @Override
        public FieldType getFieldType() {
            return FieldType.SHORT;
        }
    }
    ,
    RELATED_IMAGE_LENGTH("RelatedImageLength", 4098){

        @Override
        public FieldType getFieldType() {
            return FieldType.SHORT;
        }
    }
    ,
    UNKNOWN("Unknown", -1);

    private static final Map<Short, InteropTag> tagMap;
    private final String name;
    private final short value;

    private InteropTag(String string2, short s) {
        this.name = string2;
        this.value = s;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public short getValue() {
        return this.value;
    }

    public String toString() {
        if (this == UNKNOWN) {
            return this.name;
        }
        return this.name + " [Value: " + StringUtils.shortToHexStringMM(this.value) + "]";
    }

    public static Tag fromShort(short s) {
        InteropTag interopTag = tagMap.get(s);
        if (interopTag == null) {
            return TiffTag.UNKNOWN;
        }
        return interopTag;
    }

    @Override
    public String getFieldAsString(Object object) {
        return "";
    }

    @Override
    public boolean isCritical() {
        return true;
    }

    @Override
    public FieldType getFieldType() {
        return FieldType.UNKNOWN;
    }

    static {
        tagMap = new HashMap<Short, InteropTag>();
        for (InteropTag interopTag : InteropTag.values()) {
            tagMap.put(interopTag.getValue(), interopTag);
        }
    }
}

