/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.meta.iptc;

import com.icafe4j.image.meta.iptc.IPTCTag;
import com.icafe4j.string.StringUtils;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

public enum IPTCEnvelopeTag implements IPTCTag
{
    RECORD_VERSION(0, "EnvelopeRecordVersion"),
    DESTINATION(5, "Destination"){

        @Override
        public boolean allowMultiple() {
            return true;
        }
    }
    ,
    FILE_FORMAT(20, "FileFormat"),
    FILE_VERSION(22, "FileVersion"),
    SERVICE_IDENTIFIER(30, "ServiceIdentifier"),
    ENVELOPE_NUMBER(40, "EnvelopeNumber"),
    PRODUCT_ID(50, "ProductID"){

        @Override
        public boolean allowMultiple() {
            return true;
        }
    }
    ,
    ENVELOPE_PRIORITY(60, "EnvelopePriority"),
    DATE_SENT(70, "DateSent"),
    TIME_SENT(80, "TimeSent"),
    CODED_CHARACTER_SET(90, "CodedCharacterSet"),
    UNIQUE_OBJECT_NAME(100, "UniqueObjectName"),
    ARM_IDENTIFIER(120, "ARMIdentifier"),
    ARM_VERSION(122, "ARMVersion"),
    UNKNOWN(999, "Unknown");

    private static final Map<Integer, IPTCEnvelopeTag> recordMap;
    private final int tag;
    private final String name;

    private IPTCEnvelopeTag(int n2, String string2) {
        this.tag = n2;
        this.name = string2;
    }

    @Override
    public boolean allowMultiple() {
        return false;
    }

    @Override
    public String getDataAsString(byte[] byArray) {
        try {
            String string = new String(byArray, "UTF-8").trim();
            if (string.length() > 0) {
                return string;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        return StringUtils.byteArrayToHexString(byArray, 0, 10);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getTag() {
        return this.tag;
    }

    public static IPTCEnvelopeTag fromTag(int n) {
        IPTCEnvelopeTag iPTCEnvelopeTag = recordMap.get(n);
        if (iPTCEnvelopeTag == null) {
            return UNKNOWN;
        }
        return iPTCEnvelopeTag;
    }

    public String toString() {
        return this.name;
    }

    static {
        recordMap = new HashMap<Integer, IPTCEnvelopeTag>();
        for (IPTCEnvelopeTag iPTCEnvelopeTag : IPTCEnvelopeTag.values()) {
            recordMap.put(iPTCEnvelopeTag.getTag(), iPTCEnvelopeTag);
        }
    }
}

