/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.meta.jpeg;

import com.icafe4j.image.meta.Metadata;
import com.icafe4j.image.meta.MetadataType;
import com.icafe4j.image.meta.jpeg.DuckyDataSet;
import com.icafe4j.image.meta.jpeg.DuckyTag;
import com.icafe4j.io.IOUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ducky
extends Metadata {
    private Map<DuckyTag, DuckyDataSet> datasetMap;
    private static final Logger LOGGER = LoggerFactory.getLogger(Ducky.class);

    public Ducky() {
        super(MetadataType.JPG_DUCKY);
        this.datasetMap = new EnumMap<DuckyTag, DuckyDataSet>(DuckyTag.class);
        this.isDataRead = true;
    }

    public Ducky(byte[] byArray) {
        super(MetadataType.JPG_DUCKY, byArray);
        this.ensureDataRead();
    }

    public void addDataSet(DuckyDataSet duckyDataSet) {
        if (this.datasetMap != null) {
            this.datasetMap.put(DuckyTag.fromTag(duckyDataSet.getTag()), duckyDataSet);
        }
    }

    public void addDataSets(Collection<? extends DuckyDataSet> collection) {
        if (this.datasetMap != null) {
            for (DuckyDataSet duckyDataSet : collection) {
                this.datasetMap.put(DuckyTag.fromTag(duckyDataSet.getTag()), duckyDataSet);
            }
        }
    }

    public Map<DuckyTag, DuckyDataSet> getDataSets() {
        this.ensureDataRead();
        return Collections.unmodifiableMap(this.datasetMap);
    }

    @Override
    public void read() throws IOException {
        if (!this.isDataRead) {
            int n = 0;
            this.datasetMap = new EnumMap<DuckyTag, DuckyDataSet>(DuckyTag.class);
            while (n + 4 <= this.data.length) {
                int n2 = IOUtils.readUnsignedShortMM(this.data, n);
                int n3 = IOUtils.readUnsignedShortMM(this.data, n += 2);
                DuckyTag duckyTag = DuckyTag.fromTag(n2);
                this.datasetMap.put(duckyTag, new DuckyDataSet(n2, n3, this.data, n += 2));
                n += n3;
            }
            this.isDataRead = true;
        }
    }

    @Override
    public void showMetadata() {
        this.ensureDataRead();
        LOGGER.info("JPEG Ducky output starts =>");
        for (DuckyDataSet duckyDataSet : this.datasetMap.values()) {
            duckyDataSet.print();
        }
        LOGGER.info("<= JPEG Ducky output ends");
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        this.ensureDataRead();
        for (DuckyDataSet duckyDataSet : this.getDataSets().values()) {
            duckyDataSet.write(outputStream);
        }
    }
}

