/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.meta.jpeg;

import com.icafe4j.image.meta.jpeg.DuckyTag;
import com.icafe4j.io.IOUtils;
import com.icafe4j.util.ArrayUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuckyDataSet {
    private int tag;
    private int size;
    private byte[] data;
    private int offset;
    private static final Logger LOGGER = LoggerFactory.getLogger(DuckyDataSet.class);

    public DuckyDataSet(int n, byte[] byArray) {
        this(n, byArray.length, byArray, 0);
    }

    public DuckyDataSet(int n, int n2, byte[] byArray, int n3) {
        this.tag = n;
        this.size = n2;
        this.data = byArray;
        this.offset = n3;
    }

    public byte[] getData() {
        return ArrayUtils.subArray(this.data, this.offset, this.size);
    }

    public int getSize() {
        return this.size;
    }

    public int getTag() {
        return this.tag;
    }

    public void print() {
        if (this.size < 4) {
            LOGGER.warn("Data set size {} is too small, should >= 4", (Object)this.size);
            return;
        }
        DuckyTag duckyTag = DuckyTag.fromTag(this.tag);
        if (duckyTag == DuckyTag.UNKNOWN) {
            LOGGER.info("Unknown tag: {}", (Object)this.tag);
        } else if (duckyTag == DuckyTag.QUALITY) {
            LOGGER.info((Object)((Object)duckyTag) + ": {}", (Object)IOUtils.readUnsignedIntMM(this.data, this.offset));
        } else {
            String string = "";
            try {
                string = new String(this.data, this.offset + 4, this.size - 4, "UTF-16BE");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                LOGGER.error("UnsupportedEncoding \"UTF-16BE\"");
            }
            LOGGER.info((Object)((Object)duckyTag) + ": {}", (Object)string);
        }
    }

    public void write(OutputStream outputStream) throws IOException {
        IOUtils.writeShortMM(outputStream, this.tag);
        IOUtils.writeShortMM(outputStream, this.size);
        outputStream.write(this.data, this.offset, this.size);
    }
}

