/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.png;

import com.icafe4j.image.png.Chunk;
import com.icafe4j.image.png.ChunkType;
import com.icafe4j.util.Reader;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.zip.InflaterInputStream;

public class TextReader
implements Reader {
    private String keyword;
    private String text;
    private Chunk chunk;

    public TextReader() {
    }

    public TextReader(Chunk chunk) {
        this.setInput(chunk);
    }

    public String getKeyword() {
        return this.keyword;
    }

    public String getText() {
        return this.text;
    }

    @Override
    public void read() throws IOException {
        StringBuilder stringBuilder = new StringBuilder(1024);
        byte[] byArray = this.chunk.getData();
        switch (this.chunk.getChunkType()) {
            case ZTXT: {
                int n = 0;
                while (byArray[n] != 0) {
                    ++n;
                }
                this.keyword = new String(byArray, 0, n, "UTF-8");
                InflaterInputStream inflaterInputStream = new InflaterInputStream(new ByteArrayInputStream(byArray, n + 2, byArray.length - n - 2));
                InputStreamReader inputStreamReader = new InputStreamReader((InputStream)inflaterInputStream, "UTF-8");
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                String string = null;
                while ((string = bufferedReader.readLine()) != null) {
                    stringBuilder.append(string);
                    stringBuilder.append("\n");
                }
                bufferedReader.close();
                break;
            }
            case TEXT: {
                int n = 0;
                while (byArray[n] != 0) {
                    ++n;
                }
                this.keyword = new String(byArray, 0, n, "UTF-8");
                stringBuilder.append(new String(byArray, n + 1, byArray.length - n - 1, "UTF-8"));
                break;
            }
            case ITXT: {
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                boolean bl = false;
                while (byArray[n] != 0) {
                    ++n;
                }
                stringBuilder.append(new String(byArray, 0, n, "UTF-8"));
                if (byArray[++n] == 1) {
                    bl = true;
                }
                ++n;
                while (byArray[++n] != 0) {
                    ++n3;
                }
                stringBuilder.append("(");
                if (n3 > 0) {
                    stringBuilder.append(new String(byArray, n - n3, n3, "UTF-8"));
                }
                while (byArray[++n] != 0) {
                    ++n2;
                }
                if (n2 > 0) {
                    stringBuilder.append(" ");
                    stringBuilder.append(new String(byArray, n - n2, n2, "UTF-8"));
                }
                stringBuilder.append(")");
                this.keyword = stringBuilder.toString().replaceFirst("\\(\\)", "");
                stringBuilder.setLength(0);
                if (bl) {
                    InflaterInputStream inflaterInputStream = new InflaterInputStream(new ByteArrayInputStream(byArray, n + 1, byArray.length - n - 1));
                    InputStreamReader inputStreamReader = new InputStreamReader((InputStream)inflaterInputStream, "UTF-8");
                    BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                    String string = null;
                    while ((string = bufferedReader.readLine()) != null) {
                        stringBuilder.append(string);
                        stringBuilder.append("\n");
                    }
                    bufferedReader.close();
                } else {
                    stringBuilder.append(new String(byArray, n + 1, byArray.length - n - 1, "UTF-8"));
                    stringBuilder.append("\n");
                }
                stringBuilder.deleteCharAt(stringBuilder.length() - 1);
                break;
            }
            default: {
                throw new IllegalArgumentException("Not a valid textual chunk.");
            }
        }
        this.text = stringBuilder.toString();
    }

    public void setInput(Chunk chunk) {
        TextReader.validate(chunk);
        this.chunk = chunk;
        try {
            this.read();
        }
        catch (IOException iOException) {
            throw new RuntimeException("TextReader: error reading chunk");
        }
    }

    private static void validate(Chunk chunk) {
        if (chunk == null) {
            throw new IllegalArgumentException("Input chunk is null");
        }
        if (chunk.getChunkType() != ChunkType.TEXT && chunk.getChunkType() != ChunkType.ZTXT && chunk.getChunkType() != ChunkType.ITXT) {
            throw new IllegalArgumentException("Not a valid textual chunk.");
        }
    }
}

