/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.png;

import com.icafe4j.image.png.Chunk;
import com.icafe4j.image.png.UnknownChunk;
import com.icafe4j.util.Reader;
import java.io.IOException;

public class UnknownChunkReader
implements Reader {
    private int chunkValue;
    private byte[] data;
    private Chunk chunk;

    public UnknownChunkReader(Chunk chunk) {
        if (chunk == null) {
            throw new IllegalArgumentException("Input chunk is null");
        }
        this.chunk = chunk;
        try {
            this.read();
        }
        catch (IOException iOException) {
            throw new RuntimeException("UnknownChunkReader: error reading chunk");
        }
    }

    public int getChunkValue() {
        return this.chunkValue;
    }

    public byte[] getData() {
        return (byte[])this.data.clone();
    }

    @Override
    public void read() throws IOException {
        if (!(this.chunk instanceof UnknownChunk)) {
            throw new IllegalArgumentException("Expect UnknownChunk.");
        }
        UnknownChunk unknownChunk = (UnknownChunk)this.chunk;
        this.chunkValue = unknownChunk.getChunkValue();
        this.data = unknownChunk.getData();
    }
}

