/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.quant;

import com.icafe4j.image.quant.NeuQuant;
import java.awt.Canvas;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;

public class NQCanvas
extends Canvas {
    private static final long serialVersionUID = -5075876371476649415L;
    private NeuQuant nq = null;
    private int w = 0;
    private int h = 0;
    private Image image = null;
    private String url = null;

    public NQCanvas(String string) {
        this.url = string;
    }

    public void set() {
        try {
            Serializable serializable;
            System.out.println("Fetching " + this.url + " ...");
            Image image = null;
            try {
                serializable = new URL(this.url);
                image = Toolkit.getDefaultToolkit().getImage((URL)serializable);
            }
            catch (Exception exception) {
                image = Toolkit.getDefaultToolkit().getImage(this.url);
            }
            serializable = new MediaTracker(this);
            ((MediaTracker)serializable).addImage(image, 0);
            try {
                ((MediaTracker)serializable).waitForID(0);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            System.out.println("w = " + image.getWidth(this));
            System.out.println("h = " + image.getHeight(this));
            this.set(image);
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public void set(Image image) throws IOException {
        this.w = image.getWidth(this);
        this.h = image.getHeight(this);
        int[] nArray = new int[this.w * this.h];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, this.w, this.h, nArray, 0, this.w);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if ((pixelGrabber.getStatus() & 0x80) != 0) {
            throw new IOException("Image pixel grab aborted or errored");
        }
        this.nq = new NeuQuant(nArray);
        nArray = this.nq.quantize();
        this.image = this.createImage(new MemoryImageSource(this.w, this.h, nArray, 0, this.w));
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.image == null) {
            this.set();
        }
        if (this.image != null) {
            graphics.drawImage(this.image, 0, 0, this);
        }
    }

    public static void main(String[] stringArray) {
        NQCanvas nQCanvas = new NQCanvas(stringArray[0]);
        Frame frame = new Frame("NeuQuant Test");
        frame.setSize(500, 500);
        frame.add(nQCanvas);
        frame.setVisible(true);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                System.out.println("Closing program");
                System.exit(0);
            }
        });
    }
}

