/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.quant;

import com.icafe4j.image.util.IMGUtils;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NeuQuant {
    public static final int ncycles = 100;
    public static final int netsize = 256;
    public static final int specials = 3;
    public static final int bgColour = 2;
    public static final int cutnetsize = 253;
    public static final int maxnetpos = 255;
    public static final int initrad = 32;
    public static final int radiusbiasshift = 6;
    public static final int radiusbias = 64;
    public static final int initBiasRadius = 2048;
    public static final int radiusdec = 30;
    public static final int alphabiasshift = 10;
    public static final int initalpha = 1024;
    public static final double gamma = 1024.0;
    public static final double beta = 9.765625E-4;
    public static final double betagamma = 1.0;
    public static final int prime1 = 499;
    public static final int prime2 = 491;
    public static final int prime3 = 487;
    public static final int prime4 = 503;
    public static final int maxprime = 503;
    private double[][] network = new double[256][3];
    private int[] netindex = new int[256];
    private double[] bias = new double[256];
    private double[] freq = new double[256];
    private int samplefac = 0;
    private int[] pixels = null;
    private int[][] colormap = new int[256][4];
    private int transparent_color = -1;
    private static final Logger LOGGER = LoggerFactory.getLogger(NeuQuant.class);

    public NeuQuant(Image image, int n, int n2) {
        this(1);
        this.setPixels(image, n, n2);
        this.setUpArrays();
    }

    public NeuQuant(int n, Image image, int n2, int n3) {
        this(n);
        this.setPixels(image, n2, n3);
        this.setUpArrays();
    }

    public NeuQuant(int[] nArray) {
        this(1, nArray);
    }

    public NeuQuant(int n, int[] nArray) {
        this(n);
        this.pixels = nArray;
    }

    private NeuQuant(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Sample must be 1..30");
        }
        if (n > 30) {
            throw new IllegalArgumentException("Sample must be 1..30");
        }
        this.samplefac = n;
    }

    public int getColorCount() {
        return 256;
    }

    public int[][] getColourMap() {
        return this.colormap;
    }

    private void setUpArrays() {
        int n;
        this.network[0][0] = 0.0;
        this.network[0][1] = 0.0;
        this.network[0][2] = 0.0;
        this.network[1][0] = 255.0;
        this.network[1][1] = 255.0;
        this.network[1][2] = 255.0;
        for (n = 0; n < 3; ++n) {
            this.freq[n] = 0.00390625;
            this.bias[n] = 0.0;
        }
        for (n = 3; n < 256; ++n) {
            double[] dArray = this.network[n];
            dArray[0] = 255.0 * (double)(n - 3) / 253.0;
            dArray[1] = 255.0 * (double)(n - 3) / 253.0;
            dArray[2] = 255.0 * (double)(n - 3) / 253.0;
            this.freq[n] = 0.00390625;
            this.bias[n] = 0.0;
        }
    }

    private void setPixels(Image image, int n, int n2) {
        if (n * n2 < 503) {
            throw new IllegalArgumentException("Image is too small");
        }
        int[] nArray = null;
        if (image instanceof BufferedImage) {
            nArray = IMGUtils.getRGB((BufferedImage)image);
        } else {
            nArray = new int[n * n2];
            PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n, n2, nArray, 0, n);
            try {
                pixelGrabber.grabPixels();
            }
            catch (InterruptedException interruptedException) {
                System.err.println("interrupted waiting for pixels!");
            }
            if ((pixelGrabber.getStatus() & 0x80) != 0) {
                System.err.println("image fetch aborted or errored");
            }
        }
    }

    public int[] quantize() {
        this.learn();
        this.fix();
        this.inxbuild();
        for (int i = 0; i < this.pixels.length; ++i) {
            int n = this.pixels[i] >> 24 & 0xFF;
            int n2 = this.pixels[i] >> 16 & 0xFF;
            int n3 = this.pixels[i] >> 8 & 0xFF;
            int n4 = this.pixels[i] & 0xFF;
            int n5 = this.inxsearch(n4, n3, n2);
            int n6 = this.colormap[n5][0];
            int n7 = this.colormap[n5][1];
            int n8 = this.colormap[n5][2];
            this.pixels[i] = n << 24 | n8 << 16 | n7 << 8 | n6;
        }
        return this.pixels;
    }

    public int quantize(byte[] byArray, int[] nArray, int[] nArray2) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        this.learn();
        this.fix();
        this.inxbuild();
        for (n5 = 0; n5 < this.pixels.length; ++n5) {
            n4 = this.pixels[n5];
            n3 = n4 >> 16 & 0xFF;
            n2 = n4 >> 8 & 0xFF;
            n = n4 & 0xFF;
            byArray[n5] = n4 >>> 24 < 128 ? -1 : (byte)this.inxsearch(n, n2, n3);
        }
        for (n5 = 0; n5 < 256; ++n5) {
            n4 = this.colormap[n5][0];
            n3 = this.colormap[n5][1];
            n2 = this.colormap[n5][2];
            n = this.colormap[n5][3];
            nArray[n5] = n << 24 | n2 << 16 | n3 << 8 | n4;
        }
        n5 = 0;
        while (1 << n5 < 256) {
            ++n5;
        }
        nArray2[0] = n5;
        nArray2[1] = -1;
        if (this.transparent_color >= 0) {
            nArray[255] = this.transparent_color;
            nArray2[1] = 255;
        }
        return this.transparent_color >= 0 ? 255 : 256;
    }

    public int quantize(int[] nArray, int[] nArray2) {
        int n;
        this.learn();
        this.fix();
        this.inxbuild();
        for (n = 0; n < 256; ++n) {
            int n2 = this.colormap[n][0];
            int n3 = this.colormap[n][1];
            int n4 = this.colormap[n][2];
            int n5 = this.colormap[n][3];
            nArray[n] = n5 << 24 | n4 << 16 | n3 << 8 | n2;
        }
        n = 0;
        while (1 << n < 256) {
            ++n;
        }
        nArray2[0] = n;
        nArray2[1] = -1;
        if (this.transparent_color >= 0) {
            nArray[255] = this.transparent_color;
            nArray2[1] = 255;
        }
        return this.transparent_color >= 0 ? 255 : 256;
    }

    private void altersingle(double d, int n, double d2, double d3, double d4) {
        double[] dArray = this.network[n];
        dArray[0] = dArray[0] - d * (dArray[0] - d2);
        dArray[1] = dArray[1] - d * (dArray[1] - d3);
        dArray[2] = dArray[2] - d * (dArray[2] - d4);
    }

    private void alterneigh(double d, int n, int n2, double d2, double d3, double d4) {
        int n3;
        int n4 = n2 - n;
        if (n4 < 2) {
            n4 = 2;
        }
        if ((n3 = n2 + n) > 256) {
            n3 = 256;
        }
        int n5 = n2 + 1;
        int n6 = n2 - 1;
        int n7 = 0;
        while (n5 < n3 || n6 > n4) {
            double[] dArray;
            double d5 = d * (double)(n * n - n7 * n7) / (double)(n * n);
            ++n7;
            if (n5 < n3) {
                dArray = this.network[n5];
                dArray[0] = dArray[0] - d5 * (dArray[0] - d2);
                dArray[1] = dArray[1] - d5 * (dArray[1] - d3);
                dArray[2] = dArray[2] - d5 * (dArray[2] - d4);
                ++n5;
            }
            if (n6 <= n4) continue;
            dArray = this.network[n6];
            dArray[0] = dArray[0] - d5 * (dArray[0] - d2);
            dArray[1] = dArray[1] - d5 * (dArray[1] - d3);
            dArray[2] = dArray[2] - d5 * (dArray[2] - d4);
            --n6;
        }
    }

    private int contest(double d, double d2, double d3) {
        int n;
        double d4;
        double d5 = d4 = 3.4028234663852886E38;
        int n2 = n = -1;
        for (int i = 3; i < 256; ++i) {
            double d6;
            double d7;
            double[] dArray = this.network[i];
            double d8 = dArray[0] - d;
            if (d8 < 0.0) {
                d8 = -d8;
            }
            if ((d7 = dArray[1] - d2) < 0.0) {
                d7 = -d7;
            }
            d8 += d7;
            d7 = dArray[2] - d3;
            if (d7 < 0.0) {
                d7 = -d7;
            }
            if ((d8 += d7) < d4) {
                d4 = d8;
                n = i;
            }
            if ((d6 = d8 - this.bias[i]) < d5) {
                d5 = d6;
                n2 = i;
            }
            int n3 = i;
            this.freq[n3] = this.freq[n3] - 9.765625E-4 * this.freq[i];
            int n4 = i;
            this.bias[n4] = this.bias[n4] + 1.0 * this.freq[i];
        }
        int n5 = n;
        this.freq[n5] = this.freq[n5] + 9.765625E-4;
        int n6 = n;
        this.bias[n6] = this.bias[n6] - 1.0;
        return n2;
    }

    private int specialFind(double d, double d2, double d3) {
        for (int i = 0; i < 3; ++i) {
            double[] dArray = this.network[i];
            if (dArray[0] != d || dArray[1] != d2 || dArray[2] != d3) continue;
            return i;
        }
        return -1;
    }

    private void learn() {
        int n = 2048;
        int n2 = 30 + (this.samplefac - 1) / 3;
        int n3 = this.pixels.length;
        int n4 = n3 / this.samplefac;
        int n5 = n4 / 100;
        int n6 = 1024;
        int n7 = 0;
        int n8 = n >> 6;
        if (n8 <= 1) {
            n8 = 0;
        }
        LOGGER.info("beginning 1D learning: samplepixels = {} rad = {}", (Object)n4, (Object)n8);
        int n9 = 0;
        int n10 = 0;
        n9 = n3 % 499 != 0 ? 499 : (n3 % 491 != 0 ? 491 : (n3 % 487 != 0 ? 487 : 503));
        n7 = 0;
        while (n7 < n4) {
            int n11;
            int n12 = this.pixels[n10];
            if (n12 >>> 24 < 128 && this.transparent_color < 0) {
                this.transparent_color = n12;
            }
            double d = n12 >> 16 & 0xFF;
            double d2 = n12 >> 8 & 0xFF;
            double d3 = n12 & 0xFF;
            if (n7 == 0) {
                this.network[2][0] = d3;
                this.network[2][1] = d2;
                this.network[2][2] = d;
            }
            int n13 = n11 = (n11 = this.specialFind(d3, d2, d)) < 0 ? this.contest(d3, d2, d) : n11;
            if (n11 >= 3) {
                double d4 = 1.0 * (double)n6 / 1024.0;
                this.altersingle(d4, n11, d3, d2, d);
                if (n8 > 0) {
                    this.alterneigh(d4, n8, n11, d3, d2, d);
                }
            }
            n10 += n9;
            while (n10 >= n3) {
                n10 -= n3;
            }
            if (++n7 % n5 != 0) continue;
            n6 -= n6 / n2;
            if ((n8 = (n -= n / 30) >> 6) > 1) continue;
            n8 = 0;
        }
        LOGGER.info("finished 1D learning: final alpha = {} !", (Object)(1.0 * (double)n6 / 1024.0));
    }

    private void fix() {
        for (int i = 0; i < 256; ++i) {
            for (int j = 0; j < 3; ++j) {
                int n = (int)(0.5 + this.network[i][j]);
                if (n < 0) {
                    n = 0;
                }
                if (n > 255) {
                    n = 255;
                }
                this.colormap[i][j] = n;
            }
            this.colormap[i][3] = i;
        }
    }

    private void inxbuild() {
        int n;
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < 256; ++n) {
            int n4;
            int[] nArray = this.colormap[n];
            int[] nArray2 = null;
            int n5 = n;
            int n6 = nArray[1];
            for (n4 = n + 1; n4 < 256; ++n4) {
                nArray2 = this.colormap[n4];
                if (nArray2[1] >= n6) continue;
                n5 = n4;
                n6 = nArray2[1];
            }
            nArray2 = this.colormap[n5];
            if (n != n5) {
                n4 = nArray2[0];
                nArray2[0] = nArray[0];
                nArray[0] = n4;
                n4 = nArray2[1];
                nArray2[1] = nArray[1];
                nArray[1] = n4;
                n4 = nArray2[2];
                nArray2[2] = nArray[2];
                nArray[2] = n4;
                n4 = nArray2[3];
                nArray2[3] = nArray[3];
                nArray[3] = n4;
            }
            if (n6 == n2) continue;
            this.netindex[n2] = n3 + n >> 1;
            for (n4 = n2 + 1; n4 < n6; ++n4) {
                this.netindex[n4] = n;
            }
            n2 = n6;
            n3 = n;
        }
        this.netindex[n2] = n3 + 255 >> 1;
        for (n = n2 + 1; n < 256; ++n) {
            this.netindex[n] = 255;
        }
    }

    private int inxsearch(int n, int n2, int n3) {
        int n4 = 1000;
        int n5 = -1;
        int n6 = this.netindex[n2];
        int n7 = n6 - 1;
        while (n6 < 256 || n7 >= 0) {
            int n8;
            int n9;
            int[] nArray;
            if (n6 < 256) {
                nArray = this.colormap[n6];
                n9 = nArray[1] - n2;
                if (n9 >= n4) {
                    n6 = 256;
                } else {
                    if (n9 < 0) {
                        n9 = -n9;
                    }
                    if ((n8 = nArray[0] - n) < 0) {
                        n8 = -n8;
                    }
                    if ((n9 += n8) < n4) {
                        n8 = nArray[2] - n3;
                        if (n8 < 0) {
                            n8 = -n8;
                        }
                        if ((n9 += n8) < n4) {
                            n4 = n9;
                            n5 = n6;
                        }
                    }
                    ++n6;
                }
            }
            if (n7 < 0) continue;
            nArray = this.colormap[n7];
            n9 = n2 - nArray[1];
            if (n9 >= n4) {
                n7 = -1;
                continue;
            }
            if (n9 < 0) {
                n9 = -n9;
            }
            if ((n8 = nArray[0] - n) < 0) {
                n8 = -n8;
            }
            if ((n9 += n8) < n4) {
                n8 = nArray[2] - n3;
                if (n8 < 0) {
                    n8 = -n8;
                }
                if ((n9 += n8) < n4) {
                    n4 = n9;
                    n5 = n7;
                }
            }
            --n7;
        }
        return n5;
    }
}

