/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.reader;

import com.icafe4j.image.compression.huffman.HuffmanTbl;
import com.icafe4j.image.jpeg.Component;
import com.icafe4j.image.jpeg.DHTReader;
import com.icafe4j.image.jpeg.DQTReader;
import com.icafe4j.image.jpeg.HTable;
import com.icafe4j.image.jpeg.Marker;
import com.icafe4j.image.jpeg.QTable;
import com.icafe4j.image.jpeg.SOFReader;
import com.icafe4j.image.jpeg.SOSReader;
import com.icafe4j.image.jpeg.Segment;
import com.icafe4j.image.reader.ImageReader;
import com.icafe4j.io.IOUtils;
import com.icafe4j.string.StringUtils;
import com.icafe4j.util.ArrayUtils;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPGReader
extends ImageReader {
    public static final byte[] ADOBE_ID = new byte[]{65, 100, 111, 98, 101};
    public static final String ICC_PROFILE_ID = "ICC_PROFILE\u0000";
    private SOFReader sofReader;
    private int[][] quant_tbl = new int[4][];
    private HuffmanTbl[] dc_hufftbl = new HuffmanTbl[4];
    private HuffmanTbl[] ac_hufftbl = new HuffmanTbl[4];
    private Map<Integer, Component> components = new HashMap<Integer, Component>(4);
    private static final Logger LOGGER = LoggerFactory.getLogger(JPGReader.class);

    public BufferedImage read1(InputStream inputStream) throws Exception {
        boolean bl = false;
        int n = 0;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (Marker.fromShort(IOUtils.readShortMM(inputStream)) != Marker.SOI) {
            throw new IllegalArgumentException("Invalid JPEG image, expected SOI marker not found!");
        }
        short s = IOUtils.readShortMM(inputStream);
        block12: while (!bl) {
            if (Marker.fromShort(s) == Marker.EOI) {
                bl = true;
                continue;
            }
            Marker marker = Marker.fromShort(s);
            switch (marker) {
                case JPG: 
                case JPG0: 
                case JPG13: 
                case TEM: {
                    s = IOUtils.readShortMM(inputStream);
                    continue block12;
                }
                case PADDING: {
                    int n2 = 0;
                    while ((n2 = IOUtils.read(inputStream)) == 255) {
                    }
                    s = (short)(0xFF00 | n2);
                    continue block12;
                }
                case DQT: {
                    this.read_DQT(inputStream);
                    s = IOUtils.readShortMM(inputStream);
                    continue block12;
                }
                case DHT: {
                    this.read_DHT(inputStream);
                    s = IOUtils.readShortMM(inputStream);
                    continue block12;
                }
                case SOS: {
                    this.readSOS(inputStream, this.sofReader);
                    s = IOUtils.readShortMM(inputStream);
                    continue block12;
                }
                case SOF0: 
                case SOF1: 
                case SOF2: {
                    this.readSOF(inputStream, marker);
                }
                case SOF3: 
                case SOF5: 
                case SOF6: 
                case SOF7: {
                    throw new Exception("Lossless Jpeg is not supported yet");
                }
                case SOF9: 
                case SOF10: 
                case SOF11: {
                    throw new Exception("Arithmetic encoded Jpeg is not supported yet");
                }
                case APP2: {
                    JPGReader.readAPP2(inputStream, byteArrayOutputStream);
                    s = IOUtils.readShortMM(inputStream);
                    continue block12;
                }
                case APP14: {
                    JPGReader.readAPP14(inputStream);
                }
            }
            n = IOUtils.readUnsignedShortMM(inputStream);
            byte[] byArray = new byte[n - 2];
            IOUtils.readFully(inputStream, byArray);
            s = IOUtils.readShortMM(inputStream);
        }
        return null;
    }

    private static void readAPP2(InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[12];
        int n = IOUtils.readUnsignedShortMM(inputStream);
        IOUtils.readFully(inputStream, byArray);
        if (Arrays.equals(byArray, ICC_PROFILE_ID.getBytes())) {
            byArray = new byte[n - 14];
            IOUtils.readFully(inputStream, byArray);
            outputStream.write(byArray, 2, n - 16);
        } else {
            IOUtils.skipFully(inputStream, n - 14);
        }
    }

    private static void readAPP14(InputStream inputStream) throws IOException {
        String[] stringArray = new String[]{"DCTEncodeVersion: ", "APP14Flags0: ", "APP14Flags1: ", "ColorTransform: "};
        int n = 14;
        int n2 = IOUtils.readUnsignedShortMM(inputStream);
        if (n2 >= n) {
            byte[] byArray = new byte[n2 - 2];
            IOUtils.readFully(inputStream, byArray, 0, n2 - 2);
            byte[] byArray2 = ArrayUtils.subArray(byArray, 0, 5);
            if (Arrays.equals(byArray2, ADOBE_ID)) {
                int n3 = 0;
                int n4 = 5;
                while (n3 < 3) {
                    LOGGER.info("{}{}", (Object)stringArray[n3], (Object)StringUtils.shortToHexStringMM(IOUtils.readShortMM(byArray, n4)));
                    ++n3;
                    n4 += 2;
                }
                LOGGER.info("{}{}", (Object)stringArray[3], (Object)((byArray[11] & 0xFF) == 0 ? "Unknown (RGB or CMYK)" : ((byArray[11] & 0xFF) == 1 ? "YCbCr" : "YCCK")));
            }
        }
    }

    private void read_DQT(InputStream inputStream) throws IOException {
        int n = IOUtils.readUnsignedShortMM(inputStream);
        byte[] byArray = new byte[n - 2];
        IOUtils.readFully(inputStream, byArray);
        DQTReader dQTReader = new DQTReader(new Segment(Marker.DQT, n, byArray));
        List<QTable> list = dQTReader.getTables();
        for (QTable qTable : list) {
            int n2 = qTable.getID();
            this.quant_tbl[n2] = qTable.getData();
        }
        LOGGER.debug("\n{}", (Object)JPGReader.qTablesToString(list));
    }

    private static String qTablesToString(List<QTable> list) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Quantization table information =>:\n");
        int n = 0;
        for (QTable qTable : list) {
            int n2;
            int n3 = qTable.getPrecision();
            int[] nArray = qTable.getData();
            stringBuilder.append("precision of QT is " + n3 + "\n");
            stringBuilder.append("Quantization table #" + qTable.getID() + ":\n");
            if (n3 == 0) {
                for (n2 = 0; n2 < 64; ++n2) {
                    if (n2 != 0 && n2 % 8 == 0) {
                        stringBuilder.append("\n");
                    }
                    stringBuilder.append(nArray[n2] + " ");
                }
            } else {
                for (n2 = 0; n2 < 64; ++n2) {
                    if (n2 != 0 && n2 % 8 == 0) {
                        stringBuilder.append("\n");
                    }
                    stringBuilder.append(nArray[n2] + " ");
                }
            }
            ++n;
            stringBuilder.append("\n");
            stringBuilder.append("***************************\n");
        }
        stringBuilder.append("Total number of Quantation tables: " + n + "\n");
        stringBuilder.append("End of quantization table information\n");
        return stringBuilder.toString();
    }

    private void read_DHT(InputStream inputStream) throws IOException {
        int n = IOUtils.readUnsignedShortMM(inputStream);
        byte[] byArray = new byte[n - 2];
        IOUtils.readFully(inputStream, byArray);
        DHTReader dHTReader = new DHTReader(new Segment(Marker.DHT, n, byArray));
        List<HTable> list = dHTReader.getDCTables();
        List<HTable> list2 = dHTReader.getACTables();
        for (HTable hTable : list) {
            this.dc_hufftbl[hTable.getID()] = new HuffmanTbl(hTable.getBits(), hTable.getValues());
        }
        for (HTable hTable : list2) {
            this.ac_hufftbl[hTable.getID()] = new HuffmanTbl(hTable.getBits(), hTable.getValues());
        }
        LOGGER.debug("\n{}", (Object)JPGReader.hTablesToString(list));
        LOGGER.debug("\n{}", (Object)JPGReader.hTablesToString(list2));
    }

    private static String hTablesToString(List<HTable> list) {
        String[] stringArray = new String[]{"DC Component", "AC Component"};
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Huffman table information =>:\n");
        for (HTable hTable : list) {
            int n;
            stringBuilder.append("Class: " + hTable.getClazz() + " (" + stringArray[hTable.getClazz()] + ")\n");
            stringBuilder.append("Huffman table #: " + hTable.getID() + "\n");
            byte[] byArray = hTable.getBits();
            byte[] byArray2 = hTable.getValues();
            int n2 = 0;
            for (n = 0; n < byArray.length; ++n) {
                n2 += byArray[n] & 0xFF;
            }
            stringBuilder.append("Number of codes: " + n2 + "\n");
            if (n2 > 256) {
                throw new RuntimeException("Invalid huffman code count: " + n2);
            }
            n = 0;
            for (int i = 0; i < 16; ++i) {
                stringBuilder.append("Codes of length " + (i + 1) + " (" + (byArray[i] & 0xFF) + " total): [ ");
                for (int j = 0; j < (byArray[i] & 0xFF); ++j) {
                    stringBuilder.append((byArray2[n++] & 0xFF) + " ");
                }
                stringBuilder.append("]\n");
            }
            stringBuilder.append("<= End of Huffman table information>>\n");
        }
        return stringBuilder.toString();
    }

    private SOFReader readSOF(InputStream inputStream, Marker marker) throws IOException {
        int n = IOUtils.readUnsignedShortMM(inputStream);
        byte[] byArray = new byte[n - 2];
        IOUtils.readFully(inputStream, byArray);
        Segment segment = new Segment(marker, n, byArray);
        SOFReader sOFReader = new SOFReader(segment);
        LOGGER.debug("\n", (Object)JPGReader.sofToString(sOFReader));
        return sOFReader;
    }

    private static String sofToString(SOFReader sOFReader) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SOF information =>\n");
        stringBuilder.append("Precision: " + sOFReader.getPrecision() + "\n");
        stringBuilder.append("Image height: " + sOFReader.getFrameHeight() + "\n");
        stringBuilder.append("Image width: " + sOFReader.getFrameWidth() + "\n");
        stringBuilder.append("# of Components: " + sOFReader.getNumOfComponents() + "\n");
        stringBuilder.append("(1 = grey scaled, 3 = color YCbCr or YIQ, 4 = color CMYK)\n");
        for (Component component : sOFReader.getComponents()) {
            stringBuilder.append("\n");
            stringBuilder.append("Component ID: " + component.getId() + "\n");
            stringBuilder.append("Herizontal sampling factor: " + component.getHSampleFactor() + "\n");
            stringBuilder.append("Vertical sampling factor: " + component.getVSampleFactor() + "\n");
            stringBuilder.append("Quantization table #: " + component.getQTableNumber() + "\n");
            stringBuilder.append("DC table number: " + component.getDCTableNumber() + "\n");
            stringBuilder.append("AC table number: " + component.getACTableNumber() + "\n");
        }
        stringBuilder.append("<= End of SOF information");
        return stringBuilder.toString();
    }

    private short readSOS(InputStream inputStream, SOFReader sOFReader) throws IOException {
        int n = IOUtils.readUnsignedShortMM(inputStream);
        byte[] byArray = new byte[n - 2];
        IOUtils.readFully(inputStream, byArray);
        Segment segment = new Segment(Marker.SOS, n, byArray);
        new SOSReader(segment, sOFReader);
        int n2 = 0;
        short s = 0;
        block3: while ((n2 = IOUtils.read(inputStream)) != -1) {
            if (n2 != 255) continue;
            n2 = IOUtils.read(inputStream);
            if (n2 == -1) {
                throw new IOException("Premature end of SOS segment!");
            }
            if (n2 == 0) continue;
            s = (short)(0xFF00 | n2);
            switch (Marker.fromShort(s)) {
                case RST0: 
                case RST1: 
                case RST2: 
                case RST3: 
                case RST4: 
                case RST5: 
                case RST6: 
                case RST7: {
                    continue block3;
                }
            }
        }
        if (n2 == -1) {
            throw new IOException("Premature end of SOS segment!");
        }
        return s;
    }

    @Override
    public BufferedImage read(InputStream inputStream) throws Exception {
        return ImageIO.read(inputStream);
    }
}

