/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.reader;

import com.icafe4j.image.reader.ImageReader;
import com.icafe4j.image.util.BytePacker;
import com.icafe4j.io.IOUtils;
import com.icafe4j.util.ArrayUtils;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PCXReader
extends ImageReader {
    short bytesPerLine = 0;
    byte NPlanes = 0;
    PcxHeader pcxHeader;
    private static final Logger LOGGER = LoggerFactory.getLogger(PCXReader.class);

    @Override
    public BufferedImage read(InputStream inputStream) throws Exception {
        this.pcxHeader = new PcxHeader();
        this.pcxHeader.readHeader(inputStream);
        this.width = this.pcxHeader.xmax - this.pcxHeader.xmin + 1;
        this.height = this.pcxHeader.ymax - this.pcxHeader.ymin + 1;
        this.bytesPerLine = this.pcxHeader.bytes_per_line;
        this.rgbColorPalette = this.pcxHeader.colorPalette;
        this.NPlanes = this.pcxHeader.color_plane;
        this.bitsPerPixel = this.pcxHeader.bits_per_pixel * this.pcxHeader.color_plane;
        if (this.pcxHeader.bits_per_pixel == 8 && this.pcxHeader.color_plane == 1) {
            return this.read256ColorPcx(inputStream);
        }
        if (this.pcxHeader.bits_per_pixel == 8 && this.pcxHeader.color_plane == 3) {
            return this.readTrueColorPcx(inputStream);
        }
        if (this.NPlanes == 1) {
            switch (this.bitsPerPixel) {
                case 4: {
                    LOGGER.info("16 color pcx image, 4 bits per pixel, 1 color plane!");
                    break;
                }
                case 3: {
                    throw new UnsupportedOperationException("Invalid bitsPerPixel: " + this.bitsPerPixel + " for one plane PCX image");
                }
                case 2: {
                    LOGGER.info("4 color pcx image, 2 bits per pixel, 1 color plane!");
                    break;
                }
                case 1: {
                    LOGGER.info("2 color pcx image, 1 bits per pixel, 1 color plane!");
                    break;
                }
            }
            return this.readOnePlaneEgaPcx(inputStream);
        }
        if (this.pcxHeader.bits_per_pixel == 1) {
            switch (this.NPlanes) {
                case 4: {
                    LOGGER.info("16 color image, 1 bit per plane, 4 planes!");
                    break;
                }
                case 3: {
                    LOGGER.info("8 color image, 1 bit per plane, 3 planes!");
                    break;
                }
                case 2: {
                    LOGGER.info("4 color image, 1 bit per plane, 2 planes!");
                    break;
                }
            }
            return this.readOneBitEgaPcx(inputStream);
        }
        LOGGER.error("unimplemented for this format!");
        return null;
    }

    private void readPalette(byte[] byArray) throws Exception {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < byArray.length; i += 3) {
            this.rgbColorPalette[n++] = 0xFF000000 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF;
        }
    }

    private void readPalette(InputStream inputStream, int n) throws Exception {
        int n2 = 0;
        int n3 = 0;
        byte[] byArray = new byte[n];
        inputStream.read(byArray, 0, n);
        for (int i = 0; i < n; i += 3) {
            this.rgbColorPalette[n2++] = 0xFF000000 | (byArray[n3++] & 0xFF) << 16 | (byArray[n3++] & 0xFF) << 8 | byArray[n3++] & 0xFF;
        }
    }

    private BufferedImage readTrueColorPcx(InputStream inputStream) throws Exception {
        byte[] byArray = IOUtils.readFully(inputStream, 4096);
        byte[] byArray2 = new byte[this.bytesPerLine * this.NPlanes * this.height];
        LOGGER.info("true color pcx image!");
        this.readScanLines(byArray, byArray.length, byArray2);
        inputStream.close();
        DataBufferByte dataBufferByte = new DataBufferByte(byArray2, byArray2.length);
        int n = 1;
        int[] nArray = new int[]{8, 8, 8};
        WritableRaster writableRaster = Raster.createBandedRaster(dataBufferByte, this.width, this.height, this.bytesPerLine * 3, new int[]{0, 0, 0}, new int[]{0, this.bytesPerLine, this.bytesPerLine * 2}, null);
        ComponentColorModel componentColorModel = new ComponentColorModel(ColorSpace.getInstance(1000), nArray, false, false, n, 0);
        return new BufferedImage(componentColorModel, writableRaster, false, null);
    }

    private void readScanLines(byte[] byArray, int n, byte[] byArray2) throws Exception {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = this.NPlanes * this.bytesPerLine;
        block0: for (int i = 0; i < this.height; ++i) {
            do {
                if (((n3 = byArray[n6++] & 0xFF) & 0xC0) == 192) {
                    n7 = n3 & 0x3F;
                    n4 = byArray[n6++] & 0xFF;
                    for (int j = 0; j < n7 && n2 < n8; ++j, ++n2) {
                        byArray2[n5++] = (byte)n4;
                    }
                    if (n6 < n) continue;
                    break block0;
                }
                byArray2[n5++] = (byte)n3;
                ++n2;
                if (n6 >= n) break block0;
            } while (n2 < n8);
            n2 = 0;
        }
    }

    private BufferedImage read256ColorPcx(InputStream inputStream) throws Exception {
        int n = this.bytesPerLine * this.NPlanes;
        byte[] byArray = new byte[n * this.height];
        byte[] byArray2 = IOUtils.readFully(inputStream, 4096);
        int n2 = 1 << this.NPlanes * this.pcxHeader.bits_per_pixel;
        int n3 = 3 * n2;
        this.rgbColorPalette = new int[n2];
        int n4 = byArray2.length - n3;
        byte[] byArray3 = ArrayUtils.subArray(byArray2, 0, n4);
        this.readPalette(ArrayUtils.subArray(byArray2, n4, n3));
        LOGGER.info("256 color pcx image!");
        this.readScanLines(byArray3, n4, byArray);
        inputStream.close();
        int[] nArray = new int[]{0};
        DataBufferByte dataBufferByte = new DataBufferByte(byArray, byArray.length);
        WritableRaster writableRaster = Raster.createInterleavedRaster(dataBufferByte, this.width, this.height, (int)this.bytesPerLine, 1, nArray, null);
        IndexColorModel indexColorModel = new IndexColorModel(8, this.rgbColorPalette.length, this.rgbColorPalette, 0, false, -1, 0);
        return new BufferedImage(indexColorModel, writableRaster, false, null);
    }

    private BufferedImage readOneBitEgaPcx(InputStream inputStream) throws Exception {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        byte[] byArray = IOUtils.readFully(inputStream, 4096);
        int n9 = byArray.length;
        n7 = this.bytesPerLine * this.NPlanes;
        int[] nArray = new int[n7];
        BytePacker bytePacker = new BytePacker(this.bitsPerPixel, this.width, this.width * this.height);
        block0: for (int i = 0; i < this.height; ++i) {
            int n10;
            do {
                if (((n5 = byArray[n4++] & 0xFF) & 0xC0) == 192) {
                    n8 = n5 & 0x3F;
                    n6 = byArray[n4++] & 0xFF;
                    for (n10 = 0; n10 < n8 && n < n7; ++n10) {
                        nArray[n++] = n6;
                    }
                    if (n4 < n9) continue;
                    break block0;
                }
                nArray[n++] = n5;
                if (n4 >= n9) break block0;
            } while (n < n7);
            block3: for (n10 = 0; n10 < this.bytesPerLine; ++n10) {
                for (int j = 7; j >= 0; --j) {
                    for (int k = 0; k < this.NPlanes; ++k) {
                        n3 |= (nArray[n10 + this.bytesPerLine * k] >> j & 1) << k;
                    }
                    bytePacker.packByte(n3);
                    n3 = 0;
                    if (++n2 % this.width == 0) break block3;
                }
            }
            n = 0;
        }
        inputStream.close();
        byte[] byArray2 = bytePacker.getPackedBytes();
        DataBufferByte dataBufferByte = new DataBufferByte(byArray2, byArray2.length);
        WritableRaster writableRaster = Raster.createPackedRaster(dataBufferByte, this.width, this.height, this.bitsPerPixel, null);
        IndexColorModel indexColorModel = new IndexColorModel(this.bitsPerPixel, this.rgbColorPalette.length, this.rgbColorPalette, 0, false, -1, 0);
        return new BufferedImage(indexColorModel, writableRaster, false, null);
    }

    private BufferedImage readOnePlaneEgaPcx(InputStream inputStream) throws Exception {
        Object object;
        byte[] byArray = IOUtils.readFully(inputStream, 4096);
        byte[] byArray2 = new byte[this.bytesPerLine * this.height];
        this.readScanLines(byArray, byArray.length, byArray2);
        inputStream.close();
        DataBufferByte dataBufferByte = new DataBufferByte(byArray2, byArray2.length);
        WritableRaster writableRaster = Raster.createPackedRaster(dataBufferByte, this.width, this.height, this.bitsPerPixel, null);
        if (this.bitsPerPixel == 1) {
            object = new int[]{-16777216, -1};
            this.rgbColorPalette = object;
        }
        object = new IndexColorModel(this.bitsPerPixel, this.rgbColorPalette.length, this.rgbColorPalette, 0, false, -1, 0);
        return new BufferedImage((ColorModel)object, writableRaster, false, null);
    }

    private static class PcxHeader {
        byte manufacturer;
        byte version;
        byte encoding;
        byte bits_per_pixel;
        short xmin;
        short ymin;
        short xmax;
        short ymax;
        short hres;
        short vres;
        int[] colorPalette = new int[16];
        byte reserved;
        byte color_plane;
        short bytes_per_line;
        short palette_type;
        byte[] filler = new byte[58];

        private PcxHeader() {
        }

        void readHeader(InputStream inputStream) throws Exception {
            int n;
            int n2 = 0;
            byte[] byArray = new byte[128];
            IOUtils.readFully(inputStream, byArray, 0, 128);
            this.manufacturer = byArray[n2++];
            this.version = byArray[n2++];
            this.encoding = byArray[n2++];
            this.bits_per_pixel = byArray[n2++];
            this.xmin = (short)(byArray[n2++] & 0xFF | (byArray[n2++] & 0xFF) << 8);
            this.ymin = (short)(byArray[n2++] & 0xFF | (byArray[n2++] & 0xFF) << 8);
            this.xmax = (short)(byArray[n2++] & 0xFF | (byArray[n2++] & 0xFF) << 8);
            this.ymax = (short)(byArray[n2++] & 0xFF | (byArray[n2++] & 0xFF) << 8);
            this.hres = (short)(byArray[n2++] & 0xFF | (byArray[n2++] & 0xFF) << 8);
            this.vres = (short)(byArray[n2++] & 0xFF | (byArray[n2++] & 0xFF) << 8);
            for (n = 0; n < 16; ++n) {
                this.colorPalette[n] = 0xFF000000 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF;
            }
            this.reserved = byArray[n2++];
            this.color_plane = byArray[n2++];
            this.bytes_per_line = (short)(byArray[n2++] & 0xFF | (byArray[n2++] & 0xFF) << 8);
            this.palette_type = (short)(byArray[n2++] & 0xFF | (byArray[n2++] & 0xFF) << 8);
            for (n = 0; n < 58; ++n) {
                this.filler[n] = byArray[n2++];
            }
        }
    }
}

