/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.reader;

import com.icafe4j.image.meta.icc.ICCProfile;
import com.icafe4j.image.png.ChunkType;
import com.icafe4j.image.png.ColorType;
import com.icafe4j.image.png.Filter;
import com.icafe4j.image.png.PNGDescriptor;
import com.icafe4j.image.reader.ImageReader;
import com.icafe4j.image.util.IMGUtils;
import com.icafe4j.io.IOUtils;
import com.icafe4j.util.ArrayUtils;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.InflaterInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PNGReader
extends ImageReader {
    public static final long SIGNATURE = -8552249625308161526L;
    private static final byte NON_INTERLACED = 0;
    private static final byte ADAM7 = 1;
    private static final int[] BLACK_WHITE_PALETTE = new int[]{-16777216, -1};
    private static final int[] FOUR_COLOR_PALETTE = new int[]{-16777216, -12566464, -8355712, -1};
    private static final int[] SIXTEEN_COLOR_PALETTE = new int[]{-16777216, -15658735, -14540254, -13421773, -12303292, -11184811, -10066330, -8947849, -7829368, -6710887, -5592406, -4473925, -3355444, -2236963, -1118482, -1};
    private static final int[] EIGHT_BIT_COLOR_PALETTE = new int[256];
    private static final Logger LOGGER;
    private byte color_format;
    private byte compression;
    private byte filter_method;
    private byte interlace_method;
    private float gamma = 0.45455f;
    private boolean hasGamma;
    private float displayExponent = 2.2f;
    private byte[] alpha;
    private byte[] gammaTable;
    private short[] gammaUShortTable;
    private int block_width;
    private int block_height;
    private int x_start;
    private int y_start;
    private int x_inc;
    private int y_inc;
    private byte renderingIntent = (byte)-1;
    private boolean hasICCP = false;
    private byte[] icc_profile;

    private static void apply_defilter(InputStream inputStream, byte[] byArray, int n, int n2, int n3) throws Exception {
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n5 < n) {
            n4 = inputStream.read();
            IOUtils.readFully(inputStream, byArray, n6, n3);
            switch (n4) {
                case 0: {
                    break;
                }
                case 1: {
                    Filter.defilter_sub(n2, n3, byArray, n6);
                    break;
                }
                case 2: {
                    Filter.defilter_up(n3, byArray, n6);
                    break;
                }
                case 3: {
                    Filter.defilter_average(n2, n3, byArray, n6);
                    break;
                }
                case 4: {
                    Filter.defilter_paeth(n2, n3, byArray, n6);
                    break;
                }
            }
            ++n5;
            n6 += n3;
        }
    }

    private void adjust_grayscale_PLTE(int[] nArray) {
        LOGGER.info("Transparent grayscale image!");
        nArray[this.alpha[1] & 0xFF] = nArray[this.alpha[1] & 0xFF] & 0xFFFFFF;
    }

    private void adjust_PLTE() {
        LOGGER.info("Transparent indexed color image!");
        int n = Math.min(this.alpha.length, this.rgbColorPalette.length);
        for (int i = 0; i < n; ++i) {
            this.rgbColorPalette[i] = (this.alpha[i] & 0xFF) << 24 | this.rgbColorPalette[i] & 0xFFFFFF;
        }
    }

    private boolean calculatePassVariables(int n) {
        switch (n) {
            case 1: {
                this.block_width = this.width / 8 + (this.width % 8 == 0 ? 0 : 1);
                this.block_height = this.height / 8 + (this.height % 8 == 0 ? 0 : 1);
                this.y_start = 0;
                this.x_start = 0;
                this.y_inc = 8;
                this.x_inc = 8;
                break;
            }
            case 2: {
                if (this.width < 5) {
                    return false;
                }
                this.block_width = this.width / 8 + (this.width % 8 < 5 ? 0 : 1);
                this.block_height = this.height / 8 + (this.height % 8 == 0 ? 0 : 1);
                this.x_start = 4;
                this.y_start = 0;
                this.y_inc = 8;
                this.x_inc = 8;
                break;
            }
            case 3: {
                if (this.height < 5) {
                    return false;
                }
                this.block_width = this.width / 4 + (this.width % 4 == 0 ? 0 : 1);
                this.block_height = this.height / 8 + (this.height % 8 < 5 ? 0 : 1);
                this.x_start = 0;
                this.y_start = 4;
                this.x_inc = 4;
                this.y_inc = 8;
                break;
            }
            case 4: {
                if (this.width < 3) {
                    return false;
                }
                this.block_width = this.width / 4 + (this.width % 4 < 3 ? 0 : 1);
                this.block_height = this.height / 4 + (this.height % 4 == 0 ? 0 : 1);
                this.x_start = 2;
                this.y_start = 0;
                this.x_inc = 4;
                this.y_inc = 4;
                break;
            }
            case 5: {
                if (this.height < 3) {
                    return false;
                }
                this.block_width = this.width / 2 + (this.width % 2 == 0 ? 0 : 1);
                this.block_height = this.height / 4 + (this.height % 4 < 3 ? 0 : 1);
                this.x_start = 0;
                this.y_start = 2;
                this.x_inc = 2;
                this.y_inc = 4;
                break;
            }
            case 6: {
                if (this.width < 2) {
                    return false;
                }
                this.block_width = this.width / 2;
                this.block_height = this.height / 2 + (this.height % 2 == 0 ? 0 : 1);
                this.x_start = 1;
                this.y_start = 0;
                this.y_inc = 2;
                this.x_inc = 2;
                break;
            }
            case 7: {
                if (this.height < 2) {
                    return false;
                }
                this.block_width = this.width;
                this.block_height = this.height / 2;
                this.x_start = 0;
                this.y_start = 1;
                this.x_inc = 1;
                this.y_inc = 2;
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private void correctGamma(byte[] byArray, int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            int n4 = 0;
            while (n4 < n) {
                byArray[n3] = this.gammaTable[byArray[n3] & 0xFF];
                ++n4;
                n3 += 2;
            }
        }
    }

    private void correctGamma(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            byte by = this.gammaTable[(nArray[i] & 0xFF0000) >> 16];
            byte by2 = this.gammaTable[(nArray[i] & 0xFF00) >> 8];
            byte by3 = this.gammaTable[nArray[i] & 0xFF];
            nArray[i] = nArray[i] & 0xFF000000 | (by & 0xFF) << 16 | (by2 & 0xFF) << 8 | by3 & 0xFF;
        }
    }

    private void correctGamma(int[] nArray, int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            int n4 = 0;
            while (n4 < n) {
                byte by = this.gammaTable[(nArray[n3] & 0xFF0000) >> 16];
                byte by2 = this.gammaTable[(nArray[n3] & 0xFF00) >> 8];
                byte by3 = this.gammaTable[nArray[n3] & 0xFF];
                nArray[n3] = nArray[n3] & 0xFF000000 | (by & 0xFF) << 16 | (by2 & 0xFF) << 8 | by3 & 0xFF;
                ++n4;
                ++n3;
            }
        }
    }

    private void correctGamma(byte[] byArray, int n, int n2, boolean bl) {
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            int n4 = 0;
            while (n4 < n) {
                byArray[n3] = this.gammaTable[byArray[n3] & 0xFF];
                byArray[n3 + 1] = this.gammaTable[byArray[n3 + 1] & 0xFF];
                byArray[n3 + 2] = this.gammaTable[byArray[n3 + 2] & 0xFF];
                if (bl) {
                    ++n3;
                }
                ++n4;
                n3 += 3;
            }
        }
    }

    private void correctGamma(short[] sArray, int n, int n2, int n3, int n4) {
        int n5 = 0;
        for (int i = 0; i < n2; ++i) {
            int n6 = 0;
            while (n6 < n) {
                int n7 = 0;
                while (n7 < n3) {
                    sArray[n5] = this.gammaUShortTable[sArray[n5] & 0xFFFF];
                    ++n7;
                    ++n5;
                }
                ++n6;
                n5 += n4;
            }
        }
    }

    private void createGammaTable(float f, float f2) {
        int n = 256;
        this.gammaTable = new byte[n];
        double d = 1.0 / ((double)f * (double)f2);
        for (int i = 0; i < n; ++i) {
            this.gammaTable[i] = (byte)(Math.pow((double)i / (double)(n - 1), d) * (double)(n - 1));
        }
    }

    private void createUShortGammaTable(float f, float f2) {
        int n = 65536;
        this.gammaUShortTable = new short[n];
        double d = 1.0 / ((double)f * (double)f2);
        for (int i = 0; i < n; ++i) {
            this.gammaUShortTable[i] = (short)(Math.pow((double)i / (double)(n - 1), d) * (double)(n - 1));
        }
    }

    private byte[] deflateRGBPixels(byte[] byArray, boolean bl) throws Exception {
        int n = 0;
        switch (this.bitsPerPixel) {
            case 8: {
                if (bl) {
                    n = 4;
                    break;
                }
                n = 3;
                break;
            }
            case 16: {
                if (bl) {
                    n = 8;
                    break;
                }
                n = 6;
                break;
            }
            default: {
                LOGGER.error("... " + this.bitsPerPixel + " bit color depth is not valid for RGB image...");
            }
        }
        this.bytesPerScanLine = this.width * n;
        byte[] byArray2 = new byte[this.height * this.bytesPerScanLine];
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new InflaterInputStream(new ByteArrayInputStream(byArray)));
        PNGReader.apply_defilter(bufferedInputStream, byArray2, this.height, n, this.bytesPerScanLine);
        return byArray2;
    }

    private short[] generate16BitGrayscaleInterlacedPixels(byte[] byArray) throws Exception {
        int n = 0;
        int n2 = 0;
        n = 2;
        short s = 0;
        short[] sArray = null;
        if (this.alpha != null) {
            s = (short)(this.alpha[1] & 0xFF | (this.alpha[0] & 0xFF) << 8);
            sArray = new short[this.width * this.height * 2];
        } else {
            sArray = new short[this.width * this.height];
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new InflaterInputStream(new ByteArrayInputStream(byArray)));
        for (int i = 1; i < 8; ++i) {
            int n3;
            int n4;
            int n5;
            if (!this.calculatePassVariables(i)) continue;
            this.bytesPerScanLine = n * this.block_width;
            byte[] byArray2 = new byte[this.block_height * this.bytesPerScanLine];
            PNGReader.apply_defilter(bufferedInputStream, byArray2, this.block_height, n, this.bytesPerScanLine);
            n2 = this.x_start + this.width * this.y_start;
            if (this.alpha != null) {
                n5 = 0;
                n4 = 0;
                for (n3 = 0; n3 < this.block_height; ++n3) {
                    int n6 = 0;
                    while (n6 < this.block_width) {
                        n5 = n2 << 1;
                        sArray[n5] = (short)((byArray2[n4++] & 0xFF) << 8 | byArray2[n4++] & 0xFF);
                        sArray[++n5] = sArray[n5] == s ? 0 : -1;
                        ++n6;
                        n2 += this.x_inc;
                    }
                    n2 = ((n3 + 1) * this.y_inc + this.y_start) * this.width + this.x_start;
                }
                continue;
            }
            n5 = 0;
            for (n3 = 0; n3 < this.block_height; ++n3) {
                n4 = 0;
                while (n4 < this.block_width) {
                    sArray[n2] = (short)((byArray2[n5++] & 0xFF) << 8 | byArray2[n5++] & 0xFF);
                    ++n4;
                    n2 += this.x_inc;
                }
                n2 = ((n3 + 1) * this.y_inc + this.y_start) * this.width + this.x_start;
            }
        }
        bufferedInputStream.close();
        return sArray;
    }

    private short[] generate16BitGrayscalePixels(byte[] byArray) throws Exception {
        int n = 1;
        n = 2;
        this.bytesPerScanLine = n * this.width;
        byte[] byArray2 = new byte[this.height * this.bytesPerScanLine];
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new InflaterInputStream(new ByteArrayInputStream(byArray)));
        PNGReader.apply_defilter(bufferedInputStream, byArray2, this.height, n, this.bytesPerScanLine);
        bufferedInputStream.close();
        if (this.alpha != null) {
            short[] sArray = new short[this.width * this.height * 2];
            short s = (short)(this.alpha[1] & 0xFF | (this.alpha[0] & 0xFF) << 8);
            int n2 = 0;
            int n3 = 0;
            while (n2 < byArray2.length) {
                sArray[n3] = (short)((byArray2[n2++] & 0xFF) << 8 | byArray2[n2++] & 0xFF);
                sArray[++n3] = sArray[n3] == s ? 0 : -1;
                ++n3;
            }
            return sArray;
        }
        return ArrayUtils.toShortArray(byArray2, true);
    }

    private short[] generate16BitRGBInterlacedPixels(byte[] byArray, boolean bl) throws Exception {
        int n = 0;
        int n2 = 0;
        short s = 0;
        short s2 = 0;
        short s3 = 0;
        if (this.alpha != null) {
            s = (short)(this.alpha[1] & 0xFF | (this.alpha[0] & 0xFF) << 8);
            s2 = (short)(this.alpha[3] & 0xFF | (this.alpha[2] & 0xFF) << 8);
            s3 = (short)(this.alpha[5] & 0xFF | (this.alpha[4] & 0xFF) << 8);
        }
        n = bl ? 8 : 6;
        short[] sArray = null;
        sArray = bl || this.alpha != null ? new short[this.width * this.height * 4] : new short[this.width * this.height * 3];
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new InflaterInputStream(new ByteArrayInputStream(byArray)));
        for (int i = 1; i < 8; ++i) {
            int n3;
            int n4;
            int n5;
            int n6;
            if (!this.calculatePassVariables(i)) continue;
            this.bytesPerScanLine = n * this.block_width;
            byte[] byArray2 = new byte[this.block_height * this.bytesPerScanLine];
            PNGReader.apply_defilter(bufferedInputStream, byArray2, this.block_height, n, this.bytesPerScanLine);
            n2 = this.x_start + this.width * this.y_start;
            if (bl) {
                n6 = 0;
                n5 = 0;
                for (n4 = 0; n4 < this.block_height; ++n4) {
                    n3 = 0;
                    while (n3 < this.block_width) {
                        n6 = n2 << 2;
                        sArray[n6++] = (short)((byArray2[n5++] & 0xFF) << 8 | byArray2[n5++] & 0xFF);
                        sArray[n6++] = (short)((byArray2[n5++] & 0xFF) << 8 | byArray2[n5++] & 0xFF);
                        sArray[n6++] = (short)((byArray2[n5++] & 0xFF) << 8 | byArray2[n5++] & 0xFF);
                        sArray[n6++] = (short)((byArray2[n5++] & 0xFF) << 8 | byArray2[n5++] & 0xFF);
                        ++n3;
                        n2 += this.x_inc;
                    }
                    n2 = ((n4 + 1) * this.y_inc + this.y_start) * this.width + this.x_start;
                }
                continue;
            }
            if (this.alpha != null) {
                n6 = 0;
                n5 = 0;
                for (n4 = 0; n4 < this.block_height; ++n4) {
                    n3 = 0;
                    while (n3 < this.block_width) {
                        n6 = n2 << 2;
                        sArray[n6] = (short)((byArray2[n5++] & 0xFF) << 8 | byArray2[n5++] & 0xFF);
                        sArray[n6 + 1] = (short)((byArray2[n5++] & 0xFF) << 8 | byArray2[n5++] & 0xFF);
                        sArray[n6 + 2] = (short)((byArray2[n5++] & 0xFF) << 8 | byArray2[n5++] & 0xFF);
                        sArray[n6 + 3] = sArray[n6] == s && sArray[n6 + 1] == s2 && sArray[n6 + 2] == s3 ? 0 : -1;
                        ++n3;
                        n2 += this.x_inc;
                    }
                    n2 = ((n4 + 1) * this.y_inc + this.y_start) * this.width + this.x_start;
                }
                continue;
            }
            n6 = 0;
            n5 = 0;
            for (n4 = 0; n4 < this.block_height; ++n4) {
                n3 = 0;
                while (n3 < this.block_width) {
                    n6 = n2 * 3;
                    sArray[n6++] = (short)((byArray2[n5++] & 0xFF) << 8 | byArray2[n5++] & 0xFF);
                    sArray[n6++] = (short)((byArray2[n5++] & 0xFF) << 8 | byArray2[n5++] & 0xFF);
                    sArray[n6++] = (short)((byArray2[n5++] & 0xFF) << 8 | byArray2[n5++] & 0xFF);
                    ++n3;
                    n2 += this.x_inc;
                }
                n2 = ((n4 + 1) * this.y_inc + this.y_start) * this.width + this.x_start;
            }
        }
        bufferedInputStream.close();
        return sArray;
    }

    private short[] generate16BitRGBPixels(byte[] byArray, boolean bl) throws Exception {
        int n = 0;
        n = bl ? 8 : 6;
        this.bytesPerScanLine = this.width * n;
        byte[] byArray2 = new byte[this.height * this.bytesPerScanLine];
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new InflaterInputStream(new ByteArrayInputStream(byArray)));
        PNGReader.apply_defilter(bufferedInputStream, byArray2, this.height, n, this.bytesPerScanLine);
        short[] sArray = null;
        if (this.alpha != null) {
            sArray = new short[this.width * this.height * 4];
            short s = (short)(this.alpha[1] & 0xFF | (this.alpha[0] & 0xFF) << 8);
            short s2 = (short)(this.alpha[3] & 0xFF | (this.alpha[2] & 0xFF) << 8);
            short s3 = (short)(this.alpha[5] & 0xFF | (this.alpha[4] & 0xFF) << 8);
            int n2 = 0;
            int n3 = 0;
            while (n2 < byArray2.length) {
                short s4 = (short)((byArray2[n2++] & 0xFF) << 8 | byArray2[n2++] & 0xFF);
                short s5 = (short)((byArray2[n2++] & 0xFF) << 8 | byArray2[n2++] & 0xFF);
                short s6 = (short)((byArray2[n2++] & 0xFF) << 8 | byArray2[n2++] & 0xFF);
                sArray[n3] = s4;
                sArray[n3 + 1] = s5;
                sArray[n3 + 2] = s6;
                sArray[n3 + 3] = sArray[n3] == s && sArray[n3 + 1] == s2 && sArray[n3 + 2] == s3 ? 0 : -1;
                n3 += 4;
            }
        } else {
            sArray = ArrayUtils.toShortArray(byArray2, true);
        }
        return sArray;
    }

    private byte[] generate8BitRGBInterlacedPixels(byte[] byArray, boolean bl) throws Exception {
        int n = 0;
        int n2 = 0;
        byte[] byArray2 = new byte[this.width * this.height * 3];
        n = bl ? 4 : 3;
        if (bl || this.alpha != null) {
            byArray2 = new byte[this.width * this.height * 4];
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new InflaterInputStream(new ByteArrayInputStream(byArray)));
        for (int i = 1; i < 8; ++i) {
            int n3;
            int n4;
            int n5;
            if (!this.calculatePassVariables(i)) continue;
            this.bytesPerScanLine = n * this.block_width;
            byte[] byArray3 = new byte[this.block_height * this.bytesPerScanLine];
            PNGReader.apply_defilter(bufferedInputStream, byArray3, this.block_height, n, this.bytesPerScanLine);
            n2 = this.x_start + this.width * this.y_start;
            if (bl) {
                n5 = 0;
                for (n4 = 0; n4 < this.block_height; ++n4) {
                    n3 = 0;
                    while (n3 < this.block_width) {
                        System.arraycopy(byArray3, n5, byArray2, n2 << 2, 4);
                        ++n3;
                        n2 += this.x_inc;
                        n5 += 4;
                    }
                    n2 = ((n4 + 1) * this.y_inc + this.y_start) * this.width + this.x_start;
                }
                continue;
            }
            if (this.alpha != null) {
                n5 = 0;
                for (n4 = 0; n4 < this.block_height; ++n4) {
                    n3 = 0;
                    while (n3 < this.block_width) {
                        int n6 = n2 << 2;
                        System.arraycopy(byArray3, n5, byArray2, n6, 3);
                        byArray2[n6 + 3] = byArray3[n5] == this.alpha[1] && byArray3[n5 + 1] == this.alpha[3] && byArray3[n5 + 2] == this.alpha[5] ? 0 : -1;
                        ++n3;
                        n2 += this.x_inc;
                        n5 += 3;
                    }
                    n2 = ((n4 + 1) * this.y_inc + this.y_start) * this.width + this.x_start;
                }
                continue;
            }
            n5 = 0;
            for (n4 = 0; n4 < this.block_height; ++n4) {
                n3 = 0;
                while (n3 < this.block_width) {
                    System.arraycopy(byArray3, n5, byArray2, 3 * n2, 3);
                    ++n3;
                    n2 += this.x_inc;
                    n5 += 3;
                }
                n2 = ((n4 + 1) * this.y_inc + this.y_start) * this.width + this.x_start;
            }
        }
        return byArray2;
    }

    private byte[] generate8BitRGBPixels(byte[] byArray, boolean bl) throws Exception {
        byte[] byArray2 = this.deflateRGBPixels(byArray, bl);
        if (this.alpha == null) {
            return byArray2;
        }
        int n = this.width * this.height;
        byte[] byArray3 = new byte[n * this.height * 4];
        int n2 = 0;
        int n3 = 0;
        while (n2 < byArray2.length) {
            byte by = byArray2[n2++];
            byte by2 = byArray2[n2++];
            byte by3 = byArray2[n2++];
            byArray3[n3++] = by;
            byArray3[n3++] = by2;
            byArray3[n3++] = by3;
            if (by == this.alpha[1] && by2 == this.alpha[3] && by3 == this.alpha[5]) {
                byArray3[n3++] = 0;
                continue;
            }
            byArray3[n3++] = -1;
        }
        return byArray3;
    }

    private void generateGrayscaleInterlacedPixels(byte[] byArray, byte[] byArray2, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        int n9 = 0;
        int n10 = n - n3;
        switch (this.bitsPerPixel) {
            case 8: {
                int n11 = 0;
                for (int i = 0; i < n2; ++i) {
                    int n12 = 0;
                    while (n12 < n) {
                        byArray[n4] = byArray2[n11++];
                        ++n12;
                        n4 += n7;
                    }
                    n4 = ((i + 1) * n8 + n6) * this.width + n5;
                }
                break;
            }
            case 4: {
                for (int i = 0; i < n2; ++i) {
                    for (int j = 0; j < n10; j += 2) {
                        byArray[n4] = (byte)(byArray2[n9] >>> 4 & 0xF);
                        byArray[n4 += n7] = (byte)(byArray2[n9++] >>> 0 & 0xF);
                        n4 += n7;
                    }
                    if (n3 != 0) {
                        byArray[n4] = (byte)(byArray2[n9++] >>> 4 & 0xF);
                        n4 += n7;
                    }
                    n4 = ((i + 1) * n8 + n6) * this.width + n5;
                }
                break;
            }
            case 2: {
                for (int i = 0; i < n2; ++i) {
                    int n13;
                    int n14 = 0;
                    while (n14 < n10) {
                        for (n13 = 6; n13 >= 0; n13 -= 2) {
                            byArray[n4] = (byte)(byArray2[n9] >>> n13 & 3);
                            n4 += n7;
                        }
                        n14 += 4;
                        ++n9;
                    }
                    if (n3 != 0) {
                        n14 = 0;
                        n13 = 6;
                        while (n14 < n3) {
                            byArray[n4] = (byte)(byArray2[n9] >>> n13 & 3);
                            n4 += n7;
                            ++n14;
                            n13 -= 2;
                        }
                        ++n9;
                    }
                    n4 = ((i + 1) * n8 + n6) * this.width + n5;
                }
                break;
            }
            case 1: {
                for (int i = 0; i < n2; ++i) {
                    int n15 = 0;
                    while (n15 < n10) {
                        for (int j = 7; j >= 0; --j) {
                            byArray[n4] = (byte)(byArray2[n9] >>> j & 1);
                            n4 += n7;
                        }
                        n15 += 8;
                        ++n9;
                    }
                    if (n3 != 0) {
                        for (n15 = 7; n15 >= 8 - n3; --n15) {
                            byArray[n4] = (byte)(byArray2[n9] >>> n15 & 1);
                            n4 += n7;
                        }
                        ++n9;
                    }
                    n4 = ((i + 1) * n8 + n6) * this.width + n5;
                }
                break;
            }
        }
    }

    private void generateIndexedInterlacedPixels(byte[] byArray, byte[] byArray2, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        int n9 = 0;
        int n10 = n - n3;
        switch (this.bitsPerPixel) {
            case 8: {
                int n11 = 0;
                for (int i = 0; i < n2; ++i) {
                    int n12 = 0;
                    while (n12 < n) {
                        byArray[n4] = byArray2[n11];
                        ++n12;
                        ++n11;
                        n4 += n7;
                    }
                    n4 = ((i + 1) * n8 + n6) * this.width + n5;
                }
                break;
            }
            case 4: {
                for (int i = 0; i < n2; ++i) {
                    for (int j = 0; j < n10; j += 2) {
                        byArray[n4] = (byte)(byArray2[n9] >>> 4);
                        byArray[n4 += n7] = byArray2[n9++];
                        n4 += n7;
                    }
                    if (n3 != 0) {
                        byArray[n4] = (byte)(byArray2[n9++] >>> 4);
                        n4 += n7;
                    }
                    n4 = ((i + 1) * n8 + n6) * this.width + n5;
                }
                break;
            }
            case 2: {
                for (int i = 0; i < n2; ++i) {
                    int n13;
                    int n14 = 0;
                    while (n14 < n10) {
                        for (n13 = 6; n13 >= 0; n13 -= 2) {
                            byArray[n4] = (byte)(byArray2[n9] >>> n13 & 3);
                            n4 += n7;
                        }
                        n14 += 4;
                        ++n9;
                    }
                    if (n3 != 0) {
                        n14 = 0;
                        n13 = 6;
                        while (n14 < n3) {
                            byArray[n4] = (byte)(byArray2[n9] >>> n13 & 3);
                            n4 += n7;
                            ++n14;
                            n13 -= 2;
                        }
                        ++n9;
                    }
                    n4 = ((i + 1) * n8 + n6) * this.width + n5;
                }
                break;
            }
            case 1: {
                for (int i = 0; i < n2; ++i) {
                    int n15 = 0;
                    while (n15 < n10) {
                        for (int j = 7; j >= 0; --j) {
                            byArray[n4] = (byte)(byArray2[n9] >>> j & 1);
                            n4 += n7;
                        }
                        n15 += 8;
                        ++n9;
                    }
                    if (n3 != 0) {
                        for (n15 = 7; n15 >= 8 - n3; --n15) {
                            byArray[n4] = (byte)(byArray2[n9] >>> n15 & 1);
                            n4 += n7;
                        }
                        ++n9;
                    }
                    n4 = ((i + 1) * n8 + n6) * this.width + n5;
                }
                break;
            }
        }
    }

    private int getBytesPerScanLine(int n) {
        int n2 = 0;
        switch (this.bitsPerPixel) {
            case 8: {
                this.bytesPerScanLine = n;
                break;
            }
            case 4: {
                n2 = n % 2;
                this.bytesPerScanLine = n >>> 1;
                break;
            }
            case 2: {
                n2 = n % 4;
                this.bytesPerScanLine = n >>> 2;
                break;
            }
            case 1: {
                n2 = n % 8;
                this.bytesPerScanLine = n >>> 3;
                break;
            }
            default: {
                LOGGER.error("... " + this.bitsPerPixel + " bit color depth is not valid for PNG image...");
            }
        }
        if (n2 != 0) {
            ++this.bytesPerScanLine;
        }
        return this.bytesPerScanLine;
    }

    public byte[] getICCProfile() {
        return this.icc_profile;
    }

    private int getPadding(int n) {
        int n2 = 0;
        switch (this.bitsPerPixel) {
            case 8: {
                break;
            }
            case 4: {
                n2 = n % 2;
                break;
            }
            case 2: {
                n2 = n % 4;
                break;
            }
            case 1: {
                n2 = n % 8;
            }
        }
        return n2;
    }

    public boolean hasICCProfile() {
        return this.hasICCP;
    }

    private byte[] process_grayscaleAlphaImage(byte[] byArray) throws Exception {
        int n = 0;
        switch (this.bitsPerPixel) {
            case 8: {
                n = 2;
                break;
            }
            case 16: {
                n = 4;
                break;
            }
            default: {
                LOGGER.error("... " + this.bitsPerPixel + " bit color depth is invalid for full alpha grayscale image...");
            }
        }
        this.bytesPerScanLine = this.width * n;
        byte[] byArray2 = new byte[this.height * this.bytesPerScanLine];
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new InflaterInputStream(new ByteArrayInputStream(byArray)));
        PNGReader.apply_defilter(bufferedInputStream, byArray2, this.height, n, this.bytesPerScanLine);
        return byArray2;
    }

    private byte[] process_grayscaleAlphaInterlacedImage(byte[] byArray) throws Exception {
        int n = 0;
        int n2 = 0;
        switch (this.bitsPerPixel) {
            case 8: {
                n = 2;
                break;
            }
            case 16: {
                n = 4;
                break;
            }
            default: {
                LOGGER.error("... " + this.bitsPerPixel + " bit color depth is not valid for grayscale full alpha image...");
            }
        }
        byte[] byArray2 = new byte[this.width * this.height * n];
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new InflaterInputStream(new ByteArrayInputStream(byArray)));
        for (int i = 1; i < 8; ++i) {
            int n3;
            int n4;
            int n5;
            int n6;
            if (!this.calculatePassVariables(i)) continue;
            this.bytesPerScanLine = n * this.block_width;
            byte[] byArray3 = new byte[this.block_height * this.bytesPerScanLine];
            PNGReader.apply_defilter(bufferedInputStream, byArray3, this.block_height, n, this.bytesPerScanLine);
            n2 = this.x_start + this.width * this.y_start;
            if (this.bitsPerPixel == 8) {
                n6 = 0;
                for (n5 = 0; n5 < this.block_height; ++n5) {
                    n4 = 0;
                    n3 = 0;
                    while (n4 < this.block_width) {
                        n3 = n2 << 1;
                        byArray2[n3++] = byArray3[n6++];
                        byArray2[n3++] = byArray3[n6++];
                        ++n4;
                        n2 += this.x_inc;
                    }
                    n2 = ((n5 + 1) * this.y_inc + this.y_start) * this.width + this.x_start;
                }
                continue;
            }
            if (this.bitsPerPixel != 16) continue;
            n6 = 0;
            n4 = 0;
            for (n5 = 0; n5 < this.block_height; ++n5) {
                n3 = 0;
                while (n3 < this.block_width) {
                    n6 = n2 << 2;
                    byArray2[n6++] = byArray3[n4++];
                    byArray2[n6++] = byArray3[n4++];
                    byArray2[n6++] = byArray3[n4++];
                    byArray2[n6++] = byArray3[n4++];
                    ++n3;
                    n2 += this.x_inc;
                }
                n2 = ((n5 + 1) * this.y_inc + this.y_start) * this.width + this.x_start;
            }
        }
        return byArray2;
    }

    private byte[] process_grayscaleImage(byte[] byArray) throws Exception {
        int n = 1;
        int n2 = 0;
        switch (this.bitsPerPixel) {
            case 8: {
                this.rgbColorPalette = EIGHT_BIT_COLOR_PALETTE;
                this.bytesPerScanLine = this.width;
                break;
            }
            case 4: {
                n2 = this.width % 2;
                this.rgbColorPalette = SIXTEEN_COLOR_PALETTE;
                this.bytesPerScanLine = (this.width >>> 1) + (n2 == 0 ? 0 : 1);
                break;
            }
            case 2: {
                n2 = this.width % 4;
                this.rgbColorPalette = FOUR_COLOR_PALETTE;
                this.bytesPerScanLine = (this.width >>> 2) + (n2 == 0 ? 0 : 1);
                break;
            }
            case 1: {
                n2 = this.width % 8;
                this.rgbColorPalette = BLACK_WHITE_PALETTE;
                this.bytesPerScanLine = (this.width >>> 3) + (n2 == 0 ? 0 : 1);
                break;
            }
            default: {
                LOGGER.error("... " + this.bitsPerPixel + " bit color depth is not valid for grayscale image...");
            }
        }
        byte[] byArray2 = new byte[this.height * this.bytesPerScanLine];
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new InflaterInputStream(new ByteArrayInputStream(byArray)));
        PNGReader.apply_defilter(bufferedInputStream, byArray2, this.height, n, this.bytesPerScanLine);
        bufferedInputStream.close();
        return byArray2;
    }

    private byte[] process_grayscaleInterlacedImage(byte[] byArray) throws Exception {
        int n = 0;
        int n2 = 0;
        switch (this.bitsPerPixel) {
            case 8: {
                n = 1;
                this.rgbColorPalette = EIGHT_BIT_COLOR_PALETTE;
                break;
            }
            case 1: {
                n = 1;
                this.rgbColorPalette = BLACK_WHITE_PALETTE;
                break;
            }
            case 2: {
                n = 1;
                this.rgbColorPalette = FOUR_COLOR_PALETTE;
                break;
            }
            case 4: {
                n = 1;
                this.rgbColorPalette = SIXTEEN_COLOR_PALETTE;
                break;
            }
            default: {
                LOGGER.error("... " + this.bitsPerPixel + " bit color depth is not valid for grayscale image...");
            }
        }
        byte[] byArray2 = new byte[this.width * this.height * n];
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new InflaterInputStream(new ByteArrayInputStream(byArray)));
        for (int i = 1; i < 8; ++i) {
            if (!this.calculatePassVariables(i)) continue;
            this.bytesPerScanLine = this.getBytesPerScanLine(this.block_width);
            n2 = this.getPadding(this.block_width);
            byte[] byArray3 = new byte[this.block_height * this.bytesPerScanLine];
            PNGReader.apply_defilter(bufferedInputStream, byArray3, this.block_height, n, this.bytesPerScanLine);
            this.generateGrayscaleInterlacedPixels(byArray2, byArray3, this.block_width, this.block_height, n2, this.x_start + this.width * this.y_start, this.x_start, this.y_start, this.x_inc, this.y_inc);
        }
        bufferedInputStream.close();
        return ArrayUtils.packByteArray(byArray2, this.width, 0, this.bitsPerPixel, byArray2.length);
    }

    private BufferedImage process_IDAT(byte[] byArray) throws Exception {
        byte[] byArray2 = null;
        short[] sArray = null;
        WritableRaster writableRaster = null;
        DataBuffer dataBuffer = null;
        ColorModel colorModel = null;
        ColorSpace colorSpace = ColorSpace.getInstance(1000);
        if (this.hasICCP) {
            colorSpace = new ICC_ColorSpace(ICC_Profile.getInstance(this.icc_profile));
        }
        switch (ColorType.fromInt(this.color_format)) {
            case GRAY_SCALE: {
                if (this.bitsPerPixel == 16) {
                    if (this.interlace_method == 0) {
                        sArray = this.generate16BitGrayscalePixels(byArray);
                    } else if (this.interlace_method == 1) {
                        sArray = this.generate16BitGrayscaleInterlacedPixels(byArray);
                    }
                    if (this.hasGamma && this.renderingIntent == -1 && !this.hasICCP) {
                        if (this.alpha != null) {
                            this.correctGamma(sArray, this.width, this.height, 1, 1);
                        } else {
                            this.correctGamma(sArray, this.width, this.height, 1, 0);
                        }
                    }
                    if (this.alpha != null) {
                        dataBuffer = new DataBufferUShort(sArray, sArray.length);
                        int[] nArray = new int[]{0, 1};
                        writableRaster = Raster.createInterleavedRaster(dataBuffer, this.width, this.height, this.width * 2, 2, nArray, null);
                        colorModel = new ComponentColorModel(ColorSpace.getInstance(1003), true, false, 3, 1);
                    } else {
                        dataBuffer = new DataBufferUShort(sArray, sArray.length);
                        int[] nArray = new int[]{0};
                        writableRaster = Raster.createInterleavedRaster(dataBuffer, this.width, this.height, this.width, 1, nArray, null);
                        colorModel = new ComponentColorModel(ColorSpace.getInstance(1003), false, false, 1, 1);
                    }
                } else {
                    if (this.interlace_method == 0) {
                        byArray2 = this.process_grayscaleImage(byArray);
                    } else if (this.interlace_method == 1) {
                        byArray2 = this.process_grayscaleInterlacedImage(byArray);
                    }
                    dataBuffer = new DataBufferByte(byArray2, byArray2.length);
                    if (this.bitsPerPixel == 8) {
                        int[] nArray = new int[]{0};
                        writableRaster = Raster.createInterleavedRaster(dataBuffer, this.width, this.height, this.width, 1, nArray, null);
                    } else {
                        writableRaster = Raster.createPackedRaster(dataBuffer, this.width, this.height, this.bitsPerPixel, null);
                    }
                    if (this.hasGamma && this.renderingIntent == -1 && !this.hasICCP) {
                        this.correctGamma(this.rgbColorPalette);
                    }
                    colorModel = new IndexColorModel(this.bitsPerPixel, this.rgbColorPalette.length, this.rgbColorPalette, 0, true, -1, 0);
                }
                return new BufferedImage(colorModel, writableRaster, false, null);
            }
            case GRAY_SCALE_WITH_ALPHA: {
                if (this.interlace_method == 0) {
                    byArray2 = this.process_grayscaleAlphaImage(byArray);
                } else if (this.interlace_method == 1) {
                    byArray2 = this.process_grayscaleAlphaInterlacedImage(byArray);
                }
                if (this.bitsPerPixel == 16) {
                    sArray = ArrayUtils.toShortArray(byArray2, true);
                    if (this.hasGamma && this.renderingIntent == -1 && !this.hasICCP) {
                        this.correctGamma(sArray, this.width, this.height, 1, 1);
                    }
                    dataBuffer = new DataBufferUShort(sArray, sArray.length);
                    int[] nArray = new int[]{0, 1};
                    writableRaster = Raster.createInterleavedRaster(dataBuffer, this.width, this.height, this.width * 2, 2, nArray, null);
                    colorModel = new ComponentColorModel(ColorSpace.getInstance(1003), true, false, 3, 1);
                } else {
                    if (this.hasGamma && this.renderingIntent == -1 && !this.hasICCP) {
                        this.correctGamma(byArray2, this.width, this.height);
                    }
                    dataBuffer = new DataBufferByte(byArray2, byArray2.length);
                    int[] nArray = new int[]{0, 0, 0, 1};
                    writableRaster = Raster.createInterleavedRaster(dataBuffer, this.width, this.height, this.bytesPerScanLine, 2, nArray, null);
                    colorModel = new ComponentColorModel(ColorSpace.getInstance(1000), true, false, 3, 0);
                }
                return new BufferedImage(colorModel, writableRaster, false, null);
            }
            case TRUE_COLOR: {
                if (this.bitsPerPixel == 16) {
                    sArray = this.interlace_method == 0 ? this.generate16BitRGBPixels(byArray, false) : this.generate16BitRGBInterlacedPixels(byArray, false);
                    if (this.hasGamma && this.renderingIntent == -1 && !this.hasICCP) {
                        if (this.alpha != null) {
                            this.correctGamma(sArray, this.width, this.height, 3, 1);
                        } else {
                            this.correctGamma(sArray, this.width, this.height, 3, 0);
                        }
                    }
                    int[] nArray = new int[]{0, 1, 2};
                    int n = 3;
                    boolean bl = false;
                    int n2 = 1;
                    int[] nArray2 = new int[]{16, 16, 16};
                    if (this.alpha != null) {
                        nArray = new int[]{0, 1, 2, 3};
                        n = 4;
                        bl = true;
                        n2 = 3;
                        nArray2 = new int[]{16, 16, 16, 16};
                    }
                    dataBuffer = new DataBufferUShort(sArray, sArray.length);
                    writableRaster = Raster.createInterleavedRaster(dataBuffer, this.width, this.height, this.width * n, n, nArray, null);
                    colorModel = new ComponentColorModel(colorSpace, nArray2, bl, false, n2, 1);
                    if (this.hasICCP) {
                        writableRaster = IMGUtils.iccp2rgbRaster(writableRaster, colorModel);
                        colorModel = new ComponentColorModel(ColorSpace.getInstance(1000), nArray2, bl, false, n2, 1);
                    }
                } else {
                    if (this.interlace_method == 0) {
                        byArray2 = this.generate8BitRGBPixels(byArray, false);
                    } else if (this.interlace_method == 1) {
                        byArray2 = this.generate8BitRGBInterlacedPixels(byArray, false);
                    }
                    if (this.hasGamma && this.renderingIntent == -1 && !this.hasICCP) {
                        this.correctGamma(byArray2, this.width, this.height, this.alpha != null);
                    }
                    int[] nArray = new int[]{0, 1, 2};
                    int n = 3;
                    boolean bl = false;
                    int n3 = 1;
                    int[] nArray3 = new int[]{8, 8, 8};
                    dataBuffer = new DataBufferByte(byArray2, byArray2.length);
                    if (this.alpha != null) {
                        nArray = new int[]{0, 1, 2, 3};
                        n = 4;
                        bl = true;
                        n3 = 3;
                        nArray3 = new int[]{8, 8, 8, 8};
                    }
                    writableRaster = Raster.createInterleavedRaster(dataBuffer, this.width, this.height, this.width * n, n, nArray, null);
                    colorModel = new ComponentColorModel(colorSpace, nArray3, bl, false, n3, 0);
                    if (this.hasICCP) {
                        writableRaster = IMGUtils.iccp2rgbRaster(writableRaster, colorModel);
                        colorModel = new ComponentColorModel(ColorSpace.getInstance(1000), nArray3, bl, false, n3, 0);
                    }
                }
                return new BufferedImage(colorModel, writableRaster, false, null);
            }
            case TRUE_COLOR_WITH_ALPHA: {
                if (this.bitsPerPixel == 16) {
                    sArray = this.interlace_method == 0 ? this.generate16BitRGBPixels(byArray, true) : this.generate16BitRGBInterlacedPixels(byArray, true);
                    if (this.hasGamma && this.renderingIntent == -1 && !this.hasICCP) {
                        this.correctGamma(sArray, this.width, this.height, 3, 1);
                    }
                    dataBuffer = new DataBufferUShort(sArray, sArray.length);
                    int[] nArray = new int[]{0, 1, 2, 3};
                    int n = 4;
                    int n4 = 3;
                    int[] nArray4 = new int[]{16, 16, 16, 16};
                    writableRaster = Raster.createInterleavedRaster(dataBuffer, this.width, this.height, this.width * n, n, nArray, null);
                    colorModel = new ComponentColorModel(colorSpace, nArray4, true, false, n4, 1);
                    if (this.hasICCP) {
                        writableRaster = IMGUtils.iccp2rgbRaster(writableRaster, colorModel);
                        colorModel = new ComponentColorModel(ColorSpace.getInstance(1000), nArray4, true, false, n4, 1);
                    }
                } else {
                    if (this.interlace_method == 0) {
                        byArray2 = this.generate8BitRGBPixels(byArray, true);
                    } else if (this.interlace_method == 1) {
                        byArray2 = this.generate8BitRGBInterlacedPixels(byArray, true);
                    }
                    if (this.hasGamma && this.renderingIntent == -1 && !this.hasICCP) {
                        this.correctGamma(byArray2, this.width, this.height, true);
                    }
                    int[] nArray = new int[]{0, 1, 2, 3};
                    int n = 4;
                    boolean bl = true;
                    int n5 = 3;
                    int[] nArray5 = new int[]{8, 8, 8, 8};
                    dataBuffer = new DataBufferByte(byArray2, byArray2.length);
                    writableRaster = Raster.createInterleavedRaster(dataBuffer, this.width, this.height, this.width * n, n, nArray, null);
                    colorModel = new ComponentColorModel(colorSpace, nArray5, bl, false, n5, 0);
                    if (this.hasICCP) {
                        writableRaster = IMGUtils.iccp2rgbRaster(writableRaster, colorModel);
                        colorModel = new ComponentColorModel(ColorSpace.getInstance(1000), nArray5, bl, false, n5, 0);
                    }
                }
                return new BufferedImage(colorModel, writableRaster, false, null);
            }
            case INDEX_COLOR: {
                byArray2 = null;
                if (this.interlace_method == 0) {
                    byArray2 = this.process_IndexedImage(byArray);
                } else if (this.interlace_method == 1) {
                    byArray2 = this.process_IndexedInterlacedImage(byArray);
                }
                dataBuffer = new DataBufferByte(byArray2, byArray2.length);
                if (this.bitsPerPixel != 8) {
                    writableRaster = Raster.createPackedRaster(dataBuffer, this.width, this.height, this.bitsPerPixel, null);
                } else {
                    int[] nArray = new int[]{0};
                    writableRaster = Raster.createInterleavedRaster(dataBuffer, this.width, this.height, this.width, 1, nArray, null);
                }
                if (this.hasGamma && this.renderingIntent == -1 && !this.hasICCP) {
                    this.correctGamma(this.rgbColorPalette);
                }
                colorModel = new IndexColorModel(this.bitsPerPixel, this.rgbColorPalette.length, this.rgbColorPalette, 0, true, -1, 0);
                return new BufferedImage(colorModel, writableRaster, false, null);
            }
        }
        LOGGER.error("..Invalid color type...");
        return null;
    }

    private byte[] process_IndexedImage(byte[] byArray) throws Exception {
        this.bytesPerScanLine = this.getBytesPerScanLine(this.width);
        byte[] byArray2 = new byte[this.height * this.bytesPerScanLine];
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new InflaterInputStream(new ByteArrayInputStream(byArray)));
        PNGReader.apply_defilter(bufferedInputStream, byArray2, this.height, 1, this.bytesPerScanLine);
        return byArray2;
    }

    private byte[] process_IndexedInterlacedImage(byte[] byArray) throws Exception {
        int n = 0;
        byte[] byArray2 = new byte[this.width * this.height];
        switch (this.bitsPerPixel) {
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                break;
            }
            default: {
                LOGGER.error("... " + this.bitsPerPixel + " bit color depth is not valid for indexed image...");
            }
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new InflaterInputStream(new ByteArrayInputStream(byArray)));
        for (int i = 1; i < 8; ++i) {
            if (!this.calculatePassVariables(i)) continue;
            this.bytesPerScanLine = this.getBytesPerScanLine(this.block_width);
            n = this.getPadding(this.block_width);
            byte[] byArray3 = new byte[this.block_height * this.bytesPerScanLine];
            PNGReader.apply_defilter(bufferedInputStream, byArray3, this.block_height, 1, this.bytesPerScanLine);
            this.generateIndexedInterlacedPixels(byArray2, byArray3, this.block_width, this.block_height, n, this.x_start + this.width * this.y_start, this.x_start, this.y_start, this.x_inc, this.y_inc);
        }
        bufferedInputStream.close();
        return ArrayUtils.packByteArray(byArray2, this.width, 0, this.bitsPerPixel, byArray2.length);
    }

    @Override
    public BufferedImage read(InputStream inputStream) throws Exception {
        int n = 0;
        int n2 = 0;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(65536);
        long l = IOUtils.readLongMM(inputStream);
        if (l != -8552249625308161526L) {
            LOGGER.error("--- NOT A PNG IMAGE ---");
            return null;
        }
        if (!this.read_IHDR(inputStream)) {
            throw new IOException("NOT A VALID PNG IMAGE");
        }
        LOGGER.info("--- PNG IMAGE INFO ---");
        LOGGER.info("image width: {}", (Object)this.width);
        LOGGER.info("image height: {}", (Object)this.height);
        LOGGER.info("image bit depth: {}", (Object)this.bitsPerPixel);
        LOGGER.info("Image color type: {}", (Object)ColorType.fromInt(this.color_format));
        LOGGER.info("image compression: {} - {}", (Object)this.compression, (Object)PNGDescriptor.getCompressionTypeDescrition(this.compression));
        LOGGER.info("image filter method: {} - {}", (Object)this.filter_method, (Object)PNGDescriptor.getFilterTypeDescription(this.filter_method));
        LOGGER.info("image interlace method: {} - {}", (Object)this.interlace_method, (Object)PNGDescriptor.getInterlaceTypeDescription(this.interlace_method));
        LOGGER.info("--- END PNG IMAGE INFO ---");
        block8: while (true) {
            n = IOUtils.readIntMM(inputStream);
            n2 = IOUtils.readIntMM(inputStream);
            if (n2 == ChunkType.IEND.getValue()) break;
            ChunkType chunkType = ChunkType.fromInt(n2);
            switch (chunkType) {
                case IDAT: {
                    this.read_IDAT(inputStream, n, byteArrayOutputStream);
                    continue block8;
                }
                case TRNS: {
                    this.alpha = new byte[n];
                    inputStream.read(this.alpha, 0, n);
                    IOUtils.readUnsignedIntMM(inputStream);
                    if (this.color_format == 3) {
                        this.adjust_PLTE();
                        continue block8;
                    }
                    if (this.color_format == 0) {
                        if (this.bitsPerPixel == 1) {
                            this.adjust_grayscale_PLTE(BLACK_WHITE_PALETTE);
                            continue block8;
                        }
                        if (this.bitsPerPixel == 2) {
                            this.adjust_grayscale_PLTE(FOUR_COLOR_PALETTE);
                            continue block8;
                        }
                        if (this.bitsPerPixel == 4) {
                            this.adjust_grayscale_PLTE(SIXTEEN_COLOR_PALETTE);
                            continue block8;
                        }
                        if (this.bitsPerPixel != 8) continue block8;
                        this.adjust_grayscale_PLTE(EIGHT_BIT_COLOR_PALETTE);
                        continue block8;
                    }
                    if (this.color_format != 2) continue block8;
                    LOGGER.info("full color transparent image!");
                    continue block8;
                }
                case GAMA: {
                    this.read_GAMMA(inputStream, n);
                    continue block8;
                }
                case SRGB: {
                    this.read_SRGB(inputStream, n);
                    continue block8;
                }
                case PLTE: {
                    this.rgbColorPalette = new int[n / 3];
                    this.read_PLTE(inputStream, n);
                    continue block8;
                }
                case ICCP: {
                    this.hasICCP = true;
                    this.icc_profile = this.readICCProfile(inputStream, n);
                    IOUtils.readUnsignedIntMM(inputStream);
                    continue block8;
                }
            }
            IOUtils.skipFully(inputStream, n);
            IOUtils.readUnsignedIntMM(inputStream);
        }
        inputStream.close();
        return this.process_IDAT(byteArrayOutputStream.toByteArray());
    }

    private void read_GAMMA(InputStream inputStream, int n) throws Exception {
        if (n != 4) {
            LOGGER.error("Invalid Gamma data length: {}", (Object)n);
            return;
        }
        this.hasGamma = true;
        this.gamma = (float)IOUtils.readUnsignedIntMM(inputStream) / 100000.0f;
        if (this.bitsPerPixel == 16) {
            this.createUShortGammaTable(this.gamma, this.displayExponent);
        } else {
            this.createGammaTable(this.gamma, this.displayExponent);
        }
        IOUtils.readUnsignedIntMM(inputStream);
    }

    private void read_IDAT(InputStream inputStream, int n, ByteArrayOutputStream byteArrayOutputStream) throws Exception {
        byte[] byArray = new byte[n];
        IOUtils.readFully(inputStream, byArray, 0, n);
        byteArrayOutputStream.write(byArray, 0, n);
        IOUtils.readUnsignedIntMM(inputStream);
    }

    private boolean read_IHDR(InputStream inputStream) throws Exception {
        if (IOUtils.readIntMM(inputStream) != 13 || IOUtils.readIntMM(inputStream) != ChunkType.IHDR.getValue()) {
            return false;
        }
        byte[] byArray = new byte[13];
        IOUtils.readFully(inputStream, byArray, 0, 13);
        this.width = IOUtils.readIntMM(byArray, 0);
        this.height = IOUtils.readIntMM(byArray, 4);
        this.bitsPerPixel = byArray[8];
        this.color_format = byArray[9];
        this.compression = byArray[10];
        this.filter_method = byArray[11];
        this.interlace_method = byArray[12];
        IOUtils.readUnsignedIntMM(inputStream);
        return true;
    }

    private void read_PLTE(InputStream inputStream, int n) throws Exception {
        int n2 = 0;
        byte[] byArray = new byte[n];
        int n3 = n / 3;
        IOUtils.readFully(inputStream, byArray, 0, n);
        for (int i = 0; i < n3; ++i) {
            this.rgbColorPalette[i] = 0xFF000000 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF;
        }
        IOUtils.readUnsignedIntMM(inputStream);
    }

    private void read_SRGB(InputStream inputStream, int n) throws Exception {
        if (n != 1) {
            LOGGER.error("Invalid SRGB data length:{}", (Object)n);
            return;
        }
        this.renderingIntent = (byte)IOUtils.read(inputStream);
        IOUtils.readUnsignedIntMM(inputStream);
    }

    private byte[] readICCProfile(InputStream inputStream, int n) throws Exception {
        byte[] byArray = new byte[n];
        IOUtils.readFully(inputStream, byArray);
        int n2 = 0;
        while (byArray[n2] != 0) {
            ++n2;
        }
        String string = new String(byArray, 0, n2, "UTF-8");
        InflaterInputStream inflaterInputStream = new InflaterInputStream(new ByteArrayInputStream(byArray, n2 + 2, n - n2 - 2));
        LOGGER.info("ICCProfile name: {}", (Object)string);
        byte[] byArray2 = IOUtils.readFully((InputStream)inflaterInputStream, 4096);
        ICCProfile.showProfile(byArray2);
        return byArray2;
    }

    static {
        for (int i = 0; i < 256; ++i) {
            PNGReader.EIGHT_BIT_COLOR_PALETTE[i] = 0xFF000000 | i << 16 | i << 8 | i & 0xFF;
        }
        LOGGER = LoggerFactory.getLogger(PNGReader.class);
    }
}

