/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.reader;

import com.icafe4j.image.reader.ImageReader;
import com.icafe4j.io.IOUtils;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TGAReader
extends ImageReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(TGAReader.class);
    public static final int SCAN_MODE_BOTTOM_LEFT = 0;
    public static final int SCAN_MODE_BOTTOM_RIGHT = 1;
    public static final int SCAN_MODE_TOP_LEFT = 2;
    public static final int SCAN_MODE_TOP_RIGHT = 3;
    private TgaHeader tgaHeader;
    private int scanMode = 0;
    private int l = 0;
    private int m = 0;
    private int n = 0;
    private int o = 0;
    private int[] pix;

    @Override
    public BufferedImage read(InputStream inputStream) throws Exception {
        this.tgaHeader = new TgaHeader();
        this.tgaHeader.readHeader(inputStream);
        this.bitsPerPixel = this.tgaHeader.bits_per_pixel;
        this.width = this.tgaHeader.width;
        this.height = this.tgaHeader.height;
        this.pix = new int[this.width * this.height];
        if (this.tgaHeader.colourmap_type != 0 && this.tgaHeader.colourmap_type != 1) {
            LOGGER.error("Can only handle colour map types of 0 and 1");
            return null;
        }
        this.scanMode = (this.tgaHeader.image_descriptor & 0x30) >> 4;
        switch (this.scanMode) {
            case 0: {
                this.l = this.height - 1;
                this.m = -1;
                this.n = 0;
                this.o = 1;
                break;
            }
            case 1: {
                this.l = this.height - 1;
                this.m = -1;
                this.n = this.width - 1;
                this.o = -1;
                break;
            }
            case 2: {
                this.l = 0;
                this.m = 1;
                this.n = 0;
                this.o = 1;
                break;
            }
            case 3: {
                this.l = 0;
                this.m = 1;
                this.n = this.width - 1;
                this.o = -1;
                break;
            }
        }
        LOGGER.info("Image x_origin: {}", (Object)this.tgaHeader.x_origin);
        LOGGER.info("Image y_origin: {}", (Object)this.tgaHeader.y_origin);
        switch (this.tgaHeader.image_type) {
            case 0: {
                LOGGER.info("There are no data in the image file");
                System.exit(1);
            }
            case 1: {
                this.readCMPTga(inputStream);
                break;
            }
            case 2: {
                this.readTrueColorTga(inputStream);
                break;
            }
            case 3: {
                this.read_BW_Tga(inputStream);
                break;
            }
            case 9: {
                this.read_RLE_CMP_Tga(inputStream);
                break;
            }
            case 10: {
                this.read_RLE_TrueColor_Tga(inputStream);
                break;
            }
            case 11: {
                this.read_RLE_BW_Tga(inputStream);
                break;
            }
            case 32: 
            case 33: {
                LOGGER.error("Not implemented for compressed color mapped images");
                return null;
            }
            default: {
                LOGGER.error("I can't find a type matches this");
                return null;
            }
        }
        DataBufferInt dataBufferInt = new DataBufferInt(this.pix, this.pix.length);
        WritableRaster writableRaster = Raster.createPackedRaster(dataBufferInt, this.width, this.height, this.width, new int[]{0xFF0000, 65280, 255, -16777216}, null);
        DirectColorModel directColorModel = new DirectColorModel(32, 0xFF0000, 65280, 255, -16777216);
        return new BufferedImage(directColorModel, writableRaster, false, null);
    }

    private void read_BW_Tga(InputStream inputStream) throws Exception {
        this.bitsPerPixel = 1;
        LOGGER.info("Uncompressed Black and White Tga image!");
        int n = 0;
        IOUtils.skipFully(inputStream, this.tgaHeader.id_length);
        IOUtils.skipFully(inputStream, this.tgaHeader.colourmap_type * this.tgaHeader.colourmap_length);
        byte[] byArray = new byte[this.width * this.height];
        IOUtils.readFully(inputStream, byArray, 0, this.width * this.height);
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                this.pix[this.width * (this.l + this.m * i) + this.n + this.o * j] = 0xFF000000 | byArray[n] & 0xFF | (byArray[n] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16;
            }
        }
        inputStream.close();
    }

    private void read_RLE_BW_Tga(InputStream inputStream) throws Exception {
        this.bitsPerPixel = 1;
        LOGGER.info("Black and White Tga RLE image!");
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        IOUtils.skipFully(inputStream, this.tgaHeader.id_length);
        IOUtils.skipFully(inputStream, this.tgaHeader.colourmap_type * this.tgaHeader.colourmap_length);
        byte[] byArray = IOUtils.readFully(inputStream, 4096);
        block0: while (n2 < this.width * this.height) {
            int n6;
            n3 = (byArray[n++] & 0x7F) + 1;
            if ((byArray[n - 1] & 0x80) != 0) {
                for (n6 = 0; n6 < n3; ++n6) {
                    this.pix[this.width * (this.l + this.m * n4) + this.n + this.o * n5] = 0xFF000000 | byArray[n] & 0xFF | (byArray[n] & 0xFF) << 8 | (byArray[n] & 0xFF) << 16;
                    if (++n5 % this.width == 0) {
                        ++n4;
                        n5 = 0;
                    }
                    if (++n2 >= this.width * this.height) break;
                }
                ++n;
                continue;
            }
            for (n6 = 0; n6 < n3; ++n6) {
                this.pix[this.width * (this.l + this.m * n4) + this.n + this.o * n5] = 0xFF000000 | byArray[n] & 0xFF | (byArray[n] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16;
                if (++n5 % this.width == 0) {
                    ++n4;
                    n5 = 0;
                }
                if (++n2 >= this.width * this.height) continue block0;
            }
        }
        inputStream.close();
    }

    private void read_RLE_CMP_Tga(InputStream inputStream) throws Exception {
        LOGGER.info("color mapped Tga RLE image!");
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (this.tgaHeader.bits_per_pixel != 8) {
            LOGGER.error("Can only handle 8 bit color mapped tga file");
            return;
        }
        this.readPalette(inputStream);
        byte[] byArray = IOUtils.readFully(inputStream, 4096);
        block0: while (n2 < this.width * this.height) {
            int n6;
            n3 = (byArray[n++] & 0x7F) + 1;
            if ((byArray[n - 1] & 0x80) != 0) {
                for (n6 = 0; n6 < n3; ++n6) {
                    this.pix[this.width * (this.l + this.m * n4) + this.n + this.o * n5] = this.rgbColorPalette[byArray[n] & 0xFF];
                    if (++n5 % this.width == 0) {
                        ++n4;
                        n5 = 0;
                    }
                    if (++n2 >= this.width * this.height) break;
                }
                ++n;
                continue;
            }
            for (n6 = 0; n6 < n3; ++n6) {
                this.pix[this.width * (this.l + this.m * n4) + this.n + this.o * n5] = this.rgbColorPalette[byArray[n++] & 0xFF];
                if (++n5 % this.width == 0) {
                    ++n4;
                    n5 = 0;
                }
                if (++n2 >= this.width * this.height) continue block0;
            }
        }
        inputStream.close();
    }

    private void read_RLE_TrueColor_Tga(InputStream inputStream) throws Exception {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        n += this.tgaHeader.id_length;
        IOUtils.skipFully(inputStream, n += this.tgaHeader.colourmap_type * this.tgaHeader.colourmap_length);
        byte[] byArray = IOUtils.readFully(inputStream, 4096);
        if (this.tgaHeader.bits_per_pixel == 24) {
            LOGGER.info("24 bits Tga RLE image!");
            block0: while (n3 < this.width * this.height) {
                int n7;
                n4 = (byArray[n2++] & 0x7F) + 1;
                if ((byArray[n2 - 1] & 0x80) != 0) {
                    for (n7 = 0; n7 < n4; ++n7) {
                        this.pix[this.width * (this.l + this.m * n5) + this.n + this.o * n6] = 0xFF000000 | byArray[n2] & 0xFF | (byArray[n2 + 1] & 0xFF) << 8 | (byArray[n2 + 2] & 0xFF) << 16;
                        if (++n6 % this.width == 0) {
                            ++n5;
                            n6 = 0;
                        }
                        if (++n3 >= this.width * this.height) break;
                    }
                    n2 += 3;
                    continue;
                }
                for (n7 = 0; n7 < n4; ++n7) {
                    this.pix[this.width * (this.l + this.m * n5) + this.n + this.o * n6] = 0xFF000000 | byArray[n2++] & 0xFF | (byArray[n2++] & 0xFF) << 8 | (byArray[n2++] & 0xFF) << 16;
                    if (++n6 % this.width == 0) {
                        ++n5;
                        n6 = 0;
                    }
                    if (++n3 >= this.width * this.height) continue block0;
                }
            }
        } else if (this.tgaHeader.bits_per_pixel == 32) {
            LOGGER.info("32 bits Tga RLE image!");
            block3: while (n3 < this.width * this.height) {
                int n8;
                n4 = (byArray[n2++] & 0x7F) + 1;
                if ((byArray[n2 - 1] & 0x80) != 0) {
                    for (n8 = 0; n8 < n4; ++n8) {
                        this.pix[this.width * (this.l + this.m * n5) + this.n + this.o * n6] = byArray[n2] & 0xFF | (byArray[n2 + 1] & 0xFF) << 8 | (byArray[n2 + 2] & 0xFF) << 16 | (byArray[n2 + 3] & 0xFF) << 24;
                        if (++n6 % this.width == 0) {
                            ++n5;
                            n6 = 0;
                        }
                        if (++n3 >= this.width * this.height) break;
                    }
                    n2 += 4;
                    continue;
                }
                for (n8 = 0; n8 < n4; ++n8) {
                    this.pix[this.width * (this.l + this.m * n5) + this.n + this.o * n6] = byArray[n2++] & 0xFF | (byArray[n2++] & 0xFF) << 8 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 24;
                    if (++n6 % this.width == 0) {
                        ++n5;
                        n6 = 0;
                    }
                    if (++n3 >= this.width * this.height) continue block3;
                }
            }
        } else if (this.tgaHeader.bits_per_pixel == 15 || this.tgaHeader.bits_per_pixel == 16) {
            LOGGER.info("16 bits Tga RLE image!");
            int n9 = 0;
            int n10 = 0;
            int n11 = 0;
            int n12 = 0;
            block6: while (n3 < this.width * this.height) {
                int n13;
                n4 = (byArray[n2++] & 0x7F) + 1;
                if ((byArray[n2 - 1] & 0x80) != 0) {
                    n9 = (byArray[++n2] & 0x7C) << 1;
                    n10 = (byArray[n2] & 3) << 6 | (byArray[n2 - 1] & 0xE0) >> 2;
                    n11 = (byArray[n2 - 1] & 0x1F) << 3;
                    n12 = 255;
                    ++n2;
                    for (n13 = 0; n13 < n4; ++n13) {
                        this.pix[this.width * (this.l + this.m * n5) + this.n + this.o * n6] = n12 << 24 | n9 << 16 | n10 << 8 | n11;
                        if (++n6 % this.width == 0) {
                            ++n5;
                            n6 = 0;
                        }
                        if (++n3 >= this.width * this.height) continue block6;
                    }
                    continue;
                }
                for (n13 = 0; n13 < n4; ++n13) {
                    n9 = (byArray[++n2] & 0x7C) << 1;
                    n10 = (byArray[n2] & 3) << 6 | (byArray[n2 - 1] & 0xE0) >> 2;
                    n11 = (byArray[n2 - 1] & 0x1F) << 3;
                    n12 = 255;
                    ++n2;
                    this.pix[this.width * (this.l + this.m * n5) + this.n + this.o * n6] = n12 << 24 | n9 << 16 | n10 << 8 | n11;
                    if (++n6 % this.width == 0) {
                        ++n5;
                        n6 = 0;
                    }
                    if (++n3 >= this.width * this.height) continue block6;
                }
            }
        }
        inputStream.close();
    }

    private void readCMPTga(InputStream inputStream) throws Exception {
        LOGGER.info("color mapped Tga uncompressed image!");
        int n = 0;
        this.readPalette(inputStream);
        if (this.tgaHeader.bits_per_pixel != 8) {
            LOGGER.error("Can only handle 8 bit color mapped tga file");
            return;
        }
        byte[] byArray = new byte[this.width * this.height];
        IOUtils.readFully(inputStream, byArray, 0, this.width * this.height);
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                this.pix[this.width * (this.l + this.m * i) + this.n + this.o * j] = this.rgbColorPalette[byArray[n++] & 0xFF];
            }
        }
        inputStream.close();
    }

    private void readPalette(InputStream inputStream) throws Exception {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = (this.tgaHeader.colourmap_entry_size + 1) / 8;
        int n7 = n6 * (this.tgaHeader.colourmap_length - this.tgaHeader.first_entry_index);
        byte[] byArray = new byte[n7];
        int n8 = this.tgaHeader.colourmap_length - this.tgaHeader.first_entry_index;
        this.rgbColorPalette = new int[n8];
        IOUtils.skipFully(inputStream, this.tgaHeader.id_length);
        IOUtils.skipFully(inputStream, this.tgaHeader.first_entry_index);
        IOUtils.readFully(inputStream, byArray, 0, n7);
        switch (this.tgaHeader.colourmap_entry_size) {
            case 15: 
            case 16: {
                for (int i = 0; i < this.tgaHeader.colourmap_length - this.tgaHeader.first_entry_index; ++i) {
                    n2 = (byArray[++n] & 0x7C) << 1;
                    n3 = (byArray[n] & 3) << 6 | (byArray[n - 1] & 0xE0) >> 2;
                    n4 = (byArray[n - 1] & 0x1F) << 3;
                    n5 = 255;
                    this.rgbColorPalette[i] = n5 << 24 | n2 << 16 | n3 << 8 | n4;
                    ++n;
                }
                break;
            }
            case 24: {
                for (int i = 0; i < this.tgaHeader.colourmap_length - this.tgaHeader.first_entry_index; ++i) {
                    this.rgbColorPalette[i] = 0xFF000000 | byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16;
                }
                break;
            }
            case 32: {
                for (int i = 0; i < this.tgaHeader.colourmap_length - this.tgaHeader.first_entry_index; ++i) {
                    this.rgbColorPalette[i] = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
                }
                break;
            }
        }
    }

    private void readTrueColorTga(InputStream inputStream) throws Exception {
        int n = 0;
        int n2 = 0;
        n += this.tgaHeader.id_length;
        IOUtils.skipFully(inputStream, n += this.tgaHeader.colourmap_type * this.tgaHeader.colourmap_length);
        int n3 = (this.tgaHeader.bits_per_pixel + 7) / 8;
        byte[] byArray = new byte[n3 * this.width * this.height];
        IOUtils.readFully(inputStream, byArray, 0, n3 * this.width * this.height);
        if (this.tgaHeader.bits_per_pixel == 24) {
            LOGGER.info("24 bits Tga uncompressed image!");
            for (int i = 0; i < this.height; ++i) {
                for (int j = 0; j < this.width; ++j) {
                    this.pix[this.width * (this.l + this.m * i) + this.n + this.o * j] = 0xFF000000 | byArray[n2++] & 0xFF | (byArray[n2++] & 0xFF) << 8 | (byArray[n2++] & 0xFF) << 16;
                }
            }
        } else if (this.tgaHeader.bits_per_pixel == 32) {
            LOGGER.info("32 bits Tga uncompressed image!");
            for (int i = 0; i < this.height; ++i) {
                for (int j = 0; j < this.width; ++j) {
                    this.pix[this.width * (this.l + this.m * i) + this.n + this.o * j] = byArray[n2++] & 0xFF | (byArray[n2++] & 0xFF) << 8 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 24;
                }
            }
        } else if (this.tgaHeader.bits_per_pixel == 15 || this.tgaHeader.bits_per_pixel == 16) {
            LOGGER.info("16 bits Tga uncompressed image!");
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            for (int i = 0; i < this.height; ++i) {
                for (int j = 0; j < this.width; ++j) {
                    n4 = (byArray[++n2] & 0x7C) << 1;
                    n5 = (byArray[n2] & 3) << 6 | (byArray[n2 - 1] & 0xE0) >> 2;
                    n6 = (byArray[n2 - 1] & 0x1F) << 3;
                    n7 = 255;
                    ++n2;
                    this.pix[this.width * (this.l + this.m * i) + this.n + this.o * j] = n7 << 24 | n4 << 16 | n5 << 8 | n6;
                }
            }
        }
        inputStream.close();
    }

    private static class TgaHeader {
        byte id_length;
        byte colourmap_type;
        byte image_type;
        short first_entry_index;
        short colourmap_length;
        byte colourmap_entry_size;
        short x_origin;
        short y_origin;
        short width;
        short height;
        byte bits_per_pixel;
        byte image_descriptor;

        private TgaHeader() {
        }

        void readHeader(InputStream inputStream) throws Exception {
            int n = 0;
            byte[] byArray = new byte[18];
            IOUtils.readFully(inputStream, byArray, 0, 18);
            this.id_length = byArray[n++];
            this.colourmap_type = byArray[n++];
            this.image_type = byArray[n++];
            this.first_entry_index = (short)(byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8);
            this.colourmap_length = (short)(byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8);
            this.colourmap_entry_size = byArray[n++];
            this.x_origin = (short)(byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8);
            this.y_origin = (short)(byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8);
            this.width = (short)(byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8);
            this.height = (short)(byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8);
            this.bits_per_pixel = byArray[n++];
            this.image_descriptor = byArray[n++];
        }
    }
}

