/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.tiff;

import com.icafe4j.image.tiff.FieldType;
import com.icafe4j.image.tiff.TiffField;
import com.icafe4j.io.RandomAccessOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public final class ASCIIField
extends TiffField<String> {
    public ASCIIField(short s, String string) {
        super(s, FieldType.ASCII, ASCIIField.getLength(string));
        this.data = string.trim() + '\u0000';
    }

    private static int getLength(String string) {
        try {
            return string.trim().getBytes("UTF-8").length + 1;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Failed to create ASCIIField.");
        }
    }

    @Override
    public String getDataAsString() {
        return ((String)this.data).trim().replace("\u0000", "; ");
    }

    @Override
    protected int writeData(RandomAccessOutputStream randomAccessOutputStream, int n) throws IOException {
        byte[] byArray = ((String)this.data).getBytes("UTF-8");
        if (byArray.length <= 4) {
            this.dataOffset = (int)randomAccessOutputStream.getStreamPointer();
            byte[] byArray2 = new byte[4];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            randomAccessOutputStream.write(byArray2);
        } else {
            this.dataOffset = n;
            randomAccessOutputStream.writeInt(n);
            randomAccessOutputStream.seek(n);
            randomAccessOutputStream.write(byArray);
            n += byArray.length;
        }
        return n;
    }
}

