/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.image.tiff;

import com.icafe4j.image.ImageFrame;
import com.icafe4j.image.ImageIO;
import com.icafe4j.image.ImageParam;
import com.icafe4j.image.ImageType;
import com.icafe4j.image.compression.CodecException;
import com.icafe4j.image.compression.ImageDecoder;
import com.icafe4j.image.compression.ImageEncoder;
import com.icafe4j.image.compression.deflate.DeflateDecoder;
import com.icafe4j.image.compression.deflate.DeflateEncoder;
import com.icafe4j.image.compression.lzw.LZWTreeDecoder;
import com.icafe4j.image.compression.lzw.LZWTreeEncoder;
import com.icafe4j.image.compression.packbits.Packbits;
import com.icafe4j.image.jpeg.Marker;
import com.icafe4j.image.meta.Metadata;
import com.icafe4j.image.meta.MetadataType;
import com.icafe4j.image.meta.adobe.DDB;
import com.icafe4j.image.meta.adobe.IRB;
import com.icafe4j.image.meta.adobe.IRBThumbnail;
import com.icafe4j.image.meta.adobe.ImageResourceID;
import com.icafe4j.image.meta.adobe.ThumbnailResource;
import com.icafe4j.image.meta.adobe._8BIM;
import com.icafe4j.image.meta.exif.Exif;
import com.icafe4j.image.meta.exif.ExifTag;
import com.icafe4j.image.meta.exif.GPSTag;
import com.icafe4j.image.meta.exif.InteropTag;
import com.icafe4j.image.meta.icc.ICCProfile;
import com.icafe4j.image.meta.image.Comments;
import com.icafe4j.image.meta.iptc.IPTC;
import com.icafe4j.image.meta.iptc.IPTCDataSet;
import com.icafe4j.image.meta.tiff.TiffExif;
import com.icafe4j.image.meta.tiff.TiffXMP;
import com.icafe4j.image.meta.xmp.XMP;
import com.icafe4j.image.tiff.ASCIIField;
import com.icafe4j.image.tiff.AbstractRationalField;
import com.icafe4j.image.tiff.ByteField;
import com.icafe4j.image.tiff.DoubleField;
import com.icafe4j.image.tiff.FieldType;
import com.icafe4j.image.tiff.FloatField;
import com.icafe4j.image.tiff.IFD;
import com.icafe4j.image.tiff.IFDField;
import com.icafe4j.image.tiff.LongField;
import com.icafe4j.image.tiff.PageWritingException;
import com.icafe4j.image.tiff.RationalField;
import com.icafe4j.image.tiff.SRationalField;
import com.icafe4j.image.tiff.ShortField;
import com.icafe4j.image.tiff.TIFFImage;
import com.icafe4j.image.tiff.Tag;
import com.icafe4j.image.tiff.TiffField;
import com.icafe4j.image.tiff.TiffFieldEnum;
import com.icafe4j.image.tiff.TiffTag;
import com.icafe4j.image.tiff.UndefinedField;
import com.icafe4j.image.writer.ImageWriter;
import com.icafe4j.image.writer.TIFFWriter;
import com.icafe4j.io.File2RandomInputStreamAdaptor;
import com.icafe4j.io.FileCacheRandomAccessInputStream;
import com.icafe4j.io.FileCacheRandomAccessOutputStream;
import com.icafe4j.io.IOUtils;
import com.icafe4j.io.MemoryCacheRandomAccessOutputStream;
import com.icafe4j.io.RandomAccessInputStream;
import com.icafe4j.io.RandomAccessOutputStream;
import com.icafe4j.io.RandomInputStreamAdaptor;
import com.icafe4j.io.ReadStrategy;
import com.icafe4j.io.ReadStrategyII;
import com.icafe4j.io.ReadStrategyMM;
import com.icafe4j.io.Stream2RandomInputStreamAdaptor;
import com.icafe4j.io.WriteStrategy;
import com.icafe4j.io.WriteStrategyII;
import com.icafe4j.io.WriteStrategyMM;
import com.icafe4j.string.StringUtils;
import com.icafe4j.string.XMLUtils;
import com.icafe4j.util.ArrayUtils;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class TIFFTweaker {
    private static final Logger LOGGER = LoggerFactory.getLogger(TIFFTweaker.class);

    public static void append(RandomAccessInputStream randomAccessInputStream, RandomAccessOutputStream randomAccessOutputStream, BufferedImage ... bufferedImageArray) throws IOException {
        TIFFTweaker.append(randomAccessInputStream, randomAccessOutputStream, null, bufferedImageArray);
    }

    public static void append(RandomAccessInputStream randomAccessInputStream, RandomAccessOutputStream randomAccessOutputStream, ImageFrame ... imageFrameArray) throws IOException {
        TIFFTweaker.insertPages(randomAccessInputStream, randomAccessOutputStream, TIFFTweaker.getPageCount(randomAccessInputStream), imageFrameArray);
    }

    public static void append(RandomAccessInputStream randomAccessInputStream, RandomAccessOutputStream randomAccessOutputStream, ImageParam[] imageParamArray, BufferedImage ... bufferedImageArray) throws IOException {
        TIFFTweaker.insertPages(randomAccessInputStream, randomAccessOutputStream, TIFFTweaker.getPageCount(randomAccessInputStream), imageParamArray, bufferedImageArray);
    }

    public static void copyCat(RandomAccessInputStream randomAccessInputStream, RandomAccessOutputStream randomAccessOutputStream) throws IOException {
        ArrayList<IFD> arrayList = new ArrayList<IFD>();
        int n = TIFFTweaker.copyHeader(randomAccessInputStream, randomAccessOutputStream);
        int n2 = 8;
        TIFFTweaker.readIFDs(arrayList, n, randomAccessInputStream);
        n = TIFFTweaker.copyPages(arrayList, n2, randomAccessInputStream, randomAccessOutputStream);
        int n3 = ((IFD)arrayList.get(0)).getStartOffset();
        TIFFTweaker.writeToStream(randomAccessOutputStream, n3);
    }

    private static int copyHeader(RandomAccessInputStream randomAccessInputStream, RandomAccessOutputStream randomAccessOutputStream) throws IOException {
        randomAccessInputStream.seek(0L);
        short s = randomAccessInputStream.readShort();
        if (s == 19789) {
            randomAccessInputStream.setReadStrategy(ReadStrategyMM.getInstance());
            randomAccessOutputStream.setWriteStrategy(WriteStrategyMM.getInstance());
        } else if (s == 18761) {
            randomAccessInputStream.setReadStrategy(ReadStrategyII.getInstance());
            randomAccessOutputStream.setWriteStrategy(WriteStrategyII.getInstance());
        } else {
            randomAccessInputStream.close();
            randomAccessOutputStream.close();
            throw new RuntimeException("Invalid TIFF byte order");
        }
        randomAccessOutputStream.writeShort(s);
        randomAccessInputStream.seek(2L);
        short s2 = randomAccessInputStream.readShort();
        if (s2 != 42) {
            randomAccessInputStream.close();
            randomAccessOutputStream.close();
            throw new RuntimeException("Invalid TIFF identifier");
        }
        randomAccessOutputStream.writeShort(s2);
        randomAccessInputStream.seek(4L);
        return randomAccessInputStream.readInt();
    }

    private static Collection<IPTCDataSet> copyIPTCDataSet(Collection<IPTCDataSet> collection, byte[] byArray) throws IOException {
        IPTC iPTC = new IPTC(byArray);
        HashMap<String, List<IPTCDataSet>> hashMap = new HashMap<String, List<IPTCDataSet>>(iPTC.getDataSets());
        for (IPTCDataSet object : collection) {
            if (object.allowMultiple()) continue;
            hashMap.remove(object.getName());
        }
        for (List list : hashMap.values()) {
            collection.addAll(list);
        }
        return collection;
    }

    private static TiffField<?> copyJPEGHufTable(RandomAccessInputStream randomAccessInputStream, RandomAccessOutputStream randomAccessOutputStream, TiffField<?> tiffField, int n) throws IOException {
        int[] nArray = tiffField.getDataAsLong();
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            randomAccessInputStream.seek(nArray[i]);
            nArray2[i] = n;
            byte[] byArray = new byte[16];
            IOUtils.readFully((InputStream)randomAccessInputStream, byArray);
            IOUtils.write((OutputStream)randomAccessOutputStream, byArray);
            n += 16;
            int n2 = 0;
            for (int j = 0; j < 16; ++j) {
                n2 += byArray[j] & 0xFF;
            }
            n += n2;
            byArray = new byte[n2];
            IOUtils.readFully((InputStream)randomAccessInputStream, byArray);
            IOUtils.write((OutputStream)randomAccessOutputStream, byArray);
        }
        if (TiffTag.fromShort(tiffField.getTag()) == TiffTag.JPEG_AC_TABLES) {
            return new LongField(TiffTag.JPEG_AC_TABLES.getValue(), nArray2);
        }
        return new LongField(TiffTag.JPEG_DC_TABLES.getValue(), nArray2);
    }

    private static void copyJPEGIFByteCount(RandomAccessInputStream randomAccessInputStream, RandomAccessOutputStream randomAccessOutputStream, int n, int n2) throws IOException {
        boolean bl = false;
        int n3 = 0;
        randomAccessInputStream.seek(n);
        randomAccessOutputStream.seek(n2);
        if (Marker.fromShort(IOUtils.readShortMM(randomAccessInputStream)) != Marker.SOI) {
            return;
        }
        IOUtils.writeShortMM(randomAccessOutputStream, Marker.SOI.getValue());
        short s = IOUtils.readShortMM(randomAccessInputStream);
        block5: while (!bl) {
            if (Marker.fromShort(s) == Marker.EOI) {
                IOUtils.writeShortMM(randomAccessOutputStream, s);
                bl = true;
                continue;
            }
            Marker marker = Marker.fromShort(s);
            switch (marker) {
                case JPG: 
                case JPG0: 
                case JPG13: 
                case TEM: {
                    s = IOUtils.readShortMM(randomAccessInputStream);
                    continue block5;
                }
                case SOS: {
                    s = TIFFTweaker.copyJPEGSOS(randomAccessInputStream, randomAccessOutputStream);
                    continue block5;
                }
                case PADDING: {
                    int n4 = 0;
                    while ((n4 = randomAccessInputStream.read()) == 255) {
                    }
                    s = (short)(0xFF00 | n4);
                    continue block5;
                }
            }
            n3 = IOUtils.readUnsignedShortMM(randomAccessInputStream);
            byte[] byArray = new byte[n3 - 2];
            randomAccessInputStream.read(byArray);
            IOUtils.writeShortMM(randomAccessOutputStream, s);
            IOUtils.writeShortMM(randomAccessOutputStream, n3);
            randomAccessOutputStream.write(byArray);
            s = IOUtils.readShortMM(randomAccessInputStream);
        }
    }

    private static TiffField<?> copyJPEGQTable(RandomAccessInputStream randomAccessInputStream, RandomAccessOutputStream randomAccessOutputStream, TiffField<?> tiffField, int n) throws IOException {
        byte[] byArray = new byte[64];
        int[] nArray = tiffField.getDataAsLong();
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            randomAccessInputStream.seek(nArray[i]);
            nArray2[i] = n;
            IOUtils.readFully((InputStream)randomAccessInputStream, byArray);
            IOUtils.write((OutputStream)randomAccessOutputStream, byArray);
            n += 64;
        }
        return new LongField(TiffTag.JPEG_Q_TABLES.getValue(), nArray2);
    }

    private static short copyJPEGSOS(RandomAccessInputStream randomAccessInputStream, RandomAccessOutputStream randomAccessOutputStream) throws IOException {
        int n = IOUtils.readUnsignedShortMM(randomAccessInputStream);
        byte[] byArray = new byte[n - 2];
        IOUtils.readFully((InputStream)randomAccessInputStream, byArray);
        IOUtils.writeShortMM(randomAccessOutputStream, Marker.SOS.getValue());
        IOUtils.writeShortMM(randomAccessOutputStream, n);
        randomAccessOutputStream.write(byArray);
        int n2 = 0;
        short s = 0;
        block3: while ((n2 = IOUtils.read(randomAccessInputStream)) != -1) {
            randomAccessOutputStream.write(n2);
            if (n2 != 255) continue;
            n2 = IOUtils.read(randomAccessInputStream);
            randomAccessOutputStream.write(n2);
            if (n2 == -1) {
                throw new IOException("Premature end of SOS segment!");
            }
            if (n2 == 0) continue;
            s = (short)(0xFF00 | n2);
            switch (Marker.fromShort(s)) {
                case RST0: 
                case RST1: 
                case RST2: 
                case RST3: 
                case RST4: 
                case RST5: 
                case RST6: 
                case RST7: {
                    continue block3;
                }
            }
        }
        if (n2 == -1) {
            throw new IOException("Premature end of SOS segment!");
        }
        return s;
    }

    private static int copyPageData(IFD iFD, int n, RandomAccessInputStream randomAccessInputStream, RandomAccessOutputStream randomAccessOutputStream) throws IOException {
        TiffField<?> tiffField;
        Object object;
        Object object2;
        Object object3;
        TiffField<?> tiffField2;
        randomAccessOutputStream.seek(n);
        LongField longField = iFD.removeField(TiffTag.STRIP_OFFSETS);
        if (longField == null) {
            longField = iFD.removeField(TiffTag.TILE_OFFSETS);
        }
        if ((tiffField2 = iFD.getField(TiffTag.STRIP_BYTE_COUNTS)) == null) {
            tiffField2 = iFD.getField(TiffTag.TILE_BYTE_COUNTS);
        }
        if (longField != null) {
            int n2;
            object3 = tiffField2.getDataAsLong();
            object2 = ((TiffField)longField).getDataAsLong();
            object = new int[((int[])object2).length];
            tiffField = iFD.getField(TiffTag.COMPRESSION);
            if (tiffField == null || tiffField != null && tiffField.getDataAsLong()[0] == 1) {
                n2 = 1;
                tiffField = iFD.getField(TiffTag.PLANAR_CONFIGURATTION);
                if (tiffField != null) {
                    n2 = tiffField.getDataAsLong()[0];
                }
                tiffField = iFD.getField(TiffTag.SAMPLES_PER_PIXEL);
                int n3 = 1;
                if (tiffField != null) {
                    n3 = tiffField.getDataAsLong()[0];
                }
                if (n2 == 1 && ((Object)object2).length == 1 || n2 == 2 && ((Object)object2).length == n3) {
                    int[] nArray = TIFFTweaker.getBytes2Read(iFD);
                    for (int i = 0; i < ((Object)object2).length; ++i) {
                        object3[i] = nArray[i];
                    }
                }
            }
            randomAccessOutputStream.seek(n);
            for (n2 = 0; n2 < ((Object)object2).length; ++n2) {
                randomAccessInputStream.seek((long)object2[n2]);
                byte[] byArray = new byte[object3[n2]];
                randomAccessInputStream.readFully(byArray);
                randomAccessOutputStream.write(byArray);
                object[n2] = n;
                n += byArray.length;
            }
            longField = iFD.getField(TiffTag.STRIP_BYTE_COUNTS) != null ? new LongField(TiffTag.STRIP_OFFSETS.getValue(), (int[])object) : new LongField(TiffTag.TILE_OFFSETS.getValue(), (int[])object);
            iFD.addField(longField);
        }
        object3 = "ICAFE - https://github.com/dragon66/icafe\u0000";
        iFD.addField(new ASCIIField(TiffTag.SOFTWARE.getValue(), (String)object3));
        object2 = iFD.removeField(TiffTag.JPEG_INTERCHANGE_FORMAT);
        if (object2 != null) {
            object = iFD.removeField(TiffTag.JPEG_INTERCHANGE_FORMAT_LENGTH);
            try {
                if (object != null) {
                    randomAccessInputStream.seek(((TiffField)object2).getDataAsLong()[0]);
                    tiffField = (TiffField<?>)new byte[((TiffField)object).getDataAsLong()[0]];
                    randomAccessInputStream.readFully((byte[])tiffField);
                    randomAccessOutputStream.seek(n);
                    randomAccessOutputStream.write((byte[])tiffField);
                    iFD.addField((TiffField<?>)object);
                } else {
                    long l = randomAccessOutputStream.getStreamPointer();
                    TIFFTweaker.copyJPEGIFByteCount(randomAccessInputStream, randomAccessOutputStream, ((TiffField)object2).getDataAsLong()[0], n);
                    long l2 = randomAccessOutputStream.getStreamPointer();
                    iFD.addField(new LongField(TiffTag.JPEG_INTERCHANGE_FORMAT_LENGTH.getValue(), new int[]{(int)(l2 - l)}));
                }
                object2 = new LongField(TiffTag.JPEG_INTERCHANGE_FORMAT.getValue(), new int[]{n});
                iFD.addField((TiffField<?>)object2);
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
        }
        if ((object = (Object)iFD.removeField(TiffTag.JPEG_DC_TABLES)) != null) {
            try {
                iFD.addField(TIFFTweaker.copyJPEGHufTable(randomAccessInputStream, randomAccessOutputStream, object, (int)randomAccessOutputStream.getStreamPointer()));
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
        }
        if ((object = (Object)iFD.removeField(TiffTag.JPEG_AC_TABLES)) != null) {
            try {
                iFD.addField(TIFFTweaker.copyJPEGHufTable(randomAccessInputStream, randomAccessOutputStream, object, (int)randomAccessOutputStream.getStreamPointer()));
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
        }
        if ((object = iFD.removeField(TiffTag.JPEG_Q_TABLES)) != null) {
            try {
                iFD.addField(TIFFTweaker.copyJPEGQTable(randomAccessInputStream, randomAccessOutputStream, object, (int)randomAccessOutputStream.getStreamPointer()));
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
        }
        return (int)randomAccessOutputStream.getStreamPointer();
    }

    private static int copyPages(List<IFD> list, int n, RandomAccessInputStream randomAccessInputStream, RandomAccessOutputStream randomAccessOutputStream) throws IOException {
        n = TIFFTweaker.copyPageData(list.get(0), n, randomAccessInputStream, randomAccessOutputStream);
        n = list.get(0).write(randomAccessOutputStream, n);
        for (int i = 1; i < list.size(); ++i) {
            n = TIFFTweaker.copyPageData(list.get(i), n, randomAccessInputStream, randomAccessOutputStream);
            list.get(i - 1).setNextIFDOffset(randomAccessOutputStream, n);
            n = list.get(i).write(randomAccessOutputStream, n);
        }
        return n;
    }

    public static byte[] extractICCProfile(int n, RandomAccessInputStream randomAccessInputStream) throws Exception {
        int n2 = TIFFTweaker.readHeader(randomAccessInputStream);
        ArrayList<IFD> arrayList = new ArrayList<IFD>();
        TIFFTweaker.readIFDs(arrayList, n2, randomAccessInputStream);
        if (n < 0 || n >= arrayList.size()) {
            throw new IllegalArgumentException("pageNumber " + n + " out of bounds: 0 - " + (arrayList.size() - 1));
        }
        IFD iFD = (IFD)arrayList.get(n);
        TiffField<?> tiffField = iFD.getField(TiffTag.ICC_PROFILE);
        if (tiffField != null) {
            return (byte[])tiffField.getData();
        }
        return null;
    }

    public static byte[] extractICCProfile(RandomAccessInputStream randomAccessInputStream) throws Exception {
        return TIFFTweaker.extractICCProfile(0, randomAccessInputStream);
    }

    public static IRBThumbnail extractThumbnail(int n, RandomAccessInputStream randomAccessInputStream) throws IOException {
        byte[] byArray;
        IRB iRB;
        int n2 = TIFFTweaker.readHeader(randomAccessInputStream);
        ArrayList<IFD> arrayList = new ArrayList<IFD>();
        TIFFTweaker.readIFDs(arrayList, n2, randomAccessInputStream);
        if (n < 0 || n >= arrayList.size()) {
            throw new IllegalArgumentException("pageNumber " + n + " out of bounds: 0 - " + (arrayList.size() - 1));
        }
        IFD iFD = (IFD)arrayList.get(n);
        TiffField<?> tiffField = iFD.getField(TiffTag.PHOTOSHOP);
        if (tiffField != null && (iRB = new IRB(byArray = (byte[])tiffField.getData())).containsThumbnail()) {
            IRBThumbnail iRBThumbnail = iRB.getThumbnail();
            return iRBThumbnail;
        }
        return null;
    }

    public static IRBThumbnail extractThumbnail(RandomAccessInputStream randomAccessInputStream) throws IOException {
        return TIFFTweaker.extractThumbnail(0, randomAccessInputStream);
    }

    public static void extractThumbnail(RandomAccessInputStream randomAccessInputStream, String string) throws IOException {
        IRBThumbnail iRBThumbnail = TIFFTweaker.extractThumbnail(randomAccessInputStream);
        if (iRBThumbnail != null) {
            String string2 = "";
            string2 = string.endsWith("\\") || string.endsWith("/") ? string + "photoshop_thumbnail.jpg" : string.replaceFirst("[.][^.]+$", "") + "_photoshop_t.jpg";
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            if (iRBThumbnail.getDataType() == 1) {
                fileOutputStream.write(iRBThumbnail.getCompressedImage());
            } else {
                ImageWriter imageWriter = ImageIO.getWriter(ImageType.JPG);
                try {
                    imageWriter.write(iRBThumbnail.getRawImage(), fileOutputStream);
                }
                catch (Exception exception) {
                    throw new IOException("Writing thumbnail failed!");
                }
            }
            fileOutputStream.close();
        }
    }

    public static void finishInsert(RandomAccessOutputStream randomAccessOutputStream, List<IFD> list) throws IOException {
        int n;
        for (n = 0; n < list.size(); ++n) {
            int n2 = list.get(n).getField(TiffTag.PAGE_NUMBER).getDataOffset();
            randomAccessOutputStream.seek(n2);
            randomAccessOutputStream.writeShort((short)n);
            randomAccessOutputStream.writeShort((short)list.size());
        }
        for (n = 0; n < list.size() - 1; ++n) {
            list.get(n).setNextIFDOffset(randomAccessOutputStream, list.get(n + 1).getStartOffset());
        }
        n = list.get(0).getStartOffset();
        TIFFTweaker.writeToStream(randomAccessOutputStream, n);
    }

    public static void finishWrite(RandomAccessOutputStream randomAccessOutputStream, List<IFD> list) throws IOException {
        TIFFTweaker.finishInsert(randomAccessOutputStream, list);
    }

    private static int[] getBytes2Read(IFD iFD) {
        TiffField<?> tiffField = iFD.getField(TiffTag.IMAGE_WIDTH);
        int n = tiffField.getDataAsLong()[0];
        tiffField = iFD.getField(TiffTag.IMAGE_LENGTH);
        int n2 = tiffField.getDataAsLong()[0];
        int n3 = 2;
        int n4 = 2;
        int n5 = iFD.getField(TiffTag.PHOTOMETRIC_INTERPRETATION).getDataAsLong()[0];
        if (n5 == TiffFieldEnum.PhotoMetric.YCbCr.getValue()) {
            TiffField<?> tiffField2 = iFD.getField(TiffTag.YCbCr_SUB_SAMPLING);
            if (tiffField2 != null) {
                int[] nArray = tiffField2.getDataAsLong();
                n3 = nArray[0];
                n4 = nArray[1];
            }
            n = (n + n3 - 1) / n3 * n3;
            n2 = (n2 + n4 - 1) / n4 * n4;
        }
        int n6 = 1;
        tiffField = iFD.getField(TiffTag.SAMPLES_PER_PIXEL);
        if (tiffField != null) {
            n6 = tiffField.getDataAsLong()[0];
        }
        int n7 = 1;
        tiffField = iFD.getField(TiffTag.BITS_PER_SAMPLE);
        if (tiffField != null) {
            n7 = tiffField.getDataAsLong()[0];
        }
        int n8 = -1;
        int n9 = -1;
        TiffField<?> tiffField3 = iFD.getField(TiffTag.TILE_LENGTH);
        TiffField<?> tiffField4 = iFD.getField(TiffTag.TILE_WIDTH);
        if (tiffField4 != null) {
            n8 = tiffField4.getDataAsLong()[0];
            n9 = tiffField3.getDataAsLong()[0];
        }
        int n10 = n2;
        int n11 = n;
        TiffField<?> tiffField5 = iFD.getField(TiffTag.ROWS_PER_STRIP);
        if (tiffField5 != null) {
            n10 = tiffField5.getDataAsLong()[0];
        }
        if (n10 > n2) {
            n10 = n2;
        }
        if (n8 > 0) {
            n10 = n9;
            n11 = n8;
        }
        int n12 = 1;
        tiffField = iFD.getField(TiffTag.PLANAR_CONFIGURATTION);
        if (tiffField != null) {
            n12 = tiffField.getDataAsLong()[0];
        }
        int[] nArray = new int[n6];
        if (n12 == 1) {
            nArray[0] = (n11 * n7 * n6 + 7) / 8 * n10;
        } else {
            nArray[1] = nArray[2] = (n11 * n7 + 7) / 8 * n10;
            nArray[0] = nArray[2];
        }
        if (n5 == TiffFieldEnum.PhotoMetric.YCbCr.getValue()) {
            if (n6 != 3) {
                n6 = 3;
            }
            int[] nArray2 = new int[n6];
            nArray2[0] = (n7 * n11 + 7) / 8;
            nArray2[1] = (n7 * n11 / n3 + 7) / 8;
            nArray2[2] = nArray2[1];
            int[] nArray3 = new int[n6];
            nArray3[0] = n10;
            nArray3[1] = n10 / n4;
            nArray3[2] = nArray3[1];
            nArray[0] = nArray2[0] * nArray3[0];
            nArray[1] = nArray2[1] * nArray3[1];
            nArray[2] = nArray[1];
            if (tiffField != null) {
                n12 = tiffField.getDataAsLong()[0];
            }
            if (n12 == 1) {
                nArray[0] = nArray[0] + nArray[1] + nArray[2];
            }
        }
        return nArray;
    }

    public static int getPageCount(RandomAccessInputStream randomAccessInputStream) throws IOException {
        long l = randomAccessInputStream.getStreamPointer();
        randomAccessInputStream.seek(0L);
        ArrayList<IFD> arrayList = new ArrayList<IFD>();
        TIFFTweaker.readIFDs(arrayList, randomAccessInputStream);
        randomAccessInputStream.seek(l);
        return arrayList.size();
    }

    private static int getRowWidth(IFD iFD) {
        TiffField<?> tiffField = iFD.getField(TiffTag.IMAGE_WIDTH);
        int n = tiffField.getDataAsLong()[0];
        int n2 = 2;
        int n3 = iFD.getField(TiffTag.PHOTOMETRIC_INTERPRETATION).getDataAsLong()[0];
        if (n3 == TiffFieldEnum.PhotoMetric.YCbCr.getValue()) {
            TiffField<?> tiffField2 = iFD.getField(TiffTag.YCbCr_SUB_SAMPLING);
            if (tiffField2 != null) {
                int[] nArray = tiffField2.getDataAsLong();
                n2 = nArray[0];
            }
            n = (n + n2 - 1) / n2 * n2;
        }
        int n4 = n;
        int n5 = -1;
        TiffField<?> tiffField3 = iFD.getField(TiffTag.TILE_WIDTH);
        if (tiffField3 != null && (n5 = tiffField3.getDataAsLong()[0]) > 0) {
            n4 = n5;
        }
        return n4;
    }

    public static int[] getUncompressedStripByteCounts(IFD iFD, int n) {
        int[] nArray;
        block17: {
            int[] nArray2;
            int[] nArray3;
            int[] nArray4;
            int n2;
            int n3;
            block18: {
                int n4;
                int n5;
                int n6;
                int n7;
                int n8;
                int n9;
                int n10;
                int n11;
                int n12;
                block16: {
                    int n13;
                    int n14;
                    TiffField<?> tiffField = iFD.getField(TiffTag.IMAGE_WIDTH);
                    int n15 = tiffField.getDataAsLong()[0];
                    tiffField = iFD.getField(TiffTag.IMAGE_LENGTH);
                    n12 = tiffField.getDataAsLong()[0];
                    n11 = 2;
                    n10 = 2;
                    int n16 = iFD.getField(TiffTag.PHOTOMETRIC_INTERPRETATION).getDataAsLong()[0];
                    if (n16 == TiffFieldEnum.PhotoMetric.YCbCr.getValue()) {
                        TiffField<?> tiffField2 = iFD.getField(TiffTag.YCbCr_SUB_SAMPLING);
                        if (tiffField2 != null) {
                            int[] nArray5 = tiffField2.getDataAsLong();
                            n11 = nArray5[0];
                            n10 = nArray5[1];
                        }
                        n15 = (n15 + n11 - 1) / n11 * n11;
                        n12 = (n12 + n10 - 1) / n10 * n10;
                    }
                    n3 = 1;
                    tiffField = iFD.getField(TiffTag.SAMPLES_PER_PIXEL);
                    if (tiffField != null) {
                        n3 = tiffField.getDataAsLong()[0];
                    }
                    n9 = 1;
                    tiffField = iFD.getField(TiffTag.BITS_PER_SAMPLE);
                    if (tiffField != null) {
                        n9 = tiffField.getDataAsLong()[0];
                    }
                    n2 = -1;
                    int n17 = -1;
                    TiffField<?> tiffField3 = iFD.getField(TiffTag.TILE_LENGTH);
                    TiffField<?> tiffField4 = iFD.getField(TiffTag.TILE_WIDTH);
                    if (tiffField4 != null) {
                        n2 = tiffField4.getDataAsLong()[0];
                        n17 = tiffField3.getDataAsLong()[0];
                    }
                    n8 = n12;
                    n7 = n15;
                    TiffField<?> tiffField5 = iFD.getField(TiffTag.ROWS_PER_STRIP);
                    if (tiffField5 != null) {
                        n8 = tiffField5.getDataAsLong()[0];
                    }
                    if (n8 > n12) {
                        n8 = n12;
                    }
                    if (n2 > 0) {
                        n8 = n17;
                        n7 = n2;
                    }
                    int n18 = (n9 * n7 * n3 + 7) / 8;
                    n6 = 1;
                    tiffField = iFD.getField(TiffTag.PLANAR_CONFIGURATTION);
                    if (tiffField != null) {
                        n6 = tiffField.getDataAsLong()[0];
                    }
                    if (n6 == 2) {
                        n18 = (n9 * n7 + 7) / 8;
                    }
                    n5 = n18 * n8;
                    nArray = new int[n];
                    if (n16 == TiffFieldEnum.PhotoMetric.YCbCr.getValue()) break block16;
                    Arrays.fill(nArray, n5);
                    if (n2 >= 0) break block17;
                    nArray[nArray.length - 1] = n14 = n18 * n12 - n5 * (n - 1);
                    if (n6 == 2 && (n14 = n18 * n12 - n5 * ((n13 = n / n3) - 1)) > 0) {
                        int n19 = n13 - 1;
                        for (int i = 0; i < n3; ++i) {
                            nArray[n19] = n14;
                            n19 += n13;
                        }
                    }
                    break block17;
                }
                if (n3 != 3) {
                    n3 = 3;
                }
                nArray4 = new int[n3];
                nArray4[0] = (n9 * n7 + 7) / 8;
                nArray4[1] = (n9 * n7 / n11 + 7) / 8;
                nArray4[2] = nArray4[1];
                nArray3 = new int[n3];
                nArray3[0] = n8;
                nArray3[1] = n8 / n10;
                nArray3[2] = nArray3[1];
                nArray2 = new int[n3];
                nArray2[0] = n12;
                nArray2[1] = n12 / n10;
                nArray2[2] = nArray2[1];
                if (n6 != 1) break block18;
                n5 = nArray4[0] * nArray3[0] + nArray4[1] * nArray3[1] + nArray4[2] * nArray3[2];
                Arrays.fill(nArray, n5);
                if (n2 >= 0) break block17;
                nArray[nArray.length - 1] = n4 = nArray4[0] * nArray2[0] + nArray4[1] * nArray2[1] + nArray4[2] * nArray2[2] - n5 * (n - 1);
                break block17;
            }
            int[] nArray6 = new int[n3];
            nArray6[0] = nArray3[0] * nArray4[0];
            nArray6[1] = nArray3[1] * nArray4[1];
            nArray6[2] = nArray6[1];
            int n20 = n / n3;
            int n21 = 0;
            int n22 = n20;
            for (int i = 0; i < n3; ++i) {
                Arrays.fill(nArray, n21, n22, nArray6[i]);
                n21 = n22;
                n22 += n20;
            }
            if (n2 < 0) {
                int[] nArray7 = new int[n3];
                nArray7[0] = nArray4[0] * nArray2[0] - nArray6[0] * (n20 - 1);
                nArray7[1] = nArray4[1] * nArray2[1] - nArray6[1] * (n20 - 1);
                nArray7[2] = nArray7[1];
                n21 = n20 - 1;
                for (int i = 0; i < n3; ++i) {
                    nArray[n21] = nArray7[i];
                    n21 += n20;
                }
            }
        }
        return nArray;
    }

    public static void insertComments(List<String> list, RandomAccessInputStream randomAccessInputStream, RandomAccessOutputStream randomAccessOutputStream) throws IOException {
        TIFFTweaker.insertComments(list, 0, randomAccessInputStream, randomAccessOutputStream);
    }

    public static void insertComments(List<String> list, int n, RandomAccessInputStream randomAccessInputStream, RandomAccessOutputStream randomAccessOutputStream) throws IOException {
        int n2 = TIFFTweaker.copyHeader(randomAccessInputStream, randomAccessOutputStream);
        ArrayList<IFD> arrayList = new ArrayList<IFD>();
        TIFFTweaker.readIFDs(arrayList, n2, randomAccessInputStream);
        if (n < 0 || n >= arrayList.size()) {
            throw new IllegalArgumentException("pageNumber " + n + " out of bounds: 0 - " + (arrayList.size() - 1));
        }
        IFD iFD = (IFD)arrayList.get(n);
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : list) {
            stringBuilder.append(string);
            stringBuilder.append('\u0000');
        }
        iFD.addField(new ASCIIField(TiffTag.IMAGE_DESCRIPTION.getValue(), stringBuilder.toString()));
        n2 = TIFFTweaker.copyPages(arrayList, n2, randomAccessInputStream, randomAccessOutputStream);
        int n3 = ((IFD)arrayList.get(0)).getStartOffset();
        TIFFTweaker.writeToStream(randomAccessOutputStream, n3);
    }

    public static void insertExif(RandomAccessInputStream randomAccessInputStream, RandomAccessOutputStream randomAccessOutputStream, Exif exif, boolean bl) throws IOException {
        TIFFTweaker.insertExif(randomAccessInputStream, randomAccessOutputStream, exif, 0, bl);
    }

    public static void insertExif(RandomAccessInputStream randomAccessInputStream, RandomAccessOutputStream randomAccessOutputStream, Exif exif, int n, boolean bl) throws IOException {
        int n2 = TIFFTweaker.copyHeader(randomAccessInputStream, randomAccessOutputStream);
        ArrayList<IFD> arrayList = new ArrayList<IFD>();
        TIFFTweaker.readIFDs(arrayList, n2, randomAccessInputStream);
        if (n < 0 || n >= arrayList.size()) {
            throw new IllegalArgumentException("pageNumber " + n + " out of bounds: 0 - " + (arrayList.size() - 1));
        }
        IFD iFD = (IFD)arrayList.get(n);
        IFD iFD2 = iFD.getChild(TiffTag.EXIF_SUB_IFD);
        IFD iFD3 = iFD.getChild(TiffTag.GPS_SUB_IFD);
        IFD iFD4 = exif.getImageIFD();
        IFD iFD5 = exif.getExifIFD();
        IFD iFD6 = exif.getGPSIFD();
        if (iFD4 != null) {
            Collection<TiffField<?>> collection = iFD4.getFields();
            for (TiffField<?> tiffField : collection) {
                Tag tag = TiffTag.fromShort(tiffField.getTag());
                if (iFD.getField(tag) != null && tag.isCritical()) {
                    throw new RuntimeException("Duplicate Tag: " + tag);
                }
                iFD.addField(tiffField);
            }
        }
        if (bl && iFD2 != null && iFD5 != null) {
            iFD2.addFields(iFD5.getFields());
            iFD5 = iFD2;
        }
        if (iFD5 != null) {
            iFD.addField(new LongField(TiffTag.EXIF_SUB_IFD.getValue(), new int[]{0}));
            iFD.addChild(TiffTag.EXIF_SUB_IFD, iFD5);
        }
        if (bl && iFD3 != null && iFD6 != null) {
            iFD3.addFields(iFD6.getFields());
            iFD6 = iFD3;
        }
        if (iFD6 != null) {
            iFD.addField(new LongField(TiffTag.GPS_SUB_IFD.getValue(), new int[]{0}));
            iFD.addChild(TiffTag.GPS_SUB_IFD, iFD6);
        }
        int n3 = 8;
        n3 = TIFFTweaker.copyPages(arrayList, n3, randomAccessInputStream, randomAccessOutputStream);
        int n4 = ((IFD)arrayList.get(0)).getStartOffset();
        TIFFTweaker.writeToStream(randomAccessOutputStream, n4);
    }

    public static void insertICCProfile(byte[] byArray, int n, RandomAccessInputStream randomAccessInputStream, RandomAccessOutputStream randomAccessOutputStream) throws IOException {
        int n2 = TIFFTweaker.copyHeader(randomAccessInputStream, randomAccessOutputStream);
        ArrayList<IFD> arrayList = new ArrayList<IFD>();
        TIFFTweaker.readIFDs(arrayList, n2, randomAccessInputStream);
        if (n < 0 || n >= arrayList.size()) {
            throw new IllegalArgumentException("pageNumber " + n + " out of bounds: 0 - " + (arrayList.size() - 1));
        }
        IFD iFD = (IFD)arrayList.get(n);
        iFD.addField(new UndefinedField(TiffTag.ICC_PROFILE.getValue(), byArray));
        n2 = TIFFTweaker.copyPages(arrayList, n2, randomAccessInputStream, randomAccessOutputStream);
        int n3 = ((IFD)arrayList.get(0)).getStartOffset();
        TIFFTweaker.writeToStream(randomAccessOutputStream, n3);
    }

    public static void insertICCProfile(ICC_Profile iCC_Profile, RandomAccessInputStream randomAccessInputStream, RandomAccessOutputStream randomAccessOutputStream) throws IOException {
        TIFFTweaker.insertICCProfile(iCC_Profile.getData(), 0, randomAccessInputStream, randomAccessOutputStream);
    }

    public static void insertICCProfile(ICC_Profile iCC_Profile, int n, RandomAccessInputStream randomAccessInputStream, RandomAccessOutputStream randomAccessOutputStream) throws IOException {
        TIFFTweaker.insertICCProfile(iCC_Profile.getData(), n, randomAccessInputStream, randomAccessOutputStream);
    }

    public static void insertIPTC(RandomAccessInputStream randomAccessInputStream, RandomAccessOutputStream randomAccessOutputStream, Collection<IPTCDataSet> collection, boolean bl) throws IOException {
        TIFFTweaker.insertIPTC(randomAccessInputStream, randomAccessOutputStream, 0, collection, bl);
    }

    public static void insertIPTC(RandomAccessInputStream randomAccessInputStream, RandomAccessOutputStream randomAccessOutputStream, int n, Collection<IPTCDataSet> collection, boolean bl) throws IOException {
        Object object;
        int n2 = TIFFTweaker.copyHeader(randomAccessInputStream, randomAccessOutputStream);
        ArrayList<IFD> arrayList = new ArrayList<IFD>();
        TIFFTweaker.readIFDs(arrayList, n2, randomAccessInputStream);
        if (n < 0 || n >= arrayList.size()) {
            throw new IllegalArgumentException("pageNumber " + n + " out of bounds: 0 - " + (arrayList.size() - 1));
        }
        IFD iFD = (IFD)arrayList.get(n);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        TiffField<?> tiffField = iFD.removeField(TiffTag.IPTC);
        TiffField<?> tiffField2 = iFD.getField(TiffTag.PHOTOSHOP);
        if (tiffField2 != null) {
            Object object2;
            object = new IRB((byte[])tiffField2.getData());
            HashMap<Short, _8BIM> hashMap = new HashMap<Short, _8BIM>(((IRB)object).get8BIM());
            _8BIM _8BIM2 = (_8BIM)hashMap.remove(ImageResourceID.IPTC_NAA.getValue());
            if (_8BIM2 != null && bl) {
                if (tiffField != null) {
                    object2 = null;
                    object2 = tiffField.getType() == FieldType.LONG ? (Object)ArrayUtils.toByteArray(tiffField.getDataAsLong(), randomAccessInputStream.getEndian() == 19789) : (Object)((byte[])tiffField.getData());
                    TIFFTweaker.copyIPTCDataSet(collection, (byte[])object2);
                }
                TIFFTweaker.copyIPTCDataSet(collection, _8BIM2.getData());
                collection = new ArrayList<IPTCDataSet>(new HashSet<IPTCDataSet>(collection));
            }
            for (IPTCDataSet object3 : collection) {
                object3.write(byteArrayOutputStream);
            }
            object2 = new _8BIM(ImageResourceID.IPTC_NAA, "iptc", byteArrayOutputStream.toByteArray());
            byteArrayOutputStream.reset();
            ((_8BIM)object2).write(byteArrayOutputStream);
            for (_8BIM _8BIM3 : hashMap.values()) {
                _8BIM3.write(byteArrayOutputStream);
            }
            iFD.addField(new UndefinedField(TiffTag.PHOTOSHOP.getValue(), byteArrayOutputStream.toByteArray()));
        } else {
            if (tiffField != null && bl) {
                object = null;
                object = tiffField.getType() == FieldType.LONG ? (Object)ArrayUtils.toByteArray(tiffField.getDataAsLong(), randomAccessInputStream.getEndian() == 19789) : (Object)((byte[])tiffField.getData());
                TIFFTweaker.copyIPTCDataSet(collection, (byte[])object);
            }
            for (IPTCDataSet iPTCDataSet : collection) {
                iPTCDataSet.write(byteArrayOutputStream);
            }
            iFD.addField(new UndefinedField(TiffTag.IPTC.getValue(), byteArrayOutputStream.toByteArray()));
        }
        n2 = TIFFTweaker.copyPages(arrayList, n2, randomAccessInputStream, randomAccessOutputStream);
        int n3 = ((IFD)arrayList.get(0)).getStartOffset();
        TIFFTweaker.writeToStream(randomAccessOutputStream, n3);
    }

    public static void insertIRB(RandomAccessInputStream randomAccessInputStream, RandomAccessOutputStream randomAccessOutputStream, Collection<_8BIM> collection, boolean bl) throws IOException {
        TIFFTweaker.insertIRB(randomAccessInputStream, randomAccessOutputStream, 0, collection, bl);
    }

    public static void insertIRB(RandomAccessInputStream randomAccessInputStream, RandomAccessOutputStream randomAccessOutputStream, int n, Collection<_8BIM> collection, boolean bl) throws IOException {
        Object object;
        int n2 = TIFFTweaker.copyHeader(randomAccessInputStream, randomAccessOutputStream);
        ArrayList<IFD> arrayList = new ArrayList<IFD>();
        TIFFTweaker.readIFDs(arrayList, n2, randomAccessInputStream);
        if (n < 0 || n >= arrayList.size()) {
            throw new IllegalArgumentException("pageNumber " + n + " out of bounds: 0 - " + (arrayList.size() - 1));
        }
        IFD iFD = (IFD)arrayList.get(n);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (bl && (object = iFD.getField(TiffTag.PHOTOSHOP)) != null) {
            IRB object2 = new IRB((byte[])((TiffField)object).getData());
            HashMap<Short, _8BIM> hashMap = new HashMap<Short, _8BIM>(object2.get8BIM());
            for (_8BIM _8BIM2 : collection) {
                hashMap.put(_8BIM2.getID(), _8BIM2);
            }
            if (hashMap.containsKey(ImageResourceID.THUMBNAIL_RESOURCE_PS4.getValue()) && hashMap.containsKey(ImageResourceID.THUMBNAIL_RESOURCE_PS5.getValue())) {
                hashMap.remove(ImageResourceID.THUMBNAIL_RESOURCE_PS4.getValue());
            }
            collection = hashMap.values();
        }
        for (_8BIM _8BIM3 : collection) {
            _8BIM3.write(byteArrayOutputStream);
        }
        iFD.addField(new UndefinedField(TiffTag.PHOTOSHOP.getValue(), byteArrayOutputStream.toByteArray()));
        n2 = TIFFTweaker.copyPages(arrayList, n2, randomAccessInputStream, randomAccessOutputStream);
        int n3 = ((IFD)arrayList.get(0)).getStartOffset();
        TIFFTweaker.writeToStream(randomAccessOutputStream, n3);
    }

    public static void insertMetadata(RandomAccessInputStream randomAccessInputStream, RandomAccessOutputStream randomAccessOutputStream, Collection<Metadata> collection) throws IOException {
        TIFFTweaker.insertMetadata(randomAccessInputStream, randomAccessOutputStream, 0, collection);
    }

    public static void insertMetadata(RandomAccessInputStream randomAccessInputStream, RandomAccessOutputStream randomAccessOutputStream, int n, Collection<Metadata> collection) throws IOException {
        Object object;
        Object object2;
        Object object3;
        TiffField<?> tiffField;
        Object object4;
        Iterator iterator;
        Object object5;
        Object object6;
        int n2 = TIFFTweaker.copyHeader(randomAccessInputStream, randomAccessOutputStream);
        ArrayList<IFD> arrayList = new ArrayList<IFD>();
        TIFFTweaker.readIFDs(arrayList, n2, randomAccessInputStream);
        if (n < 0 || n >= arrayList.size()) {
            throw new IllegalArgumentException("pageNumber " + n + " out of bounds: 0 - " + (arrayList.size() - 1));
        }
        IFD iFD = (IFD)arrayList.get(n);
        HashMap<MetadataType, Metadata> hashMap = new HashMap<MetadataType, Metadata>();
        Object object7 = collection.iterator();
        while (object7.hasNext()) {
            object6 = object7.next();
            hashMap.put(((Metadata)object6).getType(), (Metadata)object6);
        }
        if (hashMap.get((Object)MetadataType.IPTC) != null && (object7 = (IRB)hashMap.get((Object)MetadataType.PHOTOSHOP_IRB)) != null) {
            object6 = new HashMap<Short, _8BIM>(((IRB)object7).get8BIM());
            object6.remove(ImageResourceID.IPTC_NAA.getValue());
            object5 = new ByteArrayOutputStream();
            iterator = object6.values().iterator();
            while (iterator.hasNext()) {
                object4 = (_8BIM)iterator.next();
                ((_8BIM)object4).write((OutputStream)object5);
            }
            hashMap.put(MetadataType.PHOTOSHOP_IRB, new IRB(((ByteArrayOutputStream)object5).toByteArray()));
        }
        object7 = new ByteArrayOutputStream();
        object6 = (Exif)hashMap.remove((Object)MetadataType.EXIF);
        if (object6 != null) {
            object5 = ((Exif)object6).getImageIFD();
            iterator = ((Exif)object6).getExifIFD();
            object4 = ((Exif)object6).getGPSIFD();
            if (object5 != null) {
                tiffField = ((IFD)object5).getFields();
                object3 = tiffField.iterator();
                while (object3.hasNext()) {
                    object2 = object3.next();
                    object = TiffTag.fromShort(((TiffField)object2).getTag());
                    if (iFD.getField((Tag)object) != null && object.isCritical()) {
                        throw new RuntimeException("Duplicate Tag: " + object);
                    }
                    iFD.addField((TiffField<?>)object2);
                }
            }
            if (iterator != null) {
                iFD.addField(new LongField(TiffTag.EXIF_SUB_IFD.getValue(), new int[]{0}));
                iFD.addChild(TiffTag.EXIF_SUB_IFD, (IFD)((Object)iterator));
            }
            if (object4 != null) {
                iFD.addField(new LongField(TiffTag.GPS_SUB_IFD.getValue(), new int[]{0}));
                iFD.addChild(TiffTag.GPS_SUB_IFD, (IFD)object4);
            }
            n2 = 8;
        }
        if ((object5 = (XMP)hashMap.remove((Object)MetadataType.XMP)) != null) {
            iFD.addField(new UndefinedField(TiffTag.XMP.getValue(), ((XMP)object5).getData()));
        }
        if ((iterator = (ICCProfile)hashMap.remove((Object)MetadataType.ICC_PROFILE)) != null) {
            iFD.addField(new UndefinedField(TiffTag.ICC_PROFILE.getValue(), ((Metadata)((Object)iterator)).getData()));
        }
        if ((object4 = (IPTC)hashMap.remove((Object)MetadataType.IPTC)) != null) {
            iFD.removeField(TiffTag.IPTC);
            tiffField = iFD.getField(TiffTag.PHOTOSHOP);
            if (tiffField != null) {
                object3 = new IRB((byte[])tiffField.getData());
                object2 = new HashMap<Short, _8BIM>(((IRB)object3).get8BIM());
                object2.remove(ImageResourceID.IPTC_NAA.getValue());
                ((IPTC)object4).write((OutputStream)object7);
                object = new _8BIM(ImageResourceID.IPTC_NAA, "iptc", ((ByteArrayOutputStream)object7).toByteArray());
                ((ByteArrayOutputStream)object7).reset();
                ((_8BIM)object).write((OutputStream)object7);
                for (_8BIM _8BIM2 : object2.values()) {
                    _8BIM2.write((OutputStream)object7);
                }
                iFD.addField(new UndefinedField(TiffTag.PHOTOSHOP.getValue(), ((ByteArrayOutputStream)object7).toByteArray()));
            } else {
                ((ByteArrayOutputStream)object7).reset();
                ((IPTC)object4).write((OutputStream)object7);
                iFD.addField(new UndefinedField(TiffTag.IPTC.getValue(), ((ByteArrayOutputStream)object7).toByteArray()));
            }
        }
        if ((tiffField = (IRB)hashMap.remove((Object)MetadataType.PHOTOSHOP_IRB)) != null) {
            ((ByteArrayOutputStream)object7).reset();
            object3 = ((IRB)((Object)tiffField)).get8BIM().values().iterator();
            while (object3.hasNext()) {
                object2 = (_8BIM)object3.next();
                ((_8BIM)object2).write((OutputStream)object7);
            }
            iFD.addField(new UndefinedField(TiffTag.PHOTOSHOP.getValue(), ((ByteArrayOutputStream)object7).toByteArray()));
        }
        if ((object3 = (Comments)hashMap.remove((Object)MetadataType.COMMENT)) != null) {
            object2 = new StringBuilder();
            for (String string : ((Comments)object3).getComments()) {
                ((StringBuilder)object2).append(string);
                ((StringBuilder)object2).append('\u0000');
            }
            iFD.addField(new ASCIIField(TiffTag.IMAGE_DESCRIPTION.getValue(), ((StringBuilder)object2).toString()));
        }
        n2 = TIFFTweaker.copyPages(arrayList, n2, randomAccessInputStream, randomAccessOutputStream);
        int n3 = ((IFD)arrayList.get(0)).getStartOffset();
        TIFFTweaker.writeToStream(randomAccessOutputStream, n3);
    }

    public static int insertPage(BufferedImage bufferedImage, int n, RandomAccessOutputStream randomAccessOutputStream, List<IFD> list, int n2, TIFFWriter tIFFWriter) throws IOException {
        if (n < 0) {
            n = 0;
        } else if (n > list.size()) {
            n = list.size();
        }
        try {
            n2 = tIFFWriter.writePage(bufferedImage, n, list.size(), randomAccessOutputStream, n2);
            list.add(n, tIFFWriter.getIFD());
        }
        catch (Exception exception) {
            LOGGER.error("Failed inserting page " + n, (Throwable)exception);
            throw new PageWritingException("Failed inserting page " + n, exception);
        }
        return n2;
    }

    public static int insertPage(ImageFrame imageFrame, int n, RandomAccessOutputStream randomAccessOutputStream, List<IFD> list, int n2, TIFFWriter tIFFWriter) throws IOException {
        BufferedImage bufferedImage = imageFrame.getFrame();
        tIFFWriter.setImageParam(imageFrame.getFrameParam());
        return TIFFTweaker.insertPage(bufferedImage, n, randomAccessOutputStream, list, n2, tIFFWriter);
    }

    public static void insertPages(RandomAccessInputStream randomAccessInputStream, RandomAccessOutputStream randomAccessOutputStream, int n, BufferedImage ... bufferedImageArray) throws IOException {
        TIFFTweaker.insertPages(randomAccessInputStream, randomAccessOutputStream, n, null, bufferedImageArray);
    }

    public static void insertPages(RandomAccessInputStream randomAccessInputStream, RandomAccessOutputStream randomAccessOutputStream, int n, ImageFrame ... imageFrameArray) throws IOException {
        int n2;
        randomAccessInputStream.seek(0L);
        int n3 = TIFFTweaker.copyHeader(randomAccessInputStream, randomAccessOutputStream);
        ArrayList<IFD> arrayList = new ArrayList<IFD>();
        ArrayList<IFD> arrayList2 = new ArrayList<IFD>(imageFrameArray.length);
        TIFFTweaker.readIFDs(arrayList, n3, randomAccessInputStream);
        if (n < 0) {
            n = 0;
        } else if (n > arrayList.size()) {
            n = arrayList.size();
        }
        int n4 = n;
        int n5 = arrayList.size() + imageFrameArray.length;
        int n6 = 8;
        TIFFWriter tIFFWriter = new TIFFWriter();
        for (n2 = 0; n2 < imageFrameArray.length; ++n2) {
            BufferedImage bufferedImage = imageFrameArray[n2].getFrame();
            ImageParam imageParam = imageFrameArray[n2].getFrameParam();
            try {
                tIFFWriter.setImageParam(imageParam);
                n6 = tIFFWriter.writePage(bufferedImage, n++, n5, randomAccessOutputStream, n6);
                arrayList2.add(tIFFWriter.getIFD());
                continue;
            }
            catch (Exception exception) {
                LOGGER.error("Failed inserting page " + n, (Throwable)exception);
                throw new PageWritingException("Failed inserting page " + n, exception);
            }
        }
        for (n2 = 0; n2 < n4; ++n2) {
            ((IFD)arrayList.get(n2)).removeField(TiffTag.PAGE_NUMBER);
            ((IFD)arrayList.get(n2)).addField(new ShortField(TiffTag.PAGE_NUMBER.getValue(), new short[]{(short)n2, (short)n5}));
        }
        for (n2 = n4; n2 < arrayList.size(); ++n2) {
            ((IFD)arrayList.get(n2)).removeField(TiffTag.PAGE_NUMBER);
            ((IFD)arrayList.get(n2)).addField(new ShortField(TiffTag.PAGE_NUMBER.getValue(), new short[]{(short)(n2 + imageFrameArray.length), (short)n5}));
        }
        if (arrayList.size() == 1) {
            if (((IFD)arrayList.get(0)).removeField(TiffTag.SUBFILE_TYPE) == null) {
                ((IFD)arrayList.get(0)).removeField(TiffTag.NEW_SUBFILE_TYPE);
            }
            ((IFD)arrayList.get(0)).addField(new ShortField(TiffTag.SUBFILE_TYPE.getValue(), new short[]{3}));
        }
        n6 = TIFFTweaker.copyPages(arrayList, n6, randomAccessInputStream, randomAccessOutputStream);
        for (n2 = 0; n2 < imageFrameArray.length - 1; ++n2) {
            ((IFD)arrayList2.get(n2)).setNextIFDOffset(randomAccessOutputStream, ((IFD)arrayList2.get(n2 + 1)).getStartOffset());
        }
        if (n4 != 0) {
            ((IFD)arrayList.get(n4 - 1)).setNextIFDOffset(randomAccessOutputStream, ((IFD)arrayList2.get(0)).getStartOffset());
        }
        if (n4 != arrayList.size()) {
            ((IFD)arrayList2.get(arrayList2.size() - 1)).setNextIFDOffset(randomAccessOutputStream, ((IFD)arrayList.get(n4)).getStartOffset());
        }
        n2 = 0;
        n2 = n4 == 0 ? ((IFD)arrayList2.get(0)).getStartOffset() : ((IFD)arrayList.get(0)).getStartOffset();
        TIFFTweaker.writeToStream(randomAccessOutputStream, n2);
    }

    public static void insertPages(RandomAccessInputStream randomAccessInputStream, RandomAccessOutputStream randomAccessOutputStream, int n, ImageParam[] imageParamArray, BufferedImage ... bufferedImageArray) throws IOException {
        int n2;
        randomAccessInputStream.seek(0L);
        int n3 = TIFFTweaker.copyHeader(randomAccessInputStream, randomAccessOutputStream);
        ArrayList<IFD> arrayList = new ArrayList<IFD>();
        ArrayList<IFD> arrayList2 = new ArrayList<IFD>(bufferedImageArray.length);
        TIFFTweaker.readIFDs(arrayList, n3, randomAccessInputStream);
        if (n < 0) {
            n = 0;
        } else if (n > arrayList.size()) {
            n = arrayList.size();
        }
        int n4 = n;
        int n5 = arrayList.size() + bufferedImageArray.length;
        int n6 = 8;
        Object[] objectArray = null;
        if (imageParamArray == null) {
            objectArray = new ImageParam[bufferedImageArray.length];
            Arrays.fill(objectArray, ImageParam.DEFAULT_IMAGE_PARAM);
        } else if (bufferedImageArray.length > imageParamArray.length && imageParamArray.length > 0) {
            objectArray = new ImageParam[bufferedImageArray.length];
            System.arraycopy(imageParamArray, 0, objectArray, 0, imageParamArray.length);
            Arrays.fill(objectArray, imageParamArray.length, bufferedImageArray.length, imageParamArray[imageParamArray.length - 1]);
        } else {
            objectArray = imageParamArray;
        }
        TIFFWriter tIFFWriter = new TIFFWriter();
        for (n2 = 0; n2 < bufferedImageArray.length; ++n2) {
            try {
                tIFFWriter.setImageParam((ImageParam)objectArray[n2]);
                n6 = tIFFWriter.writePage(bufferedImageArray[n2], n++, n5, randomAccessOutputStream, n6);
                arrayList2.add(tIFFWriter.getIFD());
                continue;
            }
            catch (Exception exception) {
                LOGGER.error("Failed inserting page " + n, (Throwable)exception);
                throw new PageWritingException("Failed inserting page " + n, exception);
            }
        }
        for (n2 = 0; n2 < n4; ++n2) {
            ((IFD)arrayList.get(n2)).removeField(TiffTag.PAGE_NUMBER);
            ((IFD)arrayList.get(n2)).addField(new ShortField(TiffTag.PAGE_NUMBER.getValue(), new short[]{(short)n2, (short)n5}));
        }
        for (n2 = n4; n2 < arrayList.size(); ++n2) {
            ((IFD)arrayList.get(n2)).removeField(TiffTag.PAGE_NUMBER);
            ((IFD)arrayList.get(n2)).addField(new ShortField(TiffTag.PAGE_NUMBER.getValue(), new short[]{(short)(n2 + bufferedImageArray.length), (short)n5}));
        }
        if (arrayList.size() == 1) {
            if (((IFD)arrayList.get(0)).removeField(TiffTag.SUBFILE_TYPE) == null) {
                ((IFD)arrayList.get(0)).removeField(TiffTag.NEW_SUBFILE_TYPE);
            }
            ((IFD)arrayList.get(0)).addField(new ShortField(TiffTag.SUBFILE_TYPE.getValue(), new short[]{3}));
        }
        n6 = TIFFTweaker.copyPages(arrayList, n6, randomAccessInputStream, randomAccessOutputStream);
        for (n2 = 0; n2 < bufferedImageArray.length - 1; ++n2) {
            ((IFD)arrayList2.get(n2)).setNextIFDOffset(randomAccessOutputStream, ((IFD)arrayList2.get(n2 + 1)).getStartOffset());
        }
        if (n4 != 0) {
            ((IFD)arrayList.get(n4 - 1)).setNextIFDOffset(randomAccessOutputStream, ((IFD)arrayList2.get(0)).getStartOffset());
        }
        if (n4 != arrayList.size()) {
            ((IFD)arrayList2.get(arrayList2.size() - 1)).setNextIFDOffset(randomAccessOutputStream, ((IFD)arrayList.get(n4)).getStartOffset());
        }
        n2 = 0;
        n2 = n4 == 0 ? ((IFD)arrayList2.get(0)).getStartOffset() : ((IFD)arrayList.get(0)).getStartOffset();
        TIFFTweaker.writeToStream(randomAccessOutputStream, n2);
    }

    public static void insertThumbnail(RandomAccessInputStream randomAccessInputStream, RandomAccessOutputStream randomAccessOutputStream, BufferedImage bufferedImage) throws IOException {
        if (bufferedImage == null) {
            throw new IllegalArgumentException("Input thumbnail is null");
        }
        ThumbnailResource thumbnailResource = new ThumbnailResource(bufferedImage);
        TIFFTweaker.insertIRB(randomAccessInputStream, randomAccessOutputStream, Arrays.asList(thumbnailResource), true);
    }

    public static void insertTiffImage(File file, File file2, int n, File file3) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        FileInputStream fileInputStream2 = new FileInputStream(file2);
        FileOutputStream fileOutputStream = new FileOutputStream(file3);
        FileCacheRandomAccessInputStream fileCacheRandomAccessInputStream = new FileCacheRandomAccessInputStream(fileInputStream);
        FileCacheRandomAccessInputStream fileCacheRandomAccessInputStream2 = new FileCacheRandomAccessInputStream(fileInputStream2);
        FileCacheRandomAccessOutputStream fileCacheRandomAccessOutputStream = new FileCacheRandomAccessOutputStream(fileOutputStream);
        TIFFTweaker.insertTiffImage(fileCacheRandomAccessInputStream, fileCacheRandomAccessInputStream2, n, fileCacheRandomAccessOutputStream);
        ((InputStream)fileCacheRandomAccessInputStream).close();
        ((InputStream)fileCacheRandomAccessInputStream2).close();
        ((RandomAccessOutputStream)fileCacheRandomAccessOutputStream).close();
    }

    public static void insertTiffImage(RandomAccessInputStream randomAccessInputStream, RandomAccessInputStream randomAccessInputStream2, int n, RandomAccessOutputStream randomAccessOutputStream) throws IOException {
        int n2;
        int n3;
        ArrayList<IFD> arrayList = new ArrayList<IFD>();
        int n4 = TIFFTweaker.copyHeader(randomAccessInputStream, randomAccessOutputStream);
        TIFFTweaker.readIFDs(arrayList, n4, randomAccessInputStream);
        if (n < 0) {
            n = 0;
        } else if (n > arrayList.size()) {
            n = arrayList.size();
        }
        for (n3 = 0; n3 < arrayList.size(); ++n3) {
            ((IFD)arrayList.get(n3)).removeField(TiffTag.PAGE_NUMBER);
            ((IFD)arrayList.get(n3)).addField(new ShortField(TiffTag.PAGE_NUMBER.getValue(), new short[]{0, 0}));
        }
        n3 = TIFFTweaker.copyPages(arrayList, 8, randomAccessInputStream, randomAccessOutputStream);
        short s = randomAccessOutputStream.getEndian();
        ArrayList<IFD> arrayList2 = new ArrayList<IFD>();
        TIFFTweaker.readIFDs(arrayList2, randomAccessInputStream2);
        for (int i = 0; i < arrayList2.size(); ++i) {
            ((IFD)arrayList2.get(i)).removeField(TiffTag.PAGE_NUMBER);
            ((IFD)arrayList2.get(i)).addField(new ShortField(TiffTag.PAGE_NUMBER.getValue(), new short[]{0, 0}));
        }
        ArrayList<IFD> arrayList3 = new ArrayList<IFD>(arrayList.size() + arrayList2.size());
        short s2 = randomAccessInputStream2.getEndian();
        if (s2 == s) {
            n3 = TIFFTweaker.copyPages(arrayList2, n3, randomAccessInputStream2, randomAccessOutputStream);
        } else {
            IFD iFD = null;
            for (n2 = 0; n2 < arrayList2.size(); ++n2) {
                TiffField<?> tiffField;
                IFD iFD2 = (IFD)arrayList2.get(n2);
                int n5 = 1;
                TiffField<?> tiffField2 = iFD2.getField(TiffTag.BITS_PER_SAMPLE);
                if (tiffField2 != null) {
                    n5 = tiffField2.getDataAsLong()[0];
                }
                if (n5 <= 8) {
                    n3 = TIFFTweaker.copyPageData(iFD2, n3, randomAccessInputStream2, randomAccessOutputStream);
                    continue;
                }
                if (n5 % 8 != 0) continue;
                ImageDecoder imageDecoder = null;
                ImageEncoder imageEncoder = null;
                LongField longField = iFD2.removeField(TiffTag.STRIP_OFFSETS);
                if (longField == null) {
                    longField = iFD2.removeField(TiffTag.TILE_OFFSETS);
                }
                if ((tiffField = iFD2.getField(TiffTag.STRIP_BYTE_COUNTS)) == null) {
                    tiffField = iFD2.getField(TiffTag.TILE_BYTE_COUNTS);
                }
                if (longField != null) {
                    int n6;
                    int[] nArray = tiffField.getDataAsLong();
                    int[] nArray2 = ((TiffField)longField).getDataAsLong();
                    int[] nArray3 = new int[nArray2.length];
                    int[] nArray4 = TIFFTweaker.getUncompressedStripByteCounts(iFD2, nArray2.length);
                    randomAccessOutputStream.seek(n3);
                    TiffField<?> tiffField3 = iFD2.getField(TiffTag.COMPRESSION);
                    int n7 = 1;
                    if (tiffField3 != null) {
                        n7 = tiffField3.getDataAsLong()[0];
                    }
                    TiffFieldEnum.Compression compression = TiffFieldEnum.Compression.fromValue(n7);
                    int n8 = 1;
                    tiffField3 = iFD2.getField(TiffTag.SAMPLES_PER_PIXEL);
                    if (tiffField3 != null) {
                        n8 = tiffField3.getDataAsLong()[0];
                    }
                    int n9 = 1;
                    tiffField3 = iFD2.getField(TiffTag.PLANAR_CONFIGURATTION);
                    if (tiffField3 != null) {
                        n9 = tiffField3.getDataAsLong()[0];
                    }
                    int n10 = TIFFTweaker.getRowWidth(iFD2);
                    if (n9 == 1) {
                        n10 *= n8;
                    }
                    switch (compression) {
                        case LZW: {
                            imageDecoder = new LZWTreeDecoder(8, true);
                            imageEncoder = new LZWTreeEncoder(randomAccessOutputStream, 8, 4096, null);
                            break;
                        }
                        case DEFLATE: 
                        case DEFLATE_ADOBE: {
                            imageDecoder = new DeflateDecoder();
                            imageEncoder = new DeflateEncoder(randomAccessOutputStream, 4096, 4, null);
                            break;
                        }
                        case PACKBITS: {
                            for (n6 = 0; n6 < nArray2.length; ++n6) {
                                randomAccessInputStream2.seek(nArray2[n6]);
                                byte[] byArray = new byte[nArray[n6]];
                                randomAccessInputStream2.readFully(byArray);
                                byte[] byArray2 = new byte[nArray4[n6]];
                                Packbits.unpackbits(byArray, byArray2);
                                ArrayUtils.flipEndian(byArray2, 0, byArray2.length, n5, n10, s2 == 19789);
                                byArray2 = new byte[byArray.length + (byArray.length + 127) / 128];
                                int n11 = Packbits.packbits(byArray, byArray2);
                                randomAccessOutputStream.write(byArray2, 0, n11);
                                nArray3[n6] = n3;
                                n3 += n11;
                            }
                            break;
                        }
                        case NONE: {
                            if (n9 == 1 && nArray2.length == 1 || n9 == 2 && nArray2.length == n8) {
                                int[] nArray5 = TIFFTweaker.getBytes2Read(iFD2);
                                for (int i = 0; i < nArray2.length; ++i) {
                                    nArray[i] = nArray5[i];
                                }
                            }
                            for (n6 = 0; n6 < nArray2.length; ++n6) {
                                randomAccessInputStream2.seek(nArray2[n6]);
                                byte[] byArray = new byte[nArray[n6]];
                                randomAccessInputStream2.readFully(byArray);
                                byArray = ArrayUtils.flipEndian(byArray, 0, byArray.length, n5, n10, s2 == 19789);
                                randomAccessOutputStream.write(byArray);
                                nArray3[n6] = n3;
                                n3 += byArray.length;
                            }
                            break;
                        }
                        default: {
                            for (n6 = 0; n6 < nArray2.length; ++n6) {
                                randomAccessInputStream2.seek(nArray2[n6]);
                                byte[] byArray = new byte[nArray[n6]];
                                randomAccessInputStream2.readFully(byArray);
                                randomAccessOutputStream.write(byArray);
                                nArray3[n6] = n3;
                                n3 += byArray.length;
                            }
                        }
                    }
                    if (imageDecoder != null) {
                        for (n6 = 0; n6 < nArray2.length; ++n6) {
                            randomAccessInputStream2.seek(nArray2[n6]);
                            byte[] byArray = new byte[nArray[n6]];
                            randomAccessInputStream2.readFully(byArray);
                            imageDecoder.setInput(byArray);
                            int n12 = 0;
                            byte[] byArray3 = new byte[nArray4[n6]];
                            try {
                                n12 = imageDecoder.decode(byArray3, 0, nArray4[n6]);
                            }
                            catch (Exception exception) {
                                LOGGER.error("Failed decoding image", (Throwable)exception);
                                throw new CodecException("Failed decoding image", exception);
                            }
                            byArray = ArrayUtils.flipEndian(byArray3, 0, n12, n5, n10, s2 == 19789);
                            try {
                                imageEncoder.initialize();
                                imageEncoder.encode(byArray, 0, byArray.length);
                                imageEncoder.finish();
                            }
                            catch (Exception exception) {
                                LOGGER.error("Failed encoding image", (Throwable)exception);
                                throw new CodecException("Failed encoding image", exception);
                            }
                            nArray3[n6] = n3;
                            n3 += imageEncoder.getCompressedDataLen();
                        }
                    }
                    longField = iFD2.getField(TiffTag.STRIP_BYTE_COUNTS) != null ? new LongField(TiffTag.STRIP_OFFSETS.getValue(), nArray3) : new LongField(TiffTag.TILE_OFFSETS.getValue(), nArray3);
                    iFD2.addField(longField);
                } else {
                    n3 = TIFFTweaker.copyPageData(iFD2, n3, randomAccessInputStream2, randomAccessOutputStream);
                }
                if (iFD != null) {
                    iFD.setNextIFDOffset(randomAccessOutputStream, n3);
                }
                n3 = iFD2.write(randomAccessOutputStream, n3);
                iFD = iFD2;
            }
        }
        if (n == 0) {
            ((IFD)arrayList2.get(arrayList2.size() - 1)).setNextIFDOffset(randomAccessOutputStream, ((IFD)arrayList.get(0)).getStartOffset());
            arrayList3.addAll(arrayList2);
            arrayList3.addAll(arrayList);
        } else if (n == arrayList.size()) {
            ((IFD)arrayList.get(arrayList.size() - 1)).setNextIFDOffset(randomAccessOutputStream, ((IFD)arrayList2.get(0)).getStartOffset());
            arrayList3.addAll(arrayList);
            arrayList3.addAll(arrayList2);
        } else {
            ((IFD)arrayList.get(n - 1)).setNextIFDOffset(randomAccessOutputStream, ((IFD)arrayList2.get(0)).getStartOffset());
            ((IFD)arrayList2.get(arrayList2.size() - 1)).setNextIFDOffset(randomAccessOutputStream, ((IFD)arrayList.get(n)).getStartOffset());
            arrayList3.addAll(arrayList.subList(0, n));
            arrayList3.addAll(arrayList2);
            arrayList3.addAll(arrayList.subList(n, arrayList.size()));
        }
        int n13 = arrayList3.size();
        for (n2 = 0; n2 < n13; ++n2) {
            n3 = ((IFD)arrayList3.get(n2)).getField(TiffTag.PAGE_NUMBER).getDataOffset();
            randomAccessOutputStream.seek(n3);
            randomAccessOutputStream.writeShort((short)n2);
            randomAccessOutputStream.writeShort((short)n13);
        }
        n2 = ((IFD)arrayList3.get(0)).getStartOffset();
        TIFFTweaker.writeToStream(randomAccessOutputStream, n2);
    }

    public static void insertXMP(XMP xMP, RandomAccessInputStream randomAccessInputStream, RandomAccessOutputStream randomAccessOutputStream) throws IOException {
        TIFFTweaker.insertXMP(xMP.getData(), randomAccessInputStream, randomAccessOutputStream);
    }

    public static void insertXMP(XMP xMP, int n, RandomAccessInputStream randomAccessInputStream, RandomAccessOutputStream randomAccessOutputStream) throws IOException {
        TIFFTweaker.insertXMP(xMP.getData(), n, randomAccessInputStream, randomAccessOutputStream);
    }

    public static void insertXMP(byte[] byArray, RandomAccessInputStream randomAccessInputStream, RandomAccessOutputStream randomAccessOutputStream) throws IOException {
        TIFFTweaker.insertXMP(byArray, 0, randomAccessInputStream, randomAccessOutputStream);
    }

    public static void insertXMP(byte[] byArray, int n, RandomAccessInputStream randomAccessInputStream, RandomAccessOutputStream randomAccessOutputStream) throws IOException {
        int n2 = TIFFTweaker.copyHeader(randomAccessInputStream, randomAccessOutputStream);
        ArrayList<IFD> arrayList = new ArrayList<IFD>();
        TIFFTweaker.readIFDs(arrayList, n2, randomAccessInputStream);
        if (n < 0 || n >= arrayList.size()) {
            throw new IllegalArgumentException("pageNumber " + n + " out of bounds: 0 - " + (arrayList.size() - 1));
        }
        IFD iFD = (IFD)arrayList.get(n);
        iFD.addField(new UndefinedField(TiffTag.XMP.getValue(), byArray));
        n2 = TIFFTweaker.copyPages(arrayList, n2, randomAccessInputStream, randomAccessOutputStream);
        int n3 = ((IFD)arrayList.get(0)).getStartOffset();
        TIFFTweaker.writeToStream(randomAccessOutputStream, n3);
    }

    public static void insertXMP(String string, RandomAccessInputStream randomAccessInputStream, RandomAccessOutputStream randomAccessOutputStream) throws IOException {
        Document document = XMLUtils.createXML(string);
        XMLUtils.insertLeadingPI(document, "xpacket", "begin='' id='W5M0MpCehiHzreSzNTczkc9d'");
        XMLUtils.insertTrailingPI(document, "xpacket", "end='r'");
        byte[] byArray = XMLUtils.serializeToByteArray(document);
        TIFFTweaker.insertXMP(byArray, randomAccessInputStream, randomAccessOutputStream);
    }

    private static <E> void merge(RandomAccessOutputStream randomAccessOutputStream, RandomInputStreamAdaptor<E> randomInputStreamAdaptor) throws IOException {
        if (randomInputStreamAdaptor.hasNext()) {
            int n;
            RandomAccessInputStream randomAccessInputStream = (RandomAccessInputStream)randomInputStreamAdaptor.next();
            ArrayList<IFD> arrayList = new ArrayList<IFD>();
            int n2 = TIFFTweaker.copyHeader(randomAccessInputStream, randomAccessOutputStream);
            TIFFTweaker.readIFDs(arrayList, n2, randomAccessInputStream);
            for (n = 0; n < arrayList.size(); ++n) {
                ((IFD)arrayList.get(n)).removeField(TiffTag.PAGE_NUMBER);
                ((IFD)arrayList.get(n)).addField(new ShortField(TiffTag.PAGE_NUMBER.getValue(), new short[]{0, 0}));
            }
            n = TIFFTweaker.copyPages(arrayList, 8, randomAccessInputStream, randomAccessOutputStream);
            randomAccessInputStream.close();
            short s = randomAccessOutputStream.getEndian();
            while (randomInputStreamAdaptor.hasNext()) {
                int n3;
                ArrayList<IFD> arrayList2 = new ArrayList<IFD>();
                RandomAccessInputStream randomAccessInputStream2 = (RandomAccessInputStream)randomInputStreamAdaptor.next();
                TIFFTweaker.readIFDs(arrayList2, randomAccessInputStream2);
                for (n3 = 0; n3 < arrayList2.size(); ++n3) {
                    ((IFD)arrayList2.get(n3)).removeField(TiffTag.PAGE_NUMBER);
                    ((IFD)arrayList2.get(n3)).addField(new ShortField(TiffTag.PAGE_NUMBER.getValue(), new short[]{0, 0}));
                }
                n3 = randomAccessInputStream2.getEndian();
                if (n3 == s) {
                    n = TIFFTweaker.copyPages(arrayList2, n, randomAccessInputStream2, randomAccessOutputStream);
                } else {
                    IFD iFD = null;
                    for (int i = 0; i < arrayList2.size(); ++i) {
                        IFD iFD2 = (IFD)arrayList2.get(i);
                        int n4 = 1;
                        TiffField<?> tiffField = iFD2.getField(TiffTag.BITS_PER_SAMPLE);
                        if (tiffField != null) {
                            n4 = tiffField.getDataAsLong()[0];
                        }
                        if (n4 <= 8) {
                            n = TIFFTweaker.copyPageData(iFD2, n, randomAccessInputStream2, randomAccessOutputStream);
                        } else if (n4 % 8 == 0) {
                            TiffField<?> tiffField2;
                            ImageDecoder imageDecoder = null;
                            ImageEncoder imageEncoder = null;
                            LongField longField = iFD2.removeField(TiffTag.STRIP_OFFSETS);
                            if (longField == null) {
                                longField = iFD2.removeField(TiffTag.TILE_OFFSETS);
                            }
                            if ((tiffField2 = iFD2.getField(TiffTag.STRIP_BYTE_COUNTS)) == null) {
                                tiffField2 = iFD2.getField(TiffTag.TILE_BYTE_COUNTS);
                            }
                            if (longField != null) {
                                int n5;
                                int[] nArray = tiffField2.getDataAsLong();
                                int[] nArray2 = ((TiffField)longField).getDataAsLong();
                                int[] nArray3 = new int[nArray2.length];
                                int[] nArray4 = TIFFTweaker.getUncompressedStripByteCounts(iFD2, nArray2.length);
                                randomAccessOutputStream.seek(n);
                                TiffField<?> tiffField3 = iFD2.getField(TiffTag.COMPRESSION);
                                int n6 = 1;
                                if (tiffField3 != null) {
                                    n6 = tiffField3.getDataAsLong()[0];
                                }
                                TiffFieldEnum.Compression compression = TiffFieldEnum.Compression.fromValue(n6);
                                int n7 = 1;
                                tiffField3 = iFD2.getField(TiffTag.SAMPLES_PER_PIXEL);
                                if (tiffField3 != null) {
                                    n7 = tiffField3.getDataAsLong()[0];
                                }
                                int n8 = 1;
                                tiffField3 = iFD2.getField(TiffTag.PLANAR_CONFIGURATTION);
                                if (tiffField3 != null) {
                                    n8 = tiffField3.getDataAsLong()[0];
                                }
                                int n9 = TIFFTweaker.getRowWidth(iFD2);
                                if (n8 == 1) {
                                    n9 *= n7;
                                }
                                switch (compression) {
                                    case LZW: {
                                        imageDecoder = new LZWTreeDecoder(8, true);
                                        imageEncoder = new LZWTreeEncoder(randomAccessOutputStream, 8, 4096, null);
                                        break;
                                    }
                                    case DEFLATE: 
                                    case DEFLATE_ADOBE: {
                                        imageDecoder = new DeflateDecoder();
                                        imageEncoder = new DeflateEncoder(randomAccessOutputStream, 4096, 4, null);
                                        break;
                                    }
                                    case PACKBITS: {
                                        for (n5 = 0; n5 < nArray2.length; ++n5) {
                                            randomAccessInputStream2.seek(nArray2[n5]);
                                            byte[] byArray = new byte[nArray[n5]];
                                            randomAccessInputStream2.readFully(byArray);
                                            byte[] byArray2 = new byte[nArray4[n5]];
                                            Packbits.unpackbits(byArray, byArray2);
                                            ArrayUtils.flipEndian(byArray2, 0, byArray2.length, n4, n9, n3 == 19789);
                                            byArray2 = new byte[byArray.length + (byArray.length + 127) / 128];
                                            int n10 = Packbits.packbits(byArray, byArray2);
                                            randomAccessOutputStream.write(byArray2, 0, n10);
                                            nArray3[n5] = n;
                                            n += n10;
                                        }
                                        break;
                                    }
                                    case NONE: {
                                        if (n8 == 1 && nArray2.length == 1 || n8 == 2 && nArray2.length == n7) {
                                            int[] nArray5 = TIFFTweaker.getBytes2Read(iFD2);
                                            for (int j = 0; j < nArray2.length; ++j) {
                                                nArray[j] = nArray5[j];
                                            }
                                        }
                                        for (n5 = 0; n5 < nArray2.length; ++n5) {
                                            randomAccessInputStream2.seek(nArray2[n5]);
                                            byte[] byArray = new byte[nArray[n5]];
                                            randomAccessInputStream2.readFully(byArray);
                                            byArray = ArrayUtils.flipEndian(byArray, 0, byArray.length, n4, n9, n3 == 19789);
                                            randomAccessOutputStream.write(byArray);
                                            nArray3[n5] = n;
                                            n += byArray.length;
                                        }
                                        break;
                                    }
                                    default: {
                                        for (n5 = 0; n5 < nArray2.length; ++n5) {
                                            randomAccessInputStream2.seek(nArray2[n5]);
                                            byte[] byArray = new byte[nArray[n5]];
                                            randomAccessInputStream2.readFully(byArray);
                                            randomAccessOutputStream.write(byArray);
                                            nArray3[n5] = n;
                                            n += byArray.length;
                                        }
                                    }
                                }
                                if (imageDecoder != null) {
                                    for (n5 = 0; n5 < nArray2.length; ++n5) {
                                        randomAccessInputStream2.seek(nArray2[n5]);
                                        byte[] byArray = new byte[nArray[n5]];
                                        randomAccessInputStream2.readFully(byArray);
                                        imageDecoder.setInput(byArray);
                                        int n11 = 0;
                                        byte[] byArray3 = new byte[nArray4[n5]];
                                        try {
                                            n11 = imageDecoder.decode(byArray3, 0, nArray4[n5]);
                                        }
                                        catch (Exception exception) {
                                            LOGGER.error("Failed decoding image", (Throwable)exception);
                                            throw new CodecException("Failed decoding image", exception);
                                        }
                                        byArray = ArrayUtils.flipEndian(byArray3, 0, n11, n4, n9, n3 == 19789);
                                        try {
                                            imageEncoder.initialize();
                                            imageEncoder.encode(byArray, 0, byArray.length);
                                            imageEncoder.finish();
                                        }
                                        catch (Exception exception) {
                                            LOGGER.error("Failed encoding image", (Throwable)exception);
                                            throw new CodecException("Failed encoding image", exception);
                                        }
                                        nArray3[n5] = n;
                                        n += imageEncoder.getCompressedDataLen();
                                    }
                                }
                                longField = iFD2.getField(TiffTag.STRIP_BYTE_COUNTS) != null ? new LongField(TiffTag.STRIP_OFFSETS.getValue(), nArray3) : new LongField(TiffTag.TILE_OFFSETS.getValue(), nArray3);
                                iFD2.addField(longField);
                            }
                        } else {
                            n = TIFFTweaker.copyPageData(iFD2, n, randomAccessInputStream2, randomAccessOutputStream);
                        }
                        if (iFD != null) {
                            iFD.setNextIFDOffset(randomAccessOutputStream, n);
                        }
                        n = iFD2.write(randomAccessOutputStream, n);
                        iFD = iFD2;
                    }
                }
                ((IFD)arrayList.get(arrayList.size() - 1)).setNextIFDOffset(randomAccessOutputStream, ((IFD)arrayList2.get(0)).getStartOffset());
                arrayList.addAll(arrayList2);
                randomAccessInputStream2.close();
            }
            int n12 = arrayList.size();
            if (n12 > 0) {
                int n13;
                for (n13 = 0; n13 < arrayList.size(); ++n13) {
                    n = ((IFD)arrayList.get(n13)).getField(TiffTag.PAGE_NUMBER).getDataOffset();
                    randomAccessOutputStream.seek(n);
                    randomAccessOutputStream.writeShort((short)n13);
                    randomAccessOutputStream.writeShort((short)n12);
                }
                n13 = ((IFD)arrayList.get(0)).getStartOffset();
                TIFFTweaker.writeToStream(randomAccessOutputStream, n13);
            }
        }
    }

    public static void mergeTiffImages(RandomAccessInputStream randomAccessInputStream, RandomAccessInputStream randomAccessInputStream2, RandomAccessOutputStream randomAccessOutputStream) throws IOException {
        int n;
        int n2 = TIFFTweaker.copyHeader(randomAccessInputStream, randomAccessOutputStream);
        int n3 = TIFFTweaker.readHeader(randomAccessInputStream2);
        ArrayList<IFD> arrayList = new ArrayList<IFD>();
        ArrayList<IFD> arrayList2 = new ArrayList<IFD>();
        TIFFTweaker.readIFDs(arrayList, n2, randomAccessInputStream);
        TIFFTweaker.readIFDs(arrayList2, n3, randomAccessInputStream2);
        int n4 = arrayList.size() + arrayList2.size();
        for (n = 0; n < arrayList.size(); ++n) {
            ((IFD)arrayList.get(n)).removeField(TiffTag.PAGE_NUMBER);
            ((IFD)arrayList.get(n)).addField(new ShortField(TiffTag.PAGE_NUMBER.getValue(), new short[]{(short)n, (short)n4}));
        }
        for (n = 0; n < arrayList2.size(); ++n) {
            ((IFD)arrayList2.get(n)).removeField(TiffTag.PAGE_NUMBER);
            ((IFD)arrayList2.get(n)).addField(new ShortField(TiffTag.PAGE_NUMBER.getValue(), new short[]{(short)(n + arrayList.size()), (short)n4}));
        }
        n = TIFFTweaker.copyPages(arrayList, 8, randomAccessInputStream, randomAccessOutputStream);
        n = TIFFTweaker.copyPages(arrayList2, n, randomAccessInputStream2, randomAccessOutputStream);
        ((IFD)arrayList.get(arrayList.size() - 1)).setNextIFDOffset(randomAccessOutputStream, ((IFD)arrayList2.get(0)).getStartOffset());
        int n5 = ((IFD)arrayList.get(0)).getStartOffset();
        TIFFTweaker.writeToStream(randomAccessOutputStream, n5);
    }

    public static void mergeTiffImages(RandomAccessOutputStream randomAccessOutputStream, File ... fileArray) throws IOException {
        if (fileArray != null && fileArray.length > 1) {
            int n;
            int n2;
            int n3;
            FileInputStream fileInputStream = new FileInputStream(fileArray[0]);
            FileCacheRandomAccessInputStream fileCacheRandomAccessInputStream = new FileCacheRandomAccessInputStream(fileInputStream);
            ArrayList<IFD> arrayList = new ArrayList<IFD>();
            int n4 = TIFFTweaker.copyHeader(fileCacheRandomAccessInputStream, randomAccessOutputStream);
            TIFFTweaker.readIFDs(arrayList, n4, fileCacheRandomAccessInputStream);
            for (n3 = 0; n3 < arrayList.size(); ++n3) {
                ((IFD)arrayList.get(n3)).removeField(TiffTag.PAGE_NUMBER);
                ((IFD)arrayList.get(n3)).addField(new ShortField(TiffTag.PAGE_NUMBER.getValue(), new short[]{0, 0}));
            }
            n3 = TIFFTweaker.copyPages(arrayList, 8, fileCacheRandomAccessInputStream, randomAccessOutputStream);
            ((InputStream)fileCacheRandomAccessInputStream).close();
            for (n2 = 1; n2 < fileArray.length; ++n2) {
                ArrayList<IFD> arrayList2 = new ArrayList<IFD>();
                FileInputStream fileInputStream2 = new FileInputStream(fileArray[n2]);
                FileCacheRandomAccessInputStream fileCacheRandomAccessInputStream2 = new FileCacheRandomAccessInputStream(fileInputStream2);
                TIFFTweaker.readIFDs(arrayList2, fileCacheRandomAccessInputStream2);
                for (int i = 0; i < arrayList2.size(); ++i) {
                    ((IFD)arrayList2.get(i)).removeField(TiffTag.PAGE_NUMBER);
                    ((IFD)arrayList2.get(i)).addField(new ShortField(TiffTag.PAGE_NUMBER.getValue(), new short[]{0, 0}));
                }
                n3 = TIFFTweaker.copyPages(arrayList2, n3, fileCacheRandomAccessInputStream2, randomAccessOutputStream);
                ((IFD)arrayList.get(arrayList.size() - 1)).setNextIFDOffset(randomAccessOutputStream, ((IFD)arrayList2.get(0)).getStartOffset());
                arrayList.addAll(arrayList2);
                ((InputStream)fileCacheRandomAccessInputStream2).close();
            }
            n2 = arrayList.size();
            for (n = 0; n < arrayList.size(); ++n) {
                n3 = ((IFD)arrayList.get(n)).getField(TiffTag.PAGE_NUMBER).getDataOffset();
                randomAccessOutputStream.seek(n3);
                randomAccessOutputStream.writeShort((short)n);
                randomAccessOutputStream.writeShort((short)n2);
            }
            n = ((IFD)arrayList.get(0)).getStartOffset();
            TIFFTweaker.writeToStream(randomAccessOutputStream, n);
        }
    }

    public static void mergeTiffImagesEx(RandomAccessOutputStream randomAccessOutputStream, File ... fileArray) throws IOException {
        if (fileArray != null && fileArray.length > 1) {
            TIFFTweaker.merge(randomAccessOutputStream, new File2RandomInputStreamAdaptor(fileArray));
        }
    }

    public static void mergeTiffImagesEx(RandomAccessOutputStream randomAccessOutputStream, InputStream ... inputStreamArray) throws IOException {
        if (inputStreamArray != null && inputStreamArray.length > 1) {
            TIFFTweaker.merge(randomAccessOutputStream, new Stream2RandomInputStreamAdaptor(inputStreamArray));
        }
    }

    public static int prepareForInsert(RandomAccessInputStream randomAccessInputStream, RandomAccessOutputStream randomAccessOutputStream, List<IFD> list) throws IOException {
        int n;
        int n2 = TIFFTweaker.copyHeader(randomAccessInputStream, randomAccessOutputStream);
        TIFFTweaker.readIFDs(list, n2, randomAccessInputStream);
        if (list.size() == 1) {
            if (list.get(0).removeField(TiffTag.SUBFILE_TYPE) == null) {
                list.get(0).removeField(TiffTag.NEW_SUBFILE_TYPE);
            }
            list.get(0).addField(new ShortField(TiffTag.SUBFILE_TYPE.getValue(), new short[]{3}));
        }
        for (n = 0; n < list.size(); ++n) {
            list.get(n).removeField(TiffTag.PAGE_NUMBER);
            list.get(n).addField(new ShortField(TiffTag.PAGE_NUMBER.getValue(), new short[]{0, 0}));
        }
        n = 8;
        n = TIFFTweaker.copyPages(list, n, randomAccessInputStream, randomAccessOutputStream);
        return n;
    }

    public static int prepareForWrite(RandomAccessOutputStream randomAccessOutputStream) throws IOException {
        return TIFFTweaker.writeHeader(randomAccessOutputStream);
    }

    public static void printIFDs(Collection<IFD> collection, String string) {
        int n = 0;
        LOGGER.info("Printing IFDs ... ");
        for (IFD iFD : collection) {
            LOGGER.info("IFD #{}", (Object)n);
            TIFFTweaker.printIFD(iFD, TiffTag.class, string);
            ++n;
        }
    }

    public static void printIFD(IFD iFD, Class<? extends Tag> clazz, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        TIFFTweaker.print(iFD, clazz, string, stringBuilder);
        LOGGER.info("\n{}", (Object)stringBuilder);
    }

    private static void print(IFD iFD, Class<? extends Tag> clazz, String string, StringBuilder stringBuilder) {
        Method method = null;
        try {
            method = clazz.getDeclaredMethod("fromShort", Short.TYPE);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException("Method 'fromShort' is not defined for class " + clazz);
        }
        catch (SecurityException securityException) {
            throw new RuntimeException("The operation is not allowed by the current security setup");
        }
        Collection<TiffField<?>> collection = iFD.getFields();
        int n = 0;
        for (TiffField<?> tiffField : collection) {
            stringBuilder.append(string);
            stringBuilder.append("Field #" + n + "\n");
            stringBuilder.append(string);
            short s = tiffField.getTag();
            Tag tag = TiffTag.UNKNOWN;
            if (s == ExifTag.PADDING.getValue()) {
                tag = ExifTag.PADDING;
            } else {
                try {
                    tag = (Tag)method.invoke(null, s);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new RuntimeException("Illegal access for method: " + method);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new RuntimeException("Illegal argument for method:  " + method);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new RuntimeException("Incorrect invocation target");
                }
            }
            if (tag == TiffTag.UNKNOWN) {
                LOGGER.warn("Tag: {} [Value: 0x{}] (Unknown)", (Object)tag, (Object)Integer.toHexString(s & 0xFFFF));
            } else {
                stringBuilder.append("Tag: " + tag + "\n");
            }
            FieldType fieldType = tiffField.getType();
            stringBuilder.append(string);
            stringBuilder.append("Field type: " + (Object)((Object)fieldType) + "\n");
            int n2 = tiffField.getLength();
            stringBuilder.append(string);
            stringBuilder.append("Field length: " + n2 + "\n");
            stringBuilder.append(string);
            String string2 = null;
            string2 = fieldType == FieldType.SHORT || fieldType == FieldType.SSHORT ? tag.getFieldAsString(tiffField.getDataAsLong()) : tag.getFieldAsString(tiffField.getData());
            stringBuilder.append("Field value: " + tiffField.getDataAsString() + (StringUtils.isNullOrEmpty(string2) ? "" : " => " + string2) + "\n");
            ++n;
        }
        Map<Tag, IFD> map = iFD.getChildren();
        if (map.get(TiffTag.EXIF_SUB_IFD) != null) {
            stringBuilder.append(string + "--------- ");
            stringBuilder.append("<<Exif SubIFD starts>>\n");
            TIFFTweaker.print((IFD)map.get(TiffTag.EXIF_SUB_IFD), ExifTag.class, string + "--------- ", stringBuilder);
            stringBuilder.append(string + "--------- ");
            stringBuilder.append("<<Exif SubIFD ends>>\n");
        }
        if (map.get(TiffTag.GPS_SUB_IFD) != null) {
            stringBuilder.append(string + "--------- ");
            stringBuilder.append("<<GPS SubIFD starts>>\n");
            TIFFTweaker.print((IFD)map.get(TiffTag.GPS_SUB_IFD), GPSTag.class, string + "--------- ", stringBuilder);
            stringBuilder.append(string + "--------- ");
            stringBuilder.append("<<GPS SubIFD ends>>\n");
        }
    }

    private static int readHeader(RandomAccessInputStream randomAccessInputStream) throws IOException {
        int n = 0;
        randomAccessInputStream.seek(0L);
        short s = randomAccessInputStream.readShort();
        n += 2;
        if (s == 19789) {
            randomAccessInputStream.setReadStrategy(ReadStrategyMM.getInstance());
        } else if (s == 18761) {
            randomAccessInputStream.setReadStrategy(ReadStrategyII.getInstance());
        } else {
            randomAccessInputStream.close();
            throw new RuntimeException("Invalid TIFF byte order");
        }
        randomAccessInputStream.seek(n);
        short s2 = randomAccessInputStream.readShort();
        n += 2;
        if (s2 != 42) {
            randomAccessInputStream.close();
            throw new RuntimeException("Invalid TIFF identifier");
        }
        randomAccessInputStream.seek(n);
        n = randomAccessInputStream.readInt();
        return n;
    }

    private static int readIFD(RandomAccessInputStream randomAccessInputStream, List<IFD> list, int n, Class<? extends Tag> clazz, IFD iFD, Tag tag) throws IOException {
        Method method = null;
        try {
            method = clazz.getDeclaredMethod("fromShort", Short.TYPE);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException("Method 'fromShort' is not defined for class " + clazz);
        }
        catch (SecurityException securityException) {
            throw new RuntimeException("Current security doesn't allow this operation");
        }
        IFD iFD2 = new IFD();
        randomAccessInputStream.seek(n);
        int n2 = randomAccessInputStream.readShort();
        n += 2;
        block25: for (int i = 0; i < n2; ++i) {
            randomAccessInputStream.seek(n);
            short s = randomAccessInputStream.readShort();
            Tag tag2 = TiffTag.UNKNOWN;
            try {
                tag2 = (Tag)method.invoke(null, s);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException("Illegal access for method: " + method);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new RuntimeException("Illegal argument for method:  " + method);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException("Incorrect invocation target");
            }
            randomAccessInputStream.seek(n += 2);
            short s2 = randomAccessInputStream.readShort();
            FieldType fieldType = FieldType.fromShort(s2);
            randomAccessInputStream.seek(n += 2);
            int n3 = randomAccessInputStream.readInt();
            n += 4;
            switch (fieldType) {
                case BYTE: 
                case UNDEFINED: {
                    byte[] byArray = new byte[n3];
                    randomAccessInputStream.seek(n);
                    if (n3 <= 4) {
                        randomAccessInputStream.readFully(byArray, 0, n3);
                    } else {
                        randomAccessInputStream.seek(randomAccessInputStream.readInt());
                        randomAccessInputStream.readFully(byArray, 0, n3);
                    }
                    TiffField tiffField = null;
                    tiffField = fieldType == FieldType.BYTE ? new ByteField(s, byArray) : new UndefinedField(s, byArray);
                    iFD2.addField(tiffField);
                    n += 4;
                    continue block25;
                }
                case ASCII: {
                    byte[] byArray = new byte[n3];
                    if (n3 <= 4) {
                        randomAccessInputStream.seek(n);
                        randomAccessInputStream.readFully(byArray, 0, n3);
                    } else {
                        randomAccessInputStream.seek(n);
                        randomAccessInputStream.seek(randomAccessInputStream.readInt());
                        randomAccessInputStream.readFully(byArray, 0, n3);
                    }
                    ASCIIField aSCIIField = new ASCIIField(s, new String(byArray, "UTF-8"));
                    iFD2.addField(aSCIIField);
                    n += 4;
                    continue block25;
                }
                case SHORT: {
                    short[] sArray = new short[n3];
                    if (n3 == 1) {
                        randomAccessInputStream.seek(n);
                        sArray[0] = randomAccessInputStream.readShort();
                        n += 4;
                    } else if (n3 == 2) {
                        randomAccessInputStream.seek(n);
                        sArray[0] = randomAccessInputStream.readShort();
                        randomAccessInputStream.seek(n += 2);
                        sArray[1] = randomAccessInputStream.readShort();
                        n += 2;
                    } else {
                        randomAccessInputStream.seek(n);
                        int n4 = randomAccessInputStream.readInt();
                        n += 4;
                        for (int j = 0; j < n3; ++j) {
                            randomAccessInputStream.seek(n4);
                            sArray[j] = randomAccessInputStream.readShort();
                            n4 += 2;
                        }
                    }
                    ShortField shortField = new ShortField(s, sArray);
                    iFD2.addField(shortField);
                    continue block25;
                }
                case LONG: {
                    int n5;
                    int[] nArray = new int[n3];
                    if (n3 == 1) {
                        randomAccessInputStream.seek(n);
                        nArray[0] = randomAccessInputStream.readInt();
                        n += 4;
                    } else {
                        randomAccessInputStream.seek(n);
                        int n6 = randomAccessInputStream.readInt();
                        n += 4;
                        for (n5 = 0; n5 < n3; ++n5) {
                            randomAccessInputStream.seek(n6);
                            nArray[n5] = randomAccessInputStream.readInt();
                            n6 += 4;
                        }
                    }
                    LongField longField = new LongField(s, nArray);
                    iFD2.addField(longField);
                    if (tag2 == TiffTag.EXIF_SUB_IFD && nArray[0] != 0) {
                        try {
                            TIFFTweaker.readIFD(randomAccessInputStream, null, nArray[0], ExifTag.class, iFD2, TiffTag.EXIF_SUB_IFD);
                        }
                        catch (Exception exception) {
                            iFD2.removeField(TiffTag.EXIF_SUB_IFD);
                            LOGGER.error("Unable to read TiffTag.EXIF_SUB_IFD", (Throwable)exception);
                        }
                        continue block25;
                    }
                    if (tag2 == TiffTag.GPS_SUB_IFD && nArray[0] != 0) {
                        try {
                            TIFFTweaker.readIFD(randomAccessInputStream, null, nArray[0], GPSTag.class, iFD2, TiffTag.GPS_SUB_IFD);
                        }
                        catch (Exception exception) {
                            iFD2.removeField(TiffTag.GPS_SUB_IFD);
                            LOGGER.error("Unable to read TiffTag.GPS_SUB_IFD", (Throwable)exception);
                        }
                        continue block25;
                    }
                    if (tag2 == ExifTag.EXIF_INTEROPERABILITY_OFFSET && nArray[0] != 0) {
                        try {
                            TIFFTweaker.readIFD(randomAccessInputStream, null, nArray[0], InteropTag.class, iFD2, ExifTag.EXIF_INTEROPERABILITY_OFFSET);
                        }
                        catch (Exception exception) {
                            iFD2.removeField(ExifTag.EXIF_INTEROPERABILITY_OFFSET);
                            LOGGER.error("Unable to read ExifTag.EXIF_INTEROPERABILITY_OFFSET", (Throwable)exception);
                        }
                        continue block25;
                    }
                    if (tag2 != TiffTag.SUB_IFDS) continue block25;
                    for (n5 = 0; n5 < nArray.length; ++n5) {
                        try {
                            TIFFTweaker.readIFD(randomAccessInputStream, null, nArray[0], TiffTag.class, iFD2, TiffTag.SUB_IFDS);
                            continue;
                        }
                        catch (Exception exception) {
                            iFD2.removeField(TiffTag.SUB_IFDS);
                            LOGGER.error("Unable to read TiffTag.SUB_IFDS", (Throwable)exception);
                        }
                    }
                    continue block25;
                }
                case FLOAT: {
                    float[] fArray = new float[n3];
                    if (n3 == 1) {
                        randomAccessInputStream.seek(n);
                        fArray[0] = randomAccessInputStream.readFloat();
                        n += 4;
                    } else {
                        randomAccessInputStream.seek(n);
                        int n7 = randomAccessInputStream.readInt();
                        n += 4;
                        for (int j = 0; j < n3; ++j) {
                            randomAccessInputStream.seek(n7);
                            fArray[j] = randomAccessInputStream.readFloat();
                            n7 += 4;
                        }
                    }
                    FloatField floatField = new FloatField(s, fArray);
                    iFD2.addField(floatField);
                    continue block25;
                }
                case DOUBLE: {
                    double[] dArray = new double[n3];
                    randomAccessInputStream.seek(n);
                    int n8 = randomAccessInputStream.readInt();
                    n += 4;
                    for (int j = 0; j < n3; ++j) {
                        randomAccessInputStream.seek(n8);
                        dArray[j] = randomAccessInputStream.readDouble();
                        n8 += 8;
                    }
                    DoubleField doubleField = new DoubleField(s, dArray);
                    iFD2.addField(doubleField);
                    continue block25;
                }
                case RATIONAL: 
                case SRATIONAL: {
                    int n9 = 2 * n3;
                    int[] nArray = new int[n9];
                    randomAccessInputStream.seek(n);
                    int n8 = randomAccessInputStream.readInt();
                    n += 4;
                    for (int j = 0; j < n9; j += 2) {
                        randomAccessInputStream.seek(n8);
                        nArray[j] = randomAccessInputStream.readInt();
                        randomAccessInputStream.seek(n8 += 4);
                        nArray[j + 1] = randomAccessInputStream.readInt();
                        n8 += 4;
                    }
                    AbstractRationalField abstractRationalField = null;
                    abstractRationalField = fieldType == FieldType.SRATIONAL ? new SRationalField(s, nArray) : new RationalField(s, nArray);
                    iFD2.addField(abstractRationalField);
                    continue block25;
                }
                case IFD: {
                    int n8;
                    int[] nArray = new int[n3];
                    if (n3 == 1) {
                        randomAccessInputStream.seek(n);
                        nArray[0] = randomAccessInputStream.readInt();
                        n += 4;
                    } else {
                        randomAccessInputStream.seek(n);
                        n8 = randomAccessInputStream.readInt();
                        n += 4;
                        for (int j = 0; j < n3; ++j) {
                            randomAccessInputStream.seek(n8);
                            nArray[j] = randomAccessInputStream.readInt();
                            n8 += 4;
                        }
                    }
                    IFDField iFDField = new IFDField(s, nArray);
                    iFD2.addField(iFDField);
                    for (int j = 0; j < nArray.length; ++j) {
                        TIFFTweaker.readIFD(randomAccessInputStream, null, nArray[0], TiffTag.class, iFD2, TiffTag.SUB_IFDS);
                    }
                    continue block25;
                }
                default: {
                    n += 4;
                }
            }
        }
        if (iFD != null) {
            iFD.addChild(tag, iFD2);
        } else {
            list.add(iFD2);
        }
        randomAccessInputStream.seek(n);
        return randomAccessInputStream.readInt();
    }

    private static void readIFDs(List<IFD> list, int n, RandomAccessInputStream randomAccessInputStream) throws IOException {
        while (n != 0) {
            n = TIFFTweaker.readIFD(randomAccessInputStream, list, n, TiffTag.class, null, null);
        }
    }

    public static void readIFDs(List<IFD> list, RandomAccessInputStream randomAccessInputStream) throws IOException {
        int n = TIFFTweaker.readHeader(randomAccessInputStream);
        TIFFTweaker.readIFDs(list, n, randomAccessInputStream);
    }

    public static Map<MetadataType, Metadata> readMetadata(RandomAccessInputStream randomAccessInputStream) throws IOException {
        return TIFFTweaker.readMetadata(randomAccessInputStream, 0);
    }

    public static Map<MetadataType, Metadata> readMetadata(RandomAccessInputStream randomAccessInputStream, int n) throws IOException {
        Object object;
        Object object2;
        Metadata metadata;
        HashMap<MetadataType, Metadata> hashMap = new HashMap<MetadataType, Metadata>();
        int n2 = TIFFTweaker.readHeader(randomAccessInputStream);
        ArrayList<IFD> arrayList = new ArrayList<IFD>();
        TIFFTweaker.readIFDs(arrayList, n2, randomAccessInputStream);
        if (n < 0 || n >= arrayList.size()) {
            throw new IllegalArgumentException("pageNumber " + n + " out of bounds: 0 - " + (arrayList.size() - 1));
        }
        IFD iFD = (IFD)arrayList.get(n);
        TiffField<?> tiffField = iFD.getField(TiffTag.ICC_PROFILE);
        if (tiffField != null) {
            hashMap.put(MetadataType.ICC_PROFILE, new ICCProfile((byte[])tiffField.getData()));
        }
        if ((tiffField = iFD.getField(TiffTag.XMP)) != null) {
            hashMap.put(MetadataType.XMP, new TiffXMP((byte[])tiffField.getData()));
        }
        if ((tiffField = iFD.getField(TiffTag.PHOTOSHOP)) != null) {
            metadata = new IRB((byte[])tiffField.getData());
            hashMap.put(MetadataType.PHOTOSHOP_IRB, metadata);
            object2 = ((IRB)metadata).get8BIM(ImageResourceID.IPTC_NAA.getValue());
            if (object2 != null) {
                object = new IPTC(((_8BIM)object2).getData());
                hashMap.put(MetadataType.IPTC, (Metadata)object);
            }
        }
        if ((tiffField = iFD.getField(TiffTag.IPTC)) != null) {
            metadata = (IPTC)hashMap.get((Object)MetadataType.IPTC);
            object2 = null;
            object = tiffField.getType();
            object2 = object == FieldType.LONG ? (Object)ArrayUtils.toByteArray(tiffField.getDataAsLong(), randomAccessInputStream.getEndian() == 19789) : (Object)((byte[])tiffField.getData());
            if (metadata != null) {
                object2 = ArrayUtils.concat((byte[])object2, new byte[][]{metadata.getData()});
            }
            hashMap.put(MetadataType.IPTC, new IPTC((byte[])object2));
        }
        if ((tiffField = iFD.getField(TiffTag.EXIF_SUB_IFD)) != null) {
            hashMap.put(MetadataType.EXIF, new TiffExif(iFD));
        }
        if ((tiffField = iFD.getField(TiffTag.IMAGE_SOURCE_DATA)) != null) {
            boolean bl = randomAccessInputStream.getEndian() == 19789;
            object2 = bl ? ReadStrategyMM.getInstance() : ReadStrategyII.getInstance();
            hashMap.put(MetadataType.PHOTOSHOP_DDB, new DDB((byte[])tiffField.getData(), (ReadStrategy)object2));
        }
        if ((tiffField = iFD.getField(TiffTag.IMAGE_DESCRIPTION)) != null) {
            Comments comments = new Comments();
            comments.addComment(tiffField.getDataAsString());
            hashMap.put(MetadataType.COMMENT, comments);
        }
        return hashMap;
    }

    public static void removeMetadata(int n, RandomAccessInputStream randomAccessInputStream, RandomAccessOutputStream randomAccessOutputStream, MetadataType ... metadataTypeArray) throws IOException {
        TIFFTweaker.removeMetadata(new HashSet<MetadataType>(Arrays.asList(metadataTypeArray)), n, randomAccessInputStream, randomAccessOutputStream);
    }

    public static void removeMetadata(RandomAccessInputStream randomAccessInputStream, RandomAccessOutputStream randomAccessOutputStream, MetadataType ... metadataTypeArray) throws IOException {
        TIFFTweaker.removeMetadata(0, randomAccessInputStream, randomAccessOutputStream, metadataTypeArray);
    }

    public static void removeMetadata(Set<MetadataType> set, int n, RandomAccessInputStream randomAccessInputStream, RandomAccessOutputStream randomAccessOutputStream) throws IOException {
        int n2 = TIFFTweaker.copyHeader(randomAccessInputStream, randomAccessOutputStream);
        ArrayList<IFD> arrayList = new ArrayList<IFD>();
        TIFFTweaker.readIFDs(arrayList, n2, randomAccessInputStream);
        if (n < 0 || n >= arrayList.size()) {
            throw new IllegalArgumentException("pageNumber " + n + " out of bounds: 0 - " + (arrayList.size() - 1));
        }
        IFD iFD = (IFD)arrayList.get(n);
        TiffField<?> tiffField = null;
        for (MetadataType metadataType : set) {
            switch (metadataType) {
                case XMP: {
                    iFD.removeField(TiffTag.XMP);
                    tiffField = iFD.removeField(TiffTag.PHOTOSHOP);
                    if (tiffField == null) break;
                    byte[] byArray = (byte[])tiffField.getData();
                    TIFFTweaker.removeMetadataFromIRB(iFD, byArray, ImageResourceID.XMP_METADATA);
                    break;
                }
                case IPTC: {
                    iFD.removeField(TiffTag.IPTC);
                    tiffField = iFD.removeField(TiffTag.PHOTOSHOP);
                    if (tiffField == null) break;
                    byte[] byArray = (byte[])tiffField.getData();
                    TIFFTweaker.removeMetadataFromIRB(iFD, byArray, ImageResourceID.IPTC_NAA);
                    break;
                }
                case ICC_PROFILE: {
                    iFD.removeField(TiffTag.ICC_PROFILE);
                    tiffField = iFD.removeField(TiffTag.PHOTOSHOP);
                    if (tiffField == null) break;
                    byte[] byArray = (byte[])tiffField.getData();
                    TIFFTweaker.removeMetadataFromIRB(iFD, byArray, ImageResourceID.ICC_PROFILE);
                    break;
                }
                case PHOTOSHOP_IRB: {
                    iFD.removeField(TiffTag.PHOTOSHOP);
                    break;
                }
                case EXIF: {
                    iFD.removeField(TiffTag.EXIF_SUB_IFD);
                    iFD.removeField(TiffTag.GPS_SUB_IFD);
                    tiffField = iFD.removeField(TiffTag.PHOTOSHOP);
                    if (tiffField == null) break;
                    byte[] byArray = (byte[])tiffField.getData();
                    TIFFTweaker.removeMetadataFromIRB(iFD, byArray, ImageResourceID.EXIF_DATA1, ImageResourceID.EXIF_DATA3);
                    break;
                }
            }
        }
        n2 = TIFFTweaker.copyPages(arrayList, n2, randomAccessInputStream, randomAccessOutputStream);
        int n3 = ((IFD)arrayList.get(0)).getStartOffset();
        TIFFTweaker.writeToStream(randomAccessOutputStream, n3);
    }

    public static void removeMetadata(Set<MetadataType> set, RandomAccessInputStream randomAccessInputStream, RandomAccessOutputStream randomAccessOutputStream) throws IOException {
        TIFFTweaker.removeMetadata(set, 0, randomAccessInputStream, randomAccessOutputStream);
    }

    private static void removeMetadataFromIRB(IFD iFD, byte[] byArray, ImageResourceID ... imageResourceIDArray) throws IOException {
        IRB iRB = new IRB(byArray);
        HashMap<Short, _8BIM> hashMap = new HashMap<Short, _8BIM>(iRB.get8BIM());
        for (ImageResourceID imageResourceID : imageResourceIDArray) {
            hashMap.remove(imageResourceID.getValue());
        }
        if (hashMap.size() > 0) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            for (_8BIM _8BIM2 : hashMap.values()) {
                _8BIM2.write(byteArrayOutputStream);
            }
            iFD.addField(new ByteField(TiffTag.PHOTOSHOP.getValue(), byteArrayOutputStream.toByteArray()));
        }
    }

    public static int removePages(int n, int n2, RandomAccessInputStream randomAccessInputStream, RandomAccessOutputStream randomAccessOutputStream) throws IOException {
        int n3;
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException("Negative start or end page");
        }
        if (n > n2) {
            throw new IllegalArgumentException("Start page is larger than end page");
        }
        ArrayList<IFD> arrayList = new ArrayList<IFD>();
        int n4 = TIFFTweaker.copyHeader(randomAccessInputStream, randomAccessOutputStream);
        TIFFTweaker.readIFDs(arrayList, n4, randomAccessInputStream);
        int n5 = 0;
        if (n <= arrayList.size() - 1) {
            if (n2 > arrayList.size() - 1) {
                n2 = arrayList.size() - 1;
            }
            for (n3 = n2; n3 >= n; --n3) {
                if (arrayList.size() <= 1) continue;
                ++n5;
                arrayList.remove(n3);
            }
        }
        for (n3 = 0; n3 < arrayList.size(); ++n3) {
            ((IFD)arrayList.get(n3)).removeField(TiffTag.PAGE_NUMBER);
            ((IFD)arrayList.get(n3)).addField(new ShortField(TiffTag.PAGE_NUMBER.getValue(), new short[]{(short)n3, (short)(arrayList.size() - 1)}));
        }
        n3 = 8;
        n4 = TIFFTweaker.copyPages(arrayList, n3, randomAccessInputStream, randomAccessOutputStream);
        int n6 = ((IFD)arrayList.get(0)).getStartOffset();
        TIFFTweaker.writeToStream(randomAccessOutputStream, n6);
        return n5;
    }

    public static int removePages(RandomAccessInputStream randomAccessInputStream, RandomAccessOutputStream randomAccessOutputStream, int ... nArray) throws IOException {
        int n;
        ArrayList<IFD> arrayList = new ArrayList<IFD>();
        int n2 = TIFFTweaker.copyHeader(randomAccessInputStream, randomAccessOutputStream);
        TIFFTweaker.readIFDs(arrayList, n2, randomAccessInputStream);
        int n3 = 0;
        nArray = ArrayUtils.removeDuplicates(nArray);
        for (n = nArray.length - 1; n >= 0 && nArray[n] >= 0; --n) {
            if (arrayList.size() <= 1 || arrayList.size() <= nArray[n]) continue;
            ++n3;
            arrayList.remove(nArray[n]);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            ((IFD)arrayList.get(n)).removeField(TiffTag.PAGE_NUMBER);
            ((IFD)arrayList.get(n)).addField(new ShortField(TiffTag.PAGE_NUMBER.getValue(), new short[]{(short)n, (short)(arrayList.size() - 1)}));
        }
        n = 8;
        n2 = TIFFTweaker.copyPages(arrayList, n, randomAccessInputStream, randomAccessOutputStream);
        int n4 = ((IFD)arrayList.get(0)).getStartOffset();
        TIFFTweaker.writeToStream(randomAccessOutputStream, n4);
        return n3;
    }

    public static int retainPages(int n, int n2, RandomAccessInputStream randomAccessInputStream, RandomAccessOutputStream randomAccessOutputStream) throws IOException {
        int n3;
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException("Negative start or end page");
        }
        if (n > n2) {
            throw new IllegalArgumentException("Start page is larger than end page");
        }
        ArrayList<IFD> arrayList = new ArrayList<IFD>();
        int n4 = TIFFTweaker.copyHeader(randomAccessInputStream, randomAccessOutputStream);
        TIFFTweaker.readIFDs(arrayList, n4, randomAccessInputStream);
        int n5 = arrayList.size();
        ArrayList arrayList2 = new ArrayList();
        if (n <= arrayList.size() - 1) {
            if (n2 > arrayList.size() - 1) {
                n2 = arrayList.size() - 1;
            }
            for (n3 = n2; n3 >= n; --n3) {
                arrayList2.add(arrayList.get(n3));
            }
        }
        if (arrayList2.size() > 0) {
            n5 = arrayList2.size();
            arrayList.retainAll(arrayList2);
        }
        for (n3 = 0; n3 < arrayList.size(); ++n3) {
            ((IFD)arrayList.get(n3)).removeField(TiffTag.PAGE_NUMBER);
            ((IFD)arrayList.get(n3)).addField(new ShortField(TiffTag.PAGE_NUMBER.getValue(), new short[]{(short)n3, (short)(arrayList.size() - 1)}));
        }
        n3 = 8;
        n4 = TIFFTweaker.copyPages(arrayList, n3, randomAccessInputStream, randomAccessOutputStream);
        int n6 = ((IFD)arrayList.get(0)).getStartOffset();
        TIFFTweaker.writeToStream(randomAccessOutputStream, n6);
        return n5;
    }

    public static int retainPages(RandomAccessInputStream randomAccessInputStream, RandomAccessOutputStream randomAccessOutputStream, int ... nArray) throws IOException {
        int n;
        ArrayList<IFD> arrayList = new ArrayList<IFD>();
        int n2 = TIFFTweaker.copyHeader(randomAccessInputStream, randomAccessOutputStream);
        TIFFTweaker.readIFDs(arrayList, n2, randomAccessInputStream);
        int n3 = arrayList.size();
        ArrayList arrayList2 = new ArrayList();
        Arrays.sort(nArray);
        for (n = nArray.length - 1; n >= 0; --n) {
            if (nArray[n] < 0 || nArray[n] >= arrayList.size()) continue;
            arrayList2.add(arrayList.get(nArray[n]));
        }
        if (arrayList2.size() > 0) {
            n3 = arrayList2.size();
            arrayList.retainAll(arrayList2);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            ((IFD)arrayList.get(n)).removeField(TiffTag.PAGE_NUMBER);
            ((IFD)arrayList.get(n)).addField(new ShortField(TiffTag.PAGE_NUMBER.getValue(), new short[]{(short)n, (short)(arrayList.size() - 1)}));
        }
        n = 8;
        n2 = TIFFTweaker.copyPages(arrayList, n, randomAccessInputStream, randomAccessOutputStream);
        int n4 = ((IFD)arrayList.get(0)).getStartOffset();
        TIFFTweaker.writeToStream(randomAccessOutputStream, n4);
        return n3;
    }

    public static void splitPages(RandomAccessInputStream randomAccessInputStream, List<byte[]> list) throws IOException {
        ArrayList<IFD> arrayList = new ArrayList<IFD>();
        short s = randomAccessInputStream.readShort();
        WriteStrategy writeStrategy = WriteStrategyMM.getInstance();
        if (s == 18761) {
            writeStrategy = WriteStrategyII.getInstance();
        }
        randomAccessInputStream.seek(0L);
        int n = TIFFTweaker.readHeader(randomAccessInputStream);
        TIFFTweaker.readIFDs(arrayList, n, randomAccessInputStream);
        for (int i = 0; i < arrayList.size(); ++i) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            MemoryCacheRandomAccessOutputStream memoryCacheRandomAccessOutputStream = new MemoryCacheRandomAccessOutputStream(byteArrayOutputStream);
            memoryCacheRandomAccessOutputStream.setWriteStrategy(writeStrategy);
            int n2 = TIFFTweaker.writeHeader(memoryCacheRandomAccessOutputStream);
            int n3 = n2 = TIFFTweaker.copyPageData((IFD)arrayList.get(i), n2, randomAccessInputStream, memoryCacheRandomAccessOutputStream);
            if (((IFD)arrayList.get(i)).removeField(TiffTag.SUBFILE_TYPE) == null) {
                ((IFD)arrayList.get(i)).removeField(TiffTag.NEW_SUBFILE_TYPE);
            }
            ((IFD)arrayList.get(i)).removeField(TiffTag.PAGE_NUMBER);
            ((IFD)arrayList.get(i)).addField(new ShortField(TiffTag.SUBFILE_TYPE.getValue(), new short[]{1}));
            n2 = ((IFD)arrayList.get(i)).write(memoryCacheRandomAccessOutputStream, n2);
            TIFFTweaker.writeToStream(memoryCacheRandomAccessOutputStream, n3);
            ((RandomAccessOutputStream)memoryCacheRandomAccessOutputStream).close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            LOGGER.debug("File " + i + " has byte size: " + byArray.length / 1024 + " kb");
            list.add(byArray);
        }
    }

    public static void splitPages(RandomAccessInputStream randomAccessInputStream, String string) throws IOException {
        ArrayList<IFD> arrayList = new ArrayList<IFD>();
        short s = randomAccessInputStream.readShort();
        WriteStrategy writeStrategy = WriteStrategyMM.getInstance();
        if (s == 18761) {
            writeStrategy = WriteStrategyII.getInstance();
        }
        randomAccessInputStream.seek(0L);
        int n = TIFFTweaker.readHeader(randomAccessInputStream);
        TIFFTweaker.readIFDs(arrayList, n, randomAccessInputStream);
        String string2 = "page_#";
        if (!StringUtils.isNullOrEmpty(string)) {
            string2 = string + "_" + string2;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            FileCacheRandomAccessOutputStream fileCacheRandomAccessOutputStream = new FileCacheRandomAccessOutputStream(new FileOutputStream(string2 + i + ".tif"));
            fileCacheRandomAccessOutputStream.setWriteStrategy(writeStrategy);
            int n2 = TIFFTweaker.writeHeader(fileCacheRandomAccessOutputStream);
            int n3 = n2 = TIFFTweaker.copyPageData((IFD)arrayList.get(i), n2, randomAccessInputStream, fileCacheRandomAccessOutputStream);
            if (((IFD)arrayList.get(i)).removeField(TiffTag.SUBFILE_TYPE) == null) {
                ((IFD)arrayList.get(i)).removeField(TiffTag.NEW_SUBFILE_TYPE);
            }
            ((IFD)arrayList.get(i)).removeField(TiffTag.PAGE_NUMBER);
            ((IFD)arrayList.get(i)).addField(new ShortField(TiffTag.SUBFILE_TYPE.getValue(), new short[]{1}));
            n2 = ((IFD)arrayList.get(i)).write(fileCacheRandomAccessOutputStream, n2);
            TIFFTweaker.writeToStream(fileCacheRandomAccessOutputStream, n3);
            ((RandomAccessOutputStream)fileCacheRandomAccessOutputStream).close();
        }
    }

    public static void splitPages(RandomAccessInputStream randomAccessInputStream, String string, int n) throws IOException {
        int n2;
        int n3;
        if (n <= 0) {
            throw new IllegalArgumentException("Negative size specified");
        }
        if (n == 1) {
            TIFFTweaker.splitPages(randomAccessInputStream, string);
        }
        ArrayList<IFD> arrayList = new ArrayList<IFD>();
        short s = randomAccessInputStream.readShort();
        WriteStrategy writeStrategy = WriteStrategyMM.getInstance();
        if (s == 18761) {
            writeStrategy = WriteStrategyII.getInstance();
        }
        randomAccessInputStream.seek(0L);
        int n4 = TIFFTweaker.readHeader(randomAccessInputStream);
        TIFFTweaker.readIFDs(arrayList, n4, randomAccessInputStream);
        String string2 = "image_#";
        if (!StringUtils.isNullOrEmpty(string)) {
            string2 = string + "_" + string2;
        }
        if (arrayList.size() <= n) {
            return;
        }
        int n5 = arrayList.size() / n;
        int n6 = arrayList.size() % n;
        int n7 = 0;
        for (int i = 0; i < n5; ++i) {
            int n8;
            FileCacheRandomAccessOutputStream fileCacheRandomAccessOutputStream = new FileCacheRandomAccessOutputStream(new FileOutputStream(string2 + i + ".tif"));
            fileCacheRandomAccessOutputStream.setWriteStrategy(writeStrategy);
            n3 = TIFFTweaker.writeHeader(fileCacheRandomAccessOutputStream);
            for (n2 = 0; n2 < n; ++n2) {
                n3 = TIFFTweaker.copyPageData((IFD)arrayList.get(n7 + n2), n3, randomAccessInputStream, fileCacheRandomAccessOutputStream);
            }
            n2 = n3;
            for (n8 = 0; n8 < n; ++n8) {
                if (((IFD)arrayList.get(n7 + n8)).removeField(TiffTag.SUBFILE_TYPE) == null) {
                    ((IFD)arrayList.get(n7 + n8)).removeField(TiffTag.NEW_SUBFILE_TYPE);
                }
                ((IFD)arrayList.get(n7 + n8)).removeField(TiffTag.PAGE_NUMBER);
                ((IFD)arrayList.get(n7 + n8)).addField(new ShortField(TiffTag.PAGE_NUMBER.getValue(), new short[]{(short)n8, (short)n}));
                ((IFD)arrayList.get(n7 + n8)).addField(new ShortField(TiffTag.NEW_SUBFILE_TYPE.getValue(), new short[]{2}));
                n3 = ((IFD)arrayList.get(n7 + n8)).write(fileCacheRandomAccessOutputStream, n3);
            }
            for (n8 = 0; n8 < n - 1; ++n8) {
                ((IFD)arrayList.get(n7 + n8)).setNextIFDOffset(fileCacheRandomAccessOutputStream, ((IFD)arrayList.get(n7 + n8 + 1)).getStartOffset());
            }
            TIFFTweaker.writeToStream(fileCacheRandomAccessOutputStream, n2);
            ((RandomAccessOutputStream)fileCacheRandomAccessOutputStream).close();
            n7 += n;
        }
        if (n6 > 0) {
            FileCacheRandomAccessOutputStream fileCacheRandomAccessOutputStream = new FileCacheRandomAccessOutputStream(new FileOutputStream(string2 + n5 + ".tif"));
            fileCacheRandomAccessOutputStream.setWriteStrategy(writeStrategy);
            int n9 = TIFFTweaker.writeHeader(fileCacheRandomAccessOutputStream);
            for (n3 = 0; n3 < n6; ++n3) {
                n9 = TIFFTweaker.copyPageData((IFD)arrayList.get(n7 + n3), n9, randomAccessInputStream, fileCacheRandomAccessOutputStream);
            }
            n3 = n9;
            for (n2 = 0; n2 < n6; ++n2) {
                if (((IFD)arrayList.get(n7 + n2)).removeField(TiffTag.SUBFILE_TYPE) == null) {
                    ((IFD)arrayList.get(n7 + n2)).removeField(TiffTag.NEW_SUBFILE_TYPE);
                }
                ((IFD)arrayList.get(n7 + n2)).removeField(TiffTag.PAGE_NUMBER);
                ((IFD)arrayList.get(n7 + n2)).addField(new ShortField(TiffTag.PAGE_NUMBER.getValue(), new short[]{(short)n2, (short)n}));
                ((IFD)arrayList.get(n7 + n2)).addField(new ShortField(TiffTag.NEW_SUBFILE_TYPE.getValue(), new short[]{2}));
                n9 = ((IFD)arrayList.get(n7 + n2)).write(fileCacheRandomAccessOutputStream, n9);
            }
            for (n2 = 0; n2 < n6 - 1; ++n2) {
                ((IFD)arrayList.get(n7 + n2)).setNextIFDOffset(fileCacheRandomAccessOutputStream, ((IFD)arrayList.get(n7 + n2 + 1)).getStartOffset());
            }
            TIFFTweaker.writeToStream(fileCacheRandomAccessOutputStream, n3);
            ((RandomAccessOutputStream)fileCacheRandomAccessOutputStream).close();
        }
    }

    public static void splitPages(RandomAccessInputStream randomAccessInputStream, List<byte[]> list, int n) throws IOException {
        int n2;
        int n3;
        OutputStream outputStream;
        if (n <= 0) {
            throw new IllegalArgumentException("Negative size specified");
        }
        if (n == 1) {
            TIFFTweaker.splitPages(randomAccessInputStream, list);
        }
        ArrayList<IFD> arrayList = new ArrayList<IFD>();
        short s = randomAccessInputStream.readShort();
        WriteStrategy writeStrategy = WriteStrategyMM.getInstance();
        if (s == 18761) {
            writeStrategy = WriteStrategyII.getInstance();
        }
        randomAccessInputStream.seek(0L);
        int n4 = TIFFTweaker.readHeader(randomAccessInputStream);
        TIFFTweaker.readIFDs(arrayList, n4, randomAccessInputStream);
        if (arrayList.size() <= n) {
            return;
        }
        int n5 = arrayList.size() / n;
        int n6 = arrayList.size() % n;
        int n7 = 0;
        for (int i = 0; i < n5; ++i) {
            int n8;
            outputStream = new ByteArrayOutputStream();
            FileCacheRandomAccessOutputStream fileCacheRandomAccessOutputStream = new FileCacheRandomAccessOutputStream(outputStream);
            fileCacheRandomAccessOutputStream.setWriteStrategy(writeStrategy);
            n3 = TIFFTweaker.writeHeader(fileCacheRandomAccessOutputStream);
            for (n2 = 0; n2 < n; ++n2) {
                n3 = TIFFTweaker.copyPageData((IFD)arrayList.get(n7 + n2), n3, randomAccessInputStream, fileCacheRandomAccessOutputStream);
            }
            n2 = n3;
            for (n8 = 0; n8 < n; ++n8) {
                if (((IFD)arrayList.get(n7 + n8)).removeField(TiffTag.SUBFILE_TYPE) == null) {
                    ((IFD)arrayList.get(n7 + n8)).removeField(TiffTag.NEW_SUBFILE_TYPE);
                }
                ((IFD)arrayList.get(n7 + n8)).removeField(TiffTag.PAGE_NUMBER);
                ((IFD)arrayList.get(n7 + n8)).addField(new ShortField(TiffTag.PAGE_NUMBER.getValue(), new short[]{(short)n8, (short)n}));
                ((IFD)arrayList.get(n7 + n8)).addField(new ShortField(TiffTag.NEW_SUBFILE_TYPE.getValue(), new short[]{2}));
                n3 = ((IFD)arrayList.get(n7 + n8)).write(fileCacheRandomAccessOutputStream, n3);
            }
            for (n8 = 0; n8 < n - 1; ++n8) {
                ((IFD)arrayList.get(n7 + n8)).setNextIFDOffset(fileCacheRandomAccessOutputStream, ((IFD)arrayList.get(n7 + n8 + 1)).getStartOffset());
            }
            TIFFTweaker.writeToStream(fileCacheRandomAccessOutputStream, n2);
            ((RandomAccessOutputStream)fileCacheRandomAccessOutputStream).close();
            byte[] byArray = ((ByteArrayOutputStream)outputStream).toByteArray();
            LOGGER.debug("File " + i + " has byte size: " + byArray.length / 1024 + " kb");
            list.add(byArray);
            n7 += n;
        }
        if (n6 > 0) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            outputStream = new FileCacheRandomAccessOutputStream(byteArrayOutputStream);
            ((RandomAccessOutputStream)outputStream).setWriteStrategy(writeStrategy);
            int n9 = TIFFTweaker.writeHeader((RandomAccessOutputStream)outputStream);
            for (n3 = 0; n3 < n6; ++n3) {
                n9 = TIFFTweaker.copyPageData((IFD)arrayList.get(n7 + n3), n9, randomAccessInputStream, (RandomAccessOutputStream)outputStream);
            }
            n3 = n9;
            for (n2 = 0; n2 < n6; ++n2) {
                if (((IFD)arrayList.get(n7 + n2)).removeField(TiffTag.SUBFILE_TYPE) == null) {
                    ((IFD)arrayList.get(n7 + n2)).removeField(TiffTag.NEW_SUBFILE_TYPE);
                }
                ((IFD)arrayList.get(n7 + n2)).removeField(TiffTag.PAGE_NUMBER);
                ((IFD)arrayList.get(n7 + n2)).addField(new ShortField(TiffTag.PAGE_NUMBER.getValue(), new short[]{(short)n2, (short)n}));
                ((IFD)arrayList.get(n7 + n2)).addField(new ShortField(TiffTag.NEW_SUBFILE_TYPE.getValue(), new short[]{2}));
                n9 = ((IFD)arrayList.get(n7 + n2)).write((RandomAccessOutputStream)outputStream, n9);
            }
            for (n2 = 0; n2 < n6 - 1; ++n2) {
                ((IFD)arrayList.get(n7 + n2)).setNextIFDOffset((RandomAccessOutputStream)outputStream, ((IFD)arrayList.get(n7 + n2 + 1)).getStartOffset());
            }
            TIFFTweaker.writeToStream((RandomAccessOutputStream)outputStream, n3);
            ((RandomAccessOutputStream)outputStream).close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            LOGGER.debug("File " + n5 + " has byte size: " + byArray.length / 1024 + " kb");
            list.add(byArray);
        }
    }

    public static void write(TIFFImage tIFFImage, RandomAccessOutputStream randomAccessOutputStream) throws IOException {
        RandomAccessInputStream randomAccessInputStream = tIFFImage.getInputStream();
        int n = TIFFTweaker.writeHeader(randomAccessOutputStream);
        n = TIFFTweaker.copyPages(tIFFImage.getIFDs(), n, randomAccessInputStream, randomAccessOutputStream);
        int n2 = tIFFImage.getIFDs().get(0).getStartOffset();
        TIFFTweaker.writeToStream(randomAccessOutputStream, n2);
    }

    private static int writeHeader(RandomAccessOutputStream randomAccessOutputStream) throws IOException {
        short s = randomAccessOutputStream.getEndian();
        randomAccessOutputStream.writeShort(s);
        randomAccessOutputStream.writeShort(42);
        return 8;
    }

    public static void writeMultipageTIFF(RandomAccessOutputStream randomAccessOutputStream, BufferedImage ... bufferedImageArray) throws IOException {
        TIFFTweaker.writeMultipageTIFF(randomAccessOutputStream, null, bufferedImageArray);
    }

    public static void writeMultipageTIFF(RandomAccessOutputStream randomAccessOutputStream, ImageFrame ... imageFrameArray) throws IOException {
        int n;
        int n2 = TIFFTweaker.writeHeader(randomAccessOutputStream);
        int n3 = 0;
        int n4 = imageFrameArray.length;
        ArrayList<IFD> arrayList = new ArrayList<IFD>(imageFrameArray.length);
        TIFFWriter tIFFWriter = new TIFFWriter();
        for (n = 0; n < imageFrameArray.length; ++n) {
            BufferedImage bufferedImage = imageFrameArray[n].getFrame();
            ImageParam imageParam = imageFrameArray[n].getFrameParam();
            try {
                tIFFWriter.setImageParam(imageParam);
                n2 = tIFFWriter.writePage(bufferedImage, n3++, n4, randomAccessOutputStream, n2);
                arrayList.add(tIFFWriter.getIFD());
                continue;
            }
            catch (Exception exception) {
                LOGGER.error("Failed writing page " + n3, (Throwable)exception);
                throw new PageWritingException("Failed writing page " + n3, exception);
            }
        }
        for (n = 0; n < arrayList.size() - 1; ++n) {
            ((IFD)arrayList.get(n)).setNextIFDOffset(randomAccessOutputStream, ((IFD)arrayList.get(n + 1)).getStartOffset());
        }
        if (arrayList.size() > 0) {
            n = ((IFD)arrayList.get(0)).getStartOffset();
            TIFFTweaker.writeToStream(randomAccessOutputStream, n);
        }
    }

    public static void writeMultipageTIFF(RandomAccessOutputStream randomAccessOutputStream, ImageParam[] imageParamArray, BufferedImage ... bufferedImageArray) throws IOException {
        int n;
        int n2 = TIFFTweaker.writeHeader(randomAccessOutputStream);
        int n3 = 0;
        int n4 = bufferedImageArray.length;
        ArrayList<IFD> arrayList = new ArrayList<IFD>(bufferedImageArray.length);
        TIFFWriter tIFFWriter = new TIFFWriter();
        Object[] objectArray = null;
        if (imageParamArray == null) {
            objectArray = new ImageParam[bufferedImageArray.length];
            Arrays.fill(objectArray, ImageParam.DEFAULT_IMAGE_PARAM);
        } else if (bufferedImageArray.length > imageParamArray.length && imageParamArray.length > 0) {
            objectArray = new ImageParam[bufferedImageArray.length];
            System.arraycopy(imageParamArray, 0, objectArray, 0, imageParamArray.length);
            Arrays.fill(objectArray, imageParamArray.length, bufferedImageArray.length, imageParamArray[imageParamArray.length - 1]);
        } else {
            objectArray = imageParamArray;
        }
        for (n = 0; n < bufferedImageArray.length; ++n) {
            try {
                tIFFWriter.setImageParam((ImageParam)objectArray[n]);
                n2 = tIFFWriter.writePage(bufferedImageArray[n], n3++, n4, randomAccessOutputStream, n2);
                arrayList.add(tIFFWriter.getIFD());
                continue;
            }
            catch (Exception exception) {
                LOGGER.error("Failed writing page " + n3, (Throwable)exception);
                throw new PageWritingException("Failed writing page " + n3, exception);
            }
        }
        for (n = 0; n < arrayList.size() - 1; ++n) {
            ((IFD)arrayList.get(n)).setNextIFDOffset(randomAccessOutputStream, ((IFD)arrayList.get(n + 1)).getStartOffset());
        }
        if (arrayList.size() > 0) {
            n = ((IFD)arrayList.get(0)).getStartOffset();
            TIFFTweaker.writeToStream(randomAccessOutputStream, n);
        }
    }

    public static int writePage(BufferedImage bufferedImage, RandomAccessOutputStream randomAccessOutputStream, List<IFD> list, int n, TIFFWriter tIFFWriter) throws IOException {
        try {
            n = tIFFWriter.writePage(bufferedImage, 0, 0, randomAccessOutputStream, n);
            list.add(tIFFWriter.getIFD());
        }
        catch (Exception exception) {
            LOGGER.error("Failed writing page", (Throwable)exception);
            throw new PageWritingException("Failed writing page", exception);
        }
        return n;
    }

    public static int writePage(ImageFrame imageFrame, RandomAccessOutputStream randomAccessOutputStream, List<IFD> list, int n, TIFFWriter tIFFWriter) throws IOException {
        BufferedImage bufferedImage = imageFrame.getFrame();
        tIFFWriter.setImageParam(imageFrame.getFrameParam());
        return TIFFTweaker.writePage(bufferedImage, randomAccessOutputStream, list, n, tIFFWriter);
    }

    private static void writeToStream(RandomAccessOutputStream randomAccessOutputStream, int n) throws IOException {
        randomAccessOutputStream.seek(4L);
        randomAccessOutputStream.writeInt(n);
        randomAccessOutputStream.seek(0L);
        randomAccessOutputStream.writeToStream(randomAccessOutputStream.getLength());
    }
}

