/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.io;

import com.icafe4j.io.IOUtils;
import com.icafe4j.util.ArrayUtils;
import java.io.IOException;
import java.io.InputStream;

public class PeekHeadInputStream
extends InputStream {
    private InputStream src;
    private byte[] buffer;
    private int position;
    private boolean closed;

    public PeekHeadInputStream(InputStream inputStream, int n) {
        this.src = inputStream;
        this.buffer = new byte[n];
        try {
            IOUtils.readFully(inputStream, this.buffer);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Error while reading bytes into buffer");
        }
    }

    public void shallowClose() throws IOException {
        if (this.closed) {
            return;
        }
        this.buffer = null;
        this.src = null;
        this.closed = true;
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.buffer = null;
        this.src.close();
        this.src = null;
        this.closed = true;
    }

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
    }

    public byte[] peek(int n) throws IOException {
        this.ensureOpen();
        if (n <= this.buffer.length) {
            return ArrayUtils.subArray(this.buffer, 0, n);
        }
        throw new IllegalArgumentException("Peek length larger than buffer");
    }

    @Override
    public int read() throws IOException {
        this.ensureOpen();
        if (this.position >= this.buffer.length) {
            return this.src.read();
        }
        return this.buffer[this.position++] & 0xFF;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.ensureOpen();
        if (this.position >= this.buffer.length) {
            return this.src.read(byArray, n, n2);
        }
        if (this.position + n2 > this.buffer.length) {
            int n3 = this.buffer.length - this.position;
            System.arraycopy(this.buffer, this.position, byArray, n, n3);
            this.position += n3;
            return n3 + this.src.read(byArray, n + n3, n2 - n3);
        }
        System.arraycopy(this.buffer, this.position, byArray, n, n2);
        this.position += n2;
        return n2;
    }
}

