/*
 * Decompiled with CFR 0.152.
 */
package com.icafe4j.util;

import java.io.PrintStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LangUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(LangUtils.class);

    private LangUtils() {
    }

    public static long[] doubleToRational(double d) {
        if (d == 0.0 || Double.isNaN(d)) {
            throw new IllegalArgumentException(d + " cannot be represented as a rational number");
        }
        long l = Double.doubleToLongBits(d);
        long l2 = l >>> 63;
        long l3 = (l >>> 52 ^ l2 << 11) - 1023L;
        long l4 = l << 12;
        long l5 = 1L;
        long l6 = 1L;
        for (int i = 63; i >= 12; --i) {
            l5 = l5 * 2L + (l4 >>> i & 1L);
            l6 *= 2L;
        }
        if (l3 > 0L) {
            l5 *= (long)(1 << (int)l3);
        } else {
            l6 *= (long)(1 << (int)(-l3));
        }
        if (l2 == 1L) {
            l5 *= -1L;
        }
        return new long[]{l5, l6};
    }

    public static Annotation getAnnotation(AnnotatedElement annotatedElement, String string) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception);
        }
        return annotatedElement.getAnnotation(clazz.asSubclass(Annotation.class));
    }

    public static String getClassName(Class<?> clazz) {
        String string = clazz.getName().replace('$', '.');
        if (clazz.isArray()) {
            switch (string.charAt(1)) {
                case 'B': {
                    string = "byte";
                    break;
                }
                case 'C': {
                    string = "char";
                    break;
                }
                case 'D': {
                    string = "double";
                    break;
                }
                case 'F': {
                    string = "float";
                    break;
                }
                case 'I': {
                    string = "int";
                    break;
                }
                case 'J': {
                    string = "long";
                    break;
                }
                case 'L': {
                    string = string.substring(2, string.length() - 1);
                    break;
                }
                case 'S': {
                    string = "short";
                    break;
                }
                case 'Z': {
                    string = "boolean";
                }
            }
            string = string + "[]";
        }
        return string;
    }

    public static Type[] getGenericTypeArguments(Method method, int n) {
        try {
            Type type = method.getGenericParameterTypes()[n];
            if (type instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)type;
                return parameterizedType.getActualTypeArguments();
            }
        }
        catch (Exception exception) {
            LOGGER.error("Error probing generic type arguments!", (Throwable)exception);
        }
        return new Type[0];
    }

    public static void log(String string, PrintStream printStream) {
        StackTraceElement stackTraceElement = Thread.currentThread().getStackTrace()[2];
        printStream.println("; " + string + " - [" + stackTraceElement.getClassName() + "." + stackTraceElement.getMethodName() + "(): line " + stackTraceElement.getLineNumber() + "]");
    }

    public static URL getLoadedClassLocation(Class<?> clazz) {
        ProtectionDomain protectionDomain = clazz.getProtectionDomain();
        CodeSource codeSource = protectionDomain.getCodeSource();
        URL uRL = codeSource == null ? null : codeSource.getLocation();
        return uRL;
    }

    public static URL getLoadedClassLocation(String string) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        return LangUtils.getLoadedClassLocation(clazz);
    }

    public static URL getLoadedClassURL(String string) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        ClassLoader classLoader = clazz.getClassLoader();
        URL uRL = classLoader.getResource(string.replaceAll(Pattern.quote("."), "/") + ".class");
        return uRL;
    }

    public static void invokeMain(String ... stringArray) {
        try {
            Class<?> clazz = Class.forName(stringArray[0]);
            Class<String[]> clazz2 = String[].class;
            Method method = clazz.getDeclaredMethod("main", clazz2);
            String[] stringArray2 = Arrays.copyOfRange(stringArray, 1, stringArray.length);
            LOGGER.info("invoking {}.main()\n", (Object)clazz.getName());
            method.invoke(null, new Object[]{stringArray2});
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static int longToIntHashCode(long l) {
        return Long.valueOf(l).hashCode();
    }

    public static URI relativize(URI uRI, URI uRI2) {
        int n;
        int n2;
        uRI = uRI.normalize();
        uRI2 = uRI2.normalize();
        String[] stringArray = uRI.getPath().split("/");
        String[] stringArray2 = uRI2.getPath().split("/");
        if (stringArray.length > 0 && !uRI.getPath().endsWith("/")) {
            System.arraycopy(stringArray, 0, stringArray, 0, stringArray.length - 1);
        }
        for (n2 = 0; n2 < stringArray.length && n2 < stringArray2.length && stringArray[n2].equals(stringArray2[n2]); ++n2) {
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (n = 0; n < stringArray.length - n2; ++n) {
            stringBuilder.append("../");
        }
        for (n = n2; n < stringArray2.length; ++n) {
            if (n != n2) {
                stringBuilder.append("/");
            }
            stringBuilder.append(stringArray2[n]);
        }
        return URI.create(stringBuilder.toString());
    }
}

