/*
 * Decompiled with CFR 0.152.
 */
package net.markenwerk.utils.mail.dkim;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import net.markenwerk.utils.mail.dkim.DkimException;
import net.markenwerk.utils.mail.dkim.DomainKey;

public final class DomainKeyUtil {
    private static final Map<String, DomainKey> CACHE = new HashMap<String, DomainKey>();
    private static final long DEFAULT_CACHE_TTL = 0x6DDD00L;
    private static long cacheTtl = 0x6DDD00L;

    private DomainKeyUtil() {
    }

    public static synchronized long getCacheTtl() {
        return cacheTtl;
    }

    public static synchronized void setCacheTtl(long cacheTtl) {
        if (cacheTtl < 0L) {
            cacheTtl = 0x6DDD00L;
        }
        DomainKeyUtil.cacheTtl = cacheTtl;
    }

    public static synchronized DomainKey getDomainKey(String signingDomain, String selector) throws DkimException {
        return DomainKeyUtil.getDomainKey(DomainKeyUtil.getRecordName(signingDomain, selector));
    }

    private static synchronized DomainKey getDomainKey(String recordName) throws DkimException {
        DomainKey domainKey = CACHE.get(recordName);
        if (null != domainKey && (0L == cacheTtl || domainKey.getTimestamp() + cacheTtl > System.currentTimeMillis())) {
            return domainKey;
        }
        domainKey = DomainKeyUtil.fetchDomainKey(recordName);
        CACHE.put(recordName, domainKey);
        return domainKey;
    }

    private static DomainKey fetchDomainKey(String recordName) throws DkimException {
        return new DomainKey(DomainKeyUtil.getTags(recordName));
    }

    public static Map<Character, String> getTags(String signingDomain, String selector) throws DkimException {
        return DomainKeyUtil.getTags(DomainKeyUtil.getRecordName(signingDomain, selector));
    }

    private static Map<Character, String> getTags(String recordName) throws DkimException {
        HashMap<Character, String> tags = new HashMap<Character, String>();
        String unquotedRecordValue = DomainKeyUtil.unquoteRecordValue(DomainKeyUtil.getValue(recordName));
        for (String tag : unquotedRecordValue.split(";")) {
            try {
                tag = tag.trim();
                tags.put(Character.valueOf(tag.charAt(0)), tag.substring(2));
            }
            catch (IndexOutOfBoundsException e) {
                throw new DkimException("The tag " + tag + " in RR " + recordName + " couldn't be decoded.", e);
            }
        }
        return tags;
    }

    private static String unquoteRecordValue(String recordValue) {
        if (recordValue != null && (recordValue.startsWith("\"") && recordValue.endsWith("\"") || recordValue.startsWith("'") && recordValue.endsWith("'"))) {
            recordValue = recordValue.substring(1, recordValue.length() - 1);
        }
        return recordValue;
    }

    public static String getValue(String signingDomain, String selector) throws DkimException {
        return DomainKeyUtil.getValue(DomainKeyUtil.getRecordName(signingDomain, selector));
    }

    private static String getValue(String recordName) throws DkimException {
        try {
            InitialDirContext dnsContext = new InitialDirContext(DomainKeyUtil.getEnvironment());
            Attributes attributes = dnsContext.getAttributes(recordName, new String[]{"TXT"});
            Attribute txtRecord = attributes.get("txt");
            if (txtRecord == null) {
                throw new DkimException("There is no TXT record available for " + recordName);
            }
            StringBuilder builder = new StringBuilder();
            NamingEnumeration<?> e = txtRecord.getAll();
            while (e.hasMore()) {
                builder.append((String)e.next());
            }
            String value = builder.toString();
            if (value.isEmpty()) {
                throw new DkimException("Value of RR " + recordName + " couldn't be retrieved");
            }
            return value;
        }
        catch (NamingException ne) {
            throw new DkimException("Selector lookup failed", ne);
        }
    }

    private static String getRecordName(String signingDomain, String selector) {
        return selector + "._domainkey." + signingDomain;
    }

    private static Hashtable<String, String> getEnvironment() {
        Hashtable<String, String> environment = new Hashtable<String, String>();
        environment.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
        return environment;
    }
}

