/*
 * Decompiled with CFR 0.152.
 */
package cc.ceofax.controller;

import cc.ceofax.bean.Friend;
import cc.ceofax.bean.NoteStamp;
import cc.ceofax.bean.PDocument;
import cc.ceofax.bean.RDocument;
import cc.ceofax.controller.Main;
import cc.ceofax.controller.portal;
import cc.ceofax.tool.S3Tool;
import cc.ceofax.tool.StyleChangingRowFactory;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.sun.media.imageioimpl.plugins.tiff.TIFFImageWriterSpi;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.embed.swing.SwingFXUtils;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.SnapshotParameters;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.Slider;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.image.ImageView;
import javafx.scene.image.PixelReader;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DataFormat;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.transform.Transform;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.filechooser.FileSystemView;

public class DocViewer {
    public static Timer autoRefreshTimer;
    public static int editImgSteps;
    private static boolean shouldCenterImg;
    public ScrollPane documentScroller;
    public ImageView imgViewer;
    public Button btnCut;
    public Rectangle dragBox;
    public Button btnCutReback;
    public Button btnPasNote;
    public Label noteStampsLabel;
    public AnchorPane imgviewerPane;
    public Button btnNote;
    public TableView lstNoteStamps;
    public TextArea txtNoteContent;
    public Slider txtNoteSize;
    public CheckBox noteBorder;
    public HBox btnGroup1;
    public VBox btnGroup2;
    public StackPane zoomPane;
    public Group group;
    public TabPane tabBosses;
    public Button btnCreateQRCode;
    public Button btnSentTo;
    public VBox boxDocLists;
    public VBox friendsList;
    public TableView lstDocs1;
    public TableView lstDocs2;
    public TableView lstDocs3;
    public TableColumn lstDocs1Label;
    public TableColumn lstDocs1Page;
    public TableColumn lstDocs2Label;
    public TableColumn lstDocs2Page;
    public TableColumn lstDocs3Label;
    public TableColumn lstDocs3Page;
    public Map<String, TableView> rDocTables;
    public Button btnSkip;
    public static String docLabel;
    public TextField txtRDPage;
    public Button btnSetBlank;
    public Button btnClearNoteStampTxt;
    public ImageView qrImg;
    public CheckBox chkAutoRefresh;
    public TextField txtAutoRefreshTimer;
    public Button btnEndPastNote;
    int touchx;
    int touchy;
    double boxx;
    double boxy;
    static int fontSize;
    public static DataFormat dataFormat;
    public boolean canAutoIncreasePage = false;
    boolean thisIsBlank = false;
    static int autoRefresh;

    public void showNoteStampsLabel() {
        if (!this.noteStampsLabel.isVisible() && this.imgViewer.getImage() != null) {
            this.noteStampsLabel.setVisible(true);
            this.noteStampsLabel.setLayoutX(this.imgViewer.getLayoutX() + this.imgViewer.getImage().getWidth() / 2.0);
            this.noteStampsLabel.setLayoutY(this.imgViewer.getLayoutY() + this.imgViewer.getImage().getHeight() / 2.0);
        }
    }

    public static void saveStepImgs() {
        File file = new File(Main.dir + "\\\u66ab\u5b58\\step" + ++editImgSteps + ".tiff");
        DocViewer.saveImgViewer(file);
        if (editImgSteps > 1) {
            Stage s = portal.stages.get("DocViewer");
            Button btnEndPastNote = (Button)s.getScene().lookup("#btnEndPastNote");
            btnEndPastNote.setDisable(false);
        }
    }

    public static void loadImage(File f) throws IOException {
        Stage s = portal.stages.get("DocViewer");
        ImageView imgViewer = (ImageView)s.getScene().lookup("#imgViewer");
        if (f.exists()) {
            double yRate;
            shouldCenterImg = true;
            BufferedImage bi = null;
            bi = ImageIO.read(f);
            WritableImage wr = null;
            if (bi != null) {
                wr = new WritableImage(bi.getWidth(), bi.getHeight());
                PixelWriter pw = wr.getPixelWriter();
                for (int x = 0; x < bi.getWidth(); ++x) {
                    for (int y = 0; y < bi.getHeight(); ++y) {
                        pw.setArgb(x, y, bi.getRGB(x, y));
                    }
                }
                pw = null;
            }
            imgViewer.setImage(wr);
            imgViewer.setFitWidth(wr.getWidth());
            imgViewer.setFitHeight(wr.getHeight());
            Group group = (Group)s.getScene().lookup("#group");
            double xRate = (float)((s.getWidth() - 250.0) / wr.getWidth());
            double rate = yRate = (double)((float)((s.getHeight() - 100.0) / wr.getHeight()));
            if (xRate < yRate) {
                rate = xRate;
            }
            if (rate > 1.0) {
                rate = 1.0;
            }
            group.setScaleX(rate);
            group.setScaleY(rate);
            editImgSteps = 0;
            DocViewer.saveStepImgs();
            wr = null;
            bi.flush();
            bi = null;
            System.gc();
        } else {
            imgViewer.setImage(null);
        }
    }

    private void setSelection(TableView table, IndexedCell cell) {
        table.getSelectionModel().select(cell.getIndex());
        this.btnSkip.setDisable(table.getSelectionModel().getSelectedItems().size() == 0);
        table.requestFocus();
    }

    public void initialize() {
        double[] startDragX = new double[]{0.0};
        double[] startDragY = new double[]{0.0};
        double[] oldX = new double[]{0.0};
        double[] oldY = new double[]{0.0};
        editImgSteps = 0;
        this.btnSkip.setDisable(true);
        this.txtAutoRefreshTimer.setText(String.valueOf(autoRefresh));
        this.txtAutoRefreshTimer.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (autoRefreshTimer != null) {
                    autoRefreshTimer.cancel();
                    autoRefreshTimer = null;
                }
                autoRefresh = Integer.parseInt(DocViewer.this.txtAutoRefreshTimer.getText());
                if (!newValue.matches("\\d*")) {
                    DocViewer.this.txtAutoRefreshTimer.setText(newValue.replaceAll("[^\\d]", ""));
                }
                if (DocViewer.this.txtAutoRefreshTimer.getText().length() > 3) {
                    String s = DocViewer.this.txtAutoRefreshTimer.getText().substring(0, 3);
                    DocViewer.this.txtAutoRefreshTimer.setText(s);
                }
                DocViewer.this.chkAutoRefresh.setSelected(false);
            }
        });
        this.txtRDPage.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (!newValue.matches("\\d*")) {
                    DocViewer.this.txtRDPage.setText(newValue.replaceAll("[^\\d]", ""));
                }
                if (DocViewer.this.txtRDPage.getText().length() > 3) {
                    String s = DocViewer.this.txtRDPage.getText().substring(0, 3);
                    DocViewer.this.txtRDPage.setText(s);
                }
            }
        });
        this.lstDocs1.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.lstDocs1.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        this.lstDocs1Label.setCellValueFactory((Callback)new PropertyValueFactory("label"));
        this.lstDocs1Page.setCellValueFactory((Callback)new PropertyValueFactory("page"));
        StyleChangingRowFactory<PDocument> rowFactory = new StyleChangingRowFactory<PDocument>("highlightedRow", new Callback<TableView<PDocument>, TableRow<PDocument>>(){

            public TableRow<PDocument> call(final TableView<PDocument> tableView) {
                TableRow<PDocument> row = new TableRow<PDocument>(){

                    protected void updateItem(PDocument d, boolean b) {
                        super.updateItem((Object)d, b);
                        if (d != null) {
                            // empty if block
                        }
                    }
                };
                row.addEventFilter(MouseEvent.MOUSE_PRESSED, (EventHandler)new EventHandler<MouseEvent>((TableRow)row, tableView){
                    final /* synthetic */ TableRow val$row;
                    final /* synthetic */ TableView val$tableView;
                    {
                        this.val$row = tableRow;
                        this.val$tableView = tableView;
                    }

                    public void handle(MouseEvent event) {
                        int index = this.val$row.getIndex();
                        if (event.isPrimaryButtonDown()) {
                            if (index >= 0 && index < this.val$tableView.getItems().size()) {
                                boolean bl = DocViewer.this.canAutoIncreasePage = this.val$tableView == DocViewer.this.lstDocs1;
                                if (DocViewer.this.txtRDPage.getText().length() == 0) {
                                    String fid = ((Tab)DocViewer.this.tabBosses.getSelectionModel().getSelectedItem()).getId();
                                    DocViewer.this.txtRDPage.setText(String.valueOf(Main.rDocumentLists.get(fid).size() + 1));
                                }
                                this.val$tableView.getSelectionModel().select(index);
                                PDocument p = (PDocument)this.val$tableView.getSelectionModel().getSelectedItem();
                                File f = new File(Main.dir + "\\\u96f2\u7aef\\" + p.getFilename());
                                try {
                                    Main.viewFilename = f.getPath();
                                    docLabel = p.getLabel() + "- P" + p.getPage();
                                    DocViewer.loadImage(f);
                                    portal.stages.get("DocViewer").setTitle("\u6aa2\u8996\u6587\u4ef6 - " + docLabel);
                                }
                                catch (IOException e) {
                                    Main.log.error((Object)"error:", (Throwable)e);
                                }
                                event.consume();
                            }
                            DocViewer.this.btnSkip.setDisable(this.val$tableView.getSelectionModel().getSelectedItems().size() == 0);
                        }
                        this.val$tableView.requestFocus();
                    }
                });
                row.setOnDragEntered((EventHandler)new EventHandler<DragEvent>((TableRow)row){
                    final /* synthetic */ TableRow val$row;
                    {
                        this.val$row = tableRow;
                    }

                    public void handle(DragEvent t) {
                        DocViewer.this.setSelection(tableView, (IndexedCell)this.val$row);
                    }
                });
                row.setOnDragDetected((EventHandler)new EventHandler<MouseEvent>((TableRow)row, tableView){
                    final /* synthetic */ TableRow val$row;
                    final /* synthetic */ TableView val$tableView;
                    {
                        this.val$row = tableRow;
                        this.val$tableView = tableView;
                    }

                    public void handle(MouseEvent t) {
                        Dragboard db = this.val$row.getTableView().startDragAndDrop(new TransferMode[]{TransferMode.COPY});
                        ClipboardContent content = new ClipboardContent();
                        content.put((Object)dataFormat, (Object)"XData");
                        db.setContent((Map)content);
                        DocViewer.this.setSelection(this.val$tableView, (IndexedCell)this.val$row);
                        t.consume();
                    }
                });
                row.setOnMouseClicked(arg_0 -> this.lambda$call$1((TableRow)row, tableView, arg_0));
                return row;
            }

            private /* synthetic */ void lambda$call$1(TableRow row, TableView tableView, MouseEvent event) {
                if (!(row.isEmpty() || event.isControlDown() || event.isShiftDown())) {
                    tableView.getSelectionModel().clearSelection();
                    tableView.getSelectionModel().select(row.getIndex());
                    DocViewer.this.thisIsBlank = false;
                }
            }
        });
        this.lstDocs1.setRowFactory(rowFactory);
        this.lstDocs2.setRowFactory(rowFactory);
        this.lstDocs3.setRowFactory(rowFactory);
        if (Main.pDocumentLists.get(1) != null) {
            this.lstDocs1.setItems(FXCollections.observableArrayList((Collection)Main.pDocumentLists.get(1)));
        }
        this.lstDocs2.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        this.lstDocs2Label.setCellValueFactory((Callback)new PropertyValueFactory("label"));
        this.lstDocs2Page.setCellValueFactory((Callback)new PropertyValueFactory("page"));
        if (Main.pDocumentLists.get(2) != null) {
            this.lstDocs2.setItems(FXCollections.observableArrayList((Collection)Main.pDocumentLists.get(2)));
        }
        this.lstDocs3.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        this.lstDocs3Label.setCellValueFactory((Callback)new PropertyValueFactory("label"));
        this.lstDocs3Page.setCellValueFactory((Callback)new PropertyValueFactory("page"));
        if (Main.pDocumentLists.get(3) != null) {
            this.lstDocs3.setItems(FXCollections.observableArrayList((Collection)Main.pDocumentLists.get(3)));
        }
        this.rDocTables = new HashMap<String, TableView>();
        boolean hasBoss = false;
        for (final Friend f : Main.friends.values()) {
            if (!f.isBoss()) continue;
            hasBoss = true;
            final String bossName = f.getNickname() + (f.getBossCode() != null ? "(" + f.getBossCode() + ")" : "");
            String[] tab = new Tab();
            tab.setText(bossName);
            VBox vbox = new VBox();
            Button btn = new Button();
            btn.setText("\u50b3\u9001\u4eca\u65e5\u7d50\u679c\u7d66" + bossName);
            btn.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    BufferedImage bi = new BufferedImage(630, 891, 12);
                    Graphics2D graphics = bi.createGraphics();
                    graphics.setBackground(Color.WHITE);
                    graphics.fillRect(0, 0, bi.getWidth(), bi.getHeight());
                    WritableImage newImage = SwingFXUtils.toFXImage((BufferedImage)bi, null);
                    DocViewer.this.imgViewer.setImage((javafx.scene.image.Image)newImage);
                    DocViewer.this.imgViewer.setFitWidth(newImage.getWidth());
                    DocViewer.this.imgViewer.setFitHeight(newImage.getHeight());
                    DocViewer.this.noteBorder.setSelected(true);
                    DocViewer.this.txtNoteSize.setValue(24.0);
                    int repeatNum = 1;
                    int blankNum = 1;
                    StringBuilder repeatStr = new StringBuilder("");
                    StringBuilder blankStr = new StringBuilder("");
                    if (Main.rDocumentLists.get(f.getIdStr()) == null) {
                        Main.rDocumentLists.put(f.getIdStr(), new ArrayList());
                    }
                    for (RDocument rd : Main.rDocumentLists.get(f.getIdStr())) {
                        if (rd.isRepeat()) {
                            repeatStr.append("P" + rd.getPage()).append("x").append(rd.getRepeatTimes()).append(" ,");
                            if (repeatNum % 5 == 0) {
                                repeatStr.append("\n      ");
                            }
                            ++repeatNum;
                        }
                        if (!rd.isBlank()) continue;
                        blankStr.append("P" + rd.getPage()).append(" ,");
                        if (blankNum % 10 == 0) {
                            blankStr.append("\n      ");
                        }
                        ++blankNum;
                    }
                    if (repeatStr.length() > 0) {
                        repeatStr.deleteCharAt(repeatStr.lastIndexOf(","));
                    }
                    if (blankStr.length() > 0) {
                        blankStr.deleteCharAt(blankStr.lastIndexOf(","));
                    }
                    String resultStr = bossName + "\n\n\u672c\u65e5\u5171 " + Main.rDocumentLists.get(f.getIdStr()).size() + "\u5f35\n\n" + "\u91cd\u50b3: " + repeatStr.toString() + "\n\n" + "\u7a7a\u55ae: " + blankStr.toString();
                    DocViewer.this.txtNoteContent.setText(resultStr);
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            DocViewer.this.noteStampsLabel.setLayoutX(DocViewer.this.imgViewer.getLayoutX() + (630.0 - DocViewer.this.noteStampsLabel.getWidth()) / 2.0);
                            DocViewer.this.noteStampsLabel.setLayoutY(DocViewer.this.imgViewer.getLayoutY() + 100.0);
                        }
                    });
                    repeatStr = null;
                    blankStr = null;
                    bi.flush();
                    bi = null;
                    graphics.dispose();
                    graphics = null;
                    newImage = null;
                    System.gc();
                    DocViewer.this.txtRDPage.setText("");
                }
            });
            vbox.getChildren().add((Object)btn);
            ArrayList ds = Main.rDocumentLists.get(f.getIdStr());
            if (ds == null) {
                ds = new ArrayList();
            }
            ObservableList docs = FXCollections.observableArrayList((Collection)ds);
            TableView listView = new TableView();
            listView.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
            TableColumn pagegCol = new TableColumn("\u8f49\u50b3\u9801");
            pagegCol.setSortable(false);
            pagegCol.setStyle("-fx-padding: 0 0 0 20;");
            pagegCol.setCellValueFactory((Callback)new PropertyValueFactory("label"));
            Object[] cols = new TableColumn[]{pagegCol};
            listView.getColumns().addAll(cols);
            listView.setItems(docs);
            listView.setRowFactory(tv -> {
                TableRow row = new TableRow();
                row.setOnMouseClicked(event -> {
                    if (!row.isEmpty()) {
                        this.canAutoIncreasePage = false;
                        RDocument d = (RDocument)row.getItem();
                        this.btnSetBlank.setDisable(d.isBlank());
                        this.txtRDPage.setText(String.valueOf(d.getPage()));
                        Main.selectFilename = d.getFilename();
                        Main.viewFilename = Main.dir + "\\\u96f2\u7aef\\" + Main.selectFilename;
                        try {
                            DocViewer.loadImage(new File(Main.viewFilename));
                            docLabel = d.getFrom();
                            portal.stages.get("DocViewer").setTitle("\u6aa2\u8996\u6587\u4ef6 - " + docLabel);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        this.thisIsBlank = false;
                    }
                });
                return row;
            });
            VBox.setVgrow((Node)listView, (Priority)Priority.ALWAYS);
            vbox.setPadding(new Insets(5.0, 0.0, 5.0, 0.0));
            vbox.setSpacing(10.0);
            vbox.getChildren().add((Object)listView);
            vbox.setAlignment(Pos.TOP_CENTER);
            tab.setContent((Node)vbox);
            tab.setId(f.getIdStr());
            this.tabBosses.getTabs().add((Object)tab);
            this.rDocTables.put(f.getIdStr(), listView);
        }
        if (hasBoss) {
            this.btnSentTo.setText("\u7d66 " + ((Tab)this.tabBosses.getTabs().get(0)).getText());
            this.txtRDPage.setText(String.valueOf(this.rDocTables.get(((Tab)this.tabBosses.getTabs().get(0)).getId()).getItems().size() + 1));
        }
        if (!Main.setting.isShowRedirectToFriend()) {
            ((Pane)this.btnSentTo.getParent()).getChildren().remove((Object)this.btnSentTo);
            ((Pane)this.btnCreateQRCode.getParent()).getChildren().remove((Object)this.btnCreateQRCode);
            ((Pane)this.tabBosses.getParent()).getChildren().remove((Object)this.tabBosses);
            ((Pane)this.btnSetBlank.getParent()).getChildren().remove((Object)this.btnSetBlank);
            ((Pane)this.boxDocLists.getParent()).getChildren().remove((Object)this.boxDocLists);
            ((Pane)this.friendsList.getParent()).getChildren().remove((Object)this.friendsList);
        }
        if (!Main.setting.isShowLabelingTool()) {
            ((Pane)this.btnGroup2.getParent()).getChildren().remove((Object)this.btnGroup2);
        }
        this.tabBosses.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<Tab>(){

            public void changed(ObservableValue<? extends Tab> ov, Tab t, Tab t1) {
                DocViewer.this.btnSentTo.setText("\u7d66 " + t1.getText());
                DocViewer.this.txtRDPage.setText(String.valueOf(DocViewer.this.rDocTables.get(t1.getId()).getItems().size() + 1));
            }
        });
        this.noteStampsLabel.setVisible(false);
        this.noteStampsLabel.setFont(new javafx.scene.text.Font("DFKai-sb", (double)fontSize));
        this.noteStampsLabel.setStyle("-fx-font-weight: bold");
        this.noteStampsLabel.getStyleClass().clear();
        this.noteStampsLabel.getStyleClass().add((Object)"noteStampsBLabel");
        this.noteStampsLabel.setLayoutX(0.0);
        this.noteStampsLabel.setLayoutY(0.0);
        this.noteStampsLabel.setStyle("-fx-font-size:" + Math.round(fontSize) + "px");
        this.noteStampsLabel.setBorder(new Border(new BorderStroke[]{new BorderStroke((Paint)javafx.scene.paint.Color.RED, BorderStrokeStyle.SOLID, new CornerRadii(5.0), new BorderWidths(5.0))}));
        this.noteStampsLabel.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                if (mouseEvent.getButton().equals((Object)MouseButton.PRIMARY) && mouseEvent.getClickCount() == 2) {
                    DocViewer.this.btnPasNoteAction(null);
                }
            }
        });
        this.noteStampsLabel.setOnMousePressed(e -> {
            startDragX[0] = e.getSceneX() / this.group.getScaleX();
            startDragY[0] = e.getSceneY() / this.group.getScaleY();
            oldX[0] = this.noteStampsLabel.getLayoutX();
            oldY[0] = this.noteStampsLabel.getLayoutY();
            e.consume();
        });
        this.noteStampsLabel.setOnMouseDragged(e -> {
            this.noteStampsLabel.setLayoutX(-e.getSceneX() / this.group.getScaleX() + startDragX[0] + oldX[0]);
            this.noteStampsLabel.setLayoutY(e.getSceneY() / this.group.getScaleY() - startDragY[0] + oldY[0]);
            e.consume();
        });
        this.qrImg.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                if (mouseEvent.getButton().equals((Object)MouseButton.PRIMARY) && mouseEvent.getClickCount() == 2) {
                    DocViewer.this.btnPasNoteAction(null);
                }
            }
        });
        this.qrImg.setOnMousePressed(e -> {
            startDragX[0] = e.getSceneX() / this.group.getScaleX();
            startDragY[0] = e.getSceneY() / this.group.getScaleY();
            oldX[0] = this.qrImg.getLayoutX();
            oldY[0] = this.qrImg.getLayoutY();
            e.consume();
        });
        this.qrImg.setOnMouseDragged(e -> {
            this.qrImg.setLayoutX(-e.getSceneX() / this.group.getScaleX() + startDragX[0] + oldX[0]);
            this.qrImg.setLayoutY(e.getSceneY() / this.group.getScaleY() - startDragY[0] + oldY[0]);
            e.consume();
        });
        this.imgViewer.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                shouldCenterImg = false;
                if (!DocViewer.this.documentScroller.isPannable()) {
                    DocViewer.this.touchx = (int)event.getX();
                    DocViewer.this.touchy = (int)event.getY();
                    DocViewer.this.dragBox.setX(event.getSceneX());
                    DocViewer.this.dragBox.setY(event.getSceneY());
                    DocViewer.this.boxx = event.getSceneX();
                    DocViewer.this.boxy = event.getSceneY();
                    DocViewer.this.dragBox.setWidth(0.0);
                    DocViewer.this.dragBox.setHeight(0.0);
                    DocViewer.this.dragBox.setVisible(true);
                    event.consume();
                }
            }
        });
        this.imgViewer.addEventHandler(MouseEvent.MOUSE_DRAGGED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                shouldCenterImg = false;
                if (!DocViewer.this.documentScroller.isPannable()) {
                    if (event.getSceneX() < DocViewer.this.boxx) {
                        DocViewer.this.dragBox.setX(event.getSceneX());
                    }
                    if (event.getSceneY() < DocViewer.this.boxy) {
                        DocViewer.this.dragBox.setY(event.getSceneY());
                    }
                    DocViewer.this.dragBox.setWidth(Math.abs(DocViewer.this.boxx - event.getSceneX()));
                    DocViewer.this.dragBox.setHeight(Math.abs(DocViewer.this.boxy - event.getSceneY()));
                    event.consume();
                }
            }
        });
        this.imgViewer.setOnMouseReleased((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                shouldCenterImg = false;
                if (!DocViewer.this.documentScroller.isPannable()) {
                    DocViewer.this.dragBox.setVisible(false);
                    int w = (int)Math.abs((double)DocViewer.this.touchx - event.getX());
                    int h = (int)Math.abs((double)DocViewer.this.touchy - event.getY());
                    if ((double)DocViewer.this.touchx > event.getX()) {
                        DocViewer.this.touchx = (int)event.getX();
                    }
                    if ((double)DocViewer.this.touchy > event.getY()) {
                        DocViewer.this.touchy = (int)event.getY();
                    }
                    if (DocViewer.this.touchx < 0) {
                        DocViewer.this.touchx = 0;
                    }
                    if (DocViewer.this.touchy < 0) {
                        DocViewer.this.touchy = 0;
                    }
                    if ((double)(DocViewer.this.touchx + w) > DocViewer.this.imgViewer.getImage().getWidth()) {
                        w = (int)(DocViewer.this.imgViewer.getImage().getWidth() - (double)DocViewer.this.touchx);
                    }
                    if ((double)(DocViewer.this.touchy + h) > DocViewer.this.imgViewer.getImage().getHeight()) {
                        h = (int)(DocViewer.this.imgViewer.getImage().getHeight() - (double)DocViewer.this.touchy);
                    }
                    if (w > 0 && h > 0) {
                        PixelReader reader = DocViewer.this.imgViewer.getImage().getPixelReader();
                        WritableImage newImage = new WritableImage(reader, DocViewer.this.touchx, DocViewer.this.touchy, w, h);
                        DocViewer.this.imgViewer.setImage((javafx.scene.image.Image)newImage);
                        DocViewer.this.imgViewer.setFitWidth(newImage.getWidth());
                        DocViewer.this.imgViewer.setFitHeight(newImage.getHeight());
                        DocViewer.this.btnCut.setText("\u88c1\u5207\u5340\u57df");
                        DocViewer.this.documentScroller.setPannable(true);
                        DocViewer.this.imgViewer.setCursor(Cursor.DEFAULT);
                        DocViewer.saveStepImgs();
                    }
                    event.consume();
                }
            }
        });
        ArrayList<NoteStamp> theNoteStamps = new ArrayList<NoteStamp>();
        theNoteStamps.addAll(Main.noteStamps);
        String[] words = new String[]{"\u2605", "\u25a1", "\u25cf", "\u25cb", "\u2714", "\u2716", "\u2191", "\u2197", "\u2192", "\u2198", "\u2193", "\u2199", "\u2190", "\u2196"};
        int i = Main.noteStamps.size();
        for (String w : words) {
            NoteStamp n = new NoteStamp();
            n.setContent(w);
            n.setOrder(i);
            theNoteStamps.add(n);
            ++i;
        }
        TableColumn noteContent = new TableColumn("\u6a19\u7c64\u6a23\u7248");
        noteContent.setStyle("-fx-alignment: CENTER;");
        TableColumn order = new TableColumn("\u9806\u5e8f");
        order.setVisible(false);
        noteContent.setCellValueFactory((Callback)new PropertyValueFactory("content"));
        noteContent.setSortable(false);
        order.setCellValueFactory((Callback)new PropertyValueFactory("order"));
        order.setSortable(true);
        Object[] NScols = new TableColumn[]{noteContent, order};
        this.lstNoteStamps.getColumns().addAll(NScols);
        this.lstNoteStamps.setItems(FXCollections.observableArrayList(theNoteStamps));
        this.lstNoteStamps.getSortOrder().add((Object)order);
        this.lstNoteStamps.getSelectionModel().selectedItemProperty().addListener((obs, oldSelection, newSelection) -> {
            if (newSelection != null) {
                if (this.noteStampsLabel.getText().length() == 0) {
                    this.noteStampsLabel.setLayoutX(this.noteStampsLabel.getLayoutX() + 30.0);
                    this.noteStampsLabel.setLayoutY(this.noteStampsLabel.getLayoutY() + 30.0);
                }
                this.noteStampsLabel.setText(((NoteStamp)newSelection).getContent());
                this.showNoteStampsLabel();
                this.txtNoteContent.setText(((NoteStamp)newSelection).getContent());
                this.noteStampsLabel.setTextFill((Paint)javafx.scene.paint.Color.RED);
                if (this.noteBorder.isSelected()) {
                    this.noteStampsLabel.setBorder(new Border(new BorderStroke[]{new BorderStroke((Paint)javafx.scene.paint.Color.RED, BorderStrokeStyle.SOLID, new CornerRadii(5.0), new BorderWidths(5.0))}));
                } else {
                    this.noteStampsLabel.setBorder(null);
                }
            }
        });
        this.lstNoteStamps.getSelectionModel().selectedItemProperty().addListener((obs, oldSelection, newSelection) -> {
            if (newSelection != null) {
                NoteStamp n = (NoteStamp)newSelection;
                this.txtNoteContent.setText(n.getContent());
                this.noteBorder.setSelected(n.hasBorder);
                this.noteBorderAction(null);
                this.txtNoteSize.setValue((double)n.fontSize);
            }
        });
        this.txtNoteContent.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (DocViewer.this.noteStampsLabel.getText().length() == 0) {
                    DocViewer.this.noteStampsLabel.setLayoutX(DocViewer.this.imgViewer.getLayoutX() + DocViewer.this.imgViewer.getFitWidth() / 2.0);
                    DocViewer.this.noteStampsLabel.setLayoutY(DocViewer.this.imgViewer.getLayoutY() + DocViewer.this.imgViewer.getFitHeight() / 2.0);
                }
                DocViewer.this.noteStampsLabel.setText(newValue);
                if (newValue.length() > 0) {
                    DocViewer.this.showNoteStampsLabel();
                }
                DocViewer.this.btnPasNote.setDisable(newValue.length() == 0);
                DocViewer.this.noteStampsLabel.setTextFill((Paint)javafx.scene.paint.Color.RED);
                if (DocViewer.this.noteBorder.isSelected()) {
                    DocViewer.this.noteStampsLabel.setBorder(new Border(new BorderStroke[]{new BorderStroke((Paint)javafx.scene.paint.Color.RED, BorderStrokeStyle.SOLID, new CornerRadii(5.0), new BorderWidths(5.0))}));
                } else {
                    DocViewer.this.noteStampsLabel.setBorder(null);
                }
            }
        });
        this.txtNoteSize.setValue((double)fontSize);
        this.txtNoteSize.valueProperty().addListener((obs, oldValue, newValue) -> {
            fontSize = newValue.intValue();
            if (this.qrImg.getImage() != null && this.qrImg.isVisible()) {
                this.qrImg.setFitWidth(180.0 * (double)((float)fontSize / 20.0f));
                this.qrImg.setFitHeight(220.0 * (double)((float)fontSize / 20.0f));
            } else {
                this.noteStampsLabel.setStyle("-fx-font-size:" + Math.round(fontSize) + "px");
            }
        });
        double SCALE_DELTA = 1.1;
        this.zoomPane.setOnScroll((EventHandler)new EventHandler<ScrollEvent>(){

            public void handle(ScrollEvent event) {
                event.consume();
                if (event.getDeltaY() == 0.0) {
                    return;
                }
                double scaleFactor = event.getDeltaY() > 0.0 ? 1.1 : 0.9090909090909091;
                DocViewer.this.group.setScaleX(DocViewer.this.group.getScaleX() * scaleFactor);
                DocViewer.this.group.setScaleY(DocViewer.this.group.getScaleY() * scaleFactor);
                if (DocViewer.this.group.getScaleX() > 1.0) {
                    DocViewer.this.group.setScaleX(1.0);
                    DocViewer.this.group.setScaleY(1.0);
                }
                DocViewer.this.group.requestLayout();
            }
        });
        ChangeListener<Object> changeListener = new ChangeListener<Object>(){

            public void changed(ObservableValue<? extends Object> observable, Object oldValue, Object newValue) {
                if (shouldCenterImg) {
                    DocViewer.this.documentScroller.setHvalue(0.5);
                    DocViewer.this.documentScroller.setVvalue(0.5);
                }
            }
        };
        this.documentScroller.viewportBoundsProperty().addListener((ChangeListener)changeListener);
        this.documentScroller.hvalueProperty().addListener((ChangeListener)changeListener);
        this.documentScroller.vvalueProperty().addListener((ChangeListener)changeListener);
    }

    public void zoomInAction(ActionEvent actionEvent) {
        if (this.group.getScaleX() < 1.0) {
            this.group.setScaleX(this.group.getScaleX() * 1.1);
            this.group.setScaleY(this.group.getScaleY() * 1.1);
        }
        this.documentScroller.setHvalue(0.5);
        this.documentScroller.setVvalue(0.5);
    }

    public void zoomOutAction(ActionEvent actionEvent) {
        this.group.setScaleX(this.group.getScaleX() / 1.1);
        this.group.setScaleY(this.group.getScaleY() / 1.1);
        this.documentScroller.setHvalue(0.5);
        this.documentScroller.setVvalue(0.5);
    }

    public void redirectAction(ActionEvent actionEvent) {
        if (this.imgViewer.getImage() != null) {
            Main.redirectType = 1;
            Main.selectFilename = "redirect_" + Main.newFilename() + ".tiff";
            File f = new File(Main.dir + "\\\u96f2\u7aef\\" + Main.selectFilename);
            DocViewer.saveImgViewer(f);
            try {
                portal.newStage("friendlist", "\u7acb\u523b\u8f49\u767c", 500, 600);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public BufferedImage getRotatedImage(AffineTransform atf, BufferedImage bufferedImage) {
        AffineTransformOp op = new AffineTransformOp(atf, 2);
        return op.filter(bufferedImage, null);
    }

    private AffineTransform rotateClockwise90(BufferedImage source) {
        AffineTransform transform = new AffineTransform();
        transform.rotate(1.5707963267948966, source.getWidth() / 2, source.getHeight() / 2);
        double offset = (source.getWidth() - source.getHeight()) / 2;
        transform.translate(offset, offset);
        return transform;
    }

    private AffineTransform rotateCounterClockwise90(BufferedImage source) {
        AffineTransform transform = new AffineTransform();
        transform.rotate(-1.5707963267948966, source.getWidth() / 2, source.getHeight() / 2);
        double offset = (source.getWidth() - source.getHeight()) / 2;
        transform.translate(-offset, -offset);
        return transform;
    }

    public void rotationLeftAction(ActionEvent actionEvent) {
        if (this.imgViewer.getImage() != null) {
            BufferedImage buffImg = SwingFXUtils.fromFXImage((javafx.scene.image.Image)this.imgViewer.getImage(), null);
            buffImg = this.getRotatedImage(this.rotateCounterClockwise90(buffImg), buffImg);
            this.imgViewer.setImage((javafx.scene.image.Image)SwingFXUtils.toFXImage((BufferedImage)buffImg, null));
            this.imgViewer.setFitWidth((double)buffImg.getWidth());
            this.imgViewer.setFitHeight((double)buffImg.getHeight());
        }
    }

    public void rotationRightAction(ActionEvent actionEvent) {
        if (this.imgViewer.getImage() != null) {
            BufferedImage buffImg = SwingFXUtils.fromFXImage((javafx.scene.image.Image)this.imgViewer.getImage(), null);
            buffImg = this.getRotatedImage(this.rotateClockwise90(buffImg), buffImg);
            this.imgViewer.setImage((javafx.scene.image.Image)SwingFXUtils.toFXImage((BufferedImage)buffImg, null));
            this.imgViewer.setFitWidth((double)buffImg.getWidth());
            this.imgViewer.setFitHeight((double)buffImg.getHeight());
        }
    }

    public void justPrintAction(ActionEvent actionEvent) {
        if (this.imgViewer.getImage() != null) {
            File file = new File(Main.dir + "\\\u66ab\u5b58\\" + Main.newFilename() + ".tiff");
            DocViewer.saveImgViewer(file);
            Main.print(file.getPath(), null, null, null, null, "");
            Main.showDetail("1\u4efd\u6587\u4ef6\u958b\u59cb\u5217\u5370");
        }
    }

    private static void configureFileChooser(FileChooser fileChooser) {
        fileChooser.setTitle("View Pictures");
        fileChooser.setInitialDirectory(new File(System.getProperty("user.home")));
    }

    public static void saveImgViewer(File output) {
        Stage s = portal.stages.get("DocViewer");
        ImageView imgViewer = (ImageView)s.getScene().lookup("#imgViewer");
        if (imgViewer.getImage() != null) {
            BufferedImage newImg = null;
            BufferedImage image = SwingFXUtils.fromFXImage((javafx.scene.image.Image)imgViewer.getImage(), null);
            int IMAGE_WIDTH = image.getWidth();
            int IMAGE_HEIGHT = image.getHeight();
            newImg = new BufferedImage(IMAGE_WIDTH, IMAGE_HEIGHT, 12);
            Graphics2D g = (Graphics2D)newImg.getGraphics();
            g.drawImage((Image)image, 0, 0, null);
            g.dispose();
            TIFFImageWriterSpi tiffspi = new TIFFImageWriterSpi();
            ImageWriter writer = null;
            try {
                writer = tiffspi.createWriterInstance();
                ImageWriteParam param = writer.getDefaultWriteParam();
                param.setTilingMode(0);
                param.setCompressionMode(2);
                param.setCompressionType("CCITT T.6");
                ImageOutputStream ios = ImageIO.createImageOutputStream(output);
                writer.setOutput(ios);
                writer.write(null, new IIOImage(newImg, null, null), param);
                ios.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void saveasAction(ActionEvent actionEvent) {
        if (this.imgViewer.getImage() != null) {
            FileChooser fileChooser = new FileChooser();
            fileChooser.setTitle("\u53e6\u5b58\u6a94\u6848");
            if (Main.recentSaveFolder != null) {
                fileChooser.setInitialDirectory(Main.recentSaveFolder);
            } else {
                fileChooser.setInitialDirectory(FileSystemView.getFileSystemView().getHomeDirectory());
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
            fileChooser.setInitialFileName(sdf.format(new Date()));
            FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("TIF (*.tiff)", new String[]{"*.tiff"});
            fileChooser.getExtensionFilters().add((Object)extFilter);
            File file = fileChooser.showSaveDialog((Window)portal.stages.get("portal"));
            if (file != null) {
                Main.recentSaveFolder = file.getParentFile();
                DocViewer.saveImgViewer(file);
            }
        }
    }

    public void sendFileAction(ActionEvent actionEvent) {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("\u958b\u555f\u6a94\u6848");
        if (Main.recentOpenFolder != null) {
            fileChooser.setInitialDirectory(Main.recentOpenFolder);
        } else {
            fileChooser.setInitialDirectory(FileSystemView.getFileSystemView().getHomeDirectory());
        }
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Image Files", new String[]{"*.bmp", "*.png", "*.jpg", "*.gif", "*.tif", "*.tiff"}));
        File file = fileChooser.showOpenDialog((Window)portal.stages.get("portal"));
        File target = null;
        if (file != null) {
            Main.recentOpenFolder = file.getParentFile();
            Main.viewFilename = file.getPath();
            if (!file.getPath().toLowerCase().endsWith(".tiff") && !file.getPath().toLowerCase().endsWith(".tif")) {
                File tmp = null;
                try {
                    target = new File(Main.dir + "\\\u66ab\u5b58\\" + UUID.randomUUID().toString().replaceAll("-", "") + ".tiff");
                    tmp = File.createTempFile(UUID.randomUUID().toString().replaceAll("-", ""), ".tiff");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                String cmd = " -lat 20x20-10%  -depth 1 -monochrome -type bilevel -compress LZW ";
                Runtime rt = Runtime.getRuntime();
                try {
                    cmd = Main.imageMagickPath + " " + file.getCanonicalPath() + cmd + target.getCanonicalPath();
                    Process pr = rt.exec(cmd);
                    pr.waitFor();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                catch (InterruptedException e2) {
                    e2.printStackTrace();
                }
                file = target;
            }
            Main.viewFilename = file.getPath();
            try {
                DocViewer.loadImage(file);
                docLabel = "";
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void btnNextAction(ActionEvent actionEvent) {
        portal.portal.btnNextAction();
    }

    public void btnPrevAction(ActionEvent actionEvent) {
        portal.portal.btnPrevAction();
    }

    public void btnCloseAction(ActionEvent actionEvent) {
        if (autoRefreshTimer != null) {
            autoRefreshTimer.cancel();
            autoRefreshTimer = null;
        }
        portal.closeStage("DocViewer");
    }

    public void btnCutAction(ActionEvent actionEvent) {
        if (!this.documentScroller.isPannable()) {
            this.btnCut.setText("\u88c1\u5207\u5340\u57df");
            this.documentScroller.setPannable(true);
            this.imgViewer.setCursor(Cursor.DEFAULT);
        } else {
            this.btnCut.setText("\u53d6\u6d88\u88c1\u5207");
            this.documentScroller.setPannable(false);
            this.imgViewer.setCursor(Cursor.CROSSHAIR);
        }
    }

    public void btnCutRebackAction(ActionEvent actionEvent) {
        this.noteStampsLabel.setVisible(false);
        this.txtNoteContent.setText("");
        this.qrImg.setImage(null);
        this.qrImg.setVisible(false);
        if (editImgSteps > 1) {
            File f = new File(Main.dir + "\\\u66ab\u5b58\\step" + --editImgSteps + ".tiff");
            BufferedImage bi = null;
            try {
                bi = ImageIO.read(f);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            WritableImage wr = null;
            if (bi != null) {
                wr = new WritableImage(bi.getWidth(), bi.getHeight());
                PixelWriter pw = wr.getPixelWriter();
                for (int x = 0; x < bi.getWidth(); ++x) {
                    for (int y = 0; y < bi.getHeight(); ++y) {
                        pw.setArgb(x, y, bi.getRGB(x, y));
                    }
                }
                pw = null;
            }
            this.imgViewer.setImage(wr);
            this.imgViewer.setFitWidth(wr.getWidth());
            this.imgViewer.setFitHeight(wr.getHeight());
            Stage s = portal.stages.get("DocViewer");
            Button btnEndPastNote = (Button)s.getScene().lookup("#btnEndPastNote");
            btnEndPastNote.setDisable(editImgSteps <= 1);
        }
    }

    public void noteBorderAction(ActionEvent actionEvent) {
        if (this.noteBorder.isSelected()) {
            this.noteStampsLabel.setBorder(new Border(new BorderStroke[]{new BorderStroke((Paint)javafx.scene.paint.Color.RED, BorderStrokeStyle.SOLID, new CornerRadii(5.0), new BorderWidths(5.0))}));
        } else {
            this.noteStampsLabel.setBorder(null);
        }
    }

    public void btnEndPastNoteAction(ActionEvent actionEvent) {
        this.noteStampsLabel.setVisible(false);
    }

    public static BufferedImage convertToBinary(BufferedImage image) {
        BufferedImage result = new BufferedImage(image.getWidth(), image.getHeight(), 12);
        Graphics g = result.getGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return result;
    }

    public void btnPasNoteAction(ActionEvent actionEvent) {
        if (this.noteStampsLabel.getText().length() > 0 || this.qrImg.getImage() != null && this.qrImg.isVisible()) {
            this.noteStampsLabel.setTextFill((Paint)javafx.scene.paint.Color.BLACK);
            if (this.noteBorder.isSelected()) {
                this.noteStampsLabel.setBorder(new Border(new BorderStroke[]{new BorderStroke((Paint)javafx.scene.paint.Color.BLACK, BorderStrokeStyle.SOLID, new CornerRadii(5.0), new BorderWidths(5.0))}));
            } else {
                this.noteStampsLabel.setBorder(null);
            }
            if (this.qrImg.getImage() != null) {
                BufferedImage qi = SwingFXUtils.fromFXImage((javafx.scene.image.Image)this.qrImg.getImage(), null);
                this.qrImg.setImage((javafx.scene.image.Image)SwingFXUtils.toFXImage((BufferedImage)DocViewer.convertToBinary(qi), null));
            }
            SnapshotParameters spaLabel = new SnapshotParameters();
            spaLabel.setFill((Paint)javafx.scene.paint.Color.WHITE);
            spaLabel.setTransform((Transform)Transform.scale((double)-1.0, (double)1.0));
            double oldScale = this.group.getScaleX();
            this.group.setScaleX(1.0);
            this.group.setScaleY(1.0);
            WritableImage image = this.group.snapshot(spaLabel, null);
            this.group.setScaleX(oldScale);
            this.group.setScaleY(oldScale);
            this.imgViewer.setImage((javafx.scene.image.Image)image);
            DocViewer.saveStepImgs();
            this.noteStampsLabel.setVisible(false);
            this.qrImg.setImage(null);
            this.qrImg.setVisible(false);
            this.txtNoteContent.setText("");
            this.lstNoteStamps.getSelectionModel().clearSelection();
        }
    }

    public void newFileAction(ActionEvent actionEvent) {
        double yRate;
        shouldCenterImg = true;
        Stage s = portal.stages.get("DocViewer");
        ImageView imgViewer = (ImageView)s.getScene().lookup("#imgViewer");
        BufferedImage bi = new BufferedImage(620, 877, 12);
        Graphics2D g = bi.createGraphics();
        g.setPaint(Color.white);
        g.fillRect(0, 0, bi.getWidth(), bi.getHeight());
        g.dispose();
        WritableImage wr = null;
        if (bi != null) {
            wr = new WritableImage(bi.getWidth(), bi.getHeight());
            PixelWriter pw = wr.getPixelWriter();
            for (int x = 0; x < bi.getWidth(); ++x) {
                for (int y = 0; y < bi.getHeight(); ++y) {
                    pw.setArgb(x, y, bi.getRGB(x, y));
                }
            }
            pw = null;
        }
        imgViewer.setImage(wr);
        imgViewer.setFitWidth(wr.getWidth());
        imgViewer.setFitHeight(wr.getHeight());
        Group group = (Group)s.getScene().lookup("#group");
        double xRate = (float)((s.getWidth() - 250.0) / wr.getWidth());
        double rate = yRate = (double)((float)((s.getHeight() - 100.0) / wr.getHeight()));
        if (xRate < yRate) {
            rate = xRate;
        }
        if (rate > 1.0) {
            rate = 1.0;
        }
        group.setScaleX(rate);
        group.setScaleY(rate);
        wr = null;
        bi.flush();
        bi = null;
        System.gc();
    }

    public void btnCreateQRCode(boolean isBlank) throws WriterException {
        RDocument r;
        int repeatTimes = 0;
        int page = Integer.parseInt(this.txtRDPage.getText());
        String fid = ((Tab)this.tabBosses.getSelectionModel().getSelectedItem()).getId();
        if (Main.rDocumentLists.get(fid) != null && Main.rDocumentLists.get(fid).size() >= page && (r = (RDocument)Main.rDocumentLists.get(fid).get(page - 1)) != null) {
            repeatTimes = r.getRepeatTimes() + 1;
            if (r.isBlank()) {
                isBlank = r.isBlank();
            }
        }
        this.qrImg.setImage(null);
        EnumMap<EncodeHintType, String> hintMap = new EnumMap<EncodeHintType, String>(EncodeHintType.class);
        hintMap.put(EncodeHintType.CHARACTER_SET, "UTF-8");
        hintMap.put(EncodeHintType.ERROR_CORRECTION, (String)ErrorCorrectionLevel.Q);
        int size = 400;
        int pw = (int)((double)size * 4.5);
        int ph = (int)((double)size * 5.5);
        BufferedImage bi = new BufferedImage(pw, ph, 2);
        bi.createGraphics();
        Graphics2D graphics = (Graphics2D)bi.getGraphics();
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, pw, ph);
        graphics.setColor(Color.RED);
        Friend f = Main.friends.get(fid);
        graphics.setFont(new Font("DFKai-SB", 1, 250));
        String label = f.getBossCode() + " ";
        if (this.txtRDPage.getText().length() > 0) {
            label = label + " P" + this.txtRDPage.getText();
        }
        graphics.drawString(label, 250, ph - 100);
        label = "";
        if (!isBlank) {
            if (repeatTimes > 1) {
                label = label + "\u91cd x" + repeatTimes;
            } else if (repeatTimes == 1) {
                label = label + "\u91cd";
            }
        }
        graphics.drawString(label, 250, 240);
        graphics.setColor(Color.RED);
        QRCodeWriter qrCodeWriter = new QRCodeWriter();
        BitMatrix byteMatrix = qrCodeWriter.encode("CQ," + f.getAccount() + "," + f.getBossCode() + ",1," + this.txtRDPage.getText() + "," + (isBlank ? "1" : "0"), BarcodeFormat.QR_CODE, size, size, hintMap);
        int CrunchifyWidth = byteMatrix.getWidth();
        for (int i = 0; i < CrunchifyWidth; ++i) {
            for (int j = 0; j < CrunchifyWidth; ++j) {
                if (!byteMatrix.get(i, j)) continue;
                graphics.fillRect(i * 5 - 190 + 100, j * 5 - 190 + 240, 5, 5);
            }
        }
        WritableImage newImage = SwingFXUtils.toFXImage((BufferedImage)bi, null);
        this.qrImg.setImage((javafx.scene.image.Image)newImage);
        this.qrImg.setVisible(true);
        if (this.qrImg.getLayoutX() == 0.0 && this.qrImg.getLayoutY() == 0.0) {
            this.qrImg.setLayoutX(this.imgViewer.getLayoutX());
            this.qrImg.setLayoutY(this.imgViewer.getLayoutY());
        }
        bi.flush();
        bi = null;
        graphics.dispose();
        graphics = null;
        newImage = null;
        System.gc();
        if (isBlank) {
            this.qrImg.setLayoutX(this.imgViewer.getLayoutX() + (double)(size / 2));
            this.qrImg.setLayoutY(this.imgViewer.getLayoutY() + (double)(size / 2));
        }
        this.btnPasNote.setDisable(false);
    }

    public void btnCreateQRCodeAction(ActionEvent actionEvent) {
        try {
            this.btnCreateQRCode(false);
        }
        catch (WriterException e) {
            Main.log.debug((Object)e.toString());
        }
    }

    public void btnSentToAction(ActionEvent actionEvent) {
        if (this.imgViewer.getImage() != null) {
            if (this.noteStampsLabel.isVisible() || this.qrImg.isVisible()) {
                this.btnPasNoteAction(null);
            }
            Main.selectFilename = "redirect_" + Main.newFilename() + ".tiff";
            File f = new File(Main.dir + "\\\u96f2\u7aef\\" + Main.selectFilename);
            DocViewer.saveImgViewer(f);
            String fid = ((Tab)this.tabBosses.getSelectionModel().getSelectedItem()).getId();
            if (S3Tool.upload(Main.dir + "//\u96f2\u7aef//" + Main.selectFilename)) {
                ArrayList<Friend> fs = new ArrayList<Friend>();
                fs.add(Main.friends.get(fid));
                ArrayList<String> filenames = new ArrayList<String>();
                filenames.add(Main.selectFilename);
                Main.redirectDocs(fs, filenames);
            } else {
                Main.showMsg("\u8f49\u50b3\u5931\u6557", "\u6a94\u6848\u8655\u7406\u7570\u5e38\u3002", 2);
            }
            if (this.txtRDPage.getText().equalsIgnoreCase("")) {
                Alert alert = new Alert(Alert.AlertType.INFORMATION);
                alert.setTitle("\u672c\u65e5\u7d71\u8a08");
                alert.setHeaderText("");
                alert.setContentText("\u672c\u65e5\u7d71\u8a08\u5df2\u6210\u529f\u50b3\u51fa!");
                alert.showAndWait();
            } else {
                int page = Integer.parseInt(this.txtRDPage.getText());
                ArrayList arr = Main.rDocumentLists.get(fid);
                if (arr == null) {
                    arr = new ArrayList();
                    Main.rDocumentLists.put(fid, arr);
                }
                ArrayList<RDocument> rds = new ArrayList<RDocument>();
                int lastPage = 0;
                if (Main.rDocumentLists.get(fid).size() > 0) {
                    lastPage = ((RDocument)Main.rDocumentLists.get(fid).get(Main.rDocumentLists.get(fid).size() - 1)).getPage();
                }
                if (page > lastPage + 1) {
                    for (int i = lastPage + 1; i < page; ++i) {
                        RDocument rd = new RDocument();
                        rd.setUuid(UUID.randomUUID().toString());
                        rd.setUserId(Main.strAccount);
                        rd.setFrom("");
                        rd.setFid(fid);
                        rd.setPage(i);
                        rd.setLabel("P" + i + " \u7a7a");
                        rd.setBlank(true);
                        rd.setRepeat(false);
                        rds.add(rd);
                    }
                }
                RDocument rd = new RDocument();
                rd.setUuid(UUID.randomUUID().toString());
                rd.setUserId(Main.strAccount);
                rd.setFrom(docLabel);
                rd.setFid(fid);
                rd.setPage(page);
                rd.setFilename(Main.selectFilename);
                rd.setOldFilename(Main.viewFilename);
                if (this.thisIsBlank) {
                    rd.setBlank(true);
                    rd.setRepeat(page <= lastPage);
                    rd.setLabel("P" + page + " \u7a7a");
                } else {
                    rd.setBlank(false);
                    if (lastPage > 0) {
                        if (page > lastPage) {
                            rd.setRepeat(false);
                            rd.setLabel("P" + page + "(" + docLabel + ")");
                        } else {
                            rd.setRepeat(true);
                            rd.setRepeatTimes(rd.getRepeatTimes() + 1);
                            rd.setLabel("P" + page + " \u91cd" + (rd.getRepeatTimes() > 1 ? " x" + rd.getRepeatTimes() : "") + " (" + docLabel + ")");
                        }
                    } else {
                        rd.setRepeat(false);
                        rd.setLabel("P" + page + "(" + docLabel + ")");
                    }
                }
                rds.add(rd);
                String pUUID = null;
                if (this.lstDocs1.getItems().size() > 0) {
                    Iterator pIterator = this.lstDocs1.getItems().iterator();
                    while (pIterator.hasNext()) {
                        PDocument p = (PDocument)pIterator.next();
                        if (!Main.viewFilename.endsWith(p.getFilename())) continue;
                        int index = 0;
                        pUUID = p.getUuid();
                        if (this.canAutoIncreasePage) {
                            index = this.lstDocs1.getSelectionModel().getSelectedIndex();
                        }
                        this.lstDocs2.getItems().add((Object)p);
                        Main.pDocumentLists.get(2).add(p);
                        pIterator.remove();
                        Main.pDocumentLists.get(1).remove(p);
                        if (!this.canAutoIncreasePage) break;
                        this.lstDocs1.getSelectionModel().clearSelection();
                        if (this.lstDocs1.getItems().size() <= index) break;
                        this.lstDocs1.getSelectionModel().select(index);
                        Main.viewFilename = Main.dir + "\\\u96f2\u7aef\\" + ((PDocument)this.lstDocs1.getSelectionModel().getSelectedItem()).getFilename();
                        this.lstDocs1.requestFocus();
                        break;
                    }
                }
                if (rd.isRepeat()) {
                    RDocument oldRd = (RDocument)Main.rDocumentLists.get(fid).get(page - 1);
                    rd.setRepeatTimes(oldRd.getRepeatTimes() + 1);
                    if (rd.isBlank()) {
                        rd.setLabel("P" + page + " \u7a7a");
                    } else {
                        rd.setLabel("P" + page + " \u91cd" + (rd.getRepeatTimes() > 1 ? " x" + rd.getRepeatTimes() : "") + " (" + docLabel + ")");
                    }
                    rd.setUuid(oldRd.getUuid());
                    rd.setpUUID(pUUID);
                    Main.rDocumentLists.get(fid).set(page - 1, rd);
                    this.rDocTables.get(fid).getItems().set(page - 1, (Object)rd);
                    Main.speak("updateRD," + Main.gson.toJson((Object)rd));
                } else {
                    rd.setpUUID(pUUID);
                    Main.rDocumentLists.get(fid).addAll(rds);
                    this.rDocTables.get(fid).getItems().addAll(rds);
                    Main.speak("addNewRDs," + Main.gson.toJson(rds));
                }
                if (this.txtRDPage.getText() != null && this.txtRDPage.getText().length() > 0 && this.canAutoIncreasePage) {
                    int p = Integer.parseInt(this.txtRDPage.getText());
                    this.txtRDPage.setText(String.valueOf(p + 1));
                }
            }
        }
    }

    public void btnReloadPDS(ActionEvent actionEvent) {
        System.out.println("btnReloadPDS");
        this.lstDocs1.getItems().clear();
        if (Main.pDocumentLists.get(1) != null) {
            this.lstDocs1.setItems(FXCollections.observableArrayList((Collection)Main.pDocumentLists.get(1)));
        }
        this.lstDocs2.getItems().clear();
        if (Main.pDocumentLists.get(2) != null) {
            this.lstDocs2.setItems(FXCollections.observableArrayList((Collection)Main.pDocumentLists.get(2)));
        }
        this.lstDocs3.getItems().clear();
        if (Main.pDocumentLists.get(3) != null) {
            this.lstDocs3.setItems(FXCollections.observableArrayList((Collection)Main.pDocumentLists.get(3)));
        }
    }

    public void btnSkipAction(ActionEvent actionEvent) {
        if (this.lstDocs1.getSelectionModel().getSelectedItems().size() > 0) {
            ArrayList items = new ArrayList(this.lstDocs1.getSelectionModel().getSelectedItems());
            StringBuilder cmd = new StringBuilder("skipPDs,");
            for (PDocument p : items) {
                cmd.append(p.getUuid());
                cmd.append(",");
            }
            Main.speak(cmd.toString());
            Main.pDocumentLists.get(3).addAll(items);
            Main.pDocumentLists.get(1).removeAll(items);
            this.lstDocs3.getItems().addAll(items);
            this.lstDocs1.getItems().removeAll(items);
            this.lstDocs1.getSelectionModel().clearSelection();
            this.btnSkip.setDisable(true);
        }
    }

    public void btnSetBlankAction(ActionEvent actionEvent) {
        this.thisIsBlank = true;
        try {
            this.btnCreateQRCode(true);
        }
        catch (WriterException e) {
            Main.log.debug((Object)e.toString());
        }
        this.btnSetBlank.setDisable(true);
        String fid = ((Tab)this.tabBosses.getSelectionModel().getSelectedItem()).getId();
        RDocument rd = (RDocument)this.rDocTables.get(fid).getSelectionModel().getSelectedItem();
        rd.setBlank(true);
        rd.setRepeat(false);
        rd.setFrom(null);
        rd.setLabel("P" + rd.getPage() + " \u7a7a");
        Main.rDocumentLists.get(fid).set(rd.getPage() - 1, rd);
        this.rDocTables.get(fid).getItems().set(rd.getPage() - 1, (Object)rd);
        Main.speak("updateRD," + Main.gson.toJson((Object)rd));
    }

    public void chkAutoRefreshAction(ActionEvent actionEvent) {
        if (this.chkAutoRefresh.isSelected()) {
            if (autoRefresh == 0) {
                autoRefresh = 1;
                this.txtAutoRefreshTimer.setText("1");
            }
            if (autoRefresh > 0) {
                autoRefreshTimer = new Timer();
                TimerTask task = new TimerTask(){

                    @Override
                    public void run() {
                        DocViewer.this.btnReloadPDS(null);
                    }
                };
                autoRefreshTimer.schedule(task, autoRefresh * 1000, (long)(autoRefresh * 1000));
            }
        } else if (autoRefreshTimer != null) {
            autoRefreshTimer.cancel();
            autoRefreshTimer = null;
        }
    }

    static {
        editImgSteps = 0;
        shouldCenterImg = false;
        fontSize = 20;
        dataFormat = new DataFormat(new String[]{"mypdata"});
        autoRefresh = 10;
    }
}

