/*
 * Decompiled with CFR 0.152.
 */
package cc.ceofax.controller;

import cc.ceofax.bean.QRType;
import cc.ceofax.bean.QRWho;
import cc.ceofax.controller.Main;
import cc.ceofax.controller.portal;
import cc.ceofax.tool.PrintQR;
import cc.ceofax.tool.PrintTiff;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javax.imageio.ImageIO;
import javax.print.PrintService;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSizeName;

public class printQRCode {
    public TextField txtQRTypeName;
    public TextField txtQRWhoName;
    public TextField txtCopy;
    public ComboBox lstPrinter;
    public ComboBox lstQRTypes;
    public ComboBox lstQRWhos;
    public Label txtCopyDesc;
    public Button btnPrint;
    public TextField txtMax;
    public TextField txtStart;

    public void initialize() {
        this.setTextMax(this.txtQRTypeName, 3);
        this.setTextMax(this.txtQRWhoName, 3);
        this.setTextNumbic(this.txtCopy);
        this.setTextNumbic(this.txtMax);
        this.setTextNumbic(this.txtStart);
        this.setTextMax(this.txtCopy, 4);
        this.setTextMax(this.txtMax, 7);
        this.setTextMax(this.txtStart, 7);
        this.lstPrinter.getItems().addAll(PrintTiff.getPrinterServiceNameList());
        this.lstQRWhos.getItems().addAll((Collection)Main.qrWhos.stream().filter(qrWho -> !qrWho.isHidden()).collect(Collectors.toList()));
        this.lstQRTypes.getItems().addAll((Collection)Main.qrTypes.stream().filter(qrTypes -> !qrTypes.isHidden()).collect(Collectors.toList()));
        this.lstPrinter.getSelectionModel().select((Object)Main.setting.getPrinter());
        this.txtStart.setText("1");
        this.txtMax.setText("70");
    }

    public void setTextMax(final TextField tf, final int maxLength) {
        tf.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> ov, String oldValue, String newValue) {
                if (tf.getText().length() > maxLength) {
                    String s = tf.getText().substring(0, maxLength);
                    tf.setText(s);
                }
                if (!tf.getText().trim().equalsIgnoreCase("") && tf == printQRCode.this.txtCopy) {
                    int numCopy = Integer.valueOf(printQRCode.this.txtCopy.getText());
                    int numStart = Integer.valueOf(printQRCode.this.txtStart.getText());
                    int numMax = Integer.valueOf(printQRCode.this.txtMax.getText());
                    int numPapers = (int)Math.ceil((float)((numMax - numStart + 1) * numCopy) / 70.0f);
                    printQRCode.this.txtCopyDesc.setText("\u4efd\uff0c\u5171\u8a08 " + numPapers + " \u9801");
                }
            }
        });
    }

    public void setTextNumbic(final TextField tf) {
        tf.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (!newValue.matches("\\d*")) {
                    tf.setText(newValue.replaceAll("[^\\d]", ""));
                }
            }
        });
    }

    public void btnAddQRWho(ActionEvent actionEvent) {
        String name = this.txtQRWhoName.getText().trim();
        if (name.length() > 0) {
            Main.speak("addQRWho," + name);
        }
        this.txtQRWhoName.setText("");
    }

    public void btnAddQRType(ActionEvent actionEvent) {
        String name = this.txtQRTypeName.getText().trim();
        if (name.length() > 0) {
            Main.speak("addQRType," + name);
        }
        this.txtQRTypeName.setText("");
    }

    public static void refreshQRData(boolean selectLastQRWho, boolean selectLastQRType) {
        ComboBox lstQRWhos = (ComboBox)portal.stages.get("printQRCode").getScene().lookup("#lstQRWhos");
        ComboBox lstQRTypes = (ComboBox)portal.stages.get("printQRCode").getScene().lookup("#lstQRTypes");
        if (selectLastQRWho) {
            lstQRWhos.getItems().clear();
            lstQRWhos.getItems().addAll((Collection)Main.qrWhos.stream().filter(qrWho -> !qrWho.isHidden()).collect(Collectors.toList()));
            lstQRWhos.getSelectionModel().select(lstQRWhos.getItems().size() - 1);
        }
        if (selectLastQRType) {
            lstQRTypes.getItems().clear();
            lstQRTypes.getItems().addAll((Collection)Main.qrTypes.stream().filter(qrTypes -> !qrTypes.isHidden()).collect(Collectors.toList()));
            lstQRTypes.getSelectionModel().select(lstQRTypes.getItems().size() - 1);
        }
    }

    public void btnDelQRWhoAction(ActionEvent actionEvent) {
        QRWho obj = (QRWho)this.lstQRWhos.getSelectionModel().getSelectedItem();
        if (obj != null) {
            Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
            alert.setContentText("\u60a8\u78ba\u5b9a\u8981\u522a\u9664" + obj.getName() + "?");
            alert.setTitle("\u78ba\u5b9a\u522a\u9664");
            alert.setHeaderText(null);
            Optional result = alert.showAndWait();
            if (result.get() == ButtonType.OK) {
                obj.setHidden(true);
                Main.speak("delQRWho," + obj.getIndex());
                printQRCode.refreshQRData(true, false);
            }
        }
    }

    public void btnDelQRTypeAction(ActionEvent actionEvent) {
        QRType obj = (QRType)this.lstQRTypes.getSelectionModel().getSelectedItem();
        if (obj != null) {
            Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
            alert.setContentText("\u60a8\u78ba\u5b9a\u8981\u522a\u9664" + obj.getName() + "?");
            alert.setTitle("\u78ba\u5b9a\u522a\u9664");
            alert.setHeaderText(null);
            Optional result = alert.showAndWait();
            if (result.get() == ButtonType.OK) {
                obj.setHidden(true);
                Main.speak("delQRType," + obj.getIndex());
                printQRCode.refreshQRData(false, true);
            }
        }
    }

    public void btnPrintAction(ActionEvent actionEvent) {
        if (!this.txtCopy.getText().trim().equalsIgnoreCase("")) {
            final QRWho who = (QRWho)this.lstQRWhos.getSelectionModel().getSelectedItem();
            final QRType type = (QRType)this.lstQRTypes.getSelectionModel().getSelectedItem();
            final int numCopy = Integer.valueOf(this.txtCopy.getText());
            final String printerName = (String)this.lstPrinter.getSelectionModel().getSelectedItem();
            if (who != null && type != null && numCopy > 0 && printerName != null && !printerName.equalsIgnoreCase("") && !printerName.equalsIgnoreCase("\u672a\u8a2d\u5b9a")) {
                this.btnPrint.setDisable(true);
                this.btnPrint.setText("\u5217\u5370\u4e2d");
                new Timer().schedule(new TimerTask(){

                    @Override
                    public void run() {
                        int countInThisPage;
                        ArrayList<Integer> allNums = new ArrayList<Integer>();
                        int numStart = Integer.parseInt(printQRCode.this.txtStart.getText());
                        int numEnd = Integer.parseInt(printQRCode.this.txtMax.getText());
                        for (int r = 0; r < numCopy; ++r) {
                            for (int i = numStart; i <= numEnd; ++i) {
                                allNums.add(i);
                            }
                        }
                        for (int last = 0; last < allNums.size(); last += countInThisPage) {
                            countInThisPage = 70;
                            if (last + 70 > allNums.size()) {
                                countInThisPage = allNums.size() % 70;
                            }
                            ArrayList<Integer> pageNums = new ArrayList<Integer>();
                            for (int i = last; i < last + countInThisPage; ++i) {
                                pageNums.add((Integer)allNums.get(i));
                            }
                            printQRCode.this.printAction(Main.strAccount + "," + who.getIndex() + "," + type.getIndex() + ",", who.getName(), type.getName(), printerName, pageNums);
                        }
                    }
                }, 500L);
                new Timer().schedule(new TimerTask(){

                    @Override
                    public void run() {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                printQRCode.this.btnPrint.setDisable(false);
                                printQRCode.this.btnPrint.setText("\u5217\u5370\u8cbc\u7d19");
                            }
                        });
                    }
                }, 3000L);
            } else {
                Main.showMsg("\u8cc7\u6599\u932f\u8aa4", "\u8acb\u6aa2\u67e5\u662f\u5426\u586b\u5165\u6b63\u78ba\u8cc7\u6599\u3002", 2);
            }
        } else {
            Main.showMsg("\u8cc7\u6599\u932f\u8aa4", "\u8acb\u6aa2\u67e5\u662f\u5426\u586b\u5165\u6b63\u78ba\u8cc7\u6599\u3002", 2);
        }
    }

    public void printAction(String data, String who, String type, String printerName, List<Integer> nums) {
        int pw = 2480;
        int ph = 3508;
        int dpi = 300;
        double qrSizeCM = 2.0;
        int size = (int)(qrSizeCM / 2.54 * (double)dpi);
        int cw = (int)PrintQR.cmsToPixel(20.0, dpi);
        int ch = (int)PrintQR.cmsToPixel(28.4, dpi) + 7;
        pw = cw;
        ph = ch;
        int col = 5;
        int row = 14;
        String filePath = Main.dir + "\\\u66ab\u5b58\\" + Main.newFilename() + ".jpg";
        String fileType = "jpg";
        File myFile = new File(filePath);
        try {
            EnumMap<EncodeHintType, String> hintMap = new EnumMap<EncodeHintType, String>(EncodeHintType.class);
            hintMap.put(EncodeHintType.CHARACTER_SET, "UTF-8");
            hintMap.put(EncodeHintType.ERROR_CORRECTION, (String)ErrorCorrectionLevel.L);
            BufferedImage image = new BufferedImage(pw, ph, 12);
            image.createGraphics();
            Graphics2D graphics = (Graphics2D)image.getGraphics();
            graphics.setColor(Color.WHITE);
            graphics.fillRect(0, 0, pw, ph);
            graphics.setColor(Color.BLACK);
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            int p = 1;
            for (Integer v : nums) {
                QRCodeWriter qrCodeWriter = new QRCodeWriter();
                BitMatrix byteMatrix = qrCodeWriter.encode(data + v, BarcodeFormat.QR_CODE, size, size, hintMap);
                int CrunchifyWidth = byteMatrix.getWidth();
                int ix = (p - 1) % col;
                int iy = (int)Math.floor((p - 1) / col);
                int x = ix * (cw / col) + cw / col / 2 - size / 2 - 60;
                int y = iy * (ch / row) + ch / row / 2 - size / 2;
                for (int i = 0; i < CrunchifyWidth; ++i) {
                    for (int j = 0; j < CrunchifyWidth; ++j) {
                        if (!byteMatrix.get(i, j)) continue;
                        graphics.fillRect(i + x, j + y, 1, 1);
                    }
                }
                graphics.setFont(new Font("DFKai-SB", 1, 50));
                graphics.drawString(who, x + size / 2 + 93, y + size / 2 - 30);
                graphics.drawString(String.valueOf(v), x + size / 2 + 93, y + size / 2 + 70);
                String typeStr = "";
                for (int si = 0; si < type.length(); ++si) {
                    String w = type.substring(si, si + 1);
                    int yDis = 0;
                    if (type.length() == 2) {
                        yDis = si == 0 ? -12 : 12;
                    } else if (type.length() == 3) {
                        if (si == 0) {
                            yDis = -12;
                        } else if (si == 2) {
                            yDis = 12;
                        }
                    }
                    graphics.drawString(w, x - 50, y + size / 2 + 22 + yDis * 4);
                }
                ++p;
            }
            ImageIO.write((RenderedImage)image, fileType, myFile);
        }
        catch (WriterException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        double width = PrintQR.cmsToPixel(21.0, dpi);
        double height = PrintQR.cmsToPixel(29.7, dpi);
        PrintService printService = PrintQR.findPrintService(printerName);
        PrintQR p = new PrintQR();
        p.setFilepath(filePath);
        PrinterJob job = PrinterJob.getPrinterJob();
        PageFormat pageFormat = job.defaultPage();
        Paper paper = pageFormat.getPaper();
        paper.setSize(width, height);
        paper.setImageableArea(0.0, 0.0, width, height);
        pageFormat.setPaper(paper);
        pageFormat.setOrientation(1);
        HashPrintRequestAttributeSet attr = new HashPrintRequestAttributeSet();
        attr.add(new MediaPrintableArea(0.0f, 0.0f, (float)width / (float)dpi, (float)height / (float)dpi, 25400));
        attr.add(MediaSizeName.ISO_A4);
        try {
            job.setPrintService(printService);
        }
        catch (PrinterException e) {
            e.printStackTrace();
        }
        job.setPrintable(p);
        try {
            job.print(attr);
        }
        catch (PrinterException printerException) {
            // empty catch block
        }
    }
}

