/*
 * Decompiled with CFR 0.152.
 */
package cc.ceofax.controller;

import cc.ceofax.bean.ButtonModeData;
import cc.ceofax.bean.Friend;
import cc.ceofax.bean.Team;
import cc.ceofax.controller.Main;
import cc.ceofax.controller.portal;
import java.util.ArrayList;
import java.util.List;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.GridPane;

public class setButtonMode1 {
    public GridPane grid1_0;
    public GridPane grid1_1;
    public GridPane grid1_2;
    public GridPane grid1_3;
    public GridPane grid1_4;
    static List<Label> friendSet1 = new ArrayList<Label>();
    static List<Label> teamSet1 = new ArrayList<Label>();

    public void initialize() {
        ButtonModeData data;
        Label txt;
        friendSet1.clear();
        teamSet1.clear();
        MouseGestures mg = new MouseGestures();
        GridPane grid = null;
        for (int p = 0; p < 5; ++p) {
            switch (p) {
                case 0: {
                    grid = this.grid1_0;
                    break;
                }
                case 1: {
                    grid = this.grid1_1;
                    break;
                }
                case 2: {
                    grid = this.grid1_2;
                    break;
                }
                case 3: {
                    grid = this.grid1_3;
                    break;
                }
                case 4: {
                    grid = this.grid1_4;
                }
            }
            for (int i = 0; i < 18; ++i) {
                txt = new Label("");
                txt.setMinWidth(170.0);
                txt.setPrefWidth(170.0);
                txt.setMinHeight(30.0);
                txt.setPrefHeight(30.0);
                txt.setStyle("-fx-alignment:center");
                txt.setStyle("-fx-font-size: 20px;");
                GridPane.setMargin((Node)txt, (Insets)new Insets(2.0, 2.0, 2.0, 2.0));
                data = new ButtonModeData();
                data.setType(1);
                data.setPage(p + 1);
                data.setIndex(i);
                txt.setUserData((Object)data);
                grid.add((Node)txt, i % 2, Math.floorDiv(i, 2));
                mg.makeDraggable((Node)txt);
                if (i >= 14) {
                    teamSet1.add(txt);
                    txt.getStyleClass().add((Object)"txtButtonModeTeam1");
                    continue;
                }
                friendSet1.add(txt);
            }
        }
        for (Friend f : Main.friends.values()) {
            if (f.getPage() == null || f.getIndex() == null) continue;
            txt = null;
            if (f.getAccType() != 3) continue;
            txt = friendSet1.get((f.getPage() - 1) * 14 + f.getIndex());
            txt.getStyleClass().add((Object)"txtButtonModeSingle1");
            txt.setText(f.getNickname());
            data = (ButtonModeData)txt.getUserData();
            data.setIdStr(f.getIdStr());
            txt.setUserData((Object)data);
        }
        for (Team t : Main.teams.values()) {
            if (t.getPage() == null || t.getIndex() == null) continue;
            txt = null;
            if (t.getButtonModeType() != 1) continue;
            txt = teamSet1.get((t.getPage() - 1) * 4 + t.getIndex());
            txt.setText(t.getName());
            data = (ButtonModeData)txt.getUserData();
            data.setIdStr(t.getIdStr());
            txt.setUserData((Object)data);
        }
    }

    public static class MouseGestures {
        DragContext dragContext = new DragContext();
        EventHandler<MouseEvent> onMousePressedEventHandler = event -> {
            Node node = (Node)event.getSource();
            this.dragContext.x = node.getTranslateX() - event.getSceneX();
            this.dragContext.y = node.getTranslateY() - event.getSceneY();
        };
        EventHandler<MouseEvent> onMouseDraggedEventHandler = event -> {
            Node node = (Node)event.getSource();
            node.getScene().setCursor(Cursor.MOVE);
        };
        EventHandler<MouseEvent> onMouseReleasedEventHandler = event -> {
            Node node = (Node)event.getSource();
            node.getScene().setCursor(Cursor.DEFAULT);
            node.setTranslateX(0.0);
            node.setTranslateY(0.0);
            List<Label> set = null;
            ButtonModeData data = (ButtonModeData)node.getUserData();
            if (data.getType() == 1) {
                set = data.getIndex() >= 14 ? teamSet1 : friendSet1;
            }
            Label from = (Label)node;
            Label target = null;
            for (Label overTxt : set) {
                Bounds b = overTxt.localToScene(overTxt.getBoundsInLocal());
                if (!(event.getSceneX() > b.getMinX()) || !(event.getSceneX() < b.getMaxX()) || !(event.getSceneY() > b.getMinY()) || !(event.getSceneY() < b.getMaxY())) continue;
                target = overTxt;
            }
            if (target != null) {
                ButtonModeData fromData = (ButtonModeData)from.getUserData();
                ButtonModeData targetData = (ButtonModeData)target.getUserData();
                if (targetData.getIdStr() == null && fromData.getIdStr() != null) {
                    target.setText(from.getText());
                    from.setText("");
                    String idStr = fromData.getIdStr();
                    targetData.setIdStr(idStr);
                    fromData.setIdStr(null);
                    target.setUserData((Object)targetData);
                    from.setUserData((Object)fromData);
                    if (fromData.getIndex() >= 14) {
                        Team t = Main.teams.get(idStr);
                        t.setPage(targetData.getPage());
                        t.setIndex(targetData.getIndex() - 14);
                        Main.speak("editTeam," + Main.gson.toJson((Object)t));
                    } else {
                        Friend f = Main.friends.get(idStr);
                        f.setPage(targetData.getPage());
                        f.setIndex(targetData.getIndex());
                        from.getStyleClass().clear();
                        target.getStyleClass().clear();
                        if (f.getAccType() == 3) {
                            target.getStyleClass().add((Object)"txtButtonModeSingle1");
                        }
                        Main.speak("editFriend," + Main.gson.toJson((Object)f));
                    }
                    portal.refreshButtonModeButtons();
                }
            }
        };

        public void makeDraggable(Node node) {
            node.setOnMousePressed(this.onMousePressedEventHandler);
            node.setOnMouseDragged(this.onMouseDraggedEventHandler);
            node.setOnMouseReleased(this.onMouseReleasedEventHandler);
        }

        class DragContext {
            double x;
            double y;

            DragContext() {
            }
        }
    }
}

