/*
 * Decompiled with CFR 0.152.
 */
package cc.ceofax.tool;

import cc.ceofax.bean.Document;
import cc.ceofax.bean.History;
import cc.ceofax.controller.Main;
import cc.ceofax.controller.portal;
import com.icafe4j.image.tiff.TIFFTweaker;
import com.icafe4j.io.FileCacheRandomAccessInputStream;
import com.icafe4j.io.RandomAccessInputStream;
import com.sun.imageio.plugins.bmp.BMPImageReaderSpi;
import com.sun.imageio.plugins.jpeg.JPEGImageReaderSpi;
import com.sun.imageio.plugins.png.PNGImageReaderSpi;
import com.sun.mail.smtp.SMTPTransport;
import com.sun.media.imageioimpl.plugins.tiff.TIFFImageWriterSpi;
import com.sun.media.jai.codec.FileSeekableStream;
import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.ImageDecoder;
import com.sun.media.jai.codec.SeekableStream;
import java.awt.Desktop;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Hashtable;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import javafx.application.Platform;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.TableColumn;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import net.markenwerk.utils.mail.dkim.Canonicalization;
import net.markenwerk.utils.mail.dkim.DkimMessage;
import net.markenwerk.utils.mail.dkim.DkimSigner;
import net.markenwerk.utils.mail.dkim.SigningAlgorithm;
import net.sf.image4j.util.ConvertUtil;
import org.apache.commons.io.FileUtils;
import org.apache.sanselan.ImageInfo;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.Sanselan;

public class MailTool {
    static Session session = null;
    public static String id = null;
    public static String pw = null;
    static String smtpPort = "587";

    public static void init(String id_, String pw_) {
        id = id_;
        pw = pw_;
        if (portal.account.mailhost == null) {
            portal.account.mailhost = "smtp.hibox.biz";
        }
        if (portal.account.mailport == null) {
            portal.account.mailport = "25";
        }
        if (session == null) {
            System.out.println("SSLEmail Start");
            Properties props = new Properties();
            props.put("mail.smtp.host", portal.account.mailhost);
            props.put("mail.smtp.socketFactory.port", portal.account.mailport);
            props.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            props.put("mail.smtp.auth", "true");
            props.put("mail.smtp.port", portal.account.mailport);
            props.put("mail.smtp.timeout", "5000");
            props.put("mail.smtp.connectiontimeout", "5000");
            Authenticator authenticator = new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(id, pw);
                }
            };
        }
    }

    private static MimeMessage dkimSignMessage(MimeMessage message, String from, String signingDomain, String selector) throws Exception {
        DkimSigner dkimSigner = new DkimSigner(signingDomain, selector, MailTool.class.getResourceAsStream("dkim.der"));
        dkimSigner.setIdentity(from);
        dkimSigner.setHeaderCanonicalization(Canonicalization.SIMPLE);
        dkimSigner.setBodyCanonicalization(Canonicalization.RELAXED);
        dkimSigner.setSigningAlgorithm(SigningAlgorithm.SHA256_WITH_RSA);
        dkimSigner.setLengthParam(true);
        dkimSigner.setZParam(false);
        return new DkimMessage(message, dkimSigner);
    }

    public static void sendRealFax(String tel, String filename, int total) {
        String[] files = new String[total];
        for (int i = 0; i < total; ++i) {
            files[i] = Main.dir + "\\scan\\" + filename + "_" + (i + 1) + ".tiff";
        }
        MailTool.sendRealFax(tel, files);
    }

    public static void sendRealFax(String tels, String[] files) {
        for (String tel : tels.split(";")) {
            if (tel.equalsIgnoreCase("")) continue;
            MailTool.sendEmail("mail2fax@send.farfax.net", Main.param3 + tel, files, null);
        }
    }

    public static void sendEmail(String toEmail, String subject, String[] files, String docUUIDs) {
        if (toEmail.toLowerCase().endsWith("@ceowin.net") || toEmail.toLowerCase().endsWith("@ceowin99.net")) {
            String filenames = "";
            for (String f : files) {
                filenames = filenames + new File(f).getName() + ";";
            }
            Main.speak("sendInnerMail," + toEmail + "," + filenames + "," + docUUIDs);
        } else {
            sendEmailRunnable r = new sendEmailRunnable(toEmail, subject, files);
            new Thread(r).start();
        }
    }

    public static void splitTiff(File file, int accType, String account, Date sentTime, String plusEmailName) throws IOException {
        FileSeekableStream ss = new FileSeekableStream(file);
        ImageDecoder dec = ImageCodec.createImageDecoder((String)"tiff", (SeekableStream)ss, null);
        int count = dec.getNumPages();
        String filename = Main.newFilename();
        ImageInfo info = null;
        if (count > 1) {
            FileInputStream fin = new FileInputStream(file.getPath());
            FileCacheRandomAccessInputStream rin = new FileCacheRandomAccessInputStream((InputStream)fin);
            TIFFTweaker.splitPages((RandomAccessInputStream)rin, (String)(Main.dir + "\\\u96f2\u7aef\\" + filename));
            rin.close();
            fin.close();
            fin = null;
            rin = null;
            for (int i = 0; i < count; ++i) {
                String singleTiffPath = Main.dir + "\\\u96f2\u7aef\\" + filename + "_page_#" + i + ".tif";
                try {
                    info = Sanselan.getImageInfo((File)new File(singleTiffPath));
                }
                catch (ImageReadException e) {
                    e.printStackTrace();
                    Main.log.error((Object)"error", (Throwable)e);
                }
                float w = info.getWidth();
                float h = info.getHeight();
                float dpiW = info.getPhysicalWidthDpi();
                float dpiH = info.getPhysicalHeightDpi();
                float realH = h * dpiW / dpiH;
                float rateX = w / 1490.0f;
                float rateY = realH / 2222.0f;
                float rate = rateX;
                if (rateX > rateY) {
                    rate = rateY;
                }
                if (dpiW != dpiH) {
                    MailTool.resizeImage(singleTiffPath, Main.dir + "\\\u96f2\u7aef\\" + filename + "_" + (i + 1) + ".tiff", (int)(w / rate), (int)(realH / rate), false);
                    System.gc();
                } else {
                    FileUtils.copyFile((File)new File(Main.dir + "\\\u96f2\u7aef\\" + filename + "_page_#" + i + ".tif"), (File)new File(Main.dir + "\\\u96f2\u7aef\\" + filename + "_" + (i + 1) + ".tiff"));
                }
                new File(Main.dir + "\\\u96f2\u7aef\\" + filename + "_page_#" + i + ".tif").delete();
            }
        } else {
            File target = new File(Main.dir + "\\\u96f2\u7aef\\" + filename + "_1.tiff");
            FileUtils.copyFile((File)file, (File)target);
            try {
                info = Sanselan.getImageInfo((File)target);
            }
            catch (ImageReadException e) {
                e.printStackTrace();
                Main.log.error((Object)"error", (Throwable)e);
            }
            float w = info.getWidth();
            float h = info.getHeight();
            float dpiW = info.getPhysicalWidthDpi();
            float dpiH = info.getPhysicalHeightDpi();
            float realH = h * dpiW / dpiH;
            float rateX = w / 1490.0f;
            float rateY = realH / 2222.0f;
            float rate = rateX;
            if (rateX > rateY) {
                rate = rateY;
            }
            if (dpiW != dpiH) {
                MailTool.resizeImage(target.getPath(), target.getPath(), (int)(w / rate), (int)(realH / rate), false);
                System.gc();
            }
        }
        History history = new History();
        history.setAccType(accType);
        history.setFrom(account);
        history.setFilename(filename);
        history.setTotal(count);
        history.setSendTime(sentTime);
        history.setGotTime(new Date());
        history.setPlusEmailName(plusEmailName);
        Main.gotNewHistory(history, true);
    }

    public static void resizeImage(String in, String out, int w, int h, boolean isAdaptive) {
        try {
            BufferedImage source = ImageIO.read(new File(in));
            BufferedImage bi = new BufferedImage(w, h, 12);
            Graphics2D g = bi.createGraphics();
            g.drawImage(source, 0, 0, w, h, null);
            g.dispose();
            TIFFImageWriterSpi tiffspi = new TIFFImageWriterSpi();
            ImageWriter writer = tiffspi.createWriterInstance();
            ImageWriteParam param = writer.getDefaultWriteParam();
            param.setCompressionMode(2);
            param.setCompressionType("CCITT T.6");
            File fOutputFile = new File(out);
            ImageOutputStream ios = ImageIO.createImageOutputStream(fOutputFile);
            writer.setOutput(ios);
            writer.write(null, new IIOImage(bi, null, null), param);
            ios.close();
            source.flush();
            bi.flush();
            source = null;
            bi = null;
            g = null;
            tiffspi = null;
            writer = null;
            param = null;
            ios = null;
        }
        catch (IOException e) {
            e.printStackTrace();
            Main.log.error((Object)"error", (Throwable)e);
        }
        System.gc();
    }

    public static BufferedImage resizeImage(BufferedImage originalImage, int type, int w, int h) {
        BufferedImage resizedImage = new BufferedImage(w, h, type);
        Graphics2D g = resizedImage.createGraphics();
        g.drawImage(originalImage, 0, 0, w, h, null);
        g.dispose();
        originalImage.flush();
        resizedImage.flush();
        return resizedImage;
    }

    public static BufferedImage convertRenderedImage(RenderedImage img) {
        if (img instanceof BufferedImage) {
            return (BufferedImage)img;
        }
        ColorModel cm = img.getColorModel();
        int width = img.getWidth();
        int height = img.getHeight();
        WritableRaster raster = cm.createCompatibleWritableRaster(width, height);
        boolean isAlphaPremultiplied = cm.isAlphaPremultiplied();
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        String[] keys = img.getPropertyNames();
        if (keys != null) {
            for (int i = 0; i < keys.length; ++i) {
                properties.put(keys[i], img.getProperty(keys[i]));
            }
        }
        BufferedImage result = new BufferedImage(cm, raster, isAlphaPremultiplied, properties);
        img.copyData(raster);
        result.flush();
        img = null;
        return result;
    }

    public static void toTiff(String inFile, int accType, String account, Date sentTime) throws IOException {
        ImageIO.scanForPlugins();
        File fInputFile = new File(inFile);
        BufferedInputStream fis = new BufferedInputStream(new FileInputStream(fInputFile));
        ImageReader reader = null;
        String compressionType = "LZW";
        if (inFile.toLowerCase().endsWith("bmp")) {
            reader = new BMPImageReaderSpi().createReaderInstance();
        } else if (inFile.toLowerCase().endsWith("png")) {
            reader = new PNGImageReaderSpi().createReaderInstance();
        } else if (inFile.toLowerCase().endsWith("jpg")) {
            reader = new JPEGImageReaderSpi().createReaderInstance();
        }
        ImageInputStream iis = ImageIO.createImageInputStream(fis);
        reader.setInput(iis, true);
        try {
            BufferedImage bi = reader.read(0);
            bi = ConvertUtil.convert1((BufferedImage)bi);
            TIFFImageWriterSpi tiffspi = new TIFFImageWriterSpi();
            ImageWriter writer = tiffspi.createWriterInstance();
            ImageWriteParam param = writer.getDefaultWriteParam();
            param.setCompressionMode(2);
            param.setCompressionType(compressionType);
            String filename = Main.newFilename();
            File target = new File(Main.dir + "\\\u96f2\u7aef\\" + filename + "_1" + ".tiff");
            ImageOutputStream ios = ImageIO.createImageOutputStream(target);
            writer.setOutput(ios);
            writer.write(null, new IIOImage(bi, null, null), param);
            ios.close();
            iis.close();
            reader.dispose();
            ((InputStream)fis).close();
            fInputFile.delete();
            if (accType != -1) {
                History h = new History();
                h.setAccType(accType);
                h.setFrom(account);
                h.setFilename(filename);
                h.setTotal(1);
                h.setSendTime(sentTime);
                h.setGotTime(new Date());
                Main.gotNewHistory(h, true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Main.log.error((Object)"error", (Throwable)e);
            Main.showMsg("\u5716\u7247\u932f\u8aa4", "\u4f86\u81ea\u5bc4\u4ef6\u8005" + account + "\u6240\u50b3\u7684\u5716\u7247\u70ba\u932f\u8aa4\u683c\u5f0f\u3002", 2);
            Desktop.getDesktop().open(new File(inFile));
        }
    }

    public static class sendEmailRunnable
    implements Runnable {
        String toEmail;
        String subject;
        String[] files;

        public sendEmailRunnable(String _toEmail, String _subject, String[] _files) {
            this.toEmail = _toEmail;
            this.subject = _subject;
            this.files = _files;
        }

        @Override
        public void run() {
            boolean allExist = true;
            for (String filepath : this.files) {
                String[] file = new File(filepath);
                if (file.exists()) continue;
                allExist = false;
            }
            if (allExist) {
                try {
                    Date now = new Date();
                    MimeMessage msg = new MimeMessage(session);
                    msg.addHeader("Content-type", "text/HTML; charset=UTF-8");
                    msg.addHeader("format", "flowed");
                    msg.addHeader("Content-Transfer-Encoding", "8bit");
                    String from = Main.strAccount + "@ceowin.net";
                    if (this.toEmail.toLowerCase().endsWith("2016gomail.com")) {
                        from = Main.strAccount + "@ceowin.net";
                    } else if (this.toEmail.toLowerCase().endsWith("88gt.net")) {
                        from = Main.strAccount + "@ceowin.net";
                    }
                    msg.setFrom((Address)new InternetAddress(from, from));
                    msg.setReplyTo((Address[])InternetAddress.parse((String)id, (boolean)false));
                    msg.setSubject(this.subject, "UTF-8");
                    msg.setSentDate(now);
                    msg.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)this.toEmail, (boolean)false));
                    MimeMultipart multipart = new MimeMultipart();
                    for (String filepath : this.files) {
                        MimeBodyPart messageBodyPart = new MimeBodyPart();
                        FileDataSource source = new FileDataSource(filepath);
                        messageBodyPart.setDataHandler(new DataHandler((DataSource)source));
                        messageBodyPart.setFileName(UUID.randomUUID().toString() + ".tiff");
                        multipart.addBodyPart((BodyPart)messageBodyPart);
                    }
                    msg.setContent((Multipart)multipart);
                    try {
                        String signingDomain = "ceowin.net";
                        String selector = "sender";
                        msg = MailTool.dkimSignMessage(msg, from, signingDomain, selector);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        Main.log.error((Object)"DKIM \u7b7e\u540d\u5931\u8d25", (Throwable)e);
                    }
                    try {
                        Properties props = new Properties();
                        props.setProperty("mail.smtp.port", smtpPort);
                        props.setProperty("mail.smtp.auth", "true");
                        props.put("mail.smtp.timeout", "5000");
                        props.put("mail.smtp.connectiontimeout", "5000");
                        props.put("mail.smtp.socketFactory.port", smtpPort);
                        props.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
                        String HOST = portal.account.mailhost;
                        String mailId = id;
                        String mailPw = pw;
                        if (this.toEmail.toLowerCase().endsWith("2016gomail.com")) {
                            HOST = "2016gomail.com";
                            mailId = "ceomail@2016gomail.com";
                            mailPw = "mailgo2016";
                        }
                        final String finalMailId = mailId;
                        final String finalMailPw = mailPw;
                        Authenticator auth = new Authenticator(){

                            protected PasswordAuthentication getPasswordAuthentication() {
                                return new PasswordAuthentication(finalMailId, finalMailPw);
                            }
                        };
                        Session session = Session.getInstance((Properties)props, (Authenticator)auth);
                        SMTPTransport tp = (SMTPTransport)session.getTransport();
                        tp.connect(HOST, from, mailPw);
                        tp.sendMessage((Message)msg, msg.getAllRecipients());
                        tp.close();
                        block9: for (int i = 0; i < portal.portal.lstSendHistory.getItems().size(); ++i) {
                            Document d = (Document)portal.portal.lstSendHistory.getItems().get(i);
                            if (d == null || d.isSent() || d.getFriend().getAccount() == null || !d.getFriend().getAccount().equalsIgnoreCase(this.toEmail) && !this.subject.equalsIgnoreCase(Main.param3 + d.getFriend().getAccount())) continue;
                            for (String filepath : this.files) {
                                if (!filepath.endsWith(d.getFilename())) continue;
                                d.setSent(true);
                                continue block9;
                            }
                        }
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                ((TableColumn)portal.portal.lstSendHistory.getColumns().get(3)).setVisible(false);
                                ((TableColumn)portal.portal.lstSendHistory.getColumns().get(3)).setVisible(true);
                            }
                        });
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        Main.log.error((Object)"error", (Throwable)e);
                        block11: for (int i = 0; i < portal.portal.lstSendHistory.getItems().size(); ++i) {
                            Document d = (Document)portal.portal.lstSendHistory.getItems().get(i);
                            if (d.isSent() || d.getFriend().getAccount() == null || !d.getFriend().getAccount().equalsIgnoreCase(this.toEmail) && !this.subject.equalsIgnoreCase(Main.param3 + d.getFriend().getAccount())) continue;
                            for (String filepath : this.files) {
                                if (!filepath.endsWith(d.getFilename())) continue;
                                d.setSent(false);
                                continue block11;
                            }
                        }
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                ((TableColumn)portal.portal.lstSendHistory.getColumns().get(3)).setVisible(false);
                                ((TableColumn)portal.portal.lstSendHistory.getColumns().get(3)).setVisible(true);
                            }
                        });
                    }
                }
                catch (MessagingException e) {
                    e.printStackTrace();
                    Main.log.error((Object)"error", (Throwable)e);
                }
                catch (UnsupportedEncodingException e) {
                    Main.log.error((Object)"error", (Throwable)e);
                    e.printStackTrace();
                }
            } else {
                Platform.runLater(() -> {
                    MailTool.init(id, pw);
                    Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
                    alert.setTitle("\u5bc4\u4fe1\u5931\u6557");
                    alert.setHeaderText(null);
                    alert.setContentText("\u5c07\u5bc4\u51fa\u7684\u90f5\u4ef6\u4e2d\u5305\u542b\u4e00\u500b\u4e0d\u5b58\u5728\u7684\u6a94\u6848\uff0c\u662f\u5426\u91cd\u65b0\u5617\u8a66\u5bc4\u9001\uff1f");
                    Optional result = alert.showAndWait();
                    if (result.get() == ButtonType.OK) {
                        MailTool.sendEmail(this.toEmail, this.subject, this.files, null);
                    }
                });
            }
        }
    }
}

