/*
 * Decompiled with CFR 0.152.
 */
package cc.ceofax.tool;

import cc.ceofax.controller.Main;
import com.sun.media.imageio.plugins.tiff.TIFFImageWriteParam;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.print.PrinterJob;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.SimpleDoc;
import javax.print.attribute.HashDocAttributeSet;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.Chromaticity;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import org.apache.commons.io.FileUtils;

public class PrintTiff {
    public static PrintService mainPrintService;
    public static Map<String, PrintService> printers;
    static DocFlavor flavor;
    public static final double CM_PER_INCH = 0.393700787;
    public static final double INCH_PER_CM = 2.545;
    public static final double INCH_PER_MM = 25.45;

    public PrintTiff() {
        printers = new HashMap<String, PrintService>();
        for (PrintService ps : PrinterJob.lookupPrintServices()) {
            printers.put(ps.getName(), ps);
        }
        if (mainPrintService == null) {
            mainPrintService = printers.get(Main.setting.getPrinter());
        }
    }

    public void print(String source, Date sentTime, Date gotTime, String plusEmailName, String from, String index) throws PrintException, IOException {
        int n;
        String line;
        BufferedReader input;
        Process pr;
        Runtime rt;
        String cmd;
        File printTmp_;
        File file = new File(source);
        File printTmp = new File(Main.dir + "\\\u5217\u5370\\" + file.getName());
        File tiffFile = null;
        if (Main.setting.isBlur()) {
            printTmp_ = new File(Main.dir + "\\\u5217\u5370\\_" + file.getName());
            cmd = " -depth 1 -define connected-components:mean-color=true -define connected-components:area-threshold=20 -connected-components 1 -background white -splice 1x30 -gravity southeast -splice 1x3 -depth 1 ";
            rt = Runtime.getRuntime();
            try {
                cmd = Main.imageMagickPath + " " + source + cmd + printTmp_.getCanonicalPath();
                pr = rt.exec(cmd);
                input = new BufferedReader(new InputStreamReader(pr.getInputStream()));
                line = null;
                while ((line = input.readLine()) != null) {
                    System.out.println(line);
                }
                n = pr.waitFor();
            }
            catch (IOException e) {
                e.printStackTrace();
                Main.log.error((Object)"error", (Throwable)e);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                Main.log.error((Object)"error", (Throwable)e);
            }
            file = printTmp_;
        }
        if (Main.setting.isAutoCut()) {
            printTmp_ = new File(Main.dir + "\\\u5217\u5370\\_" + file.getName());
            cmd = " -trim +repage ";
            rt = Runtime.getRuntime();
            try {
                cmd = Main.imageMagickPath + " " + file.getCanonicalPath() + cmd + printTmp_.getCanonicalPath();
                pr = rt.exec(cmd);
                input = new BufferedReader(new InputStreamReader(pr.getInputStream()));
                line = null;
                while ((line = input.readLine()) != null) {
                    System.out.println(line);
                }
                n = pr.waitFor();
            }
            catch (IOException e) {
                e.printStackTrace();
                Main.log.error((Object)"error", (Throwable)e);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                Main.log.error((Object)"error", (Throwable)e);
            }
            file = printTmp_;
        }
        try {
            tiffFile = PrintTiff.addTimeLabel(file, printTmp, sentTime, gotTime, from, index) ? new File(printTmp.getPath()) : file;
        }
        catch (IOException e) {
            e.printStackTrace();
            Main.log.error((Object)"error", (Throwable)e);
            Main.showMsg("\u5217\u5370\u5931\u6557", "\u8acb\u6aa2\u67e5\u6587\u4ef6\u662f\u5426\u5df2\u5217\u5370\uff0c\u6216\u624b\u52d5\u5217\u5370\u3002", 2);
        }
        if (plusEmailName == null && mainPrintService == null) {
            Main.showMsg("\u5217\u5370\u5931\u6557", "\u8acb\u5148\u8a2d\u5b9a\u4e00\u53f0\u5370\u8868\u6a5f", 2);
        } else {
            PrintService service = null;
            if (plusEmailName != null) {
                String printerName = Main.plusEmailPrinters.get(plusEmailName);
                if (printerName == null || printerName.equals("") || printerName.equals("\u9810\u8a2d")) {
                    if (mainPrintService == null) {
                        Main.showMsg("\u5217\u5370\u5931\u6557", "\u8acb\u5148\u8a2d\u5b9a\u4e00\u53f0\u5370\u8868\u6a5f", 2);
                    } else {
                        service = mainPrintService;
                    }
                } else {
                    PrintService plusEmailPrintService = printers.get(printerName);
                    service = plusEmailPrintService == null ? mainPrintService : plusEmailPrintService;
                }
            } else {
                service = mainPrintService;
            }
            double width = PrintTiff.cmsToPixel(21.0, 72.0);
            double height = PrintTiff.cmsToPixel(29.7, 72.0);
            if (Main.setting.getPrinterSize().equalsIgnoreCase("B4")) {
                width = PrintTiff.cmsToPixel(25.0, 72.0);
                height = PrintTiff.cmsToPixel(35.3, 72.0);
            } else if (Main.setting.getPrinterSize().equalsIgnoreCase("JIS B4")) {
                width = PrintTiff.cmsToPixel(25.7, 72.0);
                height = PrintTiff.cmsToPixel(36.4, 72.0);
            }
            HashPrintRequestAttributeSet pras = new HashPrintRequestAttributeSet();
            pras.add(new MediaPrintableArea(0.0f, 0.0f, (float)width / 72.0f, (float)height / 72.0f, 25400));
            if (Main.setting.getPrinterSize().equalsIgnoreCase("B4")) {
                pras.add(MediaSizeName.ISO_B4);
            } else if (Main.setting.getPrinterSize().equalsIgnoreCase("JIS B4")) {
                pras.add(MediaSizeName.JIS_B4);
            } else {
                pras.add(MediaSizeName.ISO_A4);
            }
            pras.add(OrientationRequested.PORTRAIT);
            pras.add(Chromaticity.MONOCHROME);
            pras.add(new Copies(1));
            pras.add(new JobName(tiffFile.getName(), Locale.getDefault()));
            if (service != null) {
                DocPrintJob job = service.createPrintJob();
                FileInputStream fis = new FileInputStream(tiffFile);
                HashDocAttributeSet das = new HashDocAttributeSet();
                SimpleDoc doc = new SimpleDoc(fis, flavor, das);
                job.print(doc, pras);
                fis.close();
                fis = null;
                doc = null;
                job = null;
                das = null;
            }
            pras = null;
            System.gc();
        }
    }

    public static double pixelsToCms(double pixels, double dpi) {
        return PrintTiff.inchesToCms(pixels / dpi);
    }

    public static double cmsToPixel(double cms, double dpi) {
        return PrintTiff.cmToInches(cms) * dpi;
    }

    public static double cmToInches(double cms) {
        return cms * 0.393700787;
    }

    public static double inchesToCms(double inch) {
        return inch * 2.545;
    }

    public static List<String> getPrinterServiceNameList() {
        PrintService[] services = PrinterJob.lookupPrintServices();
        ArrayList<String> list = new ArrayList<String>();
        list.add("\u672a\u8a2d\u5b9a");
        for (int i = 0; i < services.length; ++i) {
            list.add(services[i].getName());
        }
        return list;
    }

    public static boolean addTimeLabel(File source, File target, Date sentTime, Date gotTime, String from, String index) throws IOException {
        if (sentTime != null || gotTime != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("MM-dd HH:mm:ss");
            String msg = "";
            if (sentTime != null) {
                msg = msg + "\u50b3 " + sdf.format(sentTime);
            }
            if (gotTime != null) {
                msg = msg + " - \u6536 " + sdf.format(gotTime);
            }
            if (from != null && Main.setting.isShowFrom()) {
                msg = msg + " " + from + " \u7b2c " + index + " \u5f35";
            }
            File temp = target;
            BufferedImage image = ImageIO.read(source);
            BufferedImage paper = new BufferedImage(image.getWidth(), image.getHeight() + 60, 12);
            Graphics2D g = paper.createGraphics();
            g.setColor(Color.white);
            g.fillRect(0, 0, paper.getWidth(), paper.getHeight());
            g.drawImage(image, 0, 60, image.getWidth(), image.getHeight(), null);
            g.setColor(Color.black);
            int fontSize = 35 * image.getWidth() / 1600;
            g.setFont(new Font("DFKai-SB", 1, fontSize));
            ((Graphics)g).drawString(msg, 5, 35);
            g.dispose();
            PrintTiff.convertToTiff(temp, paper);
            image.flush();
            paper.flush();
            image = null;
            paper = null;
            g = null;
            System.gc();
            return true;
        }
        FileUtils.copyFile((File)source, (File)target);
        return false;
    }

    public static boolean convertToTiff(File tiffFile, BufferedImage image) {
        ImageIO.scanForPlugins();
        ImageOutputStream ios = null;
        ImageWriter writer = null;
        try {
            Iterator<ImageWriter> it = ImageIO.getImageWritersByFormatName("TIF");
            if (!it.hasNext()) {
                return false;
            }
            writer = it.next();
            ios = ImageIO.createImageOutputStream(tiffFile);
            writer.setOutput(ios);
            TIFFImageWriteParam writeParam = new TIFFImageWriteParam(Locale.ENGLISH);
            writeParam.setCompressionMode(2);
            writeParam.setCompressionType("CCITT T.4");
            IIOImage iioImage = new IIOImage(image, null, null);
            writer.write(null, iioImage, (ImageWriteParam)writeParam);
            writer.dispose();
            writer = null;
            writeParam = null;
            ios.flush();
            ios.close();
            ios = null;
        }
        catch (IOException e) {
            e.printStackTrace();
            Main.log.error((Object)"error", (Throwable)e);
            return false;
        }
        return true;
    }

    static {
        flavor = DocFlavor.INPUT_STREAM.JPEG;
    }
}

