/*
 * Decompiled with CFR 0.152.
 */
package cc.ceofax.tool;

import cc.ceofax.controller.Main;
import cc.ceofax.controller.portal;
import cc.ceofax.tool.EZTwain;
import cc.ceofax.tool.UnzipUtility;
import com.sun.jna.Native;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.swing.JOptionPane;

public class TWScannerInterrface
extends Thread {
    public String[] devices;
    public EZTwain tw;
    DateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
    int scanningIndex = 0;
    public List<String> scanningFilenames = new ArrayList<String>();
    public boolean hasJob = false;
    public boolean openUI = false;
    public boolean shouldCancel = false;
    private static final int CAP_HP_EDGE_ERASE_ENABLED = 32784;
    private static final int CAP_HP_FAST_BW_ENABLED = 32848;
    private static final int CAP_HP_ENABLE_DROPCOLOR1 = 32864;
    private static final int CAP_HP_ENABLE_DROPCOLOR2 = 32869;
    private static final int CAP_HP_ENABLE_DROPCOLOR3 = 32880;
    private static final int CAP_HP_MULTISTREAM_THRESHOLD = 32967;
    private static final int CAP_HP_MULTISTREAM_ENHANCED_BW_CONTENT_ENABLED = 32968;

    public TWScannerInterrface() {
        try {
            this.tw = (EZTwain)Native.loadLibrary((String)"Eztwain4", EZTwain.class);
            this.tw.TWAIN_UniversalLicense("ceofax168", -288887628);
            this.getSources();
        }
        catch (UnsatisfiedLinkError e) {
            e.printStackTrace();
            portal.stages.get("login").hide();
            JOptionPane.showMessageDialog(null, "\u7cfb\u7d71\u5373\u5c07\u81ea\u52d5\u66f4\u65b0\uff0c\u9ede\u9078\u78ba\u8a8d\u4e26\u7a0d\u4faf\u7247\u523b\uff0c\u66f4\u65b0\u5b8c\u7562\u5f8c\u5c07\u81ea\u52d5\u958b\u555fVIP");
            String path = TWScannerInterrface.class.getProtectionDomain().getCodeSource().getLocation().getPath();
            Main.log.error((Object)"error", (Throwable)e);
            try {
                String decodedPath = URLDecoder.decode(path, "UTF-8");
                File desktopPath = new File(decodedPath).getParentFile().getParentFile().getParentFile();
                String zipPath = desktopPath + "/newVIP.zip";
                System.out.println(zipPath);
                TWScannerInterrface.download("http://www.ceowin.net/vip32.zip", zipPath);
                String newFolderPath = desktopPath.getPath() + "/newVIP";
                File newFolder = new File(newFolderPath);
                if (!newFolder.exists()) {
                    newFolder.mkdir();
                }
                UnzipUtility uu = new UnzipUtility();
                uu.unzip(zipPath, newFolderPath, null, null, false);
                try {
                    new ProcessBuilder(newFolder + "\\vip32\\vip.exe").start();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                    Main.log.error((Object)"error", (Throwable)e2);
                }
                System.exit(0);
            }
            catch (IOException e1) {
                e1.printStackTrace();
                Main.log.error((Object)"error", (Throwable)e1);
            }
        }
    }

    public void getSources() {
        if (this.tw.TWAIN_GetSourceList()) {
            ArrayList<String> names = new ArrayList<String>();
            byte[] sName = new byte[33];
            while (this.tw.TWAIN_GetNextSourceName(sName)) {
                names.add(new String(sName));
                sName = new byte[33];
            }
            this.devices = names.toArray(new String[0]);
        }
    }

    public void finishScan() {
        this.scanningIndex = 0;
        Main.isScaanning = false;
        portal.stages.get("portal").getScene().lookup("#btnDirectSent1").setDisable(false);
        portal.stages.get("portal").getScene().lookup("#lstFriend").setDisable(false);
        portal.stages.get("portal").getScene().lookup("#chkIsVip").setDisable(false);
        portal.stages.get("portal").getScene().lookup("#btnSelectAllFriend").setDisable(false);
        portal.stages.get("portal").getScene().lookup("#btnAddFriend").setDisable(false);
        portal.stages.get("portal").getScene().lookup("#boxFriends").setVisible(true);
        portal.stages.get("portal").getScene().lookup("#boxScanStatus").setVisible(false);
        if (this.scanningFilenames != null && this.scanningFilenames.size() > 0) {
            ArrayList<String> allFiles = new ArrayList<String>();
            allFiles.addAll(this.scanningFilenames);
            new Thread(() -> Main.sentDocsWithMail(allFiles)).start();
        }
        this.scanningFilenames.clear();
        this.tw.TWAIN_ClearError();
        this.suspend();
    }

    @Override
    public void run() {
        while (true) {
            System.out.println("start scan");
            if (!this.hasJob) continue;
            this.hasJob = false;
            if (this.openUI) {
                System.out.println("1");
                String sourceName = Main.setting.getScanner();
                if (this.tw.TWAIN_OpenSource(sourceName)) {
                    System.out.println("2");
                    this.tw.TWAIN_SetHideUI(false);
                    System.out.println("3");
                    this.tw.TWAIN_Acquire(0);
                    System.out.println("4");
                } else {
                    System.out.println("no");
                }
                this.tw.TWAIN_DisableSource();
                System.out.println("5");
                this.tw.TWAIN_CloseSource();
                System.out.println("6");
                this.suspend();
                System.out.println("7");
                continue;
            }
            try {
                this.scanToDir();
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
                Main.log.error((Object)"error", (Throwable)e);
                this.finishScan();
                continue;
            }
            break;
        }
    }

    public void scanToDir() throws IOException {
        String dir = Main.dir + "\\scan\\";
        if (this.devices == null) {
            return;
        }
        String sourceName = Main.setting.getScanner();
        if (this.tw.TWAIN_OpenSource(sourceName)) {
            this.tw.TWAIN_SetHideUI(true);
            if (!Main.setting.isNeedResetScanner()) {
                this.tw.TWAIN_SetIndicators(false);
                this.tw.TWAIN_SetFileAppendFlag(false);
                if (Main.setting.getScannerType() == 1) {
                    this.tw.TWAIN_SelectFeeder(true);
                    this.tw.TWAIN_SetAutoFeed(true);
                } else if (Main.setting.getScannerType() == 2) {
                    this.tw.TWAIN_SelectFeeder(false);
                }
                int paperSize = 0;
                if (Main.setting.getScannerSize().equalsIgnoreCase("A4")) {
                    paperSize = 1;
                } else if (Main.setting.getScannerSize().equalsIgnoreCase("B4")) {
                    paperSize = 6;
                } else if (Main.setting.getScannerSize().equalsIgnoreCase("JIS B4")) {
                    paperSize = 38;
                }
                this.tw.TWAIN_SetPaperSize(paperSize);
            }
            if (Main.setting.isScannerAutoBright()) {
                this.tw.TWAIN_SetAutoBright(true);
            }
            if (Main.setting.isScannerAutoCrop()) {
                this.tw.TWAIN_SetAutoCrop(3);
            } else {
                this.tw.TWAIN_SetAutoCrop(0);
            }
            if (Main.setting.isScannerAutoContrast()) {
                if (Main.setting.isHP()) {
                    this.tw.TWAIN_SetCapBool(32968, false);
                } else {
                    this.tw.TWAIN_SetAutoContrast(1);
                }
            } else {
                this.tw.TWAIN_SetAutoContrast(0);
            }
            if (Main.setting.isScannerAutoDeskew()) {
                this.tw.TWAIN_SetAutoDeskew(1);
            } else {
                this.tw.TWAIN_SetAutoDeskew(0);
            }
            this.tw.TWAIN_SetPixelType(0);
            this.tw.TWAIN_SetBitDepth(1);
            int dpi = Main.setting.getScannerDpi();
            this.tw.TWAIN_SetResolution(dpi);
            this.tw.TWAIN_SetXferCount(-1);
            this.tw.TWAIN_SetAutoScan(true);
            this.tw.TWAIN_SetMultiTransfer(true);
            this.tw.TWAIN_SetYResolution(dpi);
            this.tw.TWAIN_SetXResolution(dpi);
            if (this.tw.TWAIN_CanDoDuplex()) {
                this.tw.TWAIN_EnableDuplex(false);
            }
            if (Main.setting.isNeedResetScanner()) {
                this.tw.TWAIN_ResetRegion();
                this.tw.TWAIN_SetRegion(0.0, 0.0, 0.0, 0.0);
            }
            if (Main.setting.isScannerThreshold()) {
                if (Main.setting.isHP()) {
                    this.tw.TWAIN_SetCapability(32967, Main.setting.getThreshold());
                } else {
                    this.tw.TWAIN_SetThreshold(Main.setting.getThreshold());
                }
            }
            if (Main.setting.isHP()) {
                this.tw.TWAIN_SetCapBool(32784, false);
                this.tw.TWAIN_SetCapBool(32848, false);
                this.tw.TWAIN_SetCapBool(32864, false);
                this.tw.TWAIN_SetCapBool(32869, false);
                this.tw.TWAIN_SetCapBool(32880, false);
            }
            this.scanningIndex = 0;
            this.scanningFilenames.clear();
            this.tw.TWAIN_EnableSource(0);
            do {
                String fileName;
                String decodedPath;
                int result;
                if ((result = this.tw.TWAIN_AcquireToFilename(0, decodedPath = URLDecoder.decode(fileName = dir + UUID.randomUUID().toString().replaceAll("-", "") + this.dateFormat.format(new Date()) + "_1.tiff", "UTF-8"))) == 0) {
                    ++this.scanningIndex;
                } else {
                    String errorMsg = null;
                    if (result == -2) {
                        errorMsg = "\u6383\u63cf\u5f8c\u7684\u6a94\u6848\u5beb\u5165\u786c\u789f\u5931\u6557\uff0c\u8acb\u4f7f\u7528\u7cfb\u7d71\u7ba1\u7406\u54e1\u8eab\u4efd\u57f7\u884cVIP\u7a0b\u5f0f\uff0c\u6216\u662f\u91cd\u65b0\u5f9e\u5b98\u7db2\u4e0b\u8f09\u4e3b\u7a0b\u5f0f\uff0cXP\u7528\u6236\u8acb\u6aa2\u67e5\u8cc7\u6599\u593e'\u5099\u4efd/scan'\u88e1\u7684\u6a94\u6848\u6578\u662f\u5426\u8d85\u904e1\u842c\u4e0a\u9650\u3002";
                    } else if (result == -3) {
                        errorMsg = "\u6383\u63cf\u5f8c\u7684\u5716\u50cf\u4e0d\u6b63\u5e38\uff0c\u8acb\u63db\u6383\u63cf\u5668\u6216\u91cd\u958b\u5f8c\u518d\u6e2c\u8a66";
                    } else if (result == -4) {
                        errorMsg = "\u786c\u789f\u5df2\u6eff";
                    } else if (result == -10) {
                        errorMsg = "\u4f7f\u7528\u8005\u624b\u52d5\u53d6\u6d88\u6383\u63cf";
                    }
                    if (errorMsg == null) break;
                    Main.showMsg("\u6383\u63cf\u51fa\u932f", errorMsg, 2);
                    break;
                }
                File f = new File(fileName);
                new Thread(() -> Main.getScanDoc(f)).start();
                this.scanningFilenames.add(f.getName());
            } while (!this.tw.TWAIN_IsDone());
            this.tw.TWAIN_DisableSource();
            this.tw.TWAIN_CloseSource();
            this.finishScan();
        } else {
            System.out.println("can't open scanner");
            this.tw.TWAIN_DisableSource();
            this.tw.TWAIN_CloseSource();
            this.finishScan();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void download(String remotePath, String localPath) {
        BufferedInputStream in = null;
        FileOutputStream out = null;
        try {
            int count;
            URL url = new URL(remotePath);
            URLConnection conn = url.openConnection();
            int size = conn.getContentLength();
            if (size < 0) {
                JOptionPane.showMessageDialog(null, "\u627e\u4e0d\u5230\u4e0b\u8f09\u4f4d\u7f6e\uff0c\u6216\u7db2\u8def\u7570\u5e38\u3002");
                System.out.println("Could not get the file size");
            } else {
                System.out.println("File size: " + size);
            }
            in = new BufferedInputStream(url.openStream());
            out = new FileOutputStream(localPath);
            byte[] data = new byte[1024];
            double sumCount = 0.0;
            while ((count = in.read(data, 0, 1024)) != -1) {
                out.write(data, 0, count);
                sumCount += (double)count;
                if (size <= 0) continue;
            }
        }
        catch (FileNotFoundException e0) {
            JOptionPane.showMessageDialog(null, "\u627e\u4e0d\u5230\u4e0b\u8f09\u4f4d\u7f6e\uff0c\u6216\u7db2\u8def\u7570\u5e38\u3002");
            Main.log.error((Object)"error", (Throwable)e0);
        }
        catch (MalformedURLException e1) {
            e1.printStackTrace();
            JOptionPane.showMessageDialog(null, "\u627e\u4e0d\u5230\u4e0b\u8f09\u4f4d\u7f6e\uff0c\u6216\u7db2\u8def\u7570\u5e38\u3002");
            Main.log.error((Object)"error", (Throwable)e1);
        }
        catch (IOException e2) {
            e2.printStackTrace();
            JOptionPane.showMessageDialog(null, "\u627e\u4e0d\u5230\u4e0b\u8f09\u4f4d\u7f6e\uff0c\u6216\u7db2\u8def\u7570\u5e38\u3002");
            Main.log.error((Object)"error", (Throwable)e2);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                    Main.log.error((Object)"error", (Throwable)e3);
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e4) {
                    e4.printStackTrace();
                    Main.log.error((Object)"error", (Throwable)e4);
                }
            }
        }
    }
}

