/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.cloud.HttpServiceOptions;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageFactory;
import com.google.cloud.storage.StorageImpl;
import com.google.cloud.storage.spi.DefaultStorageRpc;
import com.google.cloud.storage.spi.StorageRpc;
import com.google.cloud.storage.spi.StorageRpcFactory;
import com.google.common.collect.ImmutableSet;
import java.util.Set;

public class StorageOptions
extends HttpServiceOptions<Storage, StorageRpc, StorageOptions> {
    private static final long serialVersionUID = -7456495262640805964L;
    private static final String GCS_SCOPE = "https://www.googleapis.com/auth/devstorage.full_control";
    private static final Set<String> SCOPES = ImmutableSet.of((Object)"https://www.googleapis.com/auth/devstorage.full_control");

    private StorageOptions(Builder builder) {
        super(StorageFactory.class, StorageRpcFactory.class, (HttpServiceOptions.Builder)builder);
    }

    protected StorageFactory defaultServiceFactory() {
        return DefaultStorageFactory.INSTANCE;
    }

    protected StorageRpcFactory defaultRpcFactory() {
        return DefaultStorageRpcFactory.INSTANCE;
    }

    protected Set<String> scopes() {
        return SCOPES;
    }

    public static StorageOptions defaultInstance() {
        return StorageOptions.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public int hashCode() {
        return this.baseHashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof StorageOptions && this.baseEquals((StorageOptions)((Object)obj));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends HttpServiceOptions.Builder<Storage, StorageRpc, StorageOptions, Builder> {
        private Builder() {
        }

        private Builder(StorageOptions options) {
            super((HttpServiceOptions)options);
        }

        public StorageOptions build() {
            return new StorageOptions(this);
        }
    }

    public static class DefaultStorageRpcFactory
    implements StorageRpcFactory {
        private static final StorageRpcFactory INSTANCE = new DefaultStorageRpcFactory();

        public StorageRpc create(StorageOptions options) {
            return new DefaultStorageRpc(options);
        }
    }

    public static class DefaultStorageFactory
    implements StorageFactory {
        private static final StorageFactory INSTANCE = new DefaultStorageFactory();

        public Storage create(StorageOptions options) {
            return new StorageImpl(options);
        }
    }
}

