/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.conversion.impl;

import com.activetree.common.conversion.impl.ImageBase;
import com.activetree.common.conversion.impl.MemoryImageMaker;
import com.activetree.common.exception.AtException;
import com.activetree.common.page.AbstractPage;
import com.activetree.common.utils.StringUtil;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileImageOutputStream;
import javax.imageio.stream.ImageOutputStream;

public class JPEG
extends ImageBase {
    public static void saveAsJPEG(AbstractPage page, String outputFileName, float qualityFactor) throws AtException {
        File file = new File(outputFileName);
        FileImageOutputStream output = null;
        try {
            output = new FileImageOutputStream(file);
        }
        catch (Throwable t) {
            String stack = StringUtil.getStackTrace(t);
            throw new AtException(stack);
        }
        JPEG.saveAsJPEG(page, output, qualityFactor);
    }

    public static final void saveAsJPEG(AbstractPage page, ImageOutputStream outputStream, float qualityFactor) throws AtException {
        double resizeFactor = 1.0;
        boolean autoMatchToPaperSize = false;
        JPEG.saveAsJPEG(page, outputStream, qualityFactor, resizeFactor, autoMatchToPaperSize);
    }

    public static final void saveAsJPEG(AbstractPage page, ImageOutputStream outputStream, float qualityFactor, double resizeFactor, boolean autoMatchToPaperSize) throws AtException {
        AbstractPage[] allPages = new AbstractPage[]{page};
        BufferedImage[] images = MemoryImageMaker.getImagesForPages(allPages, resizeFactor, autoMatchToPaperSize);
        try {
            Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName(FORMAT);
            if (iter.hasNext()) {
                ImageWriter writer = iter.next();
                IIOImage image = new IIOImage(images[0], null, null);
                ImageWriteParam iwp = writer.getDefaultWriteParam();
                iwp.setCompressionMode(2);
                iwp.setCompressionQuality(qualityFactor);
                writer.setOutput(outputStream);
                writer.write(image);
            }
            outputStream.flush();
            outputStream.close();
        }
        catch (Throwable t) {
            throw new AtException(t);
        }
    }

    static {
        FORMAT = "JPEG";
    }
}

