/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.conversion.impl;

import com.activetree.common.conversion.impl.ImageJAI;
import com.activetree.common.conversion.impl.MemoryImageMaker;
import com.activetree.common.exception.AtException;
import com.activetree.common.page.AbstractPage;
import com.activetree.common.utils.AtDebug;
import com.activetree.common.utils.StringUtil;
import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.ImageEncodeParam;
import com.sun.media.jai.codec.ImageEncoder;
import com.sun.media.jai.codec.TIFFEncodeParam;
import com.sun.media.jai.codec.TIFFField;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.media.jai.Histogram;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;

public class TiffConverterPrivate
extends ImageJAI {
    private String FORMAT = "TIFF";

    TiffConverterPrivate(String format) throws AtException {
        this.FORMAT = format;
    }

    final void saveAsTIFF(AbstractPage[] allPages, OutputStream outputStream, boolean compress, int COMPRESSION_ALGORITHM, int dpi, boolean isUseDefaultDpi, double resizeFactor, boolean autoMatchToPaperSize) throws AtException {
        AtDebug.debug("BEGIN saveAsTiff() pages " + (allPages != null ? allPages.length : 0));
        try {
            AbstractPage[] remPages = null;
            for (int i = 1; allPages != null && i < allPages.length; ++i) {
                if (remPages == null) {
                    remPages = new AbstractPage[allPages.length - 1];
                }
                remPages[i - 1] = allPages[i];
            }
            DiskImageIterator diskIter = new DiskImageIterator(remPages, COMPRESSION_ALGORITHM, compress, resizeFactor, autoMatchToPaperSize);
            TIFFEncodeParam param = new TIFFEncodeParam();
            if (compress) {
                param.setCompression(COMPRESSION_ALGORITHM);
            }
            param.setExtraImages((Iterator)diskIter);
            if (!isUseDefaultDpi) {
                TIFFField[] dpiParams = this.getDPIProperties(dpi);
                param.setExtraFields(dpiParams);
                AtDebug.debug("DPI: " + dpi);
            } else {
                AtDebug.debug("DPI (default is used)");
            }
            ImageEncoder encoder = ImageCodec.createImageEncoder((String)this.FORMAT, (OutputStream)outputStream, (ImageEncodeParam)param);
            if (allPages.length > 0) {
                AbstractPage[] page0 = new AbstractPage[]{allPages[0]};
                DiskImageIterator page0Iter = new DiskImageIterator(page0, COMPRESSION_ALGORITHM, compress, resizeFactor, autoMatchToPaperSize);
                RenderedImage page0ri = (RenderedImage)page0Iter.get(0);
                encoder.encode(page0ri);
            }
            outputStream.close();
        }
        catch (Throwable t) {
            String stack = StringUtil.getStackTrace(t);
            throw new AtException(stack);
        }
        AtDebug.debug("END saveAsTiff() pages " + (allPages != null ? allPages.length : 0));
    }

    private final TIFFField[] getDPIProperties(int dpi) {
        TIFFField[] dpiParams = new TIFFField[]{new TIFFField(282, 5, 1, (Object)new long[][]{{dpi, 1L}, {0L, 0L}}), new TIFFField(283, 5, 1, (Object)new long[][]{{dpi, 1L}, {0L, 0L}}), new TIFFField(262, 3, 1, (Object)new char[]{'\u0000'}), new TIFFField(296, 3, 1, (Object)new char[]{'\u0002'})};
        return dpiParams;
    }

    private final BufferedImage[] convertToBilevelImages(RenderedImage[] bi) {
        BufferedImage[] g4Images = null;
        for (int i = 0; bi != null && i < bi.length; ++i) {
            if (g4Images == null) {
                g4Images = new BufferedImage[bi.length];
            }
            double[][] matrix = new double[][]{{0.00392156862745098, 0.00392156862745098, 0.00392156862745098, 0.0}};
            ParameterBlock pb = new ParameterBlock();
            pb.addSource(bi[i]);
            pb.add(matrix);
            RenderedOp source = JAI.create((String)"bandCombine", (ParameterBlock)pb);
            Histogram histogram = (Histogram)JAI.create((String)"histogram", (RenderedImage)source).getProperty("histogram");
            double[] threshold = histogram.getPTileThreshold(0.5);
            source = JAI.create((String)"binarize", (RenderedImage)source, (Object)new Double(threshold[0]));
            g4Images[i] = source.getAsBufferedImage();
        }
        return g4Images;
    }

    class DiskImageIterator
    implements Iterator {
        private AbstractPage[] pages;
        private boolean compress = false;
        private int algorithm;
        double resizeFactor;
        boolean autoMatchToPaperSize;
        int cursor = 0;
        int lastRet = -1;

        DiskImageIterator(AbstractPage[] pages, int algorithm, boolean compress, double resizeFactor, boolean autoMatchToPaperSize) {
            this.pages = pages;
            this.algorithm = algorithm;
            this.compress = compress;
            this.resizeFactor = resizeFactor;
            this.autoMatchToPaperSize = autoMatchToPaperSize;
        }

        public int size() {
            return this.pages != null ? this.pages.length : 0;
        }

        public Object get(int idx) {
            AbstractPage aPage = this.pages[idx];
            AbstractPage[] allPages = new AbstractPage[]{aPage};
            RenderedImage[] images = null;
            try {
                images = MemoryImageMaker.getImagesForPages(allPages, this.resizeFactor, this.autoMatchToPaperSize);
            }
            catch (Throwable t) {
                AtDebug.debug(9, "MemoryImageMaker.getImagesForPages() got error for pageIndex=" + idx);
                throw new RuntimeException(t.getMessage());
            }
            if (this.compress) {
                if (this.algorithm == 4) {
                    images = TiffConverterPrivate.this.convertToBilevelImages(images);
                } else if (this.algorithm == 2) {
                    images = TiffConverterPrivate.this.convertToBilevelImages(images);
                } else if (this.algorithm == 3) {
                    images = TiffConverterPrivate.this.convertToBilevelImages(images);
                } else if (this.algorithm == 5) {
                    throw new RuntimeException("LZW: unsupported compression. Use other compression algorithms.");
                }
            }
            return images[0];
        }

        public boolean hasNext() {
            return this.cursor != this.size();
        }

        public Object next() {
            try {
                Object next = this.get(this.cursor);
                this.lastRet = this.cursor++;
                return next;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        public void remove() {
            throw new RuntimeException("Read only iterator");
        }
    }
}

