/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.data;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Vector;

public class Map2D
implements Serializable {
    private Vector keyObjects = new Vector();
    private Vector valueObjects = new Vector();

    private void setKey(int index, Object key) {
        this.keyObjects.setElementAt(key, index);
    }

    private void setValue(int index, Object value) {
        this.valueObjects.setElementAt(value, index);
    }

    public boolean containsKey(Object obj) {
        return this.keyObjects.contains(obj);
    }

    public void setElementAt(int index, Object key, Object value) {
        this.setKey(index, key);
        this.setValue(index, value);
    }

    public void insertElementAt(int index, Object key, Object value) {
        this.insertKey(index, key);
        this.insertValue(index, value);
    }

    private void insertKey(int index, Object key) {
        this.keyObjects.insertElementAt(key, index);
    }

    private void insertValue(int index, Object value) {
        this.valueObjects.insertElementAt(value, index);
    }

    public void put(Object key, Object value) {
        if (key == null) {
            throw new NullPointerException("null key is not allowed.");
        }
        this.keyObjects.add(key);
        this.valueObjects.add(value);
    }

    public int size() {
        return this.keyObjects.size();
    }

    public Object getKey(int idx) {
        return this.keyObjects.get(idx);
    }

    public Object getValue(int idx) {
        return this.valueObjects.get(idx);
    }

    public Object getValue(Object key) {
        int idx = this.keyObjects.indexOf(key);
        if (idx >= 0) {
            return this.valueObjects.get(idx);
        }
        return null;
    }

    public Iterator getKeyObjects() {
        Iterator keyIter = this.keyObjects.iterator();
        return keyIter;
    }

    public Iterator getValueObjects() {
        Iterator valIter = this.valueObjects.iterator();
        return valIter;
    }

    public void clear() {
        this.keyObjects.clear();
        this.valueObjects.clear();
    }

    public Object clone() {
        Vector keyCopies = (Vector)this.keyObjects.clone();
        Vector valueCopies = (Vector)this.valueObjects.clone();
        Map2D copy = new Map2D();
        for (int i = 0; i < keyCopies.size(); ++i) {
            Object key = keyCopies.get(i);
            Object value = valueCopies.get(i);
            copy.put(key, value);
        }
        return copy;
    }
}

