/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.internal;

import com.activetree.common.utils.Base64;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.SystemColor;
import java.awt.geom.AffineTransform;
import java.awt.print.PageFormat;

public class DemoShape {
    protected String tString = null;

    public DemoShape() {
        this(null);
    }

    public DemoShape(String demoString) {
        this.tString = demoString;
        if (this.tString == null) {
            this.tString = new String(Base64.decode("VHJpYWwgT25seQ==".getBytes()));
        }
    }

    protected Color getForeground() {
        return SystemColor.black;
    }

    public void drawDemoShape(Graphics2D graphics, PageFormat pf) {
        if (this.tString == null || this.tString.length() == 0) {
            return;
        }
        Graphics2D g = graphics;
        try {
            AffineTransform currAt = g.getTransform();
            Color orgColor = g.getColor();
            Font orgFont = g.getFont();
            Stroke orgStroke = g.getStroke();
            Font font = new Font("Helvetica", 1, 30);
            Color textColor = this.getForeground();
            double pw = pf.getWidth();
            double ph = pf.getHeight();
            double cx = pw / 2.0;
            double cy = ph / 2.0;
            FontMetrics fm = g.getFontMetrics(font);
            double lw = fm.stringWidth(this.tString);
            double lh = fm.getHeight();
            g.setFont(font);
            g.setColor(textColor);
            g.translate(cx, cy);
            g.drawString(this.tString, -((float)lw) / 2.0f, (float)(lh / 4.0));
            g.setTransform(currAt);
            g.setPaint(orgColor);
            g.setFont(orgFont);
            g.setStroke(orgStroke);
        }
        catch (Throwable t) {
            // empty catch block
        }
    }
}

