/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.media;

import com.activetree.common.media.AtMediaSizeObject;
import com.activetree.common.media.JPrintMediaSize;
import com.activetree.common.media.JPrintMediaSizeName;
import com.activetree.common.utils.AtDebug;
import com.activetree.common.utils.MediaUtil;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.io.Serializable;
import javax.print.attribute.standard.MediaSizeName;

public final class StandardPapers
implements Serializable {
    private static MediaSizeName[] ALL_MEDIA_NAMES;

    public static PageFormat getMatchedPageFormat(Rectangle2D printableArea) {
        PageFormat matchedPf = StandardPapers.getMatchedPageFormat(printableArea, 0.0, 0.0);
        return matchedPf;
    }

    public static PageFormat getMatchedPageFormat(Rectangle2D printableArea, double widthTolerance, double heightTolerance) {
        PageFormat matchedPf = StandardPapers.getMatchedPageFormat(printableArea, widthTolerance, heightTolerance, 1);
        return matchedPf;
    }

    public static PageFormat getMatchedPageFormat(Rectangle2D printableArea, double widthToleranceInPixels, double heightToleranceInPixels, int orientation) {
        double tolerance = widthToleranceInPixels;
        PageFormat pf = StandardPapers.getMatchedPageFormat(printableArea, tolerance, 0.0, 0.0, 0.0, 0.0, orientation);
        return pf;
    }

    public static PageFormat getMatchedPageFormat(Rectangle2D printableArea, double tolerance, double topMargin, double leftMargin, double bottomMargin, double rightMargin) {
        int orientation = 1;
        PageFormat pf = StandardPapers.getMatchedPageFormat(printableArea, tolerance, topMargin, leftMargin, bottomMargin, rightMargin, orientation);
        return pf;
    }

    public static PageFormat getMatchedPageFormat(Rectangle2D printableArea, double tolerance, double topMargin, double leftMargin, double bottomMargin, double rightMargin, int orientation) {
        AtMediaSizeObject foundMedia = StandardPapers.getMatchedMediaSizeObject(printableArea, tolerance);
        if (foundMedia != null) {
            MediaSizeName foundMediaName = foundMedia.getMediaSizeName();
            PageFormat pf = MediaUtil.getSelectedPageFormat(foundMediaName, leftMargin, rightMargin, topMargin, bottomMargin, orientation);
            String mediaNameString = AtMediaSizeObject.getUserReadableMediaSizeName(foundMediaName);
            AtDebug.debug("getMatchedPageFormat() [printableArea=" + printableArea + "] [found=" + mediaNameString + "]");
            return pf;
        }
        return null;
    }

    public static AtMediaSizeObject getMatchedMediaSizeObject(Rectangle2D printableArea, double widthToleranceInPixels, double heightToleranceInPixels, int orientation) {
        AtMediaSizeObject foundMedia = StandardPapers.getMatchedMediaSizeObject(printableArea, widthToleranceInPixels);
        return foundMedia;
    }

    public static final AtMediaSizeObject getMatchedMediaSizeObject(Rectangle2D printableArea) {
        AtMediaSizeObject foundMedia = StandardPapers.getMatchedMediaSizeObject(printableArea, 0.0);
        return foundMedia;
    }

    public static final AtMediaSizeObject getMatchedMediaSizeObject(Rectangle2D printableArea, double tolerance) {
        double mediaWidth = printableArea.getWidth();
        double mediaHeight = printableArea.getHeight();
        AtMediaSizeObject foundMedia = null;
        MediaSizeName[] allMediaNames = StandardPapers.getStandardMedia();
        for (int i = 0; allMediaNames != null && i < allMediaNames.length; ++i) {
            MediaSizeName aMedia = allMediaNames[i];
            try {
                AtMediaSizeObject aMediaSizeObject = new AtMediaSizeObject(aMedia);
                double aMediaWidth = aMediaSizeObject.getMediaWidthPixel();
                double aMediaHeight = aMediaSizeObject.getMediaHeightPixel();
                boolean matched1 = StandardPapers.match(mediaWidth, mediaHeight, aMediaWidth, aMediaHeight, tolerance);
                if (matched1) {
                    foundMedia = aMediaSizeObject;
                    break;
                }
                boolean matched2 = StandardPapers.match(mediaHeight, mediaWidth, aMediaWidth, aMediaHeight, tolerance);
                if (!matched2) continue;
                foundMedia = aMediaSizeObject;
                break;
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return foundMedia;
    }

    private static boolean match(double mediaWidth, double mediaHeight, double aMediaWidth, double aMediaHeight, double tolerance) {
        return mediaWidth >= aMediaWidth - tolerance && mediaWidth <= aMediaWidth + tolerance && mediaHeight >= aMediaHeight - tolerance && mediaHeight <= aMediaHeight + tolerance;
    }

    public static final String[] getUserReadableMediaSizeNames() {
        MediaSizeName[] allMedia = StandardPapers.getStandardMedia();
        String[] nameList = null;
        int count = 0;
        for (int i = 0; allMedia != null && i < allMedia.length; ++i) {
            try {
                MediaSizeName aMedia;
                if (nameList == null) {
                    nameList = new String[allMedia.length];
                }
                if ((aMedia = allMedia[i]) == null) continue;
                AtMediaSizeObject mso = new AtMediaSizeObject(aMedia);
                String aMediaName = mso.getMediaName();
                nameList[count++] = aMediaName;
                continue;
            }
            catch (Throwable t) {
                AtDebug.debug(9, t);
            }
        }
        return nameList;
    }

    public static final String[] getMediaSizeInchString() {
        MediaSizeName[] allMedia = StandardPapers.getStandardMedia();
        String[] nameList = null;
        int count = 0;
        for (int i = 0; allMedia != null && i < allMedia.length; ++i) {
            try {
                MediaSizeName aMedia;
                if (nameList == null) {
                    nameList = new String[allMedia.length];
                }
                if ((aMedia = allMedia[i]) == null) continue;
                AtMediaSizeObject mso = new AtMediaSizeObject(aMedia);
                String aMediaName = mso.getMediaSizeInchString();
                nameList[count++] = aMediaName;
                continue;
            }
            catch (Throwable t) {
                AtDebug.debug(9, t);
            }
        }
        return nameList;
    }

    public static final String[] getMediaSizePixelString() {
        MediaSizeName[] allMedia = StandardPapers.getStandardMedia();
        String[] nameList = null;
        int count = 0;
        for (int i = 0; allMedia != null && i < allMedia.length; ++i) {
            try {
                MediaSizeName aMedia;
                if (nameList == null) {
                    nameList = new String[allMedia.length];
                }
                if ((aMedia = allMedia[i]) == null) continue;
                AtMediaSizeObject mso = new AtMediaSizeObject(aMedia);
                String aMediaName = mso.getMediaSizePixelString();
                nameList[count++] = aMediaName;
                continue;
            }
            catch (Throwable t) {
                AtDebug.debug(9, t);
            }
        }
        return nameList;
    }

    public static final String[] getMediaSizeNamesWithInchString() {
        MediaSizeName[] allMedia = StandardPapers.getStandardMedia();
        String[] nameList = null;
        int count = 0;
        for (int i = 0; allMedia != null && i < allMedia.length; ++i) {
            try {
                MediaSizeName aMedia;
                if (nameList == null) {
                    nameList = new String[allMedia.length];
                }
                if ((aMedia = allMedia[i]) == null) continue;
                AtMediaSizeObject mso = new AtMediaSizeObject(aMedia);
                String aMediaName = mso.getMediaSizeNameWithInchString();
                nameList[count++] = aMediaName;
                continue;
            }
            catch (Throwable t) {
                AtDebug.debug(9, t);
            }
        }
        return nameList;
    }

    public static final String[] getMediaSizeNamesWithPixelString() {
        MediaSizeName[] allMedia = StandardPapers.getStandardMedia();
        String[] nameList = null;
        int count = 0;
        for (int i = 0; allMedia != null && i < allMedia.length; ++i) {
            try {
                MediaSizeName aMedia;
                if (nameList == null) {
                    nameList = new String[allMedia.length];
                }
                if ((aMedia = allMedia[i]) == null) continue;
                AtMediaSizeObject mso = new AtMediaSizeObject(aMedia);
                String aMediaName = mso.getMediaSizeNameWithPixelString();
                nameList[count++] = aMediaName;
                continue;
            }
            catch (Throwable t) {
                AtDebug.debug(9, t);
            }
        }
        return nameList;
    }

    public static final String[] getStandardMediaSizeNamesWithInchAndPixel() {
        MediaSizeName[] allMedia = StandardPapers.getStandardMedia();
        String[] nameList = null;
        int count = 0;
        for (int i = 0; allMedia != null && i < allMedia.length; ++i) {
            try {
                MediaSizeName aMedia;
                if (nameList == null) {
                    nameList = new String[allMedia.length];
                }
                if ((aMedia = allMedia[i]) == null) continue;
                AtMediaSizeObject mso = new AtMediaSizeObject(aMedia);
                String aMediaName = mso.getMediaSizeNameWithInchAndPixel();
                nameList[count++] = aMediaName;
                continue;
            }
            catch (Throwable t) {
                AtDebug.debug(9, t);
            }
        }
        return nameList;
    }

    private static final MediaSizeName[] toArray(MediaSizeName[] in) {
        if (in == null) {
            return in;
        }
        MediaSizeName[] out = new MediaSizeName[in.length];
        for (int i = 0; i < in.length; ++i) {
            out[i] = in[i];
        }
        return out;
    }

    public static final MediaSizeName[] getStandardMedia() {
        int i;
        if (ALL_MEDIA_NAMES != null) {
            MediaSizeName[] copiedArray = StandardPapers.toArray(ALL_MEDIA_NAMES);
            return copiedArray;
        }
        MediaSizeName[] naMedia = StandardPapers.getStandardNAMedia();
        MediaSizeName[] isoMedia = StandardPapers.getStandardISOMedia();
        MediaSizeName[] enggMedia = StandardPapers.getStandardEngineeringMedia();
        MediaSizeName[] jisMedia = StandardPapers.getStandardJapaneseMedia();
        MediaSizeName[] otherMedia = StandardPapers.getOtherStandardMedia();
        MediaSizeName[] jprintMedia = StandardPapers.getOtherJPrintMedia();
        int count = 0;
        if (naMedia != null) {
            count += naMedia.length;
        }
        if (isoMedia != null) {
            count += isoMedia.length;
        }
        if (enggMedia != null) {
            count += enggMedia.length;
        }
        if (jisMedia != null) {
            count += jisMedia.length;
        }
        if (otherMedia != null) {
            count += otherMedia.length;
        }
        if (jprintMedia != null) {
            count += jprintMedia.length;
        }
        MediaSizeName[] allMedia = new MediaSizeName[count];
        int idx = 0;
        for (i = 0; naMedia != null && i < naMedia.length; ++i) {
            allMedia[idx + i] = naMedia[i];
        }
        idx += i;
        for (i = 0; isoMedia != null && i < isoMedia.length; ++i) {
            allMedia[idx + i] = isoMedia[i];
        }
        idx += i;
        for (i = 0; enggMedia != null && i < enggMedia.length; ++i) {
            allMedia[idx + i] = enggMedia[i];
        }
        idx += i;
        for (i = 0; otherMedia != null && i < otherMedia.length; ++i) {
            allMedia[idx + i] = otherMedia[i];
        }
        idx += i;
        for (i = 0; jisMedia != null && i < jisMedia.length; ++i) {
            allMedia[idx + i] = jisMedia[i];
        }
        idx += i;
        for (i = 0; jprintMedia != null && i < jprintMedia.length; ++i) {
            allMedia[idx + i] = jprintMedia[i];
        }
        ALL_MEDIA_NAMES = allMedia;
        return allMedia;
    }

    public static final MediaSizeName[] getStandardNAMedia() {
        MediaSizeName[] na = new MediaSizeName[]{MediaSizeName.NA_LETTER, MediaSizeName.NA_LEGAL, MediaSizeName.NA_10X13_ENVELOPE, MediaSizeName.NA_10X14_ENVELOPE, MediaSizeName.NA_10X15_ENVELOPE, MediaSizeName.NA_5X7, MediaSizeName.NA_6X9_ENVELOPE, MediaSizeName.NA_7X9_ENVELOPE, MediaSizeName.NA_8X10, MediaSizeName.NA_9X11_ENVELOPE, MediaSizeName.NA_9X12_ENVELOPE, MediaSizeName.NA_NUMBER_10_ENVELOPE, MediaSizeName.NA_NUMBER_11_ENVELOPE, MediaSizeName.NA_NUMBER_12_ENVELOPE, MediaSizeName.NA_NUMBER_14_ENVELOPE, MediaSizeName.NA_NUMBER_9_ENVELOPE};
        return na;
    }

    public static final MediaSizeName[] getStandardISOMedia() {
        MediaSizeName[] iso = new MediaSizeName[]{MediaSizeName.ISO_A4, MediaSizeName.ISO_A0, MediaSizeName.ISO_A1, MediaSizeName.ISO_A10, MediaSizeName.ISO_A2, MediaSizeName.ISO_A2, MediaSizeName.ISO_A3, MediaSizeName.ISO_A5, MediaSizeName.ISO_A6, MediaSizeName.ISO_A7, MediaSizeName.ISO_A8, MediaSizeName.ISO_A9, MediaSizeName.ISO_B0, MediaSizeName.ISO_B1, MediaSizeName.ISO_B10, MediaSizeName.ISO_B2, MediaSizeName.ISO_B3, MediaSizeName.ISO_B4, MediaSizeName.ISO_B5, MediaSizeName.ISO_B6, MediaSizeName.ISO_B7, MediaSizeName.ISO_A8, MediaSizeName.ISO_B9, MediaSizeName.ISO_C0, MediaSizeName.ISO_C1, MediaSizeName.ISO_C2, MediaSizeName.ISO_C3, MediaSizeName.ISO_C4, MediaSizeName.ISO_C5, MediaSizeName.ISO_C6, MediaSizeName.ISO_DESIGNATED_LONG};
        return iso;
    }

    public static final MediaSizeName[] getStandardEngineeringMedia() {
        MediaSizeName[] enggPapers = new MediaSizeName[]{JPrintMediaSizeName.ENGG_A, JPrintMediaSizeName.ENGG_B, JPrintMediaSizeName.ENGG_C, JPrintMediaSizeName.ENGG_D, JPrintMediaSizeName.ENGG_E};
        return enggPapers;
    }

    public static final MediaSizeName[] getStandardJapaneseMedia() {
        MediaSizeName[] jis = new MediaSizeName[]{MediaSizeName.JAPANESE_DOUBLE_POSTCARD, MediaSizeName.JAPANESE_POSTCARD, MediaSizeName.JIS_B0, MediaSizeName.JIS_B1, MediaSizeName.JIS_B10, MediaSizeName.JIS_B2, MediaSizeName.JIS_B3, MediaSizeName.JIS_B4, MediaSizeName.JIS_B5, MediaSizeName.JIS_B6, MediaSizeName.JIS_B7, MediaSizeName.JIS_B8, JPrintMediaSizeName.JIS_B9, JPrintMediaSizeName.CHOU_1, JPrintMediaSizeName.CHOU_2, JPrintMediaSizeName.CHOU_3, JPrintMediaSizeName.CHOU_4, JPrintMediaSizeName.CHOU_30, JPrintMediaSizeName.CHOU_40, JPrintMediaSizeName.KAKU_0, JPrintMediaSizeName.KAKU_1, JPrintMediaSizeName.KAKU_2, JPrintMediaSizeName.KAKU_3, JPrintMediaSizeName.KAKU_4, JPrintMediaSizeName.KAKU_5, JPrintMediaSizeName.KAKU_6, JPrintMediaSizeName.KAKU_7, JPrintMediaSizeName.KAKU_8, JPrintMediaSizeName.KAKU_20, JPrintMediaSizeName.KAKU_A4, JPrintMediaSizeName.YOU_1, JPrintMediaSizeName.YOU_2, JPrintMediaSizeName.YOU_3, JPrintMediaSizeName.YOU_4, JPrintMediaSizeName.YOU_5, JPrintMediaSizeName.YOU_6, JPrintMediaSizeName.YOU_7};
        return jis;
    }

    public static final MediaSizeName[] getOtherStandardMedia() {
        MediaSizeName[] others = new MediaSizeName[]{MediaSizeName.EXECUTIVE, MediaSizeName.FOLIO, MediaSizeName.INVOICE, MediaSizeName.ITALY_ENVELOPE, MediaSizeName.LEDGER, MediaSizeName.MONARCH_ENVELOPE, MediaSizeName.PERSONAL_ENVELOPE, MediaSizeName.QUARTO};
        return others;
    }

    public static final MediaSizeName[] getOtherJPrintMedia() {
        MediaSizeName[] jpMedia = new MediaSizeName[]{JPrintMediaSizeName.ARCHITECTURE_A, JPrintMediaSizeName.ARCHITECTURE_B, JPrintMediaSizeName.ARCHITECTURE_C, JPrintMediaSizeName.ARCHITECTURE_D, JPrintMediaSizeName.ARCHITECTURE_E, JPrintMediaSizeName.ARCHITECTURE_E1, JPrintMediaSizeName.DIN_4A0, JPrintMediaSizeName.DIN_2A0};
        return jpMedia;
    }

    static {
        Class clazz = JPrintMediaSize.class;
        ALL_MEDIA_NAMES = null;
    }
}

