/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.object;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Vector;

public class OrderedMap
implements Serializable {
    private Vector keySet = new Vector();
    private Vector valueSet = new Vector();

    private void setKey(int index, Object key) {
        this.keySet.setElementAt(key, index);
    }

    private void setValue(int index, Object value) {
        this.valueSet.setElementAt(value, index);
    }

    public boolean containsKey(Object obj) {
        return this.keySet.contains(obj);
    }

    public void setElementAt(int index, Object key, Object value) {
        this.setKey(index, key);
        this.setValue(index, value);
    }

    public void insertElementAt(int index, Object key, Object value) {
        this.insertKey(index, key);
        this.insertValue(index, value);
    }

    private void insertKey(int index, Object key) {
        this.keySet.insertElementAt(key, index);
    }

    private void insertValue(int index, Object value) {
        this.valueSet.insertElementAt(value, index);
    }

    public void put(Object key, Object value) {
        if (key == null) {
            throw new NullPointerException("null key is not allowed.");
        }
        this.keySet.add(key);
        this.valueSet.add(value);
    }

    public int size() {
        return this.keySet.size();
    }

    public Object getKey(int idx) {
        return this.keySet.get(idx);
    }

    public Object getValue(int idx) {
        return this.valueSet.get(idx);
    }

    public Object getValue(Object key) {
        int idx = this.keySet.indexOf(key);
        if (idx >= 0) {
            return this.valueSet.get(idx);
        }
        return null;
    }

    public Iterator getKeys() {
        Iterator keyIter = this.keySet.iterator();
        return keyIter;
    }

    public Iterator getValues() {
        Iterator valIter = this.valueSet.iterator();
        return valIter;
    }

    public void clear() {
        this.keySet.clear();
        this.valueSet.clear();
    }

    public Object clone() {
        Vector keyCopies = (Vector)this.keySet.clone();
        Vector valueCopies = (Vector)this.valueSet.clone();
        OrderedMap copy = new OrderedMap();
        for (int i = 0; i < keyCopies.size(); ++i) {
            Object key = keyCopies.get(i);
            Object value = valueCopies.get(i);
            copy.put(key, value);
        }
        return copy;
    }
}

