/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.page;

import com.activetree.common.doc.DocListenerManager;
import com.activetree.common.exception.AtException;
import com.activetree.common.internal.DemoShape;
import com.activetree.common.utils.AtDebug;
import com.activetree.common.utils.GraphicsUtil;
import com.activetree.common.utils.MediaUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.SystemColor;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;

public abstract class AbstractPage
implements Printable,
Serializable {
    public static final int MARGIN = 6;
    public static final int INSET = 3;
    protected Dimension size = null;
    protected int totalPageCount = -1;
    protected PageFormat printerPageFormat;
    protected PageFormat pageFormat;
    private double zoom = 1.0;
    protected double scale = 1.0;
    protected boolean isAntiAliased = true;
    protected boolean isImageConversion = false;
    protected int pageIndex;
    protected Object renderingReason = "PageRenderingReasonViewing";
    protected Object source;
    protected Object docInfo;
    protected boolean printing = false;
    protected int printPageIndex = -1;
    protected int pageScaling = 10;
    protected boolean autoRotateAndCenter = true;
    protected boolean autoSelectMediaSize = false;
    protected int pageRotation = 0;
    protected DocListenerManager docListenerManager;
    protected DemoShape demoShape;

    public AbstractPage() {
    }

    public AbstractPage(PageFormat pf, double zoom, boolean isAntiAliased, DemoShape demoShape) {
        this.demoShape = demoShape;
        this.pageFormat = pf;
        this.zoom = zoom;
        this.size = new Dimension((int)pf.getWidth(), (int)pf.getHeight());
        this.isAntiAliased = isAntiAliased;
    }

    public abstract AbstractPage newInstance();

    public abstract void draw(Graphics var1) throws AtException;

    public void setDocListenerManager(DocListenerManager docListenerManager) {
        this.docListenerManager = docListenerManager;
    }

    public DocListenerManager getDocListenerManager() {
        return this.docListenerManager;
    }

    public int getPageScaling() {
        return this.pageScaling;
    }

    public void setPageScaling(int pageScaleToUse) {
        this.pageScaling = pageScaleToUse;
    }

    public void setAutoRotateAndCenter(boolean rotateAndCenter) {
        this.autoRotateAndCenter = rotateAndCenter;
    }

    public boolean isAutoRotateAndCenter() {
        return this.autoRotateAndCenter;
    }

    public void setAutoSelectMediaSize(boolean autoSelectMediaByPageSize) {
        this.autoSelectMediaSize = autoSelectMediaByPageSize;
    }

    public boolean isAutoSelectMediaSize() {
        return this.autoSelectMediaSize;
    }

    public void setScale(double scale) {
        this.scale = scale;
    }

    public double getScale() {
        return this.scale;
    }

    public void resizePageFormat(AbstractPage page, double resizeFactor, boolean autoMatchToPaperSize) {
        Rectangle2D printableArea = page.getPrintableArea();
        double resizeFactorToUse = resizeFactor;
        if (autoMatchToPaperSize) {
            resizeFactorToUse = 1.0;
        }
        if (resizeFactorToUse <= 0.0) {
            AtDebug.debug(7, "WARNING! resize factor \"" + resizeFactor + "\" can not be less or equal 0 (using 1.0 instead)");
            resizeFactorToUse = 1.0;
        }
        PageFormat outputPageFormat = MediaUtil.getSelectedPageFormat(printableArea, resizeFactorToUse);
        page.setPrinterPageFormat(outputPageFormat);
        page.setPageFormat(outputPageFormat);
        page.scale = resizeFactorToUse;
        page.setZoom(resizeFactorToUse);
    }

    public void copyAttributes(AbstractPage dest) {
        if (dest == null) {
            return;
        }
        if (this.size != null) {
            dest.size = new Dimension(this.size.width, this.size.height);
        }
        dest.totalPageCount = this.totalPageCount;
        dest.pageFormat = MediaUtil.getClonedPageFormat(this.pageFormat);
        dest.printerPageFormat = MediaUtil.getClonedPageFormat(this.printerPageFormat);
        dest.zoom = this.zoom;
        dest.isAntiAliased = this.isAntiAliased;
        dest.printPageIndex = this.printPageIndex;
        dest.isImageConversion = this.isImageConversion;
        dest.pageScaling = this.pageScaling;
        dest.autoRotateAndCenter = this.autoRotateAndCenter;
        dest.pageIndex = this.pageIndex;
        dest.renderingReason = this.renderingReason;
        dest.printing = this.printing;
        dest.printPageIndex = this.printPageIndex;
        dest.docInfo = this.docInfo;
        dest.source = this.source;
        dest.docListenerManager = this.docListenerManager;
        dest.demoShape = this.demoShape;
    }

    public boolean isPrinting() {
        return this.printing;
    }

    public void setPrinting(boolean printing) {
        this.printing = printing;
    }

    public Rectangle2D getPrintableArea() {
        Rectangle2D.Double printableArea = null;
        PageFormat pfToUse = this.pageFormat;
        if (this.printerPageFormat != null) {
            pfToUse = this.printerPageFormat;
        }
        if (pfToUse != null) {
            printableArea = new Rectangle2D.Double(0.0, 0.0, pfToUse.getWidth(), pfToUse.getHeight());
        }
        return printableArea;
    }

    public int getPageRotation() {
        return this.pageRotation;
    }

    public void setSource(Object source) {
        this.source = source;
    }

    public Object getSource() {
        return this.source;
    }

    public void setDocInfo(Object docInfo) {
        this.docInfo = docInfo;
    }

    public Object getDocInfo() {
        return this.docInfo;
    }

    public void setPageRotation(int pageRotation) {
        this.pageRotation = pageRotation;
    }

    public void setRenderingReason(Object renderingReason) {
        this.renderingReason = renderingReason;
    }

    public Object getRenderingReason() {
        return this.renderingReason;
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    public void setPageIndex(int pi) {
        this.pageIndex = pi;
    }

    public void setFitToPrintableArea(boolean fitToPrintableArea) {
        this.resetPageScaling(fitToPrintableArea);
    }

    public static final int toPageScale(boolean fitToPage) {
        if (fitToPage) {
            return 11;
        }
        return 10;
    }

    protected void resetPageScaling(boolean fitToPage) {
        if (fitToPage) {
            this.setPageScaling(11);
        } else {
            this.setPageScaling(10);
        }
    }

    public boolean isFitToPrintableArea() {
        int currPageScaling = this.getPageScaling();
        return currPageScaling == 11;
    }

    public boolean isImageConversion() {
        return this.isImageConversion;
    }

    public void setIsImageConversion(boolean isImageConversion) {
        this.isImageConversion = isImageConversion;
    }

    public void setZoom(double zoom) {
        this.zoom = zoom;
    }

    public double getZoom() {
        return this.zoom;
    }

    public boolean isAntiAliased() {
        return this.isAntiAliased;
    }

    public void setAntiAliased(boolean antiAliased) {
        this.isAntiAliased = antiAliased;
    }

    public void setTotalPage(int totalPageCount) {
        this.totalPageCount = totalPageCount;
    }

    public int getTotalPageCount() {
        return this.totalPageCount;
    }

    public PageFormat getPrinterPageFormat() {
        return this.printerPageFormat;
    }

    public void setPrinterPageFormat(PageFormat printerPageFormat) {
        this.printerPageFormat = printerPageFormat;
    }

    public PageFormat getPageFormat() {
        return this.pageFormat;
    }

    public void setPageFormat(PageFormat pageFormat) {
        this.pageFormat = pageFormat;
    }

    public Dimension getSize() {
        return this.size;
    }

    public Color getBackground() {
        return SystemColor.white;
    }

    public int print(Graphics g, PageFormat fmt, int pIdx) throws PrinterException {
        try {
            if (this.isAntiAliased()) {
                Graphics2D g2d = (Graphics2D)g;
                g2d.setRenderingHints(GraphicsUtil.getRenderingHints());
            }
            this.printPageIndex = pIdx;
            this.printing = true;
            this.draw(g);
            this.printPageIndex = -1;
            this.printing = false;
        }
        catch (Throwable t) {
            String msg = AbstractPage.getStackTrace(t);
            throw new PrinterException(msg);
        }
        return 0;
    }

    public static String getStackTrace(Throwable aThrowable) {
        StringWriter result = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result);
        aThrowable.printStackTrace(printWriter);
        printWriter.flush();
        String stackTrace = result.getBuffer().toString();
        if (stackTrace != null) {
            stackTrace = stackTrace.trim();
        }
        return stackTrace;
    }
}

