/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.print.dialog;

import com.activetree.common.media.AtMediaSizeObject;
import com.activetree.common.print.dialog.PageFormatView;
import com.activetree.common.resource.AtCommonResource;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class PageFormatPreviewPane
extends JPanel {
    protected final Vector imageUpdateListeners = new Vector();
    protected PageFormatView pageView;

    public PageFormatPreviewPane() {
        this(72.0, 72.0, 72.0, 72.0);
    }

    public PageFormatPreviewPane(AtMediaSizeObject defaultMedia) {
        this(defaultMedia, 72.0, 72.0, 72.0, 72.0);
    }

    public PageFormatPreviewPane(double topMarginPixels, double leftMarginPixels, double bottomMarginPixels, double rightMarginPixels) {
        this(new AtMediaSizeObject(MediaSizeName.NA_LETTER), topMarginPixels, leftMarginPixels, bottomMarginPixels, rightMarginPixels);
    }

    public PageFormatPreviewPane(AtMediaSizeObject defaultMedia, double topMarginPixels, double leftMarginPixels, double bottomMarginPixels, double rightMarginPixels) {
        this.pageView = new PageFormatView(defaultMedia, leftMarginPixels, rightMarginPixels, topMarginPixels, bottomMarginPixels);
        this.setupContentPane();
        this.postInit();
    }

    protected void postInit() {
    }

    protected void setupContentPane() {
        this.setLayout(new GridBagLayout());
        this.setBorder(new TitledBorder(null, AtCommonResource.MESSAGE_RESOURCE.getText("PREVIEW"), 1, 2, null));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.pageView, gridBagConstraints);
    }

    public void refresh() {
        this.pageView.refresh();
    }

    public void setMedia(MediaSize mediaSize, int orientation, double topMarginPixels, double leftMarginPixels, double bottomMarginPixels, double rightMarginPixels) {
        this.pageView.setTopMargin(topMarginPixels);
        this.pageView.setLeftMargin(leftMarginPixels);
        this.pageView.setBottomMargin(bottomMarginPixels);
        this.pageView.setRightMargin(rightMarginPixels);
        this.pageView.setPageOrientation(orientation);
    }

    public void setMediaSizeObject(AtMediaSizeObject mso) {
        this.pageView.setMediaSizeObject(mso);
    }

    public void setPageOrientation(int orientation) {
        this.pageView.setPageOrientation(orientation);
    }

    public void setMargins(double currLeftMargin, double currRightMargin, double currTopMargin, double currBottomMargin) {
        this.pageView.setMargins(currLeftMargin, currRightMargin, currTopMargin, currBottomMargin);
    }
}

