/*
 * Decompiled with CFR 0.152.
 */
package com.activetree.common.print.dialog;

import com.activetree.common.media.AtMediaSizeObject;
import com.activetree.common.resource.AtCommonResource;
import com.activetree.common.swing.ArrowMaker;
import com.activetree.common.utils.AtDebug;
import com.activetree.common.utils.DataUtil;
import com.activetree.common.utils.GraphicsUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.SystemColor;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JPanel;

public class PageFormatView
extends JPanel {
    private final int MARGIN = 35;
    private final float[] dash = new float[]{0.4f};
    private final Stroke DEFAULT_TITLE_BORDER_STROKE = new BasicStroke(0.4f, 0, 0, 1.0f, this.dash, 0.3f);
    public static int MIN_WIDTH = 170;
    public static int MIN_HEIGHT = 200;
    protected AtMediaSizeObject mediaSizeObject;
    protected Dimension minSize = new Dimension(120, 120);
    protected Rectangle2D.Double paperArea = new Rectangle2D.Double();
    protected Rectangle2D.Double imageableArea = new Rectangle2D.Double();
    protected double left = 72.0;
    protected double right = 72.0;
    protected double top = 72.0;
    protected double bottom = 72.0;
    protected Font fontToUse = new Font("Arial", 0, 10);
    protected int pageOrientation = 1;
    protected ArrowMaker arrowMaker = new ArrowMaker();

    public PageFormatView(AtMediaSizeObject mediaSizeObject, double leftMarginPixels, double rightMarginPixels, double topMarginPixels, double bottomMarginPixels) {
        this.arrowMaker.setAttribute("drawArrow", Boolean.TRUE);
        this.mediaSizeObject = mediaSizeObject;
        this.left = leftMarginPixels;
        this.right = rightMarginPixels;
        this.top = topMarginPixels;
        this.bottom = bottomMarginPixels;
        this.resetPaperProperties();
        this.postInit();
    }

    protected void postInit() {
    }

    public void refresh() {
        this.resetPaperProperties();
        this.repaint();
    }

    public double getPaperWidth() {
        AtMediaSizeObject pso = this.getMediaSizeObject();
        double paperWidth = -1.0;
        if (pso != null) {
            paperWidth = pso.getMediaWidthPixel();
        }
        return paperWidth;
    }

    public double getPaperHeight() {
        AtMediaSizeObject pso = this.getMediaSizeObject();
        double paperHeight = -1.0;
        if (pso != null) {
            paperHeight = pso.getMediaHeightPixel();
        }
        return paperHeight;
    }

    protected void resetPaperProperties() {
        if (this.mediaSizeObject == null) {
            AtDebug.debug("resetPaperProperties(): null MediaSizeObject is not allowed. Do nothing and return.");
            return;
        }
        double paperWidthPixel = this.getPaperWidth();
        double paperHeightPixel = this.getPaperHeight();
        if (this.getPageOrientation() == 0) {
            double temp = paperWidthPixel;
            paperWidthPixel = paperHeightPixel;
            paperHeightPixel = temp;
        }
        this.paperArea.x = 0.0;
        this.paperArea.y = 0.0;
        this.paperArea.width = paperWidthPixel;
        this.paperArea.height = paperHeightPixel;
        double imageableWidth = paperWidthPixel - this.left - this.right;
        double imageableHeight = paperHeightPixel - this.top - this.bottom;
        this.imageableArea.x = this.left;
        this.imageableArea.y = this.top;
        this.imageableArea.width = imageableWidth;
        this.imageableArea.height = imageableHeight;
    }

    public void setLeftMargin(double leftMargin) {
        this.left = leftMargin;
    }

    public double getLeftMargin() {
        return this.left;
    }

    public void setTopMargin(double topMargin) {
        this.top = topMargin;
    }

    public double getTopMargin() {
        return this.top;
    }

    public void setRightMargin(double rightMargin) {
        this.right = rightMargin;
    }

    public double getRightMargin() {
        return this.right;
    }

    public void setBottomMargin(double bottomMargin) {
        this.bottom = bottomMargin;
    }

    public double getBottomMargin() {
        return this.bottom;
    }

    public void setMargins(double left, double right, double top, double bottom) {
        this.left = left;
        this.right = right;
        this.top = top;
        this.bottom = bottom;
        this.refresh();
    }

    public void setPageOrientation(int pageOrientation) {
        this.pageOrientation = pageOrientation;
        this.refresh();
    }

    public int getPageOrientation() {
        return this.pageOrientation;
    }

    public AtMediaSizeObject getMediaSizeObject() {
        return this.mediaSizeObject;
    }

    public void setMediaSizeObject(AtMediaSizeObject mediaSizeObject) {
        this.mediaSizeObject = mediaSizeObject;
        this.refresh();
    }

    public Dimension getMinimumSize() {
        Dimension d = super.getSize();
        Dimension newd = new Dimension(d.width > MIN_WIDTH ? d.width : MIN_WIDTH, d.height > MIN_HEIGHT ? d.height : MIN_HEIGHT);
        return newd;
    }

    public Dimension getPreferredSize() {
        Dimension minSize = this.getMinimumSize();
        return minSize;
    }

    public void paintComponent(Graphics g) {
        double dy;
        double dx;
        super.paintComponent(g);
        if (this.mediaSizeObject == null) {
            return;
        }
        Dimension d = this.getSize();
        Color orgColor = g.getColor();
        Font orgFont = g.getFont();
        Rectangle2D.Double pd = new Rectangle2D.Double(35.0, 35.0, d.width - 70, d.height - 70);
        double availableViewWidth = pd.width;
        double availableViewHeight = pd.height;
        double paperWidth = this.paperArea.width;
        double paperHeight = this.paperArea.height;
        double scaleX = availableViewWidth / paperWidth;
        double scaleY = availableViewHeight / paperHeight;
        double scaleToUse = Math.min(scaleX, scaleY);
        Rectangle2D.Double scaledPaperArea = this.getScaledArea(this.paperArea, scaleToUse);
        Rectangle2D.Double scaledImageableArea = this.getScaledArea(this.imageableArea, scaleToUse);
        Graphics2D g2d = (Graphics2D)g;
        Stroke orgStroke = g2d.getStroke();
        double px2 = pd.getX();
        double py = pd.getY();
        double pw = scaledPaperArea.width;
        double ph = scaledPaperArea.height;
        if (pw < pd.width && (px2 += (dx = (pd.width - pw) / 2.0)) < pd.x) {
            px2 = pd.x;
        }
        if (ph < pd.height && (py += (dy = (pd.height - ph) / 2.0)) < pd.y) {
            py = pd.y;
        }
        g2d.setColor(SystemColor.BLACK);
        Rectangle2D.Double paperViewArea = new Rectangle2D.Double(px2, py, pw, ph);
        Rectangle2D.Double fillRect = new Rectangle2D.Double(px2 + 3.0, py + 3.0, pw, ph);
        g2d.fill(fillRect);
        g2d.setColor(SystemColor.white);
        g2d.fill(paperViewArea);
        g2d.setColor(SystemColor.black);
        g2d.draw(paperViewArea);
        g2d.setColor(SystemColor.lightGray);
        double imgx = paperViewArea.x + scaledImageableArea.x;
        double imgy = paperViewArea.y + scaledImageableArea.y;
        double imgw = scaledImageableArea.width;
        double imgh = scaledImageableArea.height;
        if (imgx <= paperViewArea.x) {
            imgx = paperViewArea.x + 1.0;
        }
        if (imgy <= paperViewArea.y) {
            imgy = paperViewArea.y + 1.0;
        }
        if (imgx + imgw >= paperViewArea.x + paperViewArea.width) {
            imgw = paperViewArea.x + paperViewArea.width - imgx - 1.0;
        }
        if (imgy + imgh >= paperViewArea.y + paperViewArea.height) {
            imgh = paperViewArea.y + paperViewArea.height - imgy - 1.0;
        }
        Rectangle2D.Double paperImageableArea = new Rectangle2D.Double(imgx, imgy, imgw, imgh);
        g2d.setStroke(this.DEFAULT_TITLE_BORDER_STROKE);
        g2d.draw(paperImageableArea);
        g2d.setStroke(orgStroke);
        g2d.setColor(SystemColor.black);
        double arrowX1 = paperViewArea.x;
        double arrowY1 = paperViewArea.y - 22.0;
        double arrowX2 = paperViewArea.x + paperViewArea.width;
        double arrowY2 = arrowY1;
        Line2D.Double topLine = new Line2D.Double(arrowX1, arrowY1, arrowX2, arrowY2);
        g2d.draw(topLine);
        double topMarkY1 = paperViewArea.y - 17.0;
        Line2D.Double topStartMarkLine = new Line2D.Double(arrowX1, topMarkY1, arrowX1, arrowY1 - (topMarkY1 - arrowY1));
        g2d.draw(topStartMarkLine);
        Line2D.Double topEndMarkLine = new Line2D.Double(arrowX2, topMarkY1, arrowX2, arrowY1 - (topMarkY1 - arrowY1));
        g2d.draw(topEndMarkLine);
        double leftArrowX1 = paperViewArea.x - 22.0;
        double leftArrowY1 = paperViewArea.y;
        double leftArrowX2 = leftArrowX1;
        double leftArrowY2 = paperViewArea.y + paperViewArea.height;
        Line2D.Double leftLine = new Line2D.Double(leftArrowX1, leftArrowY1, leftArrowX2, leftArrowY2);
        g2d.draw(leftLine);
        double x1 = paperViewArea.x - 17.0;
        Line2D.Double leftStartMarkLine = new Line2D.Double(x1, leftArrowY1, leftArrowX1 - (x1 - leftArrowX1), leftArrowY1);
        g2d.draw(leftStartMarkLine);
        Line2D.Double leftEndMarkLine = new Line2D.Double(x1, leftArrowY2, leftArrowX1 - (x1 - leftArrowX1), leftArrowY2);
        g2d.draw(leftEndMarkLine);
        FontMetrics fm = this.getFontMetrics(this.fontToUse);
        double fontHeight = fm.getHeight();
        double paperWidthInch = paperWidth / 72.0;
        String paperWidthStr = DataUtil.getString(paperWidthInch, 2);
        double wStrX = arrowX1 + (arrowX2 - arrowX1) / 2.0;
        double strWidth = GraphicsUtil.stringWidth(this.fontToUse, paperWidthStr);
        double wStrY = arrowY1 + fontHeight / 4.0;
        Rectangle2D.Double widthStrArea = new Rectangle2D.Double((wStrX -= strWidth / 2.0) - 2.0, wStrY - fontHeight / 4.0 * 3.0, strWidth + 4.0, fontHeight);
        g2d.setColor(this.getBackground());
        g2d.fill(widthStrArea);
        g2d.setColor(SystemColor.black);
        g2d.drawString(paperWidthStr, (int)wStrX, (int)wStrY);
        double paperHeightInch = paperHeight / 72.0;
        String paperHeightStr = DataUtil.getString(paperHeightInch, 2);
        double leftStrWidth = GraphicsUtil.stringWidth(this.fontToUse, paperHeightStr);
        double leftStrX = leftArrowX1 - leftStrWidth / 2.0;
        double leftStrY = leftArrowY1 + (leftArrowY2 - leftArrowY1) / 2.0;
        Rectangle2D.Double heightStrArea = new Rectangle2D.Double(leftStrX - 2.0, (leftStrY += fontHeight / 4.0) - fontHeight / 4.0 * 3.0, strWidth, fontHeight);
        g2d.setColor(this.getBackground());
        g2d.fill(heightStrArea);
        g2d.setColor(SystemColor.black);
        g2d.drawString(paperHeightStr, (int)leftStrX, (int)leftStrY);
        String bottomStr = "(" + paperWidthStr + " x " + paperHeightStr + ") " + AtCommonResource.MESSAGE_RESOURCE.getText("INCH");
        double bottomX = paperViewArea.x + paperViewArea.width / 2.0;
        double bottomStrWidth = GraphicsUtil.stringWidth(this.fontToUse, bottomStr);
        double bottomY = paperViewArea.y + paperViewArea.height + 17.0;
        g2d.drawString(bottomStr, (int)(bottomX -= bottomStrWidth / 2.0), (int)(bottomY += fontHeight / 4.0));
        GraphicsUtil.applyAntiAlias(g2d);
        Point2D.Double startPoint = new Point2D.Double(arrowX1, arrowY1);
        Point2D.Double endPoint = new Point2D.Double(arrowX2, arrowY2);
        Shape[] arrows = this.arrowMaker.createArrow(startPoint, endPoint, this.arrowMaker.getArrowBaseDiagonalDistance(), this.arrowMaker.getArrowBaseHalfWidth());
        Shape arrow = arrows[0];
        g2d.fill(arrow);
        arrows = this.arrowMaker.createArrow(endPoint, startPoint, this.arrowMaker.getArrowBaseDiagonalDistance(), this.arrowMaker.getArrowBaseHalfWidth());
        arrow = arrows[0];
        g2d.fill(arrow);
        Point2D.Double leftP1 = new Point2D.Double(leftArrowX1, leftArrowY1);
        Point2D.Double leftP2 = new Point2D.Double(leftArrowX2, leftArrowY2);
        arrows = this.arrowMaker.createArrow(leftP1, leftP2, this.arrowMaker.getArrowBaseDiagonalDistance(), this.arrowMaker.getArrowBaseHalfWidth());
        arrow = arrows[0];
        g2d.fill(arrow);
        arrows = this.arrowMaker.createArrow(leftP2, leftP1, this.arrowMaker.getArrowBaseDiagonalDistance(), this.arrowMaker.getArrowBaseHalfWidth());
        arrow = arrows[0];
        g2d.fill(arrow);
        g.setColor(orgColor);
        g.setFont(orgFont);
    }

    private Rectangle2D.Double getScaledArea(Rectangle2D.Double area, double scale) {
        double scaledx = area.x * scale;
        double scaledy = area.y * scale;
        double scaledw = area.width * scale;
        double scaledh = area.height * scale;
        Rectangle2D.Double scaledArea = new Rectangle2D.Double(scaledx, scaledy, scaledw, scaledh);
        return scaledArea;
    }
}

